{
  lib,
  stdenv,
  fetchFromGitHub,
  glib,
  openssl,
  pkg-config,
  autoreconfHook,
  SystemConfiguration,
}:

stdenv.mkDerivation rec {
  pname = "sofia-sip";
  version = "1.13.17";

  src = fetchFromGitHub {
    owner = "freeswitch";
    repo = pname;
    rev = "v${version}";
    sha256 = "sha256-7QmK2UxEO5lC0KBDWB3bwKTy0Nc7WrdTLjoQYzezoaY=";
  };

  buildInputs = [
    glib
    openssl
  ] ++ lib.optional stdenv.hostPlatform.isDarwin SystemConfiguration;
  nativeBuildInputs = [
    autoreconfHook
    pkg-config
  ];

  meta = with lib; {
    description = "Open-source SIP User-Agent library, compliant with the IETF RFC3261 specification";
    homepage = "https://github.com/freeswitch/sofia-sip";
    platforms = platforms.unix;
    license = licenses.lgpl2;
  };
}
