{
  lib,
  appdirs,
  apsw,
  buildPythonPackage,
  cvss,
  fetchFromGitHub,
  httpx,
  msgpack,
  orjson,
  packageurl-python,
  pydantic,
  pytestCheckHook,
  pytest-cov-stub,
  pythonOlder,
  rich,
  semver,
  setuptools,
  tabulate,
}:

buildPythonPackage rec {
  pname = "appthreat-vulnerability-db";
  version = "6.1.1";
  pyproject = true;

  disabled = pythonOlder "3.10";

  src = fetchFromGitHub {
    owner = "AppThreat";
    repo = "vulnerability-db";
    rev = "refs/tags/v${version}";
    hash = "sha256-FISV+wEpoRVfHNjN/fZw7aqFp5XDvB21ZhQhRQvCnHY=";
  };

  pythonRelaxDeps = [
    "msgpack"
    "semver"
  ];

  build-system = [ setuptools ];

  dependencies = [
    appdirs
    apsw
    cvss
    httpx
    msgpack
    orjson
    packageurl-python
    pydantic
    rich
    semver
    tabulate
  ] ++ httpx.optional-dependencies.http2;

  nativeCheckInputs = [
    pytestCheckHook
    pytest-cov-stub
  ];

  preCheck = ''
    export HOME=$(mktemp -d);
  '';

  disabledTests = [
    # Tests require network access
    "test_bulk_search"
    "test_download_recent"
  ];

  pythonImportsCheck = [ "vdb" ];

  meta = with lib; {
    description = "Vulnerability database and package search for sources such as OSV, NVD, GitHub and npm";
    homepage = "https://github.com/appthreat/vulnerability-db";
    changelog = "https://github.com/AppThreat/vulnerability-db/releases/tag/v${version}";
    license = with licenses; [ mit ];
    maintainers = with maintainers; [ fab ];
    mainProgram = "vdb";
  };
}
