{
  lib,
  buildPythonPackage,
  fetchPypi,
  gitpython,
  pythonOlder,
  requests,
  setuptools,
}:

buildPythonPackage rec {
  pname = "pyexploitdb";
  version = "0.2.54";
  pyproject = true;

  disabled = pythonOlder "3.7";

  src = fetchPypi {
    pname = "pyExploitDb";
    inherit version;
    hash = "sha256-TJ2cjYadXqaX31UXY99/pCeH0T2nFj83AiLdX0SMC3U=";
  };

  build-system = [ setuptools ];

  dependencies = [
    gitpython
    requests
  ];

  # Module has no tests
  doCheck = false;

  pythonImportsCheck = [ "pyExploitDb" ];

  meta = with lib; {
    description = "Library to fetch the most recent exploit-database";
    homepage = "https://github.com/Hackman238/pyExploitDb";
    changelog = "https://github.com/Hackman238/pyExploitDb/blob/master/ChangeLog.md";
    license = licenses.gpl3Plus;
    maintainers = with maintainers; [ fab ];
  };
}
