# Release 14.12 ("Caterpillar", 2014/12/30) {#sec-release-14.12}

In addition to numerous new and upgraded packages, this release has the following highlights:

- Systemd has been updated to version 217, which has numerous [improvements.](http://lists.freedesktop.org/archives/systemd-devel/2014-October/024662.html)

- [Nix has been updated to 1.8.](https://www.mail-archive.com/nix-dev@lists.science.uu.nl/msg13957.html)

- NixOS is now based on Glibc 2.20.

- KDE has been updated to 4.14.

- The default Linux kernel has been updated to 3.14.

- If `users.mutableUsers` is enabled (the default), changes made to the declaration of a user or group will be correctly realised when running `nixos-rebuild`. For instance, removing a user specification from `configuration.nix` will cause the actual user account to be deleted. If `users.mutableUsers` is disabled, it is no longer necessary to specify UIDs or GIDs; if omitted, they are allocated dynamically.

Following new services were added since the last release:

- `atftpd`

- `bosun`

- `bspwm`

- `chronos`

- `collectd`

- `consul`

- `cpuminer-cryptonight`

- `crashplan`

- `dnscrypt-proxy`

- `docker-registry`

- `docker`

- `etcd`

- `fail2ban`

- `fcgiwrap`

- `fleet`

- `fluxbox`

- `gdm`

- `geoclue2`

- `gitlab`

- `gitolite`

- `gnome3.gnome-documents`

- `gnome3.gnome-online-miners`

- `gnome3.gvfs`

- `gnome3.seahorse`

- `hbase`

- `i2pd`

- `influxdb`

- `kubernetes`

- `liquidsoap`

- `lxc`

- `mailpile`

- `mesos`

- `mlmmj`

- `monetdb`

- `mopidy`

- `neo4j`

- `nsd`

- `openntpd`

- `opentsdb`

- `openvswitch`

- `parallels-guest`

- `peerflix`

- `phd`

- `polipo`

- `prosody`

- `radicale`

- `redmine`

- `riemann`

- `scollector`

- `seeks`

- `siproxd`

- `strongswan`

- `tcsd`

- `teamspeak3`

- `thermald`

- `torque/mrom`

- `torque/server`

- `uhub`

- `unifi`

- `znc`

- `zookeeper`

When upgrading from a previous release, please be aware of the following incompatible changes:

- The default version of Apache httpd is now 2.4. If you use the `extraConfig` option to pass literal Apache configuration text, you may need to update it --- see [Apache's documentation](http://httpd.apache.org/docs/2.4/upgrading.html) for details. If you wish to continue to use httpd 2.2, add the following line to your NixOS configuration:

  ```nix
  { services.httpd.package = pkgs.apacheHttpd_2_2; }
  ```

- PHP 5.3 has been removed because it is no longer supported by the PHP project. A [migration guide](http://php.net/migration54) is available.

- The host side of a container virtual Ethernet pair is now called `ve-container-name` rather than `c-container-name`.

- GNOME 3.10 support has been dropped. The default GNOME version is now 3.12.

- VirtualBox has been upgraded to 4.3.20 release. Users may be required to run `rm -rf /tmp/.vbox*`. The line `imports = [ <nixpkgs/nixos/modules/programs/virtualbox.nix> ]` is no longer necessary, use `services.virtualboxHost.enable = true` instead.

  Also, hardening mode is now enabled by default, which means that unless you want to use USB support, you no longer need to be a member of the `vboxusers` group.

- Chromium has been updated to 39.0.2171.65. `enablePepperPDF` is now enabled by default. `chromium*Wrapper` packages no longer exist, because upstream removed NSAPI support. `chromium-stable` has been renamed to `chromium`.

- Python packaging documentation is now part of nixpkgs manual. To override the python packages available to a custom python you now use `pkgs.pythonFull.buildEnv.override` instead of `pkgs.pythonFull.override`.

- `boot.resumeDevice = "8:6"` is no longer supported. Most users will want to leave it undefined, which takes the swap partitions automatically. There is an evaluation assertion to ensure that the string starts with a slash.

- The system-wide default timezone for NixOS installations changed from `CET` to `UTC`. To choose a different timezone for your system, configure `time.timeZone` in `configuration.nix`. A fairly complete list of possible values for that setting is available at <https://en.wikipedia.org/wiki/List_of_tz_database_time_zones>.

- GNU screen has been updated to 4.2.1, which breaks the ability to connect to sessions created by older versions of screen.

- The Intel GPU driver was updated to the 3.x prerelease version (used by most distributions) and supports DRI3 now.
