{
  lib,
  buildGoModule,
  fetchFromGitHub,
}:

buildGoModule rec {
  pname = "zgrab2";
  version = "unstable-2023-03-23";

  src = fetchFromGitHub {
    owner = "zmap";
    repo = pname;
    rev = "911c86f13080ceae98f8d63d1ae0e85c4a8f7f61";
    hash = "sha256-VOWkBM/SziY3jiIaYYWq+LRzG4vKitiscqdIDfRUkYY=";
  };

  vendorHash = "sha256-Q3FCqvh4vn64QXqcePhVWTyIHJarI6I4YonH3X/7RhI=";

  patches = [
    # Without this, we get error messages like:
    # vendor/golang.org/x/sys/unix/syscall.go:83:16: unsafe.Slice requires go1.17 or later (-lang was set to go1.16; check go.mod)
    # The patch was generated by changing "go 1.12" to "go 1.17" and executing `go mod tidy -compat=1.17`.
    ./fix-go-version-error.patch
  ];

  subPackages = [
    "cmd/zgrab2"
  ];

  meta = with lib; {
    description = "Web application scanner";
    mainProgram = "zgrab2";
    homepage = "https://github.com/zmap/zgrab2";
    license = with licenses; [
      asl20
      isc
    ];
    maintainers = with maintainers; [
      fab
      juliusrickert
    ];
  };
}
