# Release 16.09 ("Flounder", 2016/09/30) {#sec-release-16.09}

In addition to numerous new and upgraded packages, this release has the following highlights:

- Many NixOS configurations and Nix packages now use significantly less disk space, thanks to the [extensive work on closure size reduction](https://github.com/NixOS/nixpkgs/issues/7117). For example, the closure size of a minimal NixOS container went down from \~424 MiB in 16.03 to \~212 MiB in 16.09, while the closure size of Firefox went from \~651 MiB to \~259 MiB.

- To improve security, packages are now [built using various hardening features](https://github.com/NixOS/nixpkgs/pull/12895). See the Nixpkgs manual for more information.

- Support for PXE netboot. See [](#sec-booting-from-pxe) for documentation.

- X.org server 1.18. If you use the `ati_unfree` driver, 1.17 is still used due to an ABI incompatibility.

- This release is based on Glibc 2.24, GCC 5.4.0 and systemd 231. The default Linux kernel remains 4.4.

The following new services were added since the last release:

- `(this will get automatically generated at release time)`

When upgrading from a previous release, please be aware of the following incompatible changes:

- A large number of packages have been converted to use the multiple outputs feature of Nix to greatly reduce the amount of required disk space, as mentioned above. This may require changes to any custom packages to make them build again; see the relevant chapter in the Nixpkgs manual for more information. (Additional caveat to packagers: some packaging conventions related to multiple-output packages [were changed](https://github.com/NixOS/nixpkgs/pull/14766) late (August 2016) in the release cycle and differ from the initial introduction of multiple outputs.)

- Previous versions of Nixpkgs had support for all versions of the LTS Haskell package set. That support has been dropped. The previously provided `haskell.packages.lts-x_y` package sets still exist in name to avoid breaking user code, but these package sets don't actually contain the versions mandated by the corresponding LTS release. Instead, our package set it loosely based on the latest available LTS release, i.e. LTS 7.x at the time of this writing. New releases of NixOS and Nixpkgs will drop those old names entirely. [The motivation for this change](https://nixos.org/nix-dev/2016-June/020585.html) has been discussed at length on the `nix-dev` mailing list and in [Github issue \#14897](https://github.com/NixOS/nixpkgs/issues/14897). Development strategies for Haskell hackers who want to rely on Nix and NixOS have been described in [another nix-dev article](https://nixos.org/nix-dev/2016-June/020642.html).

- Shell aliases for systemd sub-commands [were dropped](https://github.com/NixOS/nixpkgs/pull/15598): `start`, `stop`, `restart`, `status`.

- Redis now binds to 127.0.0.1 only instead of listening to all network interfaces. This is the default behavior of Redis 3.2

- `/var/empty` is now immutable. Activation script runs `chattr +i` to forbid any modifications inside the folder. See [ the pull request](https://github.com/NixOS/nixpkgs/pull/18365) for what bugs this caused.

- Gitlab's maintenance script `gitlab-runner` was removed and split up into the more clearer `gitlab-run` and `gitlab-rake` scripts, because `gitlab-runner` is a component of Gitlab CI.

- `services.xserver.libinput.accelProfile` default changed from `flat` to `adaptive`, as per [ official documentation](https://wayland.freedesktop.org/libinput/doc/latest/group__config.html#gad63796972347f318b180e322e35cee79).

- `fonts.fontconfig.ultimate.rendering` was removed because our presets were obsolete for some time. New presets are hardcoded into FreeType; you can select a preset via `fonts.fontconfig.ultimate.preset`. You can customize those presets via ordinary environment variables, using `environment.variables`.

- The `audit` service is no longer enabled by default. Use `security.audit.enable = true` to explicitly enable it.

- `pkgs.linuxPackages.virtualbox` now contains only the kernel modules instead of the VirtualBox user space binaries. If you want to reference the user space binaries, you have to use the new `pkgs.virtualbox` instead.

- `goPackages` was replaced with separated Go applications in appropriate `nixpkgs` categories. Each Go package uses its own dependency set. There's also a new `go2nix` tool introduced to generate a Go package definition from its Go source automatically.

- `services.mongodb.extraConfig` configuration format was changed to YAML.

- PHP has been upgraded to 7.0

Other notable improvements:

- Revamped grsecurity/PaX support. There is now only a single general-purpose distribution kernel and the configuration interface has been streamlined. Desktop users should be able to set

  ```nix
  { security.grsecurity.enable = true; }
  ```

  to get a reasonably secure system without having to sacrifice too much functionality.

- Special filesystems, like `/proc`, `/run` and others, now have the same mount options as recommended by systemd and are unified across different places in NixOS. Mount options are updated during `nixos-rebuild switch` if possible. One benefit from this is improved security --- most such filesystems are now mounted with `noexec`, `nodev` and/or `nosuid` options.

- The reverse path filter was interfering with DHCPv4 server operation in the past. An exception for DHCPv4 and a new option to log packets that were dropped due to the reverse path filter was added (`networking.firewall.logReversePathDrops`) for easier debugging.

- Containers configuration within `containers.<name>.config` is [now properly typed and checked](https://github.com/NixOS/nixpkgs/pull/17365). In particular, partial configurations are merged correctly.

- The directory container setuid wrapper programs, `/var/setuid-wrappers`, [is now updated atomically to prevent failures if the switch to a new configuration is interrupted.](https://github.com/NixOS/nixpkgs/pull/18124)

- `services.xserver.startGnuPGAgent` has been removed due to GnuPG 2.1.x bump. See [ how to achieve similar behavior](https://github.com/NixOS/nixpkgs/commit/5391882ebd781149e213e8817fba6ac3c503740c). You might need to `pkill gpg-agent` after the upgrade to prevent a stale agent being in the way.

- [ Declarative users could share the uid due to the bug in the script handling conflict resolution. ](https://github.com/NixOS/nixpkgs/commit/e561edc322d275c3687fec431935095cfc717147)

- Gummi boot has been replaced using systemd-boot.

- Hydra package and NixOS module were added for convenience.
