{
  lib,
  buildPythonApplication,
  pythonOlder,
  fetchFromGitHub,
  pdm-backend,
  cmake-format,
  pygls,
  cmake,
  pytest-datadir,
  pytestCheckHook,
}:

buildPythonApplication rec {
  pname = "cmake-language-server";
  version = "0.1.11";
  format = "pyproject";

  disabled = pythonOlder "3.8";

  src = fetchFromGitHub {
    owner = "regen100";
    repo = "cmake-language-server";
    tag = "v${version}";
    hash = "sha256-QxknG5NFYky6ZSjiIugLfHT4gXsyTBVbMMeULhQsmdk=";
  };

  patches = [
    # Test timeouts occasionally cause the build to fail
    ./disable-test-timeouts.patch
  ];

  nativeBuildInputs = [
    pdm-backend
  ];

  propagatedBuildInputs = [
    cmake-format
    pygls
  ];

  nativeCheckInputs = [
    cmake
    cmake-format
    pytest-datadir
    pytestCheckHook
  ];

  # version.py generated by pdm, no idea why it's not present in test phase
  # https://github.com/regen100/cmake-language-server/blob/v0.1.11/pyproject.toml#L35-L36
  preCheck = ''
    echo "__version__ = \"$PDM_BUILD_SCM_VERSION\"" > cmake_language_server/version.py
  '';

  dontUseCmakeConfigure = true;

  pythonImportsCheck = [
    "cmake_language_server"
  ];

  meta = with lib; {
    description = "CMake LSP Implementation";
    homepage = "https://github.com/regen100/cmake-language-server";
    changelog = "https://github.com/regen100/cmake-language-server/releases/tag/${src.tag}";
    license = licenses.mit;
    maintainers = with maintainers; [ kira-bruneau ];
    mainProgram = "cmake-language-server";
  };
}
