{
  lib,
  stdenv,
  fetchFromGitLab,
  makeWrapper,
}:

stdenv.mkDerivation rec {
  pname = "exploitdb";
  version = "2025-06-21";

  src = fetchFromGitLab {
    owner = "exploit-database";
    repo = "exploitdb";
    rev = "refs/tags/${version}";
    hash = "sha256-6mXku+SW6xmSYxd40Ilis8H/2Ozm6eUecLQHy1xeKtM=";
  };

  nativeBuildInputs = [ makeWrapper ];

  installPhase = ''
    runHook preInstall
    mkdir -p $out/bin $out/share
    cp --recursive . $out/share/exploitdb
    makeWrapper $out/share/exploitdb/searchsploit $out/bin/searchsploit
    runHook postInstall
  '';

  meta = with lib; {
    description = "Archive of public exploits and corresponding vulnerable software";
    homepage = "https://gitlab.com/exploit-database/exploitdb";
    license = with licenses; [
      gpl2Plus
      gpl3Plus
      mit
    ];
    maintainers = with maintainers; [
      applePrincess
      fab
    ];
    mainProgram = "searchsploit";
    platforms = platforms.unix;
  };
}
