{
  stdenv,
  lib,
  fetchzip,
  rustPlatform,

  # native build inputs
  pkg-config,
  installShellFiles,
  makeWrapper,
  mandoc,
  rustfmt,
  file,
  writableTmpDirAsHomeHook,

  # build inputs
  openssl,
  dbus,
  sqlite,

  # runtime deps
  gpgme,
  gnum4,
}:

rustPlatform.buildRustPackage rec {
  pname = "meli";
  version = "0.8.11";

  src = fetchzip {
    urls = [
      "https://git.meli-email.org/meli/meli/archive/v${version}.tar.gz"
      "https://codeberg.org/meli/meli/archive/v${version}.tar.gz"
      "https://github.com/meli/meli/archive/refs/tags/v${version}.tar.gz"
    ];
    hash = "sha256-q3vnvH0GWnrfYnk2WBRLTDInJ/wazI4JtkEMwiWanfI=";
  };

  cargoHash = "sha256-OAytdJgIiaS0xsHWOgNW2dkRQEyU9xcyaJtxClWzfjQ=";

  # Needed to get openssl-sys to use pkg-config
  OPENSSL_NO_VENDOR = 1;

  nativeBuildInputs = [
    pkg-config
    installShellFiles
    makeWrapper
    mandoc
    (rustfmt.override { asNightly = true; })
  ];

  buildInputs = [
    openssl
    dbus
    sqlite
  ];

  nativeCheckInputs = [
    file
    gnum4
    writableTmpDirAsHomeHook
  ];

  postInstall = ''
    installManPage meli/docs/*.{1,5,7}

    wrapProgram $out/bin/meli \
      --prefix LD_LIBRARY_PATH : ${lib.makeLibraryPath [ gpgme ]} \
      --prefix PATH : ${lib.makeBinPath [ gnum4 ]}
  '';

  checkFlags = [
    "--skip=test_cli_subcommands" # panicking due to sandbox
  ];

  meta = with lib; {
    broken = (stdenv.hostPlatform.isLinux && stdenv.hostPlatform.isAarch64);
    description = "Terminal e-mail client and e-mail client library";
    mainProgram = "meli";
    homepage = "https://meli.delivery";
    license = licenses.gpl3;
    maintainers = with maintainers; [
      _0x4A6F
      matthiasbeyer
    ];
    platforms = platforms.linux ++ platforms.darwin;
  };
}
