{
  lib,
  python3Packages,
  fetchFromGitHub,
  procps,
  stdenv,
  versionCheckHook,
  addBinToPathHook,
}:

python3Packages.buildPythonApplication rec {
  pname = "multiqc";
  version = "1.28";

  # Two data sources. One for the code, another for the test data
  srcs = [
    (fetchFromGitHub {
      name = "multiqc";
      owner = "MultiQC";
      repo = "MultiQC";
      tag = "v${version}";
      hash = "sha256-rYZaecoVAO1RE44XCw60aVwvWhKcZ/RrG3WpVRcLbuA=";
    })
    (fetchFromGitHub {
      owner = "MultiQC";
      repo = "test-data";
      rev = "d775b73c106d48726653f2fd02e473b7acbd93d8";
      hash = "sha256-uxBpMx22gWJmnbF9tVuVIdYdiqUh7n51swzu5hnfZQ0=";
      name = "test-data";
    })
  ];

  sourceRoot = "multiqc";

  dependencies = with python3Packages; [
    click
    humanize
    importlib-metadata
    jinja2
    kaleido
    markdown
    natsort
    numpy
    packaging
    requests
    pillow
    plotly
    pyyaml
    rich
    rich-click
    coloredlogs
    spectra
    pydantic
    typeguard
    tqdm
    python-dotenv
    jsonschema
  ];

  optional-dependencies = {
    dev = with python3Packages; [
      pre-commit-hooks
      pdoc3
      pytest
      pytest-cov-stub
      pytest-xdist
      syrupy
      pygithub
      mypy
      types-pyyaml
      types-tqdm
      types-requests
      types-markdown
      types-beautifulsoup4
      types-pillow
    ];
  };

  # Some tests run subprocess.run() with "multiqc"
  preCheck = ''
    chmod -R u+w ../test-data
    ln -s ../test-data .
  '';

  # Some tests run subprocess.run() with "ps"
  nativeCheckInputs =
    with python3Packages;
    [
      procps
      pytest-cov
      pytest-xdist
      pytestCheckHook
      syrupy
      pygithub
      versionCheckHook
    ]
    ++ [
      addBinToPathHook
    ];

  versionCheckProgramArg = "--version";

  disabledTests =
    # On darwin, kaleido fails to starts
    lib.optionals (stdenv.hostPlatform.isDarwin) [
      "test_flat_plot"
    ];

  meta = {
    description = "Aggregates bioinformatics results from multiple samples into a unified report";
    longDescription = ''
      MultiQC is a tool to create a single report with interactive plots for multiple bioinformatics analyses across many samples.

      Reports are generated by scanning given directories for recognised log files. These are parsed and a single HTML report is generated summarising the statistics for all logs found. MultiQC reports can describe multiple analysis steps and large numbers of samples within a single plot, and multiple analysis tools making it ideal for routine fast quality control.
    '';
    homepage = "https://multiqc.info";
    changelog = "https://github.com/MultiQC/MultiQC/releases/tag/v${version}/";
    license = [ lib.licenses.gpl3Plus ];
    maintainers = [ lib.maintainers.apraga ];
    mainProgram = "multiqc";
    platforms = lib.platforms.unix;
  };

}
