{
  lib,
  buildPythonPackage,
  fetchPypi,
  gitpython,
  pythonOlder,
  requests,
  setuptools,
}:

buildPythonPackage rec {
  pname = "pyexploitdb";
  version = "0.2.80";
  pyproject = true;

  disabled = pythonOlder "3.7";

  src = fetchPypi {
    pname = "pyExploitDb";
    inherit version;
    hash = "sha256-5ThLYOao/qGkY37hNWKcq1Oker8Gc8dOmdVlf7y7D6M=";
  };

  build-system = [ setuptools ];

  dependencies = [
    gitpython
    requests
  ];

  # Module has no tests
  doCheck = false;

  pythonImportsCheck = [ "pyExploitDb" ];

  meta = with lib; {
    description = "Library to fetch the most recent exploit-database";
    homepage = "https://github.com/Hackman238/pyExploitDb";
    changelog = "https://github.com/Hackman238/pyExploitDb/blob/master/ChangeLog.md";
    license = licenses.gpl3Plus;
    maintainers = with maintainers; [ fab ];
  };
}
