# This file is tested by tests/installer/default.nix.
if [ -n "${HOME-}" ] && [ -n "${USER-}" ]; then

    # Set up the per-user profile.

    if [ -n "${NIX_STATE_HOME-}" ]; then
        NIX_LINK="$NIX_STATE_HOME/profile"
    else
        NIX_LINK="$HOME/.nix-profile"
        if [ -n "${XDG_STATE_HOME-}" ]; then
            NIX_LINK_NEW="$XDG_STATE_HOME/nix/profile"
        else
            NIX_LINK_NEW="$HOME/.local/state/nix/profile"
        fi
        if [ -e "$NIX_LINK_NEW" ]; then
            if [ -t 2 ] && [ -e "$NIX_LINK" ]; then
                warning="\033[1;35mwarning:\033[0m"
                printf "$warning Both %s and legacy %s exist; using the former.\n" "$NIX_LINK_NEW" "$NIX_LINK" 1>&2
                if [ "$(realpath "$NIX_LINK")" = "$(realpath "$NIX_LINK_NEW")" ]; then
                    printf "         Since the profiles match, you can safely delete either of them.\n" 1>&2
                else
                    # This should be an exceptionally rare occasion: the only way to get it would be to
                    # 1. Update to newer Nix;
                    # 2. Remove .nix-profile;
                    # 3. Set the $NIX_LINK_NEW to something other than the default user profile;
                    # 4. Roll back to older Nix.
                    # If someone did all that, they can probably figure out how to migrate the profile.
                    printf "$warning Profiles do not match. You should manually migrate from %s to %s.\n" "$NIX_LINK" "$NIX_LINK_NEW" 1>&2
                fi
            fi
            NIX_LINK="$NIX_LINK_NEW"
        fi
    fi

    # Set up environment.
    # This part should be kept in sync with nixpkgs:nixos/modules/programs/environment.nix
    export NIX_PROFILES="/nix/var/nix/profiles/default $NIX_LINK"

    # Populate bash completions, .desktop files, etc
    if [ -z "${XDG_DATA_DIRS-}" ]; then
        # According to XDG spec the default is /usr/local/share:/usr/share, don't set something that prevents that default
        export XDG_DATA_DIRS="/usr/local/share:/usr/share:$NIX_LINK/share:/nix/var/nix/profiles/default/share"
    else
        export XDG_DATA_DIRS="$XDG_DATA_DIRS:$NIX_LINK/share:/nix/var/nix/profiles/default/share"
    fi

    # Set $NIX_SSL_CERT_FILE so that Nixpkgs applications like curl work.
    if [ -e /etc/ssl/certs/ca-certificates.crt ]; then # NixOS, Ubuntu, Debian, Gentoo, Arch
        export NIX_SSL_CERT_FILE=/etc/ssl/certs/ca-certificates.crt
    elif [ -e /etc/ssl/ca-bundle.pem ]; then # openSUSE Tumbleweed
        export NIX_SSL_CERT_FILE=/etc/ssl/ca-bundle.pem
    elif [ -e /etc/ssl/certs/ca-bundle.crt ]; then # Old NixOS
        export NIX_SSL_CERT_FILE=/etc/ssl/certs/ca-bundle.crt
    elif [ -e /etc/pki/tls/certs/ca-bundle.crt ]; then # Fedora, CentOS
        export NIX_SSL_CERT_FILE=/etc/pki/tls/certs/ca-bundle.crt
    elif [ -e "$NIX_LINK/etc/ssl/certs/ca-bundle.crt" ]; then # fall back to cacert in Nix profile
        export NIX_SSL_CERT_FILE="$NIX_LINK/etc/ssl/certs/ca-bundle.crt"
    elif [ -e "$NIX_LINK/etc/ca-bundle.crt" ]; then # old cacert in Nix profile
        export NIX_SSL_CERT_FILE="$NIX_LINK/etc/ca-bundle.crt"
    fi

    # Only use MANPATH if it is already set. In general `man` will just simply
    # pick up `.nix-profile/share/man` because is it close to `.nix-profile/bin`
    # which is in the $PATH. For more info, run `manpath -d`.
    if [ -n "${MANPATH-}" ]; then
        export MANPATH="$NIX_LINK/share/man:$MANPATH"
    fi

    export PATH="$NIX_LINK/bin:$PATH"
    unset NIX_LINK NIX_LINK_NEW
fi
