# Release 17.09 ("Hummingbird", 2017/09/??) {#sec-release-17.09}

## Highlights {#sec-release-17.09-highlights}

In addition to numerous new and upgraded packages, this release has the following highlights:

- The GNOME version is now 3.24. KDE Plasma was upgraded to 5.10, KDE Applications to 17.08.1 and KDE Frameworks to 5.37.

- The user handling now keeps track of deallocated UIDs/GIDs. When a user or group is revived, this allows it to be allocated the UID/GID it had before. A consequence is that UIDs and GIDs are no longer reused.

- The module option `services.xserver.xrandrHeads` now causes the first head specified in this list to be set as the primary head. Apart from that, it's now possible to also set additional options by using an attribute set, for example:

  ```nix
  {
    services.xserver.xrandrHeads = [
      "HDMI-0"
      {
        output = "DVI-0";
        primary = true;
        monitorConfig = ''
          Option "Rotate" "right"
        '';
      }
    ];
  }
  ```

  This will set the `DVI-0` output to be the primary head, even though `HDMI-0` is the first head in the list.

- The handling of SSL in the `services.nginx` module has been cleaned up, renaming the misnamed `enableSSL` to `onlySSL` which reflects its original intention. This is not to be used with the already existing `forceSSL` which creates a second non-SSL virtual host redirecting to the SSL virtual host. This by chance had worked earlier due to specific implementation details. In case you had specified both please remove the `enableSSL` option to keep the previous behaviour.

  Another `addSSL` option has been introduced to configure both a non-SSL virtual host and an SSL virtual host with the same configuration.

  Options to configure `resolver` options and `upstream` blocks have been introduced. See their information for further details.

  The `port` option has been replaced by a more generic `listen` option which makes it possible to specify multiple addresses, ports and SSL configs dependant on the new SSL handling mentioned above.

## New Services {#sec-release-17.09-new-services}

The following new services were added since the last release:

- `config/fonts/fontconfig-penultimate.nix`

- `config/fonts/fontconfig-ultimate.nix`

- `config/terminfo.nix`

- `hardware/sensor/iio.nix`

- `hardware/nitrokey.nix`

- `hardware/raid/hpsa.nix`

- `programs/browserpass.nix`

- `programs/gnupg.nix`

- `programs/qt5ct.nix`

- `programs/slock.nix`

- `programs/thefuck.nix`

- `security/auditd.nix`

- `security/lock-kernel-modules.nix`

- `service-managers/docker.nix`

- `service-managers/trivial.nix`

- `services/admin/salt/master.nix`

- `services/admin/salt/minion.nix`

- `services/audio/slimserver.nix`

- `services/cluster/kubernetes/default.nix`

- `services/cluster/kubernetes/dns.nix`

- `services/cluster/kubernetes/dashboard.nix`

- `services/continuous-integration/hail.nix`

- `services/databases/clickhouse.nix`

- `services/databases/postage.nix`

- `services/desktops/gnome3/gnome-disks.nix`

- `services/desktops/gnome3/gpaste.nix`

- `services/logging/SystemdJournal2Gelf.nix`

- `services/logging/heartbeat.nix`

- `services/logging/journalwatch.nix`

- `services/logging/syslogd.nix`

- `services/mail/mailhog.nix`

- `services/mail/nullmailer.nix`

- `services/misc/airsonic.nix`

- `services/misc/autorandr.nix`

- `services/misc/exhibitor.nix`

- `services/misc/fstrim.nix`

- `services/misc/gollum.nix`

- `services/misc/irkerd.nix`

- `services/misc/jackett.nix`

- `services/misc/radarr.nix`

- `services/misc/snapper.nix`

- `services/monitoring/osquery.nix`

- `services/monitoring/prometheus/collectd-exporter.nix`

- `services/monitoring/prometheus/fritzbox-exporter.nix`

- `services/network-filesystems/kbfs.nix`

- `services/networking/dnscache.nix`

- `services/networking/fireqos.nix`

- `services/networking/iwd.nix`

- `services/networking/keepalived/default.nix`

- `services/networking/keybase.nix`

- `services/networking/lldpd.nix`

- `services/networking/matterbridge.nix`

- `services/networking/squid.nix`

- `services/networking/tinydns.nix`

- `services/networking/xrdp.nix`

- `services/security/shibboleth-sp.nix`

- `services/security/sks.nix`

- `services/security/sshguard.nix`

- `services/security/torify.nix`

- `services/security/usbguard.nix`

- `services/security/vault.nix`

- `services/system/earlyoom.nix`

- `services/system/saslauthd.nix`

- `services/web-apps/nexus.nix`

- `services/web-apps/pgpkeyserver-lite.nix`

- `services/web-apps/piwik.nix`

- `services/web-servers/lighttpd/collectd.nix`

- `services/web-servers/minio.nix`

- `services/x11/display-managers/xpra.nix`

- `services/x11/xautolock.nix`

- `tasks/filesystems/bcachefs.nix`

- `tasks/powertop.nix`

## Backward Incompatibilities {#sec-release-17.09-incompatibilities}

When upgrading from a previous release, please be aware of the following incompatible changes:

- **In an Qemu-based virtualization environment, the network interface names changed from i.e. `enp0s3` to `ens3`.**

  This is due to a kernel configuration change. The new naming is consistent with those of other Linux distributions with systemd. See [\#29197](https://github.com/NixOS/nixpkgs/issues/29197) for more information.

  A machine is affected if the `virt-what` tool either returns `qemu` or `kvm` _and_ has interface names used in any part of its NixOS configuration, in particular if a static network configuration with `networking.interfaces` is used.

  Before rebooting affected machines, please ensure:

  - Change the interface names in your NixOS configuration. The first interface will be called `ens3`, the second one `ens8` and starting from there incremented by 1.

  - After changing the interface names, rebuild your system with `nixos-rebuild boot` to activate the new configuration after a reboot. If you switch to the new configuration right away you might lose network connectivity! If using `nixops`, deploy with `nixops deploy --force-reboot`.

- The following changes apply if the `stateVersion` is changed to 17.09 or higher. For `stateVersion = "17.03"` or lower the old behavior is preserved.

  - The `postgres` default version was changed from 9.5 to 9.6.

  - The `postgres` superuser name has changed from `root` to `postgres` to more closely follow what other Linux distributions are doing.

  - The `postgres` default `dataDir` has changed from `/var/db/postgres` to `/var/lib/postgresql/$psqlSchema` where \$psqlSchema is 9.6 for example.

  - The `mysql` default `dataDir` has changed from `/var/mysql` to `/var/lib/mysql`.

  - Radicale's default package has changed from 1.x to 2.x. Instructions to migrate can be found [ here ](http://radicale.org/1to2/). It is also possible to use the newer version by setting the `package` to `radicale2`, which is done automatically when `stateVersion` is 17.09 or higher. The `extraArgs` option has been added to allow passing the data migration arguments specified in the instructions; see the `radicale.nix` NixOS test for an example migration.

- The `aiccu` package was removed. This is due to SixXS [ sunsetting](https://www.sixxs.net/main/) its IPv6 tunnel.

- The `fanctl` package and `fan` module have been removed due to the developers not upstreaming their iproute2 patches and lagging with compatibility to recent iproute2 versions.

- Top-level `idea` package collection was renamed. All JetBrains IDEs are now at `jetbrains`.

- `flexget`'s state database cannot be upgraded to its new internal format, requiring removal of any existing `db-config.sqlite` which will be automatically recreated.

- The `ipfs` service now doesn't ignore the `dataDir` option anymore. If you've ever set this option to anything other than the default you'll have to either unset it (so the default gets used) or migrate the old data manually with

  ```ShellSession
  dataDir=<valueOfDataDir>
  mv /var/lib/ipfs/.ipfs/* $dataDir
  rmdir /var/lib/ipfs/.ipfs
  ```

- The `caddy` service was previously using an extra `.caddy` directory in the data directory specified with the `dataDir` option. The contents of the `.caddy` directory are now expected to be in the `dataDir`.

- The `ssh-agent` user service is not started by default anymore. Use `programs.ssh.startAgent` to enable it if needed. There is also a new `programs.gnupg.agent` module that creates a `gpg-agent` user service. It can also serve as a SSH agent if `enableSSHSupport` is set.

- The `services.tinc.networks.<name>.listenAddress` option had a misleading name that did not correspond to its behavior. It now correctly defines the ip to listen for incoming connections on. To keep the previous behaviour, use `services.tinc.networks.<name>.bindToAddress` instead. Refer to the description of the options for more details.

- `tlsdate` package and module were removed. This is due to the project being dead and not building with openssl 1.1.

- `wvdial` package and module were removed. This is due to the project being dead and not building with openssl 1.1.

- `cc-wrapper`'s setup-hook now exports a number of environment variables corresponding to binutils binaries, (e.g. `LD`, `STRIP`, `RANLIB`, etc). This is done to prevent packages' build systems guessing, which is harder to predict, especially when cross-compiling. However, some packages have broken due to this---their build systems either not supporting, or claiming to support without adequate testing, taking such environment variables as parameters.

- `services.firefox.syncserver` now runs by default as a non-root user. To accommodate this change, the default sqlite database location has also been changed. Migration should work automatically. Refer to the description of the options for more details.

- The `compiz` window manager and package was removed. The system support had been broken for several years.

- Touchpad support should now be enabled through `libinput` as `synaptics` is now deprecated. See the option `services.xserver.libinput.enable`.

- grsecurity/PaX support has been dropped, following upstream's decision to cease free support. See [ upstream's announcement](https://grsecurity.net/passing_the_baton.php) for more information. No complete replacement for grsecurity/PaX is available presently.

- `services.mysql` now has declarative configuration of databases and users with the `ensureDatabases` and `ensureUsers` options.

  These options will never delete existing databases and users, especially not when the value of the options are changed.

  The MySQL users will be identified using [ Unix socket authentication](https://mariadb.com/kb/en/library/authentication-plugin-unix-socket/). This authenticates the Unix user with the same name only, and that without the need for a password.

  If you have previously created a MySQL `root` user _with a password_, you will need to add `root` user for unix socket authentication before using the new options. This can be done by running the following SQL script:

  ```SQL
  CREATE USER 'root'@'%' IDENTIFIED BY '';
  GRANT ALL PRIVILEGES ON *.* TO 'root'@'%' WITH GRANT OPTION;
  FLUSH PRIVILEGES;

  -- Optionally, delete the password-authenticated user:
  -- DROP USER 'root'@'localhost';
  ```

- `services.mysqlBackup` now works by default without any user setup, including for users other than `mysql`.

  By default, the `mysql` user is no longer the user which performs the backup. Instead a system account `mysqlbackup` is used.

  The `mysqlBackup` service is also now using systemd timers instead of `cron`.

  Therefore, the `services.mysqlBackup.period` option no longer exists, and has been replaced with `services.mysqlBackup.calendar`, which is in the format of [systemd.time(7)](https://www.freedesktop.org/software/systemd/man/systemd.time.html#Calendar%20Events).

  If you expect to be sent an e-mail when the backup fails, consider using a script which monitors the systemd journal for errors. Regretfully, at present there is no built-in functionality for this.

  You can check that backups still work by running `systemctl start mysql-backup` then `systemctl status mysql-backup`.

- Templated systemd services e.g `container@name` are now handled correctly when switching to a new configuration, resulting in them being reloaded.

- Steam: the `newStdcpp` parameter was removed and should not be needed anymore.

- Redis has been updated to version 4 which mandates a cluster mass-restart, due to changes in the network handling, in order to ensure compatibility with networks NATing traffic.

## Other Notable Changes {#sec-release-17.09-notable-changes}

- Modules can now be disabled by using [ disabledModules](https://nixos.org/nixpkgs/manual/#sec-replace-modules), allowing another to take it's place. This can be used to import a set of modules from another channel while keeping the rest of the system on a stable release.

- Updated to FreeType 2.7.1, including a new TrueType engine. The new engine replaces the Infinality engine which was the default in NixOS. The default font rendering settings are now provided by fontconfig-penultimate, replacing fontconfig-ultimate; the new defaults are less invasive and provide rendering that is more consistent with other systems and hopefully with each font designer's intent. Some system-wide configuration has been removed from the Fontconfig NixOS module where user Fontconfig settings are available.

- ZFS/SPL have been updated to 0.7.0, `zfsUnstable, splUnstable` have therefore been removed.

- The `time.timeZone` option now allows the value `null` in addition to timezone strings. This value allows changing the timezone of a system imperatively using `timedatectl set-timezone`. The default timezone is still UTC.

- Nixpkgs overlays may now be specified with a file as well as a directory. The value of `<nixpkgs-overlays>` may be a file, and `~/.config/nixpkgs/overlays.nix` can be used instead of the `~/.config/nixpkgs/overlays` directory.

  See the overlays chapter of the Nixpkgs manual for more details.

- Definitions for `/etc/hosts` can now be specified declaratively with `networking.hosts`.

- Two new options have been added to the installer loader, in addition to the default having changed. The kernel log verbosity has been lowered to the upstream default for the default options, in order to not spam the console when e.g. joining a network.

  This therefore leads to adding a new `debug` option to set the log level to the previous verbose mode, to make debugging easier, but still accessible easily.

  Additionally a `copytoram` option has been added, which makes it possible to remove the install medium after booting. This allows tethering from your phone after booting from it.

- `services.gitlab-runner.configOptions` has been added to specify the configuration of gitlab-runners declaratively.

- `services.jenkins.plugins` has been added to install plugins easily, this can be generated with jenkinsPlugins2nix.

- `services.postfix.config` has been added to specify the main.cf with NixOS options. Additionally other options have been added to the postfix module and has been improved further.

- The GitLab package and module have been updated to the latest 10.0 release.

- The `systemd-boot` boot loader now lists the NixOS version, kernel version and build date of all bootable generations.

- The dnscrypt-proxy service now defaults to using a random upstream resolver, selected from the list of public non-logging resolvers with DNSSEC support. Existing configurations can be migrated to this mode of operation by omitting the `services.dnscrypt-proxy.resolverName` option or setting it to `"random"`.
