{
  lib,
  stdenv,
  fetchurl,
  lua,
  gettext,
  groff,
  libICE,
  libSM,
  libX11,
  libXext,
}:

stdenv.mkDerivation rec {
  pname = "ion";
  version = "3-20090110";

  src = fetchurl {
    url = "https://tuomov.iki.fi/software/ion/dl/ion-${version}.tar.gz";
    sha256 = "1nkks5a95986nyfkxvg2rik6zmwx0lh7szd5fji7yizccwzc9xns";
  };

  buildInputs = [
    libICE
    libSM
    libX11
    libXext
    lua
    gettext
    groff
  ];

  buildFlags = [
    "LUA_DIR=${lua}"
    "X11_PREFIX=/no-such-path"
    "PREFIX=\${out}"
  ];

  # Build system is missing depends for autogenerated export headers:
  #   luac -o mod_tiling.lc mod_tiling.lua
  #   main.c:21:10: fatal error: exports.h: No such file or directory
  enableParallelBuilding = false;

  installFlags = [ "PREFIX=\${out}" ];

  meta = with lib; {
    description = "Tiling tabbed window manager designed with keyboard users in mind";
    homepage = "https://tuomov.iki.fi/software/ion/";
    platforms = with platforms; linux;
    license = licenses.lgpl21;
    maintainers = [ ];
  };
}
