{
  lib,
  buildGoModule, # sync with go below, update to latest release
  fetchFromGitHub,

  # passthru test
  go-mockery,
  runCommand,
  go,
}:

buildGoModule rec {
  pname = "go-mockery";
  version = "2.53.3";

  src = fetchFromGitHub {
    owner = "vektra";
    repo = "mockery";
    rev = "v${version}";
    sha256 = "sha256-X0cHpv4o6pzgjg7+ULCuFkspeff95WFtJbVHqy4LxAg=";
  };

  ldflags = [
    "-s"
    "-w"
    "-X"
    "github.com/vektra/mockery/v${lib.versions.major version}/pkg/logging.SemVer=v${version}"
  ];

  env.CGO_ENABLED = false;

  proxyVendor = true;
  vendorHash = "sha256-AQY4x2bLqMwHIjoKHzEm1hebR29gRs3LJN8i00Uup5o=";

  subPackages = [ "." ];

  preCheck = ''
    # check all paths
    unset subPackages

    substituteInPlace ./pkg/generator_test.go --replace-fail 0.0.0-dev ${version}
    substituteInPlace ./pkg/logging/logging_test.go --replace-fail v0.0 v${lib.versions.majorMinor version}
  '';

  passthru.tests = {
    generateMock =
      runCommand "${pname}-test"
        {
          nativeBuildInputs = [ go-mockery ];
          buildInputs = [ go ];
        }
        ''
          if [[ $(${meta.mainProgram} --version) != *"${version}"* ]]; then
            echo "Error: program version does not match package version"
            exit 1
          fi

          export HOME=$TMPDIR

          cat <<EOF > foo.go
          package main

          type Foo interface {
            Bark() string
          }
          EOF

          ${meta.mainProgram} --name Foo --dir .

          if [[ ! -f "mocks/Foo.go" ]]; then
            echo "Error: mocks/Foo.go was not generated by ${pname}"
            exit 1
          fi

          touch $out
        '';
  };

  meta = {
    homepage = "https://github.com/vektra/mockery";
    description = "Mock code autogenerator for Golang";
    maintainers = with lib.maintainers; [
      fbrs
      jk
    ];
    mainProgram = "mockery";
    license = lib.licenses.bsd3;
  };
}
