﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

// Source files represent a source generated JsonSerializerContext as produced by the .NET 6 SDK.
// Used to validate correctness of contexts generated by previous SDKs against the current System.Text.Json runtime components.
// Unless absolutely necessary DO NOT MODIFY any of these files -- it would invalidate the purpose of the regression tests.

// <auto-generated/>
#nullable enable

// Suppress warnings about [Obsolete] member usage in generated code.
#pragma warning disable CS0618

namespace System.Text.Json.Tests.SourceGenRegressionTests.Net60
{
    public partial class Net60GeneratedContext
    {
        private global::System.Text.Json.Serialization.Metadata.JsonTypeInfo<global::System.Collections.Generic.Dictionary<global::System.String, global::System.Text.Json.Tests.SourceGenRegressionTests.Net60.HighLowTemps>>? _DictionaryStringHighLowTemps;
        public global::System.Text.Json.Serialization.Metadata.JsonTypeInfo<global::System.Collections.Generic.Dictionary<global::System.String, global::System.Text.Json.Tests.SourceGenRegressionTests.Net60.HighLowTemps>> DictionaryStringHighLowTemps
        {
            get
            {
                if (_DictionaryStringHighLowTemps == null)
                {
                    global::System.Text.Json.Serialization.JsonConverter? customConverter;
                    if (Options.Converters.Count > 0 && (customConverter = GetRuntimeProvidedCustomConverter(typeof(global::System.Collections.Generic.Dictionary<global::System.String, global::System.Text.Json.Tests.SourceGenRegressionTests.Net60.HighLowTemps>))) != null)
                    {
                        _DictionaryStringHighLowTemps = global::System.Text.Json.Serialization.Metadata.JsonMetadataServices.CreateValueInfo<global::System.Collections.Generic.Dictionary<global::System.String, global::System.Text.Json.Tests.SourceGenRegressionTests.Net60.HighLowTemps>>(Options, customConverter);
                    }
                    else
                    {
                        global::System.Text.Json.Serialization.Metadata.JsonCollectionInfoValues<global::System.Collections.Generic.Dictionary<global::System.String, global::System.Text.Json.Tests.SourceGenRegressionTests.Net60.HighLowTemps>> info = new global::System.Text.Json.Serialization.Metadata.JsonCollectionInfoValues<global::System.Collections.Generic.Dictionary<global::System.String, global::System.Text.Json.Tests.SourceGenRegressionTests.Net60.HighLowTemps>>()
                            {
                                ObjectCreator = () => new global::System.Collections.Generic.Dictionary<global::System.String, global::System.Text.Json.Tests.SourceGenRegressionTests.Net60.HighLowTemps>(),
                                KeyInfo = this.String,
                                ElementInfo = this.HighLowTemps,
                                NumberHandling = default,
                                SerializeHandler = DictionaryStringHighLowTempsSerializeHandler
                            };
            
                            _DictionaryStringHighLowTemps = global::System.Text.Json.Serialization.Metadata.JsonMetadataServices.CreateDictionaryInfo<global::System.Collections.Generic.Dictionary<global::System.String, global::System.Text.Json.Tests.SourceGenRegressionTests.Net60.HighLowTemps>, global::System.String, global::System.Text.Json.Tests.SourceGenRegressionTests.Net60.HighLowTemps>(Options, info);
            
                    }
                }
        
                return _DictionaryStringHighLowTemps;
            }
        }
        
        private static void DictionaryStringHighLowTempsSerializeHandler(global::System.Text.Json.Utf8JsonWriter writer, global::System.Collections.Generic.Dictionary<global::System.String, global::System.Text.Json.Tests.SourceGenRegressionTests.Net60.HighLowTemps>? value)
        {
            if (value == null)
            {
                writer.WriteNullValue();
                return;
            }
        
            writer.WriteStartObject();
        
            foreach (global::System.Collections.Generic.KeyValuePair<global::System.String, global::System.Text.Json.Tests.SourceGenRegressionTests.Net60.HighLowTemps> pair in value)
            {
                writer.WritePropertyName(pair.Key);
                HighLowTempsSerializeHandler(writer, pair.Value!);
            }
        
            writer.WriteEndObject();
        }
    }
}
