﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

namespace Roslyn.LanguageServer.Protocol;

/// <summary>
/// Additional <see cref="DiagnosticTag"/> values that are specific to Visual Studio.
/// </summary>
internal static class VSDiagnosticTags
{
    /// <summary>
    /// A <see cref="Diagnostic"/> entry generated by the build.
    /// </summary>
    public const DiagnosticTag BuildError = (DiagnosticTag)(int.MaxValue - 1);

    /// <summary>
    /// A <see cref="Diagnostic"/> entry generated by Intellisense.
    /// </summary>
    public const DiagnosticTag IntellisenseError = (DiagnosticTag)(int.MaxValue - 2);

    /// <summary>
    /// A <see cref="Diagnostic"/> entry that could be generated from both builds
    /// and Intellisense.
    ///
    /// <see cref="Diagnostic"/> entries tagged with <see cref="PotentialDuplicate"/> will be hidden
    /// in the error list if the error list is displaying build and intellisense
    /// errors.
    /// </summary>
    public const DiagnosticTag PotentialDuplicate = (DiagnosticTag)(int.MaxValue - 3);

    /// <summary>
    /// A <see cref="Diagnostic"/> entry is never displayed in the error list.
    /// </summary>
    public const DiagnosticTag HiddenInErrorList = (DiagnosticTag)(int.MaxValue - 4);

    /// <summary>
    /// The <see cref="Diagnostic"/> entry is always displayed in the error list.
    /// </summary>
    public const DiagnosticTag VisibleInErrorList = (DiagnosticTag)(int.MaxValue - 5);

    /// <summary>
    /// The <see cref="Diagnostic"/> entry is never displayed in the editor.
    /// </summary>
    public const DiagnosticTag HiddenInEditor = (DiagnosticTag)(int.MaxValue - 6);

    /// <summary>
    /// No tooltip is shown for the <see cref="Diagnostic"/> entry in the editor.
    /// </summary>
    public const DiagnosticTag SuppressEditorToolTip = (DiagnosticTag)(int.MaxValue - 7);

    /// <summary>
    /// The <see cref="Diagnostic"/> entry is represented in the Editor as an Edit
    /// and Continue error.
    /// </summary>
    public const DiagnosticTag EditAndContinueError = (DiagnosticTag)(int.MaxValue - 8);

    /// <summary>
    /// A <see cref="Diagnostic"/> entry is represented in the Editor as a Task List item in the TODO list.
    /// </summary>
    public const DiagnosticTag TaskItem = (DiagnosticTag)(int.MaxValue - 9);
}
