/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.db;

import com.workingdogs.village.QueryDataSet;
import com.workingdogs.village.Record;
import com.workingdogs.village.Value;
import java.math.BigDecimal;
import java.sql.Connection;
import org.apache.turbine.util.db.IdGenerator;
import org.apache.turbine.util.db.adapter.DB;

public class AutoIncrementIdGenerator
implements IdGenerator {
    private DB dbAdapter;

    public int getIdAsInt(Connection connection, Object keyInfo) throws Exception {
        return this.getIdAsVillageValue(connection, keyInfo).asInt();
    }

    public long getIdAsLong(Connection connection, Object keyInfo) throws Exception {
        return this.getIdAsVillageValue(connection, keyInfo).asLong();
    }

    public BigDecimal getIdAsBigDecimal(Connection connection, Object keyInfo) throws Exception {
        return this.getIdAsVillageValue(connection, keyInfo).asBigDecimal();
    }

    public String getIdAsString(Connection connection, Object keyInfo) throws Exception {
        return this.getIdAsVillageValue(connection, keyInfo).asString();
    }

    public boolean isPriorToInsert() {
        return false;
    }

    public boolean isPostInsert() {
        return true;
    }

    public boolean isConnectionRequired() {
        return true;
    }

    private Value getIdAsVillageValue(Connection connection, Object keyInfo) throws Exception {
        String IDSql = this.dbAdapter.getIdSqlForAutoIncrement(keyInfo);
        Value id = null;
        QueryDataSet qds = null;
        try {
            qds = new QueryDataSet(connection, IDSql);
            qds.fetchRecords(1);
            Record rec = qds.getRecord(0);
            id = rec.getValue(1);
        }
        finally {
            Object var7_7 = null;
            if (qds != null) {
                qds.close();
            }
        }
        return id;
    }

    public AutoIncrementIdGenerator(DB adapter) {
        this.dbAdapter = adapter;
    }
}

