%define OT_SpaceFillingC2_doc
R"RAW(Space filling C2 (centered L2-discrepancy) computation.

See also
--------
SpaceFilling, SpaceFillingMinDist, SpaceFillingPhiP

Notes
-----
Compute the criterion based on the centered L2 discrepancy of sample points denoted by :math:`(\vect{x}_1, \dots, \vect{x}_\sampleSize)` where :math:`\vect{x}_k \in \Rset^\inputDim`:

.. math::
    :nowrap:

    \begin{multline*}
    C^2((\vect{x}_1, \dots, \vect{x}_\sampleSize)) = \left(\frac{13}{12}\right)^{\inputDim} - \frac{2}{\sampleSize} \sum_{i=1}^{\sampleSize} \prod_{k=1}^{\inputDim} \left( 1 + \frac{1}{2} |x_k^{(i)} - 0.5| - \frac{1}{2} |x_k^{(i)} - 0.5|^2 \right)\\
             + \frac{1}{\sampleSize^2} \sum_{i,j=1}^{\sampleSize} \prod_{k=1}^{\inputDim} \left( 1 + \frac{1}{2} |x_k^{(i)} - 0.5| + \frac{1}{2} |x_k^{(j)} - 0.5| - \frac{1}{2} |x_k^{(i)} - x_k^{(j)}| \right)
    \end{multline*}
)RAW"

%enddef
%feature("docstring") OT::SpaceFillingC2
OT_SpaceFillingC2_doc

// ---------------------------------------------------------------------

%define OT_SpaceFillingC2_evaluate_doc
"Compute the C2 criterion for a specific design.

Parameters
----------
design : :class:`~openturns.Sample` or 2d array like
    The design

Returns
-------
crit : float
    The C2 criterion

Examples
--------
>>> import openturns as ot
>>> # Build an LHS using openturns class
>>> lhs = ot.LHSExperiment(ot.Uniform(), 100)
>>> design = lhs.generate()
>>> # Compute the C2 criterion
>>> crit = ot.SpaceFillingC2().evaluate(design)"
%enddef
%feature("docstring") OT::SpaceFillingC2::evaluate
OT_SpaceFillingC2_evaluate_doc

// ---------------------------------------------------------------------
