#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Luna
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250814.2

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='luna'
GAME_NAME='Luna'

ARCHIVE_BASE_1_NAME='Luna.zip'
ARCHIVE_BASE_1_MD5='7bdef26b52591152dc6fce2fe4464b7d'
ARCHIVE_BASE_1_SIZE='2359275'
ARCHIVE_BASE_1_VERSION='1.0-itch.2021.04.22'
ARCHIVE_BASE_1_URL='https://funomena.itch.io/luna'

ARCHIVE_BASE_0_NAME='Luna.zip'
ARCHIVE_BASE_0_MD5='05dbd9bf3b74d53159fa41bdbc7c26d7'
ARCHIVE_BASE_0_SIZE='2300000'
ARCHIVE_BASE_0_VERSION='1.0-itch.1'

UNITY3D_NAME='luna'
UNITY3D_NAME_0='Luna'

CONTENT_PATH_DEFAULT='Luna'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/Funomena/Luna'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialisation actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
