# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "security security-connector list",
    is_preview=True,
)
class List(AAZCommand):
    """List all the security connectors in the specified subscription.
    """

    _aaz_info = {
        "version": "2023-10-01-preview",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/providers/microsoft.security/securityconnectors", "2023-10-01-preview"],
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.security/securityconnectors", "2023-10-01-preview"],
        ]
    }

    AZ_SUPPORT_PAGINATION = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_paging(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.resource_group = AAZResourceGroupNameArg()
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        condition_0 = has_value(self.ctx.args.resource_group) and has_value(self.ctx.subscription_id)
        condition_1 = has_value(self.ctx.subscription_id) and has_value(self.ctx.args.resource_group) is not True
        if condition_0:
            self.SecurityConnectorsListByResourceGroup(ctx=self.ctx)()
        if condition_1:
            self.SecurityConnectorsList(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance.value, client_flatten=True)
        next_link = self.deserialize_output(self.ctx.vars.instance.next_link)
        return result, next_link

    class SecurityConnectorsListByResourceGroup(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2023-10-01-preview",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.next_link = AAZStrType(
                serialized_name="nextLink",
                flags={"read_only": True},
            )
            _schema_on_200.value = AAZListType(
                flags={"required": True},
            )

            value = cls._schema_on_200.value
            value.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element
            _element.etag = AAZStrType()
            _element.id = AAZStrType(
                flags={"read_only": True},
            )
            _element.kind = AAZStrType()
            _element.location = AAZStrType()
            _element.name = AAZStrType(
                flags={"read_only": True},
            )
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.system_data = AAZObjectType(
                serialized_name="systemData",
                flags={"read_only": True},
            )
            _element.tags = AAZDictType()
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.value.Element.properties
            properties.environment_data = AAZObjectType(
                serialized_name="environmentData",
            )
            properties.environment_name = AAZStrType(
                serialized_name="environmentName",
            )
            properties.hierarchy_identifier = AAZStrType(
                serialized_name="hierarchyIdentifier",
            )
            properties.hierarchy_identifier_trial_end_date = AAZStrType(
                serialized_name="hierarchyIdentifierTrialEndDate",
                flags={"read_only": True},
            )
            properties.offerings = AAZListType()

            environment_data = cls._schema_on_200.value.Element.properties.environment_data
            environment_data.environment_type = AAZStrType(
                serialized_name="environmentType",
                flags={"required": True},
            )

            disc_aws_account = cls._schema_on_200.value.Element.properties.environment_data.discriminate_by("environment_type", "AwsAccount")
            disc_aws_account.account_name = AAZStrType(
                serialized_name="accountName",
                flags={"read_only": True},
            )
            disc_aws_account.organizational_data = AAZObjectType(
                serialized_name="organizationalData",
            )
            disc_aws_account.regions = AAZListType()
            disc_aws_account.scan_interval = AAZIntType(
                serialized_name="scanInterval",
            )

            organizational_data = cls._schema_on_200.value.Element.properties.environment_data.discriminate_by("environment_type", "AwsAccount").organizational_data
            organizational_data.organization_membership_type = AAZStrType(
                serialized_name="organizationMembershipType",
                flags={"required": True},
            )

            disc_member = cls._schema_on_200.value.Element.properties.environment_data.discriminate_by("environment_type", "AwsAccount").organizational_data.discriminate_by("organization_membership_type", "Member")
            disc_member.parent_hierarchy_id = AAZStrType(
                serialized_name="parentHierarchyId",
            )

            disc_organization = cls._schema_on_200.value.Element.properties.environment_data.discriminate_by("environment_type", "AwsAccount").organizational_data.discriminate_by("organization_membership_type", "Organization")
            disc_organization.excluded_account_ids = AAZListType(
                serialized_name="excludedAccountIds",
            )
            disc_organization.stackset_name = AAZStrType(
                serialized_name="stacksetName",
            )

            excluded_account_ids = cls._schema_on_200.value.Element.properties.environment_data.discriminate_by("environment_type", "AwsAccount").organizational_data.discriminate_by("organization_membership_type", "Organization").excluded_account_ids
            excluded_account_ids.Element = AAZStrType()

            regions = cls._schema_on_200.value.Element.properties.environment_data.discriminate_by("environment_type", "AwsAccount").regions
            regions.Element = AAZStrType()

            disc_gcp_project = cls._schema_on_200.value.Element.properties.environment_data.discriminate_by("environment_type", "GcpProject")
            disc_gcp_project.organizational_data = AAZObjectType(
                serialized_name="organizationalData",
            )
            disc_gcp_project.project_details = AAZObjectType(
                serialized_name="projectDetails",
            )
            disc_gcp_project.scan_interval = AAZIntType(
                serialized_name="scanInterval",
            )

            organizational_data = cls._schema_on_200.value.Element.properties.environment_data.discriminate_by("environment_type", "GcpProject").organizational_data
            organizational_data.organization_membership_type = AAZStrType(
                serialized_name="organizationMembershipType",
                flags={"required": True},
            )

            disc_member = cls._schema_on_200.value.Element.properties.environment_data.discriminate_by("environment_type", "GcpProject").organizational_data.discriminate_by("organization_membership_type", "Member")
            disc_member.management_project_number = AAZStrType(
                serialized_name="managementProjectNumber",
            )
            disc_member.parent_hierarchy_id = AAZStrType(
                serialized_name="parentHierarchyId",
            )

            disc_organization = cls._schema_on_200.value.Element.properties.environment_data.discriminate_by("environment_type", "GcpProject").organizational_data.discriminate_by("organization_membership_type", "Organization")
            disc_organization.excluded_project_numbers = AAZListType(
                serialized_name="excludedProjectNumbers",
            )
            disc_organization.organization_name = AAZStrType(
                serialized_name="organizationName",
                flags={"read_only": True},
            )
            disc_organization.service_account_email_address = AAZStrType(
                serialized_name="serviceAccountEmailAddress",
            )
            disc_organization.workload_identity_provider_id = AAZStrType(
                serialized_name="workloadIdentityProviderId",
            )

            excluded_project_numbers = cls._schema_on_200.value.Element.properties.environment_data.discriminate_by("environment_type", "GcpProject").organizational_data.discriminate_by("organization_membership_type", "Organization").excluded_project_numbers
            excluded_project_numbers.Element = AAZStrType()

            project_details = cls._schema_on_200.value.Element.properties.environment_data.discriminate_by("environment_type", "GcpProject").project_details
            project_details.project_id = AAZStrType(
                serialized_name="projectId",
            )
            project_details.project_name = AAZStrType(
                serialized_name="projectName",
                flags={"read_only": True},
            )
            project_details.project_number = AAZStrType(
                serialized_name="projectNumber",
            )
            project_details.workload_identity_pool_id = AAZStrType(
                serialized_name="workloadIdentityPoolId",
                flags={"read_only": True},
            )

            offerings = cls._schema_on_200.value.Element.properties.offerings
            offerings.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.offerings.Element
            _element.description = AAZStrType(
                flags={"read_only": True},
            )
            _element.offering_type = AAZStrType(
                serialized_name="offeringType",
                flags={"required": True},
            )

            disc_cspm_monitor_aws = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "CspmMonitorAws")
            disc_cspm_monitor_aws.native_cloud_connection = AAZObjectType(
                serialized_name="nativeCloudConnection",
            )

            native_cloud_connection = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "CspmMonitorAws").native_cloud_connection
            native_cloud_connection.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )

            disc_cspm_monitor_gcp = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "CspmMonitorGcp")
            disc_cspm_monitor_gcp.native_cloud_connection = AAZObjectType(
                serialized_name="nativeCloudConnection",
            )

            native_cloud_connection = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "CspmMonitorGcp").native_cloud_connection
            native_cloud_connection.service_account_email_address = AAZStrType(
                serialized_name="serviceAccountEmailAddress",
            )
            native_cloud_connection.workload_identity_provider_id = AAZStrType(
                serialized_name="workloadIdentityProviderId",
            )

            disc_defender_cspm_aws = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws")
            disc_defender_cspm_aws.ciem = AAZObjectType()
            disc_defender_cspm_aws.data_sensitivity_discovery = AAZObjectType(
                serialized_name="dataSensitivityDiscovery",
            )
            disc_defender_cspm_aws.databases_dspm = AAZObjectType(
                serialized_name="databasesDspm",
            )
            disc_defender_cspm_aws.mdc_containers_agentless_discovery_k8s = AAZObjectType(
                serialized_name="mdcContainersAgentlessDiscoveryK8s",
            )
            disc_defender_cspm_aws.mdc_containers_image_assessment = AAZObjectType(
                serialized_name="mdcContainersImageAssessment",
            )
            disc_defender_cspm_aws.vm_scanners = AAZObjectType(
                serialized_name="vmScanners",
            )

            ciem = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").ciem
            ciem.ciem_discovery = AAZObjectType(
                serialized_name="ciemDiscovery",
            )
            ciem.ciem_oidc = AAZObjectType(
                serialized_name="ciemOidc",
            )

            ciem_discovery = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").ciem.ciem_discovery
            ciem_discovery.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )

            ciem_oidc = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").ciem.ciem_oidc
            ciem_oidc.azure_active_directory_app_name = AAZStrType(
                serialized_name="azureActiveDirectoryAppName",
            )
            ciem_oidc.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )

            data_sensitivity_discovery = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").data_sensitivity_discovery
            data_sensitivity_discovery.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )
            data_sensitivity_discovery.enabled = AAZBoolType()

            databases_dspm = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").databases_dspm
            databases_dspm.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )
            databases_dspm.enabled = AAZBoolType()

            mdc_containers_agentless_discovery_k8s = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").mdc_containers_agentless_discovery_k8s
            mdc_containers_agentless_discovery_k8s.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )
            mdc_containers_agentless_discovery_k8s.enabled = AAZBoolType()

            mdc_containers_image_assessment = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").mdc_containers_image_assessment
            mdc_containers_image_assessment.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )
            mdc_containers_image_assessment.enabled = AAZBoolType()

            vm_scanners = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").vm_scanners
            vm_scanners.configuration = AAZObjectType()
            vm_scanners.enabled = AAZBoolType()

            configuration = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").vm_scanners.configuration
            configuration.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )
            configuration.exclusion_tags = AAZDictType(
                serialized_name="exclusionTags",
            )
            configuration.scanning_mode = AAZStrType(
                serialized_name="scanningMode",
            )

            exclusion_tags = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").vm_scanners.configuration.exclusion_tags
            exclusion_tags.Element = AAZStrType()

            disc_defender_cspm_gcp = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmGcp")
            disc_defender_cspm_gcp.ciem_discovery = AAZObjectType(
                serialized_name="ciemDiscovery",
            )
            disc_defender_cspm_gcp.data_sensitivity_discovery = AAZObjectType(
                serialized_name="dataSensitivityDiscovery",
            )
            disc_defender_cspm_gcp.mdc_containers_agentless_discovery_k8s = AAZObjectType(
                serialized_name="mdcContainersAgentlessDiscoveryK8s",
            )
            disc_defender_cspm_gcp.mdc_containers_image_assessment = AAZObjectType(
                serialized_name="mdcContainersImageAssessment",
            )
            disc_defender_cspm_gcp.vm_scanners = AAZObjectType(
                serialized_name="vmScanners",
            )

            ciem_discovery = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmGcp").ciem_discovery
            ciem_discovery.azure_active_directory_app_name = AAZStrType(
                serialized_name="azureActiveDirectoryAppName",
            )
            ciem_discovery.service_account_email_address = AAZStrType(
                serialized_name="serviceAccountEmailAddress",
            )
            ciem_discovery.workload_identity_provider_id = AAZStrType(
                serialized_name="workloadIdentityProviderId",
            )

            data_sensitivity_discovery = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmGcp").data_sensitivity_discovery
            data_sensitivity_discovery.enabled = AAZBoolType()
            data_sensitivity_discovery.service_account_email_address = AAZStrType(
                serialized_name="serviceAccountEmailAddress",
            )
            data_sensitivity_discovery.workload_identity_provider_id = AAZStrType(
                serialized_name="workloadIdentityProviderId",
            )

            mdc_containers_agentless_discovery_k8s = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmGcp").mdc_containers_agentless_discovery_k8s
            mdc_containers_agentless_discovery_k8s.enabled = AAZBoolType()
            mdc_containers_agentless_discovery_k8s.service_account_email_address = AAZStrType(
                serialized_name="serviceAccountEmailAddress",
            )
            mdc_containers_agentless_discovery_k8s.workload_identity_provider_id = AAZStrType(
                serialized_name="workloadIdentityProviderId",
            )

            mdc_containers_image_assessment = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmGcp").mdc_containers_image_assessment
            mdc_containers_image_assessment.enabled = AAZBoolType()
            mdc_containers_image_assessment.service_account_email_address = AAZStrType(
                serialized_name="serviceAccountEmailAddress",
            )
            mdc_containers_image_assessment.workload_identity_provider_id = AAZStrType(
                serialized_name="workloadIdentityProviderId",
            )

            vm_scanners = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmGcp").vm_scanners
            vm_scanners.configuration = AAZObjectType()
            vm_scanners.enabled = AAZBoolType()

            configuration = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmGcp").vm_scanners.configuration
            configuration.exclusion_tags = AAZDictType(
                serialized_name="exclusionTags",
            )
            configuration.scanning_mode = AAZStrType(
                serialized_name="scanningMode",
            )

            exclusion_tags = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmGcp").vm_scanners.configuration.exclusion_tags
            exclusion_tags.Element = AAZStrType()

            disc_defender_for_containers_aws = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws")
            disc_defender_for_containers_aws.auto_provisioning = AAZBoolType(
                serialized_name="autoProvisioning",
            )
            disc_defender_for_containers_aws.cloud_watch_to_kinesis = AAZObjectType(
                serialized_name="cloudWatchToKinesis",
            )
            disc_defender_for_containers_aws.container_vulnerability_assessment = AAZObjectType(
                serialized_name="containerVulnerabilityAssessment",
            )
            disc_defender_for_containers_aws.container_vulnerability_assessment_task = AAZObjectType(
                serialized_name="containerVulnerabilityAssessmentTask",
            )
            disc_defender_for_containers_aws.enable_container_vulnerability_assessment = AAZBoolType(
                serialized_name="enableContainerVulnerabilityAssessment",
            )
            disc_defender_for_containers_aws.kinesis_to_s3 = AAZObjectType(
                serialized_name="kinesisToS3",
            )
            disc_defender_for_containers_aws.kube_audit_retention_time = AAZIntType(
                serialized_name="kubeAuditRetentionTime",
            )
            disc_defender_for_containers_aws.kubernetes_scuba_reader = AAZObjectType(
                serialized_name="kubernetesScubaReader",
            )
            disc_defender_for_containers_aws.kubernetes_service = AAZObjectType(
                serialized_name="kubernetesService",
            )
            disc_defender_for_containers_aws.mdc_containers_agentless_discovery_k8s = AAZObjectType(
                serialized_name="mdcContainersAgentlessDiscoveryK8s",
            )
            disc_defender_for_containers_aws.mdc_containers_image_assessment = AAZObjectType(
                serialized_name="mdcContainersImageAssessment",
            )
            disc_defender_for_containers_aws.scuba_external_id = AAZStrType(
                serialized_name="scubaExternalId",
            )

            cloud_watch_to_kinesis = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws").cloud_watch_to_kinesis
            cloud_watch_to_kinesis.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )

            container_vulnerability_assessment = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws").container_vulnerability_assessment
            container_vulnerability_assessment.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )

            container_vulnerability_assessment_task = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws").container_vulnerability_assessment_task
            container_vulnerability_assessment_task.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )

            kinesis_to_s3 = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws").kinesis_to_s3
            kinesis_to_s3.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )

            kubernetes_scuba_reader = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws").kubernetes_scuba_reader
            kubernetes_scuba_reader.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )

            kubernetes_service = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws").kubernetes_service
            kubernetes_service.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )

            mdc_containers_agentless_discovery_k8s = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws").mdc_containers_agentless_discovery_k8s
            mdc_containers_agentless_discovery_k8s.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )
            mdc_containers_agentless_discovery_k8s.enabled = AAZBoolType()

            mdc_containers_image_assessment = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws").mdc_containers_image_assessment
            mdc_containers_image_assessment.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )
            mdc_containers_image_assessment.enabled = AAZBoolType()

            disc_defender_for_containers_gcp = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersGcp")
            disc_defender_for_containers_gcp.audit_logs_auto_provisioning_flag = AAZBoolType(
                serialized_name="auditLogsAutoProvisioningFlag",
            )
            disc_defender_for_containers_gcp.data_pipeline_native_cloud_connection = AAZObjectType(
                serialized_name="dataPipelineNativeCloudConnection",
            )
            disc_defender_for_containers_gcp.defender_agent_auto_provisioning_flag = AAZBoolType(
                serialized_name="defenderAgentAutoProvisioningFlag",
            )
            disc_defender_for_containers_gcp.mdc_containers_agentless_discovery_k8s = AAZObjectType(
                serialized_name="mdcContainersAgentlessDiscoveryK8s",
            )
            disc_defender_for_containers_gcp.mdc_containers_image_assessment = AAZObjectType(
                serialized_name="mdcContainersImageAssessment",
            )
            disc_defender_for_containers_gcp.native_cloud_connection = AAZObjectType(
                serialized_name="nativeCloudConnection",
            )
            disc_defender_for_containers_gcp.policy_agent_auto_provisioning_flag = AAZBoolType(
                serialized_name="policyAgentAutoProvisioningFlag",
            )

            data_pipeline_native_cloud_connection = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersGcp").data_pipeline_native_cloud_connection
            data_pipeline_native_cloud_connection.service_account_email_address = AAZStrType(
                serialized_name="serviceAccountEmailAddress",
            )
            data_pipeline_native_cloud_connection.workload_identity_provider_id = AAZStrType(
                serialized_name="workloadIdentityProviderId",
            )

            mdc_containers_agentless_discovery_k8s = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersGcp").mdc_containers_agentless_discovery_k8s
            mdc_containers_agentless_discovery_k8s.enabled = AAZBoolType()
            mdc_containers_agentless_discovery_k8s.service_account_email_address = AAZStrType(
                serialized_name="serviceAccountEmailAddress",
            )
            mdc_containers_agentless_discovery_k8s.workload_identity_provider_id = AAZStrType(
                serialized_name="workloadIdentityProviderId",
            )

            mdc_containers_image_assessment = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersGcp").mdc_containers_image_assessment
            mdc_containers_image_assessment.enabled = AAZBoolType()
            mdc_containers_image_assessment.service_account_email_address = AAZStrType(
                serialized_name="serviceAccountEmailAddress",
            )
            mdc_containers_image_assessment.workload_identity_provider_id = AAZStrType(
                serialized_name="workloadIdentityProviderId",
            )

            native_cloud_connection = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersGcp").native_cloud_connection
            native_cloud_connection.service_account_email_address = AAZStrType(
                serialized_name="serviceAccountEmailAddress",
            )
            native_cloud_connection.workload_identity_provider_id = AAZStrType(
                serialized_name="workloadIdentityProviderId",
            )

            disc_defender_for_databases_aws = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesAws")
            disc_defender_for_databases_aws.arc_auto_provisioning = AAZObjectType(
                serialized_name="arcAutoProvisioning",
            )
            disc_defender_for_databases_aws.databases_dspm = AAZObjectType(
                serialized_name="databasesDspm",
            )
            disc_defender_for_databases_aws.rds = AAZObjectType()

            arc_auto_provisioning = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesAws").arc_auto_provisioning
            arc_auto_provisioning.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )
            arc_auto_provisioning.configuration = AAZObjectType()
            arc_auto_provisioning.enabled = AAZBoolType()

            configuration = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesAws").arc_auto_provisioning.configuration
            configuration.private_link_scope = AAZStrType(
                serialized_name="privateLinkScope",
            )
            configuration.proxy = AAZStrType()

            databases_dspm = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesAws").databases_dspm
            databases_dspm.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )
            databases_dspm.enabled = AAZBoolType()

            rds = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesAws").rds
            rds.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )
            rds.enabled = AAZBoolType()

            disc_defender_for_databases_gcp = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesGcp")
            disc_defender_for_databases_gcp.arc_auto_provisioning = AAZObjectType(
                serialized_name="arcAutoProvisioning",
            )
            disc_defender_for_databases_gcp.defender_for_databases_arc_auto_provisioning = AAZObjectType(
                serialized_name="defenderForDatabasesArcAutoProvisioning",
            )

            arc_auto_provisioning = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesGcp").arc_auto_provisioning
            arc_auto_provisioning.configuration = AAZObjectType()
            arc_auto_provisioning.enabled = AAZBoolType()

            configuration = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesGcp").arc_auto_provisioning.configuration
            configuration.private_link_scope = AAZStrType(
                serialized_name="privateLinkScope",
            )
            configuration.proxy = AAZStrType()

            defender_for_databases_arc_auto_provisioning = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesGcp").defender_for_databases_arc_auto_provisioning
            defender_for_databases_arc_auto_provisioning.service_account_email_address = AAZStrType(
                serialized_name="serviceAccountEmailAddress",
            )
            defender_for_databases_arc_auto_provisioning.workload_identity_provider_id = AAZStrType(
                serialized_name="workloadIdentityProviderId",
            )

            disc_defender_for_servers_aws = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws")
            disc_defender_for_servers_aws.arc_auto_provisioning = AAZObjectType(
                serialized_name="arcAutoProvisioning",
            )
            disc_defender_for_servers_aws.defender_for_servers = AAZObjectType(
                serialized_name="defenderForServers",
            )
            disc_defender_for_servers_aws.mde_auto_provisioning = AAZObjectType(
                serialized_name="mdeAutoProvisioning",
            )
            disc_defender_for_servers_aws.sub_plan = AAZObjectType(
                serialized_name="subPlan",
            )
            disc_defender_for_servers_aws.va_auto_provisioning = AAZObjectType(
                serialized_name="vaAutoProvisioning",
            )
            disc_defender_for_servers_aws.vm_scanners = AAZObjectType(
                serialized_name="vmScanners",
            )

            arc_auto_provisioning = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").arc_auto_provisioning
            arc_auto_provisioning.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )
            arc_auto_provisioning.configuration = AAZObjectType()
            arc_auto_provisioning.enabled = AAZBoolType()

            configuration = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").arc_auto_provisioning.configuration
            configuration.private_link_scope = AAZStrType(
                serialized_name="privateLinkScope",
            )
            configuration.proxy = AAZStrType()

            defender_for_servers = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").defender_for_servers
            defender_for_servers.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )

            mde_auto_provisioning = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").mde_auto_provisioning
            mde_auto_provisioning.configuration = AAZObjectType()
            mde_auto_provisioning.enabled = AAZBoolType()

            sub_plan = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").sub_plan
            sub_plan.type = AAZStrType()

            va_auto_provisioning = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").va_auto_provisioning
            va_auto_provisioning.configuration = AAZObjectType()
            va_auto_provisioning.enabled = AAZBoolType()

            configuration = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").va_auto_provisioning.configuration
            configuration.type = AAZStrType()

            vm_scanners = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").vm_scanners
            vm_scanners.configuration = AAZObjectType()
            vm_scanners.enabled = AAZBoolType()

            configuration = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").vm_scanners.configuration
            configuration.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )
            configuration.exclusion_tags = AAZDictType(
                serialized_name="exclusionTags",
            )
            configuration.scanning_mode = AAZStrType(
                serialized_name="scanningMode",
            )

            exclusion_tags = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").vm_scanners.configuration.exclusion_tags
            exclusion_tags.Element = AAZStrType()

            disc_defender_for_servers_gcp = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp")
            disc_defender_for_servers_gcp.arc_auto_provisioning = AAZObjectType(
                serialized_name="arcAutoProvisioning",
            )
            disc_defender_for_servers_gcp.defender_for_servers = AAZObjectType(
                serialized_name="defenderForServers",
            )
            disc_defender_for_servers_gcp.mde_auto_provisioning = AAZObjectType(
                serialized_name="mdeAutoProvisioning",
            )
            disc_defender_for_servers_gcp.sub_plan = AAZObjectType(
                serialized_name="subPlan",
            )
            disc_defender_for_servers_gcp.va_auto_provisioning = AAZObjectType(
                serialized_name="vaAutoProvisioning",
            )
            disc_defender_for_servers_gcp.vm_scanners = AAZObjectType(
                serialized_name="vmScanners",
            )

            arc_auto_provisioning = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").arc_auto_provisioning
            arc_auto_provisioning.configuration = AAZObjectType()
            arc_auto_provisioning.enabled = AAZBoolType()

            configuration = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").arc_auto_provisioning.configuration
            configuration.private_link_scope = AAZStrType(
                serialized_name="privateLinkScope",
            )
            configuration.proxy = AAZStrType()

            defender_for_servers = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").defender_for_servers
            defender_for_servers.service_account_email_address = AAZStrType(
                serialized_name="serviceAccountEmailAddress",
            )
            defender_for_servers.workload_identity_provider_id = AAZStrType(
                serialized_name="workloadIdentityProviderId",
            )

            mde_auto_provisioning = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").mde_auto_provisioning
            mde_auto_provisioning.configuration = AAZObjectType()
            mde_auto_provisioning.enabled = AAZBoolType()

            sub_plan = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").sub_plan
            sub_plan.type = AAZStrType()

            va_auto_provisioning = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").va_auto_provisioning
            va_auto_provisioning.configuration = AAZObjectType()
            va_auto_provisioning.enabled = AAZBoolType()

            configuration = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").va_auto_provisioning.configuration
            configuration.type = AAZStrType()

            vm_scanners = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").vm_scanners
            vm_scanners.configuration = AAZObjectType()
            vm_scanners.enabled = AAZBoolType()

            configuration = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").vm_scanners.configuration
            configuration.exclusion_tags = AAZDictType(
                serialized_name="exclusionTags",
            )
            configuration.scanning_mode = AAZStrType(
                serialized_name="scanningMode",
            )

            exclusion_tags = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").vm_scanners.configuration.exclusion_tags
            exclusion_tags.Element = AAZStrType()

            disc_information_protection_aws = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "InformationProtectionAws")
            disc_information_protection_aws.information_protection = AAZObjectType(
                serialized_name="informationProtection",
            )

            information_protection = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "InformationProtectionAws").information_protection
            information_protection.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )

            system_data = cls._schema_on_200.value.Element.system_data
            system_data.created_at = AAZStrType(
                serialized_name="createdAt",
            )
            system_data.created_by = AAZStrType(
                serialized_name="createdBy",
            )
            system_data.created_by_type = AAZStrType(
                serialized_name="createdByType",
            )
            system_data.last_modified_at = AAZStrType(
                serialized_name="lastModifiedAt",
            )
            system_data.last_modified_by = AAZStrType(
                serialized_name="lastModifiedBy",
            )
            system_data.last_modified_by_type = AAZStrType(
                serialized_name="lastModifiedByType",
            )

            tags = cls._schema_on_200.value.Element.tags
            tags.Element = AAZStrType()

            return cls._schema_on_200

    class SecurityConnectorsList(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/providers/Microsoft.Security/securityConnectors",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2023-10-01-preview",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.next_link = AAZStrType(
                serialized_name="nextLink",
                flags={"read_only": True},
            )
            _schema_on_200.value = AAZListType(
                flags={"required": True},
            )

            value = cls._schema_on_200.value
            value.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element
            _element.etag = AAZStrType()
            _element.id = AAZStrType(
                flags={"read_only": True},
            )
            _element.kind = AAZStrType()
            _element.location = AAZStrType()
            _element.name = AAZStrType(
                flags={"read_only": True},
            )
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.system_data = AAZObjectType(
                serialized_name="systemData",
                flags={"read_only": True},
            )
            _element.tags = AAZDictType()
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.value.Element.properties
            properties.environment_data = AAZObjectType(
                serialized_name="environmentData",
            )
            properties.environment_name = AAZStrType(
                serialized_name="environmentName",
            )
            properties.hierarchy_identifier = AAZStrType(
                serialized_name="hierarchyIdentifier",
            )
            properties.hierarchy_identifier_trial_end_date = AAZStrType(
                serialized_name="hierarchyIdentifierTrialEndDate",
                flags={"read_only": True},
            )
            properties.offerings = AAZListType()

            environment_data = cls._schema_on_200.value.Element.properties.environment_data
            environment_data.environment_type = AAZStrType(
                serialized_name="environmentType",
                flags={"required": True},
            )

            disc_aws_account = cls._schema_on_200.value.Element.properties.environment_data.discriminate_by("environment_type", "AwsAccount")
            disc_aws_account.account_name = AAZStrType(
                serialized_name="accountName",
                flags={"read_only": True},
            )
            disc_aws_account.organizational_data = AAZObjectType(
                serialized_name="organizationalData",
            )
            disc_aws_account.regions = AAZListType()
            disc_aws_account.scan_interval = AAZIntType(
                serialized_name="scanInterval",
            )

            organizational_data = cls._schema_on_200.value.Element.properties.environment_data.discriminate_by("environment_type", "AwsAccount").organizational_data
            organizational_data.organization_membership_type = AAZStrType(
                serialized_name="organizationMembershipType",
                flags={"required": True},
            )

            disc_member = cls._schema_on_200.value.Element.properties.environment_data.discriminate_by("environment_type", "AwsAccount").organizational_data.discriminate_by("organization_membership_type", "Member")
            disc_member.parent_hierarchy_id = AAZStrType(
                serialized_name="parentHierarchyId",
            )

            disc_organization = cls._schema_on_200.value.Element.properties.environment_data.discriminate_by("environment_type", "AwsAccount").organizational_data.discriminate_by("organization_membership_type", "Organization")
            disc_organization.excluded_account_ids = AAZListType(
                serialized_name="excludedAccountIds",
            )
            disc_organization.stackset_name = AAZStrType(
                serialized_name="stacksetName",
            )

            excluded_account_ids = cls._schema_on_200.value.Element.properties.environment_data.discriminate_by("environment_type", "AwsAccount").organizational_data.discriminate_by("organization_membership_type", "Organization").excluded_account_ids
            excluded_account_ids.Element = AAZStrType()

            regions = cls._schema_on_200.value.Element.properties.environment_data.discriminate_by("environment_type", "AwsAccount").regions
            regions.Element = AAZStrType()

            disc_gcp_project = cls._schema_on_200.value.Element.properties.environment_data.discriminate_by("environment_type", "GcpProject")
            disc_gcp_project.organizational_data = AAZObjectType(
                serialized_name="organizationalData",
            )
            disc_gcp_project.project_details = AAZObjectType(
                serialized_name="projectDetails",
            )
            disc_gcp_project.scan_interval = AAZIntType(
                serialized_name="scanInterval",
            )

            organizational_data = cls._schema_on_200.value.Element.properties.environment_data.discriminate_by("environment_type", "GcpProject").organizational_data
            organizational_data.organization_membership_type = AAZStrType(
                serialized_name="organizationMembershipType",
                flags={"required": True},
            )

            disc_member = cls._schema_on_200.value.Element.properties.environment_data.discriminate_by("environment_type", "GcpProject").organizational_data.discriminate_by("organization_membership_type", "Member")
            disc_member.management_project_number = AAZStrType(
                serialized_name="managementProjectNumber",
            )
            disc_member.parent_hierarchy_id = AAZStrType(
                serialized_name="parentHierarchyId",
            )

            disc_organization = cls._schema_on_200.value.Element.properties.environment_data.discriminate_by("environment_type", "GcpProject").organizational_data.discriminate_by("organization_membership_type", "Organization")
            disc_organization.excluded_project_numbers = AAZListType(
                serialized_name="excludedProjectNumbers",
            )
            disc_organization.organization_name = AAZStrType(
                serialized_name="organizationName",
                flags={"read_only": True},
            )
            disc_organization.service_account_email_address = AAZStrType(
                serialized_name="serviceAccountEmailAddress",
            )
            disc_organization.workload_identity_provider_id = AAZStrType(
                serialized_name="workloadIdentityProviderId",
            )

            excluded_project_numbers = cls._schema_on_200.value.Element.properties.environment_data.discriminate_by("environment_type", "GcpProject").organizational_data.discriminate_by("organization_membership_type", "Organization").excluded_project_numbers
            excluded_project_numbers.Element = AAZStrType()

            project_details = cls._schema_on_200.value.Element.properties.environment_data.discriminate_by("environment_type", "GcpProject").project_details
            project_details.project_id = AAZStrType(
                serialized_name="projectId",
            )
            project_details.project_name = AAZStrType(
                serialized_name="projectName",
                flags={"read_only": True},
            )
            project_details.project_number = AAZStrType(
                serialized_name="projectNumber",
            )
            project_details.workload_identity_pool_id = AAZStrType(
                serialized_name="workloadIdentityPoolId",
                flags={"read_only": True},
            )

            offerings = cls._schema_on_200.value.Element.properties.offerings
            offerings.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.offerings.Element
            _element.description = AAZStrType(
                flags={"read_only": True},
            )
            _element.offering_type = AAZStrType(
                serialized_name="offeringType",
                flags={"required": True},
            )

            disc_cspm_monitor_aws = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "CspmMonitorAws")
            disc_cspm_monitor_aws.native_cloud_connection = AAZObjectType(
                serialized_name="nativeCloudConnection",
            )

            native_cloud_connection = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "CspmMonitorAws").native_cloud_connection
            native_cloud_connection.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )

            disc_cspm_monitor_gcp = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "CspmMonitorGcp")
            disc_cspm_monitor_gcp.native_cloud_connection = AAZObjectType(
                serialized_name="nativeCloudConnection",
            )

            native_cloud_connection = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "CspmMonitorGcp").native_cloud_connection
            native_cloud_connection.service_account_email_address = AAZStrType(
                serialized_name="serviceAccountEmailAddress",
            )
            native_cloud_connection.workload_identity_provider_id = AAZStrType(
                serialized_name="workloadIdentityProviderId",
            )

            disc_defender_cspm_aws = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws")
            disc_defender_cspm_aws.ciem = AAZObjectType()
            disc_defender_cspm_aws.data_sensitivity_discovery = AAZObjectType(
                serialized_name="dataSensitivityDiscovery",
            )
            disc_defender_cspm_aws.databases_dspm = AAZObjectType(
                serialized_name="databasesDspm",
            )
            disc_defender_cspm_aws.mdc_containers_agentless_discovery_k8s = AAZObjectType(
                serialized_name="mdcContainersAgentlessDiscoveryK8s",
            )
            disc_defender_cspm_aws.mdc_containers_image_assessment = AAZObjectType(
                serialized_name="mdcContainersImageAssessment",
            )
            disc_defender_cspm_aws.vm_scanners = AAZObjectType(
                serialized_name="vmScanners",
            )

            ciem = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").ciem
            ciem.ciem_discovery = AAZObjectType(
                serialized_name="ciemDiscovery",
            )
            ciem.ciem_oidc = AAZObjectType(
                serialized_name="ciemOidc",
            )

            ciem_discovery = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").ciem.ciem_discovery
            ciem_discovery.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )

            ciem_oidc = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").ciem.ciem_oidc
            ciem_oidc.azure_active_directory_app_name = AAZStrType(
                serialized_name="azureActiveDirectoryAppName",
            )
            ciem_oidc.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )

            data_sensitivity_discovery = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").data_sensitivity_discovery
            data_sensitivity_discovery.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )
            data_sensitivity_discovery.enabled = AAZBoolType()

            databases_dspm = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").databases_dspm
            databases_dspm.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )
            databases_dspm.enabled = AAZBoolType()

            mdc_containers_agentless_discovery_k8s = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").mdc_containers_agentless_discovery_k8s
            mdc_containers_agentless_discovery_k8s.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )
            mdc_containers_agentless_discovery_k8s.enabled = AAZBoolType()

            mdc_containers_image_assessment = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").mdc_containers_image_assessment
            mdc_containers_image_assessment.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )
            mdc_containers_image_assessment.enabled = AAZBoolType()

            vm_scanners = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").vm_scanners
            vm_scanners.configuration = AAZObjectType()
            vm_scanners.enabled = AAZBoolType()

            configuration = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").vm_scanners.configuration
            configuration.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )
            configuration.exclusion_tags = AAZDictType(
                serialized_name="exclusionTags",
            )
            configuration.scanning_mode = AAZStrType(
                serialized_name="scanningMode",
            )

            exclusion_tags = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").vm_scanners.configuration.exclusion_tags
            exclusion_tags.Element = AAZStrType()

            disc_defender_cspm_gcp = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmGcp")
            disc_defender_cspm_gcp.ciem_discovery = AAZObjectType(
                serialized_name="ciemDiscovery",
            )
            disc_defender_cspm_gcp.data_sensitivity_discovery = AAZObjectType(
                serialized_name="dataSensitivityDiscovery",
            )
            disc_defender_cspm_gcp.mdc_containers_agentless_discovery_k8s = AAZObjectType(
                serialized_name="mdcContainersAgentlessDiscoveryK8s",
            )
            disc_defender_cspm_gcp.mdc_containers_image_assessment = AAZObjectType(
                serialized_name="mdcContainersImageAssessment",
            )
            disc_defender_cspm_gcp.vm_scanners = AAZObjectType(
                serialized_name="vmScanners",
            )

            ciem_discovery = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmGcp").ciem_discovery
            ciem_discovery.azure_active_directory_app_name = AAZStrType(
                serialized_name="azureActiveDirectoryAppName",
            )
            ciem_discovery.service_account_email_address = AAZStrType(
                serialized_name="serviceAccountEmailAddress",
            )
            ciem_discovery.workload_identity_provider_id = AAZStrType(
                serialized_name="workloadIdentityProviderId",
            )

            data_sensitivity_discovery = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmGcp").data_sensitivity_discovery
            data_sensitivity_discovery.enabled = AAZBoolType()
            data_sensitivity_discovery.service_account_email_address = AAZStrType(
                serialized_name="serviceAccountEmailAddress",
            )
            data_sensitivity_discovery.workload_identity_provider_id = AAZStrType(
                serialized_name="workloadIdentityProviderId",
            )

            mdc_containers_agentless_discovery_k8s = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmGcp").mdc_containers_agentless_discovery_k8s
            mdc_containers_agentless_discovery_k8s.enabled = AAZBoolType()
            mdc_containers_agentless_discovery_k8s.service_account_email_address = AAZStrType(
                serialized_name="serviceAccountEmailAddress",
            )
            mdc_containers_agentless_discovery_k8s.workload_identity_provider_id = AAZStrType(
                serialized_name="workloadIdentityProviderId",
            )

            mdc_containers_image_assessment = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmGcp").mdc_containers_image_assessment
            mdc_containers_image_assessment.enabled = AAZBoolType()
            mdc_containers_image_assessment.service_account_email_address = AAZStrType(
                serialized_name="serviceAccountEmailAddress",
            )
            mdc_containers_image_assessment.workload_identity_provider_id = AAZStrType(
                serialized_name="workloadIdentityProviderId",
            )

            vm_scanners = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmGcp").vm_scanners
            vm_scanners.configuration = AAZObjectType()
            vm_scanners.enabled = AAZBoolType()

            configuration = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmGcp").vm_scanners.configuration
            configuration.exclusion_tags = AAZDictType(
                serialized_name="exclusionTags",
            )
            configuration.scanning_mode = AAZStrType(
                serialized_name="scanningMode",
            )

            exclusion_tags = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmGcp").vm_scanners.configuration.exclusion_tags
            exclusion_tags.Element = AAZStrType()

            disc_defender_for_containers_aws = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws")
            disc_defender_for_containers_aws.auto_provisioning = AAZBoolType(
                serialized_name="autoProvisioning",
            )
            disc_defender_for_containers_aws.cloud_watch_to_kinesis = AAZObjectType(
                serialized_name="cloudWatchToKinesis",
            )
            disc_defender_for_containers_aws.container_vulnerability_assessment = AAZObjectType(
                serialized_name="containerVulnerabilityAssessment",
            )
            disc_defender_for_containers_aws.container_vulnerability_assessment_task = AAZObjectType(
                serialized_name="containerVulnerabilityAssessmentTask",
            )
            disc_defender_for_containers_aws.enable_container_vulnerability_assessment = AAZBoolType(
                serialized_name="enableContainerVulnerabilityAssessment",
            )
            disc_defender_for_containers_aws.kinesis_to_s3 = AAZObjectType(
                serialized_name="kinesisToS3",
            )
            disc_defender_for_containers_aws.kube_audit_retention_time = AAZIntType(
                serialized_name="kubeAuditRetentionTime",
            )
            disc_defender_for_containers_aws.kubernetes_scuba_reader = AAZObjectType(
                serialized_name="kubernetesScubaReader",
            )
            disc_defender_for_containers_aws.kubernetes_service = AAZObjectType(
                serialized_name="kubernetesService",
            )
            disc_defender_for_containers_aws.mdc_containers_agentless_discovery_k8s = AAZObjectType(
                serialized_name="mdcContainersAgentlessDiscoveryK8s",
            )
            disc_defender_for_containers_aws.mdc_containers_image_assessment = AAZObjectType(
                serialized_name="mdcContainersImageAssessment",
            )
            disc_defender_for_containers_aws.scuba_external_id = AAZStrType(
                serialized_name="scubaExternalId",
            )

            cloud_watch_to_kinesis = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws").cloud_watch_to_kinesis
            cloud_watch_to_kinesis.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )

            container_vulnerability_assessment = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws").container_vulnerability_assessment
            container_vulnerability_assessment.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )

            container_vulnerability_assessment_task = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws").container_vulnerability_assessment_task
            container_vulnerability_assessment_task.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )

            kinesis_to_s3 = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws").kinesis_to_s3
            kinesis_to_s3.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )

            kubernetes_scuba_reader = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws").kubernetes_scuba_reader
            kubernetes_scuba_reader.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )

            kubernetes_service = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws").kubernetes_service
            kubernetes_service.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )

            mdc_containers_agentless_discovery_k8s = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws").mdc_containers_agentless_discovery_k8s
            mdc_containers_agentless_discovery_k8s.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )
            mdc_containers_agentless_discovery_k8s.enabled = AAZBoolType()

            mdc_containers_image_assessment = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws").mdc_containers_image_assessment
            mdc_containers_image_assessment.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )
            mdc_containers_image_assessment.enabled = AAZBoolType()

            disc_defender_for_containers_gcp = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersGcp")
            disc_defender_for_containers_gcp.audit_logs_auto_provisioning_flag = AAZBoolType(
                serialized_name="auditLogsAutoProvisioningFlag",
            )
            disc_defender_for_containers_gcp.data_pipeline_native_cloud_connection = AAZObjectType(
                serialized_name="dataPipelineNativeCloudConnection",
            )
            disc_defender_for_containers_gcp.defender_agent_auto_provisioning_flag = AAZBoolType(
                serialized_name="defenderAgentAutoProvisioningFlag",
            )
            disc_defender_for_containers_gcp.mdc_containers_agentless_discovery_k8s = AAZObjectType(
                serialized_name="mdcContainersAgentlessDiscoveryK8s",
            )
            disc_defender_for_containers_gcp.mdc_containers_image_assessment = AAZObjectType(
                serialized_name="mdcContainersImageAssessment",
            )
            disc_defender_for_containers_gcp.native_cloud_connection = AAZObjectType(
                serialized_name="nativeCloudConnection",
            )
            disc_defender_for_containers_gcp.policy_agent_auto_provisioning_flag = AAZBoolType(
                serialized_name="policyAgentAutoProvisioningFlag",
            )

            data_pipeline_native_cloud_connection = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersGcp").data_pipeline_native_cloud_connection
            data_pipeline_native_cloud_connection.service_account_email_address = AAZStrType(
                serialized_name="serviceAccountEmailAddress",
            )
            data_pipeline_native_cloud_connection.workload_identity_provider_id = AAZStrType(
                serialized_name="workloadIdentityProviderId",
            )

            mdc_containers_agentless_discovery_k8s = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersGcp").mdc_containers_agentless_discovery_k8s
            mdc_containers_agentless_discovery_k8s.enabled = AAZBoolType()
            mdc_containers_agentless_discovery_k8s.service_account_email_address = AAZStrType(
                serialized_name="serviceAccountEmailAddress",
            )
            mdc_containers_agentless_discovery_k8s.workload_identity_provider_id = AAZStrType(
                serialized_name="workloadIdentityProviderId",
            )

            mdc_containers_image_assessment = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersGcp").mdc_containers_image_assessment
            mdc_containers_image_assessment.enabled = AAZBoolType()
            mdc_containers_image_assessment.service_account_email_address = AAZStrType(
                serialized_name="serviceAccountEmailAddress",
            )
            mdc_containers_image_assessment.workload_identity_provider_id = AAZStrType(
                serialized_name="workloadIdentityProviderId",
            )

            native_cloud_connection = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersGcp").native_cloud_connection
            native_cloud_connection.service_account_email_address = AAZStrType(
                serialized_name="serviceAccountEmailAddress",
            )
            native_cloud_connection.workload_identity_provider_id = AAZStrType(
                serialized_name="workloadIdentityProviderId",
            )

            disc_defender_for_databases_aws = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesAws")
            disc_defender_for_databases_aws.arc_auto_provisioning = AAZObjectType(
                serialized_name="arcAutoProvisioning",
            )
            disc_defender_for_databases_aws.databases_dspm = AAZObjectType(
                serialized_name="databasesDspm",
            )
            disc_defender_for_databases_aws.rds = AAZObjectType()

            arc_auto_provisioning = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesAws").arc_auto_provisioning
            arc_auto_provisioning.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )
            arc_auto_provisioning.configuration = AAZObjectType()
            arc_auto_provisioning.enabled = AAZBoolType()

            configuration = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesAws").arc_auto_provisioning.configuration
            configuration.private_link_scope = AAZStrType(
                serialized_name="privateLinkScope",
            )
            configuration.proxy = AAZStrType()

            databases_dspm = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesAws").databases_dspm
            databases_dspm.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )
            databases_dspm.enabled = AAZBoolType()

            rds = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesAws").rds
            rds.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )
            rds.enabled = AAZBoolType()

            disc_defender_for_databases_gcp = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesGcp")
            disc_defender_for_databases_gcp.arc_auto_provisioning = AAZObjectType(
                serialized_name="arcAutoProvisioning",
            )
            disc_defender_for_databases_gcp.defender_for_databases_arc_auto_provisioning = AAZObjectType(
                serialized_name="defenderForDatabasesArcAutoProvisioning",
            )

            arc_auto_provisioning = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesGcp").arc_auto_provisioning
            arc_auto_provisioning.configuration = AAZObjectType()
            arc_auto_provisioning.enabled = AAZBoolType()

            configuration = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesGcp").arc_auto_provisioning.configuration
            configuration.private_link_scope = AAZStrType(
                serialized_name="privateLinkScope",
            )
            configuration.proxy = AAZStrType()

            defender_for_databases_arc_auto_provisioning = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesGcp").defender_for_databases_arc_auto_provisioning
            defender_for_databases_arc_auto_provisioning.service_account_email_address = AAZStrType(
                serialized_name="serviceAccountEmailAddress",
            )
            defender_for_databases_arc_auto_provisioning.workload_identity_provider_id = AAZStrType(
                serialized_name="workloadIdentityProviderId",
            )

            disc_defender_for_servers_aws = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws")
            disc_defender_for_servers_aws.arc_auto_provisioning = AAZObjectType(
                serialized_name="arcAutoProvisioning",
            )
            disc_defender_for_servers_aws.defender_for_servers = AAZObjectType(
                serialized_name="defenderForServers",
            )
            disc_defender_for_servers_aws.mde_auto_provisioning = AAZObjectType(
                serialized_name="mdeAutoProvisioning",
            )
            disc_defender_for_servers_aws.sub_plan = AAZObjectType(
                serialized_name="subPlan",
            )
            disc_defender_for_servers_aws.va_auto_provisioning = AAZObjectType(
                serialized_name="vaAutoProvisioning",
            )
            disc_defender_for_servers_aws.vm_scanners = AAZObjectType(
                serialized_name="vmScanners",
            )

            arc_auto_provisioning = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").arc_auto_provisioning
            arc_auto_provisioning.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )
            arc_auto_provisioning.configuration = AAZObjectType()
            arc_auto_provisioning.enabled = AAZBoolType()

            configuration = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").arc_auto_provisioning.configuration
            configuration.private_link_scope = AAZStrType(
                serialized_name="privateLinkScope",
            )
            configuration.proxy = AAZStrType()

            defender_for_servers = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").defender_for_servers
            defender_for_servers.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )

            mde_auto_provisioning = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").mde_auto_provisioning
            mde_auto_provisioning.configuration = AAZObjectType()
            mde_auto_provisioning.enabled = AAZBoolType()

            sub_plan = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").sub_plan
            sub_plan.type = AAZStrType()

            va_auto_provisioning = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").va_auto_provisioning
            va_auto_provisioning.configuration = AAZObjectType()
            va_auto_provisioning.enabled = AAZBoolType()

            configuration = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").va_auto_provisioning.configuration
            configuration.type = AAZStrType()

            vm_scanners = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").vm_scanners
            vm_scanners.configuration = AAZObjectType()
            vm_scanners.enabled = AAZBoolType()

            configuration = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").vm_scanners.configuration
            configuration.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )
            configuration.exclusion_tags = AAZDictType(
                serialized_name="exclusionTags",
            )
            configuration.scanning_mode = AAZStrType(
                serialized_name="scanningMode",
            )

            exclusion_tags = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").vm_scanners.configuration.exclusion_tags
            exclusion_tags.Element = AAZStrType()

            disc_defender_for_servers_gcp = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp")
            disc_defender_for_servers_gcp.arc_auto_provisioning = AAZObjectType(
                serialized_name="arcAutoProvisioning",
            )
            disc_defender_for_servers_gcp.defender_for_servers = AAZObjectType(
                serialized_name="defenderForServers",
            )
            disc_defender_for_servers_gcp.mde_auto_provisioning = AAZObjectType(
                serialized_name="mdeAutoProvisioning",
            )
            disc_defender_for_servers_gcp.sub_plan = AAZObjectType(
                serialized_name="subPlan",
            )
            disc_defender_for_servers_gcp.va_auto_provisioning = AAZObjectType(
                serialized_name="vaAutoProvisioning",
            )
            disc_defender_for_servers_gcp.vm_scanners = AAZObjectType(
                serialized_name="vmScanners",
            )

            arc_auto_provisioning = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").arc_auto_provisioning
            arc_auto_provisioning.configuration = AAZObjectType()
            arc_auto_provisioning.enabled = AAZBoolType()

            configuration = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").arc_auto_provisioning.configuration
            configuration.private_link_scope = AAZStrType(
                serialized_name="privateLinkScope",
            )
            configuration.proxy = AAZStrType()

            defender_for_servers = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").defender_for_servers
            defender_for_servers.service_account_email_address = AAZStrType(
                serialized_name="serviceAccountEmailAddress",
            )
            defender_for_servers.workload_identity_provider_id = AAZStrType(
                serialized_name="workloadIdentityProviderId",
            )

            mde_auto_provisioning = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").mde_auto_provisioning
            mde_auto_provisioning.configuration = AAZObjectType()
            mde_auto_provisioning.enabled = AAZBoolType()

            sub_plan = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").sub_plan
            sub_plan.type = AAZStrType()

            va_auto_provisioning = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").va_auto_provisioning
            va_auto_provisioning.configuration = AAZObjectType()
            va_auto_provisioning.enabled = AAZBoolType()

            configuration = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").va_auto_provisioning.configuration
            configuration.type = AAZStrType()

            vm_scanners = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").vm_scanners
            vm_scanners.configuration = AAZObjectType()
            vm_scanners.enabled = AAZBoolType()

            configuration = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").vm_scanners.configuration
            configuration.exclusion_tags = AAZDictType(
                serialized_name="exclusionTags",
            )
            configuration.scanning_mode = AAZStrType(
                serialized_name="scanningMode",
            )

            exclusion_tags = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").vm_scanners.configuration.exclusion_tags
            exclusion_tags.Element = AAZStrType()

            disc_information_protection_aws = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "InformationProtectionAws")
            disc_information_protection_aws.information_protection = AAZObjectType(
                serialized_name="informationProtection",
            )

            information_protection = cls._schema_on_200.value.Element.properties.offerings.Element.discriminate_by("offering_type", "InformationProtectionAws").information_protection
            information_protection.cloud_role_arn = AAZStrType(
                serialized_name="cloudRoleArn",
            )

            system_data = cls._schema_on_200.value.Element.system_data
            system_data.created_at = AAZStrType(
                serialized_name="createdAt",
            )
            system_data.created_by = AAZStrType(
                serialized_name="createdBy",
            )
            system_data.created_by_type = AAZStrType(
                serialized_name="createdByType",
            )
            system_data.last_modified_at = AAZStrType(
                serialized_name="lastModifiedAt",
            )
            system_data.last_modified_by = AAZStrType(
                serialized_name="lastModifiedBy",
            )
            system_data.last_modified_by_type = AAZStrType(
                serialized_name="lastModifiedByType",
            )

            tags = cls._schema_on_200.value.Element.tags
            tags.Element = AAZStrType()

            return cls._schema_on_200


class _ListHelper:
    """Helper class for List"""


__all__ = ["List"]
