*** Settings ***
Documentation       Check diskio table

Resource            ${CURDIR}${/}..${/}..${/}..${/}resources/import.resource

Suite Setup         Ctn Generic Suite Setup
Test Timeout        120s


*** Variables ***
${CMD}      ${CENTREON_PLUGINS} --plugin=os::linux::snmp::plugin


*** Test Cases ***
diskio ${tc}
    [Tags]    os    linux
    ${command}    Catenate
    ...    ${CMD}
    ...    --mode=diskio
    ...    --hostname=${HOSTNAME}
    ...    --snmp-version=${SNMPVERSION}
    ...    --snmp-port=${SNMPPORT}
    ...    --snmp-community=os/linux/snmp/linux
    ...    --snmp-timeout=1
    ...    ${extra_options}
 
    Ctn Run Command And Check Result As Strings    ${command}    ${expected_result}

    Examples:        tc    extra_options                        expected_result    --
            ...      1     --device='1'                         OK: Device 'sda' Read I/O : Buffer creation, Write I/O : Buffer creation, Read IOPs : Buffer creation, Write IOPs : Buffer creation
            ...      2     --critical-read                      OK: All devices [Read I/O : Buffer creation, Write I/O : Buffer creation, Read IOPs : Buffer creation, Write IOPs : Buffer creation] - Server overall [R+W I/O : Buffer creation, R+W IOPs : Buffer creation] - All devices are ok
            ...      3     --critical-write                     OK: All devices [Read I/O : 0.00 B/s, Write I/O : 0.00 B/s, Read IOPs : 0.00, Write IOPs : 0.00] - Server overall [R+W I/O : 0.00 B/s, R+W IOPs : 0.00] - All devices are ok | 'total_read'=0B/s;;;0; 'total_write'=0B/s;;;0; 'total_read_iops'=0.00iops;;;0; 'total_write_iops'=0.00iops;;;0; 'sum_read_write'=0B/s;;;0; 'sum_read_write_iops'=0.00iops;;;0; 'read_sda'=0B/s;;;0; 'write_sda'=0B/s;;;0; 'read_iops_sda'=0.00iops;;;0; 'write_iops_sda'=0.00iops;;;0; 'read_sda1'=0B/s;;;0; 'write_sda1'=0B/s;;;0; 'read_iops_sda1'=0.00iops;;;0; 'write_iops_sda1'=0.00iops;;;0;
            ...      4     --critical-read-iops                 OK: All devices [Read I/O : 0.00 B/s, Write I/O : 0.00 B/s, Read IOPs : 0.00, Write IOPs : 0.00] - Server overall [R+W I/O : 0.00 B/s, R+W IOPs : 0.00] - All devices are ok | 'total_read'=0B/s;;;0; 'total_write'=0B/s;;;0; 'total_read_iops'=0.00iops;;;0; 'total_write_iops'=0.00iops;;;0; 'sum_read_write'=0B/s;;;0; 'sum_read_write_iops'=0.00iops;;;0; 'read_sda'=0B/s;;;0; 'write_sda'=0B/s;;;0; 'read_iops_sda'=0.00iops;;;0; 'write_iops_sda'=0.00iops;;;0; 'read_sda1'=0B/s;;;0; 'write_sda1'=0B/s;;;0; 'read_iops_sda1'=0.00iops;;;0; 'write_iops_sda1'=0.00iops;;;0; 
            ...      5     --critical-write-iops                OK: All devices [Read I/O : 0.00 B/s, Write I/O : 0.00 B/s, Read IOPs : 0.00, Write IOPs : 0.00] - Server overall [R+W I/O : 0.00 B/s, R+W IOPs : 0.00] - All devices are ok | 'total_read'=0B/s;;;0; 'total_write'=0B/s;;;0; 'total_read_iops'=0.00iops;;;0; 'total_write_iops'=0.00iops;;;0; 'sum_read_write'=0B/s;;;0; 'sum_read_write_iops'=0.00iops;;;0; 'read_sda'=0B/s;;;0; 'write_sda'=0B/s;;;0; 'read_iops_sda'=0.00iops;;;0; 'write_iops_sda'=0.00iops;;;0; 'read_sda1'=0B/s;;;0; 'write_sda1'=0B/s;;;0; 'read_iops_sda1'=0.00iops;;;0; 'write_iops_sda1'=0.00iops;;;0;
            ...      6     --critical-total-read                OK: All devices [Read I/O : 0.00 B/s, Write I/O : 0.00 B/s, Read IOPs : 0.00, Write IOPs : 0.00] - Server overall [R+W I/O : 0.00 B/s, R+W IOPs : 0.00] - All devices are ok | 'total_read'=0B/s;;;0; 'total_write'=0B/s;;;0; 'total_read_iops'=0.00iops;;;0; 'total_write_iops'=0.00iops;;;0; 'sum_read_write'=0B/s;;;0; 'sum_read_write_iops'=0.00iops;;;0; 'read_sda'=0B/s;;;0; 'write_sda'=0B/s;;;0; 'read_iops_sda'=0.00iops;;;0; 'write_iops_sda'=0.00iops;;;0; 'read_sda1'=0B/s;;;0; 'write_sda1'=0B/s;;;0; 'read_iops_sda1'=0.00iops;;;0; 'write_iops_sda1'=0.00iops;;;0; 
            ...      7     --critical-total-write               OK: All devices [Read I/O : 0.00 B/s, Write I/O : 0.00 B/s, Read IOPs : 0.00, Write IOPs : 0.00] - Server overall [R+W I/O : 0.00 B/s, R+W IOPs : 0.00] - All devices are ok | 'total_read'=0B/s;;;0; 'total_write'=0B/s;;;0; 'total_read_iops'=0.00iops;;;0; 'total_write_iops'=0.00iops;;;0; 'sum_read_write'=0B/s;;;0; 'sum_read_write_iops'=0.00iops;;;0; 'read_sda'=0B/s;;;0; 'write_sda'=0B/s;;;0; 'read_iops_sda'=0.00iops;;;0; 'write_iops_sda'=0.00iops;;;0; 'read_sda1'=0B/s;;;0; 'write_sda1'=0B/s;;;0; 'read_iops_sda1'=0.00iops;;;0; 'write_iops_sda1'=0.00iops;;;0; 
            ...      8     --critical-total-read-iops           OK: All devices [Read I/O : 0.00 B/s, Write I/O : 0.00 B/s, Read IOPs : 0.00, Write IOPs : 0.00] - Server overall [R+W I/O : 0.00 B/s, R+W IOPs : 0.00] - All devices are ok | 'total_read'=0B/s;;;0; 'total_write'=0B/s;;;0; 'total_read_iops'=0.00iops;;;0; 'total_write_iops'=0.00iops;;;0; 'sum_read_write'=0B/s;;;0; 'sum_read_write_iops'=0.00iops;;;0; 'read_sda'=0B/s;;;0; 'write_sda'=0B/s;;;0; 'read_iops_sda'=0.00iops;;;0; 'write_iops_sda'=0.00iops;;;0; 'read_sda1'=0B/s;;;0; 'write_sda1'=0B/s;;;0; 'read_iops_sda1'=0.00iops;;;0; 'write_iops_sda1'=0.00iops;;;0; 
            ...      9     --critical-total-write-iops          OK: All devices [Read I/O : 0.00 B/s, Write I/O : 0.00 B/s, Read IOPs : 0.00, Write IOPs : 0.00] - Server overall [R+W I/O : 0.00 B/s, R+W IOPs : 0.00] - All devices are ok | 'total_read'=0B/s;;;0; 'total_write'=0B/s;;;0; 'total_read_iops'=0.00iops;;;0; 'total_write_iops'=0.00iops;;;0; 'sum_read_write'=0B/s;;;0; 'sum_read_write_iops'=0.00iops;;;0; 'read_sda'=0B/s;;;0; 'write_sda'=0B/s;;;0; 'read_iops_sda'=0.00iops;;;0; 'write_iops_sda'=0.00iops;;;0; 'read_sda1'=0B/s;;;0; 'write_sda1'=0B/s;;;0; 'read_iops_sda1'=0.00iops;;;0; 'write_iops_sda1'=0.00iops;;;0;
            ...      10    --critical-sum-read-write            OK: All devices [Read I/O : 0.00 B/s, Write I/O : 0.00 B/s, Read IOPs : 0.00, Write IOPs : 0.00] - Server overall [R+W I/O : 0.00 B/s, R+W IOPs : 0.00] - All devices are ok | 'total_read'=0B/s;;;0; 'total_write'=0B/s;;;0; 'total_read_iops'=0.00iops;;;0; 'total_write_iops'=0.00iops;;;0; 'sum_read_write'=0B/s;;;0; 'sum_read_write_iops'=0.00iops;;;0; 'read_sda'=0B/s;;;0; 'write_sda'=0B/s;;;0; 'read_iops_sda'=0.00iops;;;0; 'write_iops_sda'=0.00iops;;;0; 'read_sda1'=0B/s;;;0; 'write_sda1'=0B/s;;;0; 'read_iops_sda1'=0.00iops;;;0; 'write_iops_sda1'=0.00iops;;;0; 
            ...      11    --critical-sum-read-write-iops       OK: All devices [Read I/O : 0.00 B/s, Write I/O : 0.00 B/s, Read IOPs : 0.00, Write IOPs : 0.00] - Server overall [R+W I/O : 0.00 B/s, R+W IOPs : 0.00] - All devices are ok | 'total_read'=0B/s;;;0; 'total_write'=0B/s;;;0; 'total_read_iops'=0.00iops;;;0; 'total_write_iops'=0.00iops;;;0; 'sum_read_write'=0B/s;;;0; 'sum_read_write_iops'=0.00iops;;;0; 'read_sda'=0B/s;;;0; 'write_sda'=0B/s;;;0; 'read_iops_sda'=0.00iops;;;0; 'write_iops_sda'=0.00iops;;;0; 'read_sda1'=0B/s;;;0; 'write_sda1'=0B/s;;;0; 'read_iops_sda1'=0.00iops;;;0; 'write_iops_sda1'=0.00iops;;;0;
            ...      12    --device='222'                       UNKNOWN: No device found for id '222'.
            ...      13    --name                               OK: All devices [Read I/O : 0.00 B/s, Write I/O : 0.00 B/s, Read IOPs : 0.00, Write IOPs : 0.00] - Server overall [R+W I/O : 0.00 B/s, R+W IOPs : 0.00] - All devices are ok | 'total_read'=0B/s;;;0; 'total_write'=0B/s;;;0; 'total_read_iops'=0.00iops;;;0; 'total_write_iops'=0.00iops;;;0; 'sum_read_write'=0B/s;;;0; 'sum_read_write_iops'=0.00iops;;;0; 'read_sda'=0B/s;;;0; 'write_sda'=0B/s;;;0; 'read_iops_sda'=0.00iops;;;0; 'write_iops_sda'=0.00iops;;;0; 'read_sda1'=0B/s;;;0; 'write_sda1'=0B/s;;;0; 'read_iops_sda1'=0.00iops;;;0; 'write_iops_sda1'=0.00iops;;;0;
            ...      14    --regexp                             OK: All devices [Read I/O : 0.00 B/s, Write I/O : 0.00 B/s, Read IOPs : 0.00, Write IOPs : 0.00] - Server overall [R+W I/O : 0.00 B/s, R+W IOPs : 0.00] - All devices are ok | 'total_read'=0B/s;;;0; 'total_write'=0B/s;;;0; 'total_read_iops'=0.00iops;;;0; 'total_write_iops'=0.00iops;;;0; 'sum_read_write'=0B/s;;;0; 'sum_read_write_iops'=0.00iops;;;0; 'read_sda'=0B/s;;;0; 'write_sda'=0B/s;;;0; 'read_iops_sda'=0.00iops;;;0; 'write_iops_sda'=0.00iops;;;0; 'read_sda1'=0B/s;;;0; 'write_sda1'=0B/s;;;0; 'read_iops_sda1'=0.00iops;;;0; 'write_iops_sda1'=0.00iops;;;0;
            ...      15    --regexp-insensitive                 OK: All devices [Read I/O : 0.00 B/s, Write I/O : 0.00 B/s, Read IOPs : 0.00, Write IOPs : 0.00] - Server overall [R+W I/O : 0.00 B/s, R+W IOPs : 0.00] - All devices are ok | 'total_read'=0B/s;;;0; 'total_write'=0B/s;;;0; 'total_read_iops'=0.00iops;;;0; 'total_write_iops'=0.00iops;;;0; 'sum_read_write'=0B/s;;;0; 'sum_read_write_iops'=0.00iops;;;0; 'read_sda'=0B/s;;;0; 'write_sda'=0B/s;;;0; 'read_iops_sda'=0.00iops;;;0; 'write_iops_sda'=0.00iops;;;0; 'read_sda1'=0B/s;;;0; 'write_sda1'=0B/s;;;0; 'read_iops_sda1'=0.00iops;;;0; 'write_iops_sda1'=0.00iops;;;0;
