[![DOI](https://zenodo.org/badge/17321421.svg)](https://zenodo.org/badge/latestdoi/17321421)

# Univalent Mathematics

This [Rocq](https://coq.inria.fr/) library aims to formalize a substantial body of mathematics using the
[univalent point of view](https://en.wikipedia.org/wiki/Univalent_foundations).

## Getting Help & Discussing UniMath

- For **questions** about the UniMath library and **requests** for **help** with installing or using the library, visit the [UniMath Zulip](https://unimath.zulipchat.com) (click [here](https://unimath.zulipchat.com/register/) to register).
- For **bugs** and **suggestions** about **improvements**, file an [issue on GitHub](https://github.com/UniMath/UniMath/issues).

## Trying out UniMath

You can try out UniMath in the browser by clicking [here](https://unimath.github.io/live/).
For instance, you can run the files from the [School on Univalent Mathematics](https://unimath.github.io/Schools/) in the browser.

## Documentation

See [the documentation](./documentation/Documentation.md) for [general information](./documentation/unimath/About-UniMath.md) about UniMath, [install instructions](./documentation/setup/Setup.md), [guides](./documentation/guides/Guides.md), [tutorials](./documentation/guides/tutorials/) and information about [contributing](./documentation/contributing/Contributing.md).

See also the automatically generated [alectryon](http://unimath.github.io/UniMath/gen/alectryon/UniMath.Foundations.PartA) documentation, where you can step through the proofs, viewing the goals at every step, and the [rocqdoc](https://unimath.github.io/UniMath/gen/rocqdoc/toc) documentation, where you can click on identifiers (like [`disp_cat`](https://unimath.github.io/UniMath/gen/rocqdoc/UniMath.CategoryTheory.DisplayedCats.Core#disp_cat)) to go to their definition. By replacing `rocqdoc` with `alectryon` in the url and vice versa, you can switch between the rocqdoc and alectryon documentation.

## Acknowledgments

The UniMath development team gratefully acknowledges the great work by
the Coq development team in providing the [Coq proof assistant](https://coq.inria.fr/), as well
as their support in keeping UniMath compatible with Coq.
