struct cpuinfo_mock_file filesystem[] = {
	{
		.path = "/proc/cpuinfo",
		.size = 314,
		.content =
			"Processor\t: ARMv7 Processor rev 5 (v7l)\n"
			"processor\t: 0\n"
			"BogoMIPS\t: 38.40\n"
			"Features\t: swp half thumb fastmult vfp edsp thumbee neon vfpv3 tls vfpv4 idiva idivt \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 7\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xc07\n"
			"CPU revision\t: 5\n"
			"\n"
			"Hardware\t: MT6595\n"
			"Revision\t: 0000\n"
			"Serial\t\t: 0000000000000000\n",
	},
	{
		.path = "/system/build.prop",
		.size = 5248,
		.content =
			"# begin build properties\n"
			"# autogenerated by buildinfo.sh\n"
			"ro.build.id=KOT49H\n"
			"ro.build.display.id=VIBEUI_V2.0_1514_5.128.1_ST_X2-TO\n"
			"ro.build.version.incremental=VIBEUI_V2.0_1514_5.128.1_ST_X2-TO\n"
			"ro.custom.build.version=VIBEUI_V2.0_1514_5.128.1_ST_X2-TO\n"
			"ro.build.version.sdk=19\n"
			"ro.build.version.codename=REL\n"
			"ro.build.version.release=4.4.2\n"
			"ro.build.date=Thu Apr  2 11:48:59 CST 2015\n"
			"ro.build.date.utc=1427946539\n"
			"ro.build.type=user\n"
			"ro.build.user=buildslave\n"
			"ro.build.host=shws45\n"
			"ro.build.tags=release-keys\n"
			"ro.product.model=Lenovo X2-TO\n"
			"ro.product.brand=Lenovo\n"
			"ro.product.name=x2to\n"
			"ro.product.device=X2-TO\n"
			"ro.product.board=x2to\n"
			"ro.product.cpu.abi=armeabi-v7a\n"
			"ro.product.cpu.abi2=armeabi\n"
			"ro.product.manufacturer=LENOVO\n"
			"ro.product.locale.language=en\n"
			"ro.product.locale.region=US\n"
			"ro.wifi.channels=\n"
			"ro.board.platform=\n"
			"# ro.build.product is obsolete; use ro.product.device\n"
			"ro.build.product=X2-TO\n"
			"# Do not try to parse ro.build.description or .fingerprint\n"
			"ro.build.description=x2to-user 4.4.2 KOT49H VIBEUI_V2.0_1514_5.128.1_ST_X2-TO dev-keys\n"
			"ro.build.fingerprint=Lenovo/x2to/X2-TO:4.4.2/KOT49H/VIBEUI_V2.0_1514_5.128.1_ST_X2-TO.:user/release-keys\n"
			"ro.build.flavor=\n"
			"ro.build.characteristics=default\n"
			"# end build properties\n"
			"\n"
			"# begin mediatek build properties\n"
			"ro.mediatek.version.release=ALPS.KK1.MP11.V1.9\n"
			"ro.mediatek.platform=MT6595\n"
			"ro.mediatek.chip_ver=S01\n"
			"ro.mediatek.version.branch=KK1.MP11\n"
			"ro.mediatek.version.sdk=2\n"
			"# end mediatek build properties\n"
			"#\n"
			"# from out/target/product/x2to/obj/CUSTGEN/config/system.prop\n"
			"#\n"
			"#\n"
			"# system.prop for generic sdk\n"
			"#\n"
			"\n"
			"rild.libpath=/system/lib/mtk-ril.so\n"
			"rild.libargs=-d /dev/ttyC0\n"
			"\n"
			"\n"
			"# MTK, Infinity, 20090720 {\n"
			"wifi.interface=wlan0\n"
			"# MTK, Infinity, 20090720 }\n"
			"\n"
			"# MTK, mtk03034, 20101210 {\n"
			"ro.mediatek.wlan.wsc=1\n"
			"# MTK, mtk03034 20101210}\n"
			"# MTK, mtk03034, 20110318 {\n"
			"ro.mediatek.wlan.p2p=1\n"
			"# MTK, mtk03034 20110318}\n"
			"\n"
			"# MTK, mtk03034, 20101213 {\n"
			"mediatek.wlan.ctia=0\n"
			"# MTK, mtk03034 20101213}\n"
			"\n"
			"\n"
			"#\n"
			"wifi.tethering.interface=ap0\n"
			"#\n"
			"\n"
			"ro.opengles.version=196608\n"
			"\n"
			"wifi.direct.interface=p2p0\n"
			"dalvik.vm.heapgrowthlimit=128m\n"
			"dalvik.vm.heapsize=256m\n"
			"\n"
			"# lenovo-sw, chenzz3, 2014-07-30, override dalvik heap settings, begin\n"
			"dalvik.vm.heapstartsize=8m\n"
			"dalvik.vm.heapgrowthlimit=192m\n"
			"dalvik.vm.heapsize=512m\n"
			"dalvik.vm.heapminfree=8m\n"
			"dalvik.vm.heapmaxfree=32m\n"
			"dalvik.vm.heaptargetutilization=0.75\n"
			"# lenovo-sw, chenzz3, 2014-07-30, override dalvik heap settings, end\n"
			"\n"
			"# USB MTP WHQL\n"
			"ro.sys.usb.mtp.whql.enable=0\n"
			"\n"
			"# Power off opt in IPO\n"
			"sys.ipo.pwrdncap=2\n"
			"\n"
			"# Switching Menu of Mass storage and MTP\n"
			"ro.sys.usb.storage.type=mtp,mass_storage\n"
			"\n"
			"# USB BICR function\n"
			"ro.sys.usb.bicr=yes\n"
			"\n"
			"# USB Charge only function\n"
			"ro.sys.usb.charging.only=yes\n"
			"\n"
			"# audio\n"
			"ro.camera.sound.forced=0\n"
			"ro.audio.silent=0\n"
			"\n"
			"ro.zygote.preload.enable=0\n"
			"\n"
			"# disable IPO shutdown for development\n"
			"#Begin,Lenovo-sw duxu1 add 2014-07-01, enable ipo.\n"
			"sys.ipo.disable=0\n"
			"#sys.ipo.disable=1\n"
			"#End,Lenovo-sw duxu1 add 2014-07-01, enable ipo.\n"
			"\n"
			"#Begin,Lenovo-sw duxu1 add 2015-01-07, disable MTK feature.\n"
			"dalvik.vm.debug=0x600\n"
			"#End,Lenovo-sw duxu1 add 2015-01-07, disable MTK feature.\n"
			"\n"
			"#Begin,Lenovo-sw niejl1 add 2014-05-20, add lenovo features.\n"
			"ro.lenovo.series=VIBE X2\n"
			"#End,Lenovo-sw niejl1 add 2014-05-20, add lenovo features.\n"
			"\n"
			"\n"
			"#\n"
			"# ADDITIONAL_BUILD_PROPERTIES\n"
			"#\n"
			"ro.config.ringtone=Fantastic_Clang.ogg\n"
			"ro.config.ringtone_2=Fantastic_Clang.ogg\n"
			"ro.config.alarm_alert=New_Morning.ogg\n"
			"ro.config.sms_notifi_sound=Bump.ogg\n"
			"ro.config.sms_notifi_sound_2=Bump.ogg\n"
			"ro.config.notification_sound=Notice.ogg\n"
			"ro.com.lenovo.smart.config=7\n"
			"persist.backgrounddata.enable=false\n"
			"ro.lenovo.adb=apkctl,speedup\n"
			"ro.sf.lcd_density=480\n"
			"ro.ctaversion.enable=false\n"
			"ro.lenovo.region=prc\n"
			"ro.lenovo.device=phone\n"
			"ro.lenovo.sim=dsda\n"
			"ro.lenovo.operator=open\n"
			"ro.lenovo.slowmotion=true\n"
			"ro.lenovo.platform=mtk\n"
			"ro.lenovo.bqb=pass\n"
			"ro.lenovo.wificert=no\n"
			"ro.lenovo.cta=false\n"
			"ro.lenovo.videocall=false\n"
			"ro.lenovo.signalbars=five\n"
			"persist.lenovo.ltetype=CSFB\n"
			"persist.sys.timezone=Asia/Shanghai\n"
			"ro.com.google.clientbase=android-lenovo\n"
			"ro.lenovo.core.version=master(PRE_V1.0.8)\n"
			"persist.gemini.sim_num=2\n"
			"ro.gemini.smart_sim_switch=false\n"
			"ro.gemini.smart_3g_switch=0\n"
			"ro.gemini.sim_switch_policy=1\n"
			"ril.specific.sm_cause=0\n"
			"bgw.current3gband=0\n"
			"ril.external.md=2\n"
			"ro.btstack=blueangel\n"
			"ro.sf.hwrotation=0\n"
			"ril.current.share_modem=1\n"
			"curlockscreen=1\n"
			"ro.mediatek.gemini_support=true\n"
			"persist.radio.fd.counter=15\n"
			"persist.radio.fd.off.counter=5\n"
			"persist.radio.fd.r8.counter=15\n"
			"persist.radio.fd.off.r8.counter=5\n"
			"drm.service.enabled=true\n"
			"fmradio.driver.enable=1\n"
			"ril.first.md=1\n"
			"ril.flightmode.poweroffMD=0\n"
			"ril.telephony.mode=0\n"
			"dalvik.vm.mtk-stack-trace-file=/data/anr/mtk_traces.txt\n"
			"persist.mtk.anr.mechanism=1\n"
			"mediatek.wlan.chip=MT6630\n"
			"mediatek.wlan.module.postfix=_mt6630\n"
			"ril.radiooff.poweroffMD=0\n"
			"sys.lenovo.romui.version.sdk=2\n"
			"persist.mtk.wcn.combo.chipid=-1\n"
			"ter.service.enable=0\n"
			"mediatek.extmd.usbport=0\n"
			"persist.sys.display.clearMotion=0\n"
			"persist.clearMotion.fblevel.nrm=255\n"
			"persist.clearMotion.fblevel.bdr=255\n"
			"ro.lte.dc.support=0\n"
			"ril.active.md=0\n"
			"wfd.dummy.enable=1\n"
			"ro.product.sw.internal.version=X2-TO_USR_ST1514_5.128.1_1504021143_MP11V1.9_CN\n"
			"ro.product.hw.version=H201\n"
			"ro.product.particular.version=LENOVO_FUJIAN\n"
			"persist.sys.dalvik.vm.lib=libdvm.so\n"
			"ro.hwui.disable_cache_fbo_size=false\n"
			"net.bt.name=Android\n"
			"dalvik.vm.stack-trace-file=/data/anr/traces.txt\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "7\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 4,
		.content = "1-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/big_cpumask",
		.size = 3,
		.content = "f0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/glbinfo",
		.size = 72,
		.content =
			"big/little arch: yes\n"
			"big/little cpumask:f0/0f\n"
			"nr_cups: 8\n"
			"nr_clusters: 2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/is_big_little",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/is_multi_cluster",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/little_cpumask",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/nr_clusters",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1690000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "403000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 5,
		.content = "1000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies",
		.size = 63,
		.content = "1690000 1495000 1365000 1248000 1144000 1001000 806000 403000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 62,
		.content = "hotplug ondemand userspace powersave interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1144000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 11,
		.content = "mt-cpufreq\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "403000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 87,
		.content =
			"1690000 1493\n"
			"1495000 0\n"
			"1365000 8\n"
			"1248000 4\n"
			"1144000 20654\n"
			"1001000 12\n"
			"806000 33\n"
			"403000 0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 3,
		.content = "95\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/trans_table",
		.size = 845,
		.content =
			"   From  :    To\n"
			"         :   1690000   1495000   1365000   1248000   1144000   1001000    806000    403000 \n"
			"  1690000:         0         0         0         2        41         1         1         0 \n"
			"  1495000:         0         0         0         0         0         0         0         0 \n"
			"  1365000:         0         0         0         0         1         0         0         0 \n"
			"  1248000:         2         0         0         0         0         0         0         0 \n"
			"  1144000:        39         0         1         0         0         1         1         0 \n"
			"  1001000:         1         0         0         0         0         0         1         0 \n"
			"   806000:         3         0         0         0         0         0         0         0 \n"
			"   403000:         0         0         0         0         0         0         0         0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 3,
		.content = "01\n",
	},
	{ NULL },
};

#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "af.policy.invertModeRout",
		.value = "1",
	},
	{
		.key = "af.policy.r_submix_prio_adjust",
		.value = "0",
	},
	{
		.key = "bgw.current3gband",
		.value = "0",
	},
	{
		.key = "bwc.mm.VideoDecodeCodec",
		.value = "2",
	},
	{
		.key = "bwc.mm._Profile",
		.value = "0",
	},
	{
		.key = "camera.open",
		.value = "0",
	},
	{
		.key = "curlockscreen",
		.value = "1",
	},
	{
		.key = "dalvik.vm.debug",
		.value = "0x600",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "192m",
	},
	{
		.key = "dalvik.vm.heapmaxfree",
		.value = "32m",
	},
	{
		.key = "dalvik.vm.heapminfree",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapstartsize",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heaptargetutilization",
		.value = "0.75",
	},
	{
		.key = "dalvik.vm.mtk-stack-trace-file",
		.value = "/data/anr/mtk_traces.txt",
	},
	{
		.key = "dalvik.vm.mtk-vm-version",
		.value = "0x01",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "debug.MB.running",
		.value = "0",
	},
	{
		.key = "debug.force_rtl",
		.value = "0",
	},
	{
		.key = "debug.hwc.compose_level",
		.value = "0",
	},
	{
		.key = "debug.log2sd.defaultpath",
		.value = "internal_sd",
	},
	{
		.key = "debug.mdlogger.Running",
		.value = "0",
	},
	{
		.key = "debug.mtklog.netlog.Running",
		.value = "0",
	},
	{
		.key = "dev.bootcomplete",
		.value = "1",
	},
	{
		.key = "drm.service.enabled",
		.value = "true",
	},
	{
		.key = "fmradio.driver.enable",
		.value = "1",
	},
	{
		.key = "gsm.baseband.capability2",
		.value = "1",
	},
	{
		.key = "gsm.baseband.capability",
		.value = "507",
	},
	{
		.key = "gsm.current.phone-type",
		.value = "1",
	},
	{
		.key = "gsm.gcf.testmode",
		.value = "0",
	},
	{
		.key = "gsm.network.type",
		.value = "Unknown",
	},
	{
		.key = "gsm.operator.alpha.2",
		.value = "",
	},
	{
		.key = "gsm.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.operator.iso-country.2",
		.value = "",
	},
	{
		.key = "gsm.operator.iso-country",
		.value = "",
	},
	{
		.key = "gsm.operator.isroaming.2",
		.value = "false",
	},
	{
		.key = "gsm.operator.isroaming",
		.value = "false",
	},
	{
		.key = "gsm.operator.numeric.2",
		.value = "",
	},
	{
		.key = "gsm.operator.numeric",
		.value = "",
	},
	{
		.key = "gsm.phone.created",
		.value = "true",
	},
	{
		.key = "gsm.project.baseband.2",
		.value = "LENOVO95_LWT_X2_KK_HW((null))",
	},
	{
		.key = "gsm.project.baseband",
		.value = "LENOVO95_LWT_X2_KK_HW(LTTG)",
	},
	{
		.key = "gsm.ril.eboot.2",
		.value = "-1",
	},
	{
		.key = "gsm.ril.eboot",
		.value = "-1",
	},
	{
		.key = "gsm.ril.uicctype.2",
		.value = "",
	},
	{
		.key = "gsm.ril.uicctype",
		.value = "",
	},
	{
		.key = "gsm.roaming.indicator.needed.2",
		.value = "false",
	},
	{
		.key = "gsm.roaming.indicator.needed",
		.value = "false",
	},
	{
		.key = "gsm.serial",
		.value = "8S5P69A6MYB5HB6047N009F60                                   10 ",
	},
	{
		.key = "gsm.sim.inserted",
		.value = "0",
	},
	{
		.key = "gsm.sim.operator.default-name.2",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.default-name",
		.value = "",
	},
	{
		.key = "gsm.sim.retry.pin1.2",
		.value = "",
	},
	{
		.key = "gsm.sim.retry.pin1",
		.value = "",
	},
	{
		.key = "gsm.sim.retry.pin2.2",
		.value = "",
	},
	{
		.key = "gsm.sim.retry.pin2",
		.value = "",
	},
	{
		.key = "gsm.sim.retry.puk1.2",
		.value = "",
	},
	{
		.key = "gsm.sim.retry.puk1",
		.value = "",
	},
	{
		.key = "gsm.sim.retry.puk2.2",
		.value = "",
	},
	{
		.key = "gsm.sim.retry.puk2",
		.value = "",
	},
	{
		.key = "gsm.sim.ril.phbready.2",
		.value = "true",
	},
	{
		.key = "gsm.sim.ril.phbready",
		.value = "true",
	},
	{
		.key = "gsm.sim.state.2",
		.value = "ABSENT",
	},
	{
		.key = "gsm.sim.state",
		.value = "ABSENT",
	},
	{
		.key = "gsm.siminfo.ready",
		.value = "true",
	},
	{
		.key = "gsm.version.baseband.2",
		.value = "X2.MD2.V26, 2014/09/09 15:34",
	},
	{
		.key = "gsm.version.baseband",
		.value = "X2-TO.V41, 2015/01/13 20:16",
	},
	{
		.key = "gsm.version.ril-impl",
		.value = "mtk ril w10.20",
	},
	{
		.key = "init.svc.66xx_launcher",
		.value = "running",
	},
	{
		.key = "init.svc.MtkCodecService",
		.value = "running",
	},
	{
		.key = "init.svc.NvRAMAgent",
		.value = "running",
	},
	{
		.key = "init.svc.PPLAgent",
		.value = "running",
	},
	{
		.key = "init.svc.aal",
		.value = "running",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.afmsvr",
		.value = "running",
	},
	{
		.key = "init.svc.agpsd",
		.value = "running",
	},
	{
		.key = "init.svc.atci_service",
		.value = "running",
	},
	{
		.key = "init.svc.atcid-daemon-u",
		.value = "running",
	},
	{
		.key = "init.svc.audio-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.autokd",
		.value = "running",
	},
	{
		.key = "init.svc.batterywarning",
		.value = "running",
	},
	{
		.key = "init.svc.bootanim",
		.value = "stopped",
	},
	{
		.key = "init.svc.bootlogoupdater",
		.value = "stopped",
	},
	{
		.key = "init.svc.bwc",
		.value = "running",
	},
	{
		.key = "init.svc.camsvrintent",
		.value = "running",
	},
	{
		.key = "init.svc.ccci_fsd",
		.value = "running",
	},
	{
		.key = "init.svc.ccci_mdinit",
		.value = "running",
	},
	{
		.key = "init.svc.custom_sn",
		.value = "stopped",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.drvbd",
		.value = "running",
	},
	{
		.key = "init.svc.ecccimdlogger",
		.value = "running",
	},
	{
		.key = "init.svc.emsvr_user",
		.value = "running",
	},
	{
		.key = "init.svc.enableswap",
		.value = "stopped",
	},
	{
		.key = "init.svc.ext_mdinit",
		.value = "running",
	},
	{
		.key = "init.svc.extmdlogger",
		.value = "running",
	},
	{
		.key = "init.svc.firmware_update",
		.value = "stopped",
	},
	{
		.key = "init.svc.flash_recovery",
		.value = "stopped",
	},
	{
		.key = "init.svc.gsm0710muxd",
		.value = "running",
	},
	{
		.key = "init.svc.gsm0710muxdmd2",
		.value = "running",
	},
	{
		.key = "init.svc.guiext-server",
		.value = "running",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.mnld",
		.value = "running",
	},
	{
		.key = "init.svc.mobile_log_d",
		.value = "running",
	},
	{
		.key = "init.svc.mtkbt",
		.value = "running",
	},
	{
		.key = "init.svc.nac_ue",
		.value = "running",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.netdiag",
		.value = "running",
	},
	{
		.key = "init.svc.nvram_daemon",
		.value = "stopped",
	},
	{
		.key = "init.svc.p2p_supplicant",
		.value = "running",
	},
	{
		.key = "init.svc.poad",
		.value = "stopped",
	},
	{
		.key = "init.svc.pq",
		.value = "stopped",
	},
	{
		.key = "init.svc.pvrsrvctl",
		.value = "stopped",
	},
	{
		.key = "init.svc.ril-daemon-md2",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.sbchk",
		.value = "stopped",
	},
	{
		.key = "init.svc.sdcard",
		.value = "running",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.sn",
		.value = "stopped",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.terservice",
		.value = "stopped",
	},
	{
		.key = "init.svc.thermal",
		.value = "running",
	},
	{
		.key = "init.svc.thermal_manager",
		.value = "stopped",
	},
	{
		.key = "init.svc.thermald",
		.value = "running",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.vtservice",
		.value = "running",
	},
	{
		.key = "init.svc.wmt_loader",
		.value = "stopped",
	},
	{
		.key = "init.svc.writeconfig",
		.value = "running",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "internal_sd_path",
		.value = "/storage/sdcard0",
	},
	{
		.key = "lackof.atci.channel",
		.value = "1",
	},
	{
		.key = "media.wfd.video-format",
		.value = "7",
	},
	{
		.key = "mediatek.extmd.usbport",
		.value = "0",
	},
	{
		.key = "mediatek.wlan.chip",
		.value = "MT6630",
	},
	{
		.key = "mediatek.wlan.ctia",
		.value = "0",
	},
	{
		.key = "mediatek.wlan.module.postfix",
		.value = "_mt6630",
	},
	{
		.key = "mtk_wifi.fw_path",
		.value = "STA",
	},
	{
		.key = "mux.report.case",
		.value = "0",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.qtaguid_enabled",
	},
	{
		.key = "net.hostname",
		.value = "android-bb0b43137f68f353",
	},
	{
		.key = "net.qtaguid_enabled",
		.value = "1",
	},
	{
		.key = "net.tcp.buffersize.default",
		.value = "4096,87380,524288,4096,16384,524288",
	},
	{
		.key = "net.tcp.buffersize.edge",
		.value = "4093,26280,35040,4096,16384,35040",
	},
	{
		.key = "net.tcp.buffersize.gprs",
		.value = "4092,8760,11680,4096,8760,11680",
	},
	{
		.key = "net.tcp.buffersize.hsdpa",
		.value = "4094,87380,524288,4096,16384,524288",
	},
	{
		.key = "net.tcp.buffersize.hspa",
		.value = "4094,87380,524288,4096,16384,524288",
	},
	{
		.key = "net.tcp.buffersize.hspap",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hsupa",
		.value = "4094,87380,524288,4096,16384,524288",
	},
	{
		.key = "net.tcp.buffersize.lte",
		.value = "524288,1048576,2097152,262144,524288,1048576",
	},
	{
		.key = "net.tcp.buffersize.umts",
		.value = "4094,87380,524288,4096,16384,524288",
	},
	{
		.key = "net.tcp.buffersize.wifi",
		.value = "524288,1048576,2097152,262144,524288,1048576",
	},
	{
		.key = "nvram_init",
		.value = "Ready",
	},
	{
		.key = "persist.af.modem.sph_enh_mask",
		.value = "0xffff 0xffffffbf",
	},
	{
		.key = "persist.backgrounddata.enable",
		.value = "false",
	},
	{
		.key = "persist.bootanim.mp4done",
		.value = "true",
	},
	{
		.key = "persist.bt.fwdump",
		.value = "0",
	},
	{
		.key = "persist.clearMotion.fblevel.bdr",
		.value = "255",
	},
	{
		.key = "persist.clearMotion.fblevel.nrm",
		.value = "255",
	},
	{
		.key = "persist.first_boot",
		.value = "0",
	},
	{
		.key = "persist.gemini.sim_num",
		.value = "2",
	},
	{
		.key = "persist.lenovo.ltetype",
		.value = "CSFB",
	},
	{
		.key = "persist.mtk.aee.aed",
		.value = "on",
	},
	{
		.key = "persist.mtk.anr.mechanism",
		.value = "1",
	},
	{
		.key = "persist.mtk.wcn.combo.chipid",
		.value = "0x6630",
	},
	{
		.key = "persist.radio.cfu.change.0",
		.value = "0",
	},
	{
		.key = "persist.radio.cfu.change.1",
		.value = "0",
	},
	{
		.key = "persist.radio.cfu.iccid.0",
		.value = "89860616010041105855",
	},
	{
		.key = "persist.radio.cfu.iccid.1",
		.value = "89860116711101654634",
	},
	{
		.key = "persist.radio.cfu.querytype",
		.value = "",
	},
	{
		.key = "persist.radio.default_sim",
		.value = "0",
	},
	{
		.key = "persist.radio.default_sim_mode",
		.value = "20",
	},
	{
		.key = "persist.radio.fd.counter",
		.value = "15",
	},
	{
		.key = "persist.radio.fd.off.counter",
		.value = "5",
	},
	{
		.key = "persist.radio.fd.off.r8.counter",
		.value = "5",
	},
	{
		.key = "persist.radio.fd.r8.counter",
		.value = "15",
	},
	{
		.key = "persist.radio.ia-apn",
		.value = "",
	},
	{
		.key = "persist.radio.ia",
		.value = "",
	},
	{
		.key = "persist.radio.nitz_oper_code2",
		.value = "",
	},
	{
		.key = "persist.radio.nitz_oper_code",
		.value = "",
	},
	{
		.key = "persist.radio.nitz_oper_lname2",
		.value = "",
	},
	{
		.key = "persist.radio.nitz_oper_lname",
		.value = "",
	},
	{
		.key = "persist.radio.nitz_oper_sname2",
		.value = "",
	},
	{
		.key = "persist.ril.gprs.setting",
		.value = "0",
	},
	{
		.key = "persist.service.acm.enable",
		.value = "",
	},
	{
		.key = "persist.service.adb.enable",
		.value = "",
	},
	{
		.key = "persist.service.pct.mode",
		.value = "1",
	},
	{
		.key = "persist.sys.afmsvr",
		.value = "1",
	},
	{
		.key = "persist.sys.bubble2_tips_show",
		.value = "false",
	},
	{
		.key = "persist.sys.country",
		.value = "US",
	},
	{
		.key = "persist.sys.dalvik.vm.lib",
		.value = "libdvm.so",
	},
	{
		.key = "persist.sys.display.clearMotion",
		.value = "0",
	},
	{
		.key = "persist.sys.extmddlprogress",
		.value = "110_0000",
	},
	{
		.key = "persist.sys.first_time_boot",
		.value = "false",
	},
	{
		.key = "persist.sys.ideadesk_theme_name",
		.value = "com.lenovo.launcher",
	},
	{
		.key = "persist.sys.input.area",
		.value = "1000",
	},
	{
		.key = "persist.sys.language",
		.value = "en",
	},
	{
		.key = "persist.sys.localevar",
		.value = "",
	},
	{
		.key = "persist.sys.mute.state",
		.value = "2",
	},
	{
		.key = "persist.sys.pq.shp.idx",
		.value = "2",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.strictmode.disable",
		.value = "1",
	},
	{
		.key = "persist.sys.theme.wallpaper",
		.value = "1",
	},
	{
		.key = "persist.sys.timezone",
		.value = "Asia/Shanghai",
	},
	{
		.key = "persist.sys.tpd_upgrade",
		.value = "true",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "ril.active.md",
		.value = "6",
	},
	{
		.key = "ril.current.share_modem",
		.value = "1",
	},
	{
		.key = "ril.ecclist2",
		.value = "",
	},
	{
		.key = "ril.ecclist",
		.value = "",
	},
	{
		.key = "ril.external.md",
		.value = "2",
	},
	{
		.key = "ril.fd.mode",
		.value = "1",
	},
	{
		.key = "ril.first.md",
		.value = "1",
	},
	{
		.key = "ril.flightmode.poweroffMD",
		.value = "0",
	},
	{
		.key = "ril.iccid.sim1",
		.value = "N/A",
	},
	{
		.key = "ril.iccid.sim2",
		.value = "N/A",
	},
	{
		.key = "ril.ipo.radiooff.2",
		.value = "0",
	},
	{
		.key = "ril.ipo.radiooff",
		.value = "0",
	},
	{
		.key = "ril.radiooff.poweroffMD",
		.value = "0",
	},
	{
		.key = "ril.ready.sim",
		.value = "false",
	},
	{
		.key = "ril.simswitch.mode",
		.value = "3",
	},
	{
		.key = "ril.specific.sm_cause",
		.value = "0",
	},
	{
		.key = "ril.telephony.mode",
		.value = "0",
	},
	{
		.key = "rild.libargs",
		.value = "-d /dev/ttyC0",
	},
	{
		.key = "rild.libpath",
		.value = "/system/lib/mtk-ril.so",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.audio.silent",
		.value = "0",
	},
	{
		.key = "ro.baseband",
		.value = "unknown",
	},
	{
		.key = "ro.board.platform",
		.value = "",
	},
	{
		.key = "ro.boot.serialno",
		.value = "0123456789ABCDEF",
	},
	{
		.key = "ro.bootloader",
		.value = "unknown",
	},
	{
		.key = "ro.bootmode",
		.value = "unknown",
	},
	{
		.key = "ro.btstack",
		.value = "blueangel",
	},
	{
		.key = "ro.build.characteristics",
		.value = "default",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1427946539",
	},
	{
		.key = "ro.build.date",
		.value = "Thu Apr  2 11:48:59 CST 2015",
	},
	{
		.key = "ro.build.description",
		.value = "x2to-user 4.4.2 KOT49H VIBEUI_V2.0_1514_5.128.1_ST_X2-TO dev-keys",
	},
	{
		.key = "ro.build.display.id",
		.value = "VIBEUI_V2.0_1514_5.128.1_ST_X2-TO",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "Lenovo/x2to/X2-TO:4.4.2/KOT49H/VIBEUI_V2.0_1514_5.128.1_ST_X2-TO.:user/release-keys",
	},
	{
		.key = "ro.build.flavor",
		.value = "",
	},
	{
		.key = "ro.build.host",
		.value = "shws45",
	},
	{
		.key = "ro.build.id",
		.value = "KOT49H",
	},
	{
		.key = "ro.build.product",
		.value = "X2-TO",
	},
	{
		.key = "ro.build.tags",
		.value = "release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.user",
		.value = "buildslave",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "VIBEUI_V2.0_1514_5.128.1_ST_X2-TO",
	},
	{
		.key = "ro.build.version.release",
		.value = "4.4.2",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "19",
	},
	{
		.key = "ro.camera.sound.forced",
		.value = "0",
	},
	{
		.key = "ro.cip.partition.support",
		.value = "no",
	},
	{
		.key = "ro.com.google.clientbase",
		.value = "android-lenovo",
	},
	{
		.key = "ro.com.lenovo.smart.config",
		.value = "7",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "New_Morning.ogg",
	},
	{
		.key = "ro.config.low_ram",
		.value = "false",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "Notice.ogg",
	},
	{
		.key = "ro.config.ringtone",
		.value = "Fantastic_Clang.ogg",
	},
	{
		.key = "ro.config.ringtone_2",
		.value = "Fantastic_Clang.ogg",
	},
	{
		.key = "ro.config.sms_notifi_sound",
		.value = "Bump.ogg",
	},
	{
		.key = "ro.config.sms_notifi_sound_2",
		.value = "Bump.ogg",
	},
	{
		.key = "ro.crypto.fs_flags",
		.value = "0x00000406",
	},
	{
		.key = "ro.crypto.fs_mnt_point",
		.value = "/data",
	},
	{
		.key = "ro.crypto.fs_options",
		.value = "noauto_da_alloc,discard",
	},
	{
		.key = "ro.crypto.fs_real_blkdev",
		.value = "/dev/block/platform/mtk-msdc.0/by-name/userdata",
	},
	{
		.key = "ro.crypto.fs_type",
		.value = "ext4",
	},
	{
		.key = "ro.crypto.fuse_sdcard",
		.value = "true",
	},
	{
		.key = "ro.crypto.state",
		.value = "unencrypted",
	},
	{
		.key = "ro.ctaversion.enable",
		.value = "false",
	},
	{
		.key = "ro.custom.build.version",
		.value = "VIBEUI_V2.0_1514_5.128.1_ST_X2-TO",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.factorytest",
		.value = "0",
	},
	{
		.key = "ro.gemini.sim_switch_policy",
		.value = "1",
	},
	{
		.key = "ro.gemini.smart_3g_switch",
		.value = "0",
	},
	{
		.key = "ro.gemini.smart_sim_switch",
		.value = "false",
	},
	{
		.key = "ro.hardware",
		.value = "mt6595",
	},
	{
		.key = "ro.hwui.disable_cache_fbo_size",
		.value = "false",
	},
	{
		.key = "ro.lenovo.adb",
		.value = "apkctl,speedup",
	},
	{
		.key = "ro.lenovo.bqb",
		.value = "pass",
	},
	{
		.key = "ro.lenovo.core.version",
		.value = "master(PRE_V1.0.8)",
	},
	{
		.key = "ro.lenovo.cta",
		.value = "false",
	},
	{
		.key = "ro.lenovo.device",
		.value = "phone",
	},
	{
		.key = "ro.lenovo.operator",
		.value = "open",
	},
	{
		.key = "ro.lenovo.platform",
		.value = "mtk",
	},
	{
		.key = "ro.lenovo.region",
		.value = "prc",
	},
	{
		.key = "ro.lenovo.series",
		.value = "VIBE X2",
	},
	{
		.key = "ro.lenovo.signalbars",
		.value = "five",
	},
	{
		.key = "ro.lenovo.sim",
		.value = "dsda",
	},
	{
		.key = "ro.lenovo.slowmotion",
		.value = "true",
	},
	{
		.key = "ro.lenovo.videocall",
		.value = "false",
	},
	{
		.key = "ro.lenovo.wificert",
		.value = "no",
	},
	{
		.key = "ro.lte.dc.support",
		.value = "0",
	},
	{
		.key = "ro.mediatek.chip_ver",
		.value = "S01",
	},
	{
		.key = "ro.mediatek.gemini_support",
		.value = "true",
	},
	{
		.key = "ro.mediatek.platform",
		.value = "MT6595",
	},
	{
		.key = "ro.mediatek.version.branch",
		.value = "KK1.MP11",
	},
	{
		.key = "ro.mediatek.version.release",
		.value = "ALPS.KK1.MP11.V1.9",
	},
	{
		.key = "ro.mediatek.version.sdk",
		.value = "2",
	},
	{
		.key = "ro.mediatek.wlan.p2p",
		.value = "1",
	},
	{
		.key = "ro.mediatek.wlan.wsc",
		.value = "1",
	},
	{
		.key = "ro.mount.fs",
		.value = "EXT4",
	},
	{
		.key = "ro.mtk.hardware",
		.value = "mt6595",
	},
	{
		.key = "ro.mtprof.disable",
		.value = "1",
	},
	{
		.key = "ro.opengles.version",
		.value = "196608",
	},
	{
		.key = "ro.persist.partition.support",
		.value = "no",
	},
	{
		.key = "ro.product.board",
		.value = "x2to",
	},
	{
		.key = "ro.product.brand",
		.value = "Lenovo",
	},
	{
		.key = "ro.product.cpu.abi2",
		.value = "armeabi",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "armeabi-v7a",
	},
	{
		.key = "ro.product.device",
		.value = "X2-TO",
	},
	{
		.key = "ro.product.hw.version",
		.value = "H201",
	},
	{
		.key = "ro.product.locale.language",
		.value = "en",
	},
	{
		.key = "ro.product.locale.region",
		.value = "US",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "LENOVO",
	},
	{
		.key = "ro.product.model",
		.value = "Lenovo X2-TO",
	},
	{
		.key = "ro.product.name",
		.value = "x2to",
	},
	{
		.key = "ro.product.particular.version",
		.value = "LENOVO_FUJIAN",
	},
	{
		.key = "ro.product.sw.internal.version",
		.value = "X2-TO_USR_ST1514_5.128.1_1504021143_MP11V1.9_CN",
	},
	{
		.key = "ro.revision",
		.value = "0",
	},
	{
		.key = "ro.runtime.firstboot",
		.value = "1395149903249",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.serialno",
		.value = "0123456789ABCDEF",
	},
	{
		.key = "ro.sf.hwrotation",
		.value = "0",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "480",
	},
	{
		.key = "ro.sys.usb.bicr",
		.value = "yes",
	},
	{
		.key = "ro.sys.usb.charging.only",
		.value = "yes",
	},
	{
		.key = "ro.sys.usb.mtp.whql.enable",
		.value = "0",
	},
	{
		.key = "ro.sys.usb.storage.type",
		.value = "mtp,mass_storage",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "ro.zygote.preload.enable",
		.value = "0",
	},
	{
		.key = "service.adb.plus",
		.value = "true",
	},
	{
		.key = "service.bootanim.exit",
		.value = "1",
	},
	{
		.key = "service.sf.status",
		.value = "1",
	},
	{
		.key = "sys.advmetamode",
		.value = "0",
	},
	{
		.key = "sys.autok.is_done",
		.value = "0.15920",
	},
	{
		.key = "sys.boot.reason",
		.value = "0",
	},
	{
		.key = "sys.boot_completed",
		.value = "1",
	},
	{
		.key = "sys.customsn.showcode",
		.value = "00000000",
	},
	{
		.key = "sys.display.clearMotion.dimmed",
		.value = "0",
	},
	{
		.key = "sys.ipo.disable",
		.value = "0",
	},
	{
		.key = "sys.ipo.pwrdncap",
		.value = "2",
	},
	{
		.key = "sys.ipowin.done",
		.value = "1",
	},
	{
		.key = "sys.lenovo.romui.version.sdk",
		.value = "2",
	},
	{
		.key = "sys.settings_system_version",
		.value = "1",
	},
	{
		.key = "sys.sysctl.extra_free_kbytes",
		.value = "126700",
	},
	{
		.key = "sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.mtpConnect",
		.value = "mtpConnection",
	},
	{
		.key = "sys.usb.state",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.vid",
		.value = "17EF",
	},
	{
		.key = "ter.service.enable",
		.value = "0",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "vold_swap_state",
		.value = "0",
	},
	{
		.key = "wfd.dummy.enable",
		.value = "1",
	},
	{
		.key = "wifi.direct.interface",
		.value = "p2p0",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{
		.key = "wifi.tethering.interface",
		.value = "ap0",
	},
	{
		.key = "wlan.driver.status",
		.value = "ok",
	},
	{
		.key = "wlan.wfd.security.image",
		.value = "1",
	},
	{ NULL },
};
#endif /* __ANDROID__ */
