/*
 * Copyright (C) 2025 Linux Studio Plugins Project <https://lsp-plug.in/>
 *           (C) 2025 Vladimir Sadovnikov <sadko4u@gmail.com>
 *
 * This file is part of lsp-dsp-lib
 * Created on: 21 февр. 2025 г.
 *
 * lsp-dsp-lib is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * lsp-dsp-lib is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with lsp-dsp-lib. If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef PRIVATE_DSP_ARCH_X86_AVX512_FFT_CONST_H_
#define PRIVATE_DSP_ARCH_X86_AVX512_FFT_CONST_H_

#ifndef PRIVATE_DSP_ARCH_X86_AVX512_IMPL
    #error "This header should not be included directly"
#endif /* PRIVATE_DSP_ARCH_X86_AVX512_IMPL */

namespace lsp
{
    namespace avx512
    {
        static const float FFT_A[] __lsp_aligned64 =
        {
            // rank == 2
            1.0000000000000000, 0.7071067811865476, 0.0000000000000000, -0.7071067811865475, 1.0000000000000000, 0.7071067811865476, 0.0000000000000000, -0.7071067811865475, 1.0000000000000000, 0.7071067811865476, 0.0000000000000000, -0.7071067811865475, 1.0000000000000000, 0.7071067811865476, 0.0000000000000000, -0.7071067811865475,
            0.0000000000000000, 0.7071067811865475, 1.0000000000000000, 0.7071067811865476, 0.0000000000000000, 0.7071067811865475, 1.0000000000000000, 0.7071067811865476, 0.0000000000000000, 0.7071067811865475, 1.0000000000000000, 0.7071067811865476, 0.0000000000000000, 0.7071067811865475, 1.0000000000000000, 0.7071067811865476,
            // rank == 3
            1.0000000000000000, 0.9238795325112867, 0.7071067811865476, 0.3826834323650898, 0.0000000000000000, -0.3826834323650897, -0.7071067811865475, -0.9238795325112867, 1.0000000000000000, 0.9238795325112867, 0.7071067811865476, 0.3826834323650898, 0.0000000000000000, -0.3826834323650897, -0.7071067811865475, -0.9238795325112867,
            0.0000000000000000, 0.3826834323650898, 0.7071067811865475, 0.9238795325112867, 1.0000000000000000, 0.9238795325112867, 0.7071067811865476, 0.3826834323650899, 0.0000000000000000, 0.3826834323650898, 0.7071067811865475, 0.9238795325112867, 1.0000000000000000, 0.9238795325112867, 0.7071067811865476, 0.3826834323650899,
            // rank == 4
            1.0000000000000000, 0.9807852804032304, 0.9238795325112867, 0.8314696123025452, 0.7071067811865476, 0.5555702330196023, 0.3826834323650898, 0.1950903220161283, 0.0000000000000001, -0.1950903220161282, -0.3826834323650897, -0.5555702330196020, -0.7071067811865475, -0.8314696123025453, -0.9238795325112867, -0.9807852804032304,
            0.0000000000000000, 0.1950903220161282, 0.3826834323650898, 0.5555702330196022, 0.7071067811865475, 0.8314696123025452, 0.9238795325112867, 0.9807852804032304, 1.0000000000000000, 0.9807852804032304, 0.9238795325112867, 0.8314696123025455, 0.7071067811865476, 0.5555702330196022, 0.3826834323650899, 0.1950903220161286,
            // rank == 5
            1.0000000000000000, 0.9951847266721969, 0.9807852804032304, 0.9569403357322088, 0.9238795325112867, 0.8819212643483550, 0.8314696123025452, 0.7730104533627370, 0.7071067811865476, 0.6343932841636455, 0.5555702330196023, 0.4713967368259978, 0.3826834323650898, 0.2902846772544623, 0.1950903220161283, 0.0980171403295608,
            0.0000000000000000, 0.0980171403295606, 0.1950903220161282, 0.2902846772544623, 0.3826834323650898, 0.4713967368259976, 0.5555702330196022, 0.6343932841636455, 0.7071067811865475, 0.7730104533627370, 0.8314696123025452, 0.8819212643483549, 0.9238795325112867, 0.9569403357322089, 0.9807852804032304, 0.9951847266721968,
            // rank == 6
            1.0000000000000000, 0.9987954562051724, 0.9951847266721969, 0.9891765099647810, 0.9807852804032304, 0.9700312531945440, 0.9569403357322088, 0.9415440651830208, 0.9238795325112867, 0.9039892931234433, 0.8819212643483550, 0.8577286100002721, 0.8314696123025452, 0.8032075314806449, 0.7730104533627370, 0.7409511253549591,
            0.0000000000000000, 0.0490676743274180, 0.0980171403295606, 0.1467304744553617, 0.1950903220161282, 0.2429801799032639, 0.2902846772544623, 0.3368898533922201, 0.3826834323650898, 0.4275550934302821, 0.4713967368259976, 0.5141027441932217, 0.5555702330196022, 0.5956993044924334, 0.6343932841636455, 0.6715589548470183,
            // rank == 7
            1.0000000000000000, 0.9996988186962042, 0.9987954562051724, 0.9972904566786902, 0.9951847266721969, 0.9924795345987100, 0.9891765099647810, 0.9852776423889412, 0.9807852804032304, 0.9757021300385286, 0.9700312531945440, 0.9637760657954398, 0.9569403357322088, 0.9495281805930367, 0.9415440651830208, 0.9329927988347390,
            0.0000000000000000, 0.0245412285229123, 0.0490676743274180, 0.0735645635996674, 0.0980171403295606, 0.1224106751992162, 0.1467304744553617, 0.1709618887603012, 0.1950903220161282, 0.2191012401568698, 0.2429801799032639, 0.2667127574748984, 0.2902846772544623, 0.3136817403988915, 0.3368898533922201, 0.3598950365349881,
            // rank == 8
            1.0000000000000000, 0.9999247018391445, 0.9996988186962042, 0.9993223845883495, 0.9987954562051724, 0.9981181129001492, 0.9972904566786902, 0.9963126121827780, 0.9951847266721969, 0.9939069700023561, 0.9924795345987100, 0.9909026354277800, 0.9891765099647810, 0.9873014181578584, 0.9852776423889412, 0.9831054874312163,
            0.0000000000000000, 0.0122715382857199, 0.0245412285229123, 0.0368072229413588, 0.0490676743274180, 0.0613207363022086, 0.0735645635996674, 0.0857973123444399, 0.0980171403295606, 0.1102222072938831, 0.1224106751992162, 0.1345807085071262, 0.1467304744553617, 0.1588581433338614, 0.1709618887603012, 0.1830398879551410,
            // rank == 9
            1.0000000000000000, 0.9999811752826011, 0.9999247018391445, 0.9998305817958234, 0.9996988186962042, 0.9995294175010931, 0.9993223845883495, 0.9990777277526454, 0.9987954562051724, 0.9984755805732948, 0.9981181129001492, 0.9977230666441916, 0.9972904566786902, 0.9968202992911657, 0.9963126121827780, 0.9957674144676598,
            0.0000000000000000, 0.0061358846491545, 0.0122715382857199, 0.0184067299058048, 0.0245412285229123, 0.0306748031766366, 0.0368072229413588, 0.0429382569349408, 0.0490676743274180, 0.0551952443496899, 0.0613207363022086, 0.0674439195636641, 0.0735645635996674, 0.0796824379714301, 0.0857973123444399, 0.0919089564971327,
            // rank == 10
            1.0000000000000000, 0.9999952938095762, 0.9999811752826011, 0.9999576445519639, 0.9999247018391445, 0.9998823474542126, 0.9998305817958234, 0.9997694053512153, 0.9996988186962042, 0.9996188224951786, 0.9995294175010931, 0.9994306045554617, 0.9993223845883495, 0.9992047586183639, 0.9990777277526454, 0.9989412931868569,
            0.0000000000000000, 0.0030679567629660, 0.0061358846491545, 0.0092037547820598, 0.0122715382857199, 0.0153392062849881, 0.0184067299058048, 0.0214740802754695, 0.0245412285229123, 0.0276081457789657, 0.0306748031766366, 0.0337411718513776, 0.0368072229413588, 0.0398729275877398, 0.0429382569349408, 0.0460031821309146,
            // rank == 11
            1.0000000000000000, 0.9999988234517019, 0.9999952938095762, 0.9999894110819284, 0.9999811752826011, 0.9999705864309741, 0.9999576445519639, 0.9999423496760239, 0.9999247018391445, 0.9999047010828529, 0.9998823474542126, 0.9998576410058239, 0.9998305817958234, 0.9998011698878843, 0.9997694053512153, 0.9997352882605617,
            0.0000000000000000, 0.0015339801862848, 0.0030679567629660, 0.0046019261204486, 0.0061358846491545, 0.0076698287395311, 0.0092037547820598, 0.0107376591672645, 0.0122715382857199, 0.0138053885280604, 0.0153392062849881, 0.0168729879472817, 0.0184067299058048, 0.0199404285515144, 0.0214740802754695, 0.0230076814688394,
            // rank == 12
            1.0000000000000000, 0.9999997058628822, 0.9999988234517019, 0.9999973527669782, 0.9999952938095762, 0.9999926465807072, 0.9999894110819284, 0.9999855873151432, 0.9999811752826011, 0.9999761749868976, 0.9999705864309741, 0.9999644096181183, 0.9999576445519639, 0.9999502912364905, 0.9999423496760239, 0.9999338198752360,
            0.0000000000000000, 0.0007669903187427, 0.0015339801862848, 0.0023009691514258, 0.0030679567629660, 0.0038349425697062, 0.0046019261204486, 0.0053689069639963, 0.0061358846491545, 0.0069028587247298, 0.0076698287395311, 0.0084367942423698, 0.0092037547820598, 0.0099707099074180, 0.0107376591672645, 0.0115046021104227,
            // rank == 13
            1.0000000000000000, 0.9999999264657179, 0.9999997058628822, 0.9999993381915255, 0.9999988234517019, 0.9999981616434870, 0.9999973527669782, 0.9999963968222944, 0.9999952938095762, 0.9999940437289858, 0.9999926465807072, 0.9999911023649456, 0.9999894110819284, 0.9999875727319041, 0.9999855873151432, 0.9999834548319377,
            0.0000000000000000, 0.0003834951875714, 0.0007669903187427, 0.0011504853371138, 0.0015339801862848, 0.0019174748098554, 0.0023009691514258, 0.0026844631545960, 0.0030679567629660, 0.0034514499201360, 0.0038349425697062, 0.0042184346552770, 0.0046019261204486, 0.0049854169088215, 0.0053689069639963, 0.0057523962295737,
            // rank == 14
            1.0000000000000000, 0.9999999816164293, 0.9999999264657179, 0.9999998345478677, 0.9999997058628822, 0.9999995404107661, 0.9999993381915255, 0.9999990992051678, 0.9999988234517019, 0.9999985109311378, 0.9999981616434870, 0.9999977755887623, 0.9999973527669782, 0.9999968931781499, 0.9999963968222944, 0.9999958636994299,
            0.0000000000000000, 0.0001917475973107, 0.0003834951875714, 0.0005752427637321, 0.0007669903187427, 0.0009587378455533, 0.0011504853371138, 0.0013422327863743, 0.0015339801862848, 0.0017257275297951, 0.0019174748098554, 0.0021092220194156, 0.0023009691514258, 0.0024927161988359, 0.0026844631545960, 0.0028762100116560,
            // rank == 15
            1.0000000000000000, 0.9999999954041073, 0.9999999816164293, 0.9999999586369661, 0.9999999264657179, 0.9999998851026849, 0.9999998345478677, 0.9999997748012666, 0.9999997058628822, 0.9999996277327151, 0.9999995404107661, 0.9999994438970360, 0.9999993381915255, 0.9999992232942359, 0.9999990992051678, 0.9999989659243228,
            0.0000000000000000, 0.0000958737990960, 0.0001917475973107, 0.0002876213937629, 0.0003834951875714, 0.0004793689778549, 0.0005752427637321, 0.0006711165443218, 0.0007669903187427, 0.0008628640861136, 0.0009587378455533, 0.0010546115961805, 0.0011504853371138, 0.0012463590674722, 0.0013422327863743, 0.0014381064929389,
            // rank == 16
            1.0000000000000000, 0.9999999988510269, 0.9999999954041073, 0.9999999896592414, 0.9999999816164293, 0.9999999712756709, 0.9999999586369661, 0.9999999437003151, 0.9999999264657179, 0.9999999069331744, 0.9999998851026849, 0.9999998609742493, 0.9999998345478677, 0.9999998058235401, 0.9999997748012666, 0.9999997414810473,
            0.0000000000000000, 0.0000479368996031, 0.0000958737990960, 0.0001438106983686, 0.0001917475973107, 0.0002396844958122, 0.0002876213937629, 0.0003355582910527, 0.0003834951875714, 0.0004314320832088, 0.0004793689778549, 0.0005273058713993, 0.0005752427637321, 0.0006231796547429, 0.0006711165443218, 0.0007190534323584,
            // rank == 17
            1.0000000000000000, 0.9999999997127567, 0.9999999988510269, 0.9999999974148104, 0.9999999954041073, 0.9999999928189177, 0.9999999896592414, 0.9999999859250787, 0.9999999816164293, 0.9999999767332933, 0.9999999712756709, 0.9999999652435617, 0.9999999586369661, 0.9999999514558838, 0.9999999437003151, 0.9999999353702598,
            0.0000000000000000, 0.0000239684498084, 0.0000479368996031, 0.0000719053493702, 0.0000958737990960, 0.0001198422487667, 0.0001438106983686, 0.0001677791478878, 0.0001917475973107, 0.0002157160466234, 0.0002396844958122, 0.0002636529448633, 0.0002876213937629, 0.0003115898424973, 0.0003355582910527, 0.0003595267394153,
        };

        static const float FFT_DW[] __lsp_aligned64 =
        {
            LSP_DSP_VEC16(0.0000000000000000), LSP_DSP_VEC16(1.0000000000000000),   // rank = 2
            LSP_DSP_VEC16(-1.0000000000000000), LSP_DSP_VEC16(0.0000000000000000),  // rank = 3
            LSP_DSP_VEC16(0.0000000000000000), LSP_DSP_VEC16(1.0000000000000000),   // rank = 4
            LSP_DSP_VEC16(0.7071067811865476), LSP_DSP_VEC16(0.7071067811865475),   // rank = 5
            LSP_DSP_VEC16(0.9238795325112867), LSP_DSP_VEC16(0.3826834323650898),   // rank = 6
            LSP_DSP_VEC16(0.9807852804032304), LSP_DSP_VEC16(0.1950903220161282),   // rank = 7
            LSP_DSP_VEC16(0.9951847266721969), LSP_DSP_VEC16(0.0980171403295606),   // rank = 8
            LSP_DSP_VEC16(0.9987954562051724), LSP_DSP_VEC16(0.0490676743274180),   // rank = 9
            LSP_DSP_VEC16(0.9996988186962042), LSP_DSP_VEC16(0.0245412285229123),   // rank = 10
            LSP_DSP_VEC16(0.9999247018391445), LSP_DSP_VEC16(0.0122715382857199),   // rank = 11
            LSP_DSP_VEC16(0.9999811752826011), LSP_DSP_VEC16(0.0061358846491545),   // rank = 12
            LSP_DSP_VEC16(0.9999952938095762), LSP_DSP_VEC16(0.0030679567629660),   // rank = 13
            LSP_DSP_VEC16(0.9999988234517019), LSP_DSP_VEC16(0.0015339801862848),   // rank = 14
            LSP_DSP_VEC16(0.9999997058628822), LSP_DSP_VEC16(0.0007669903187427),   // rank = 15
            LSP_DSP_VEC16(0.9999999264657179), LSP_DSP_VEC16(0.0003834951875714),   // rank = 16
            LSP_DSP_VEC16(0.9999999816164293), LSP_DSP_VEC16(0.0001917475973107),   // rank = 17
            LSP_DSP_VEC16(0.9999999954041073), LSP_DSP_VEC16(0.0000958737990960),   // rank = 18
        };

        static const uint32_t FFT_SCRAMBLE_INDICES[] __lsp_aligned64 =
        {
            // butterfly 1
            0,  2,  4,  6,  8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30,          // + 0x000
            1,  3,  5,  7,  9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31,          // + 0x040
            // butterfly 2
            0, 16,  2, 18,  4, 20,  6, 22,  8, 24, 10, 26, 12, 28, 14, 30,          // + 0x080
            1, 17,  3, 19,  5, 21,  7, 23,  9, 25, 11, 27, 13, 29, 15, 31,          // + 0x0c0
            // butterfly 3
            0,  1, 16, 17,  4,  5, 20, 21,  8,  9, 24, 25, 12, 13, 28, 29,          // + 0x100
            0, 17, 16,  1,  4, 21, 20,  5,  8, 25, 24,  9, 12, 29, 28, 13,          // + 0x140
            2,  3, 18, 19,  6,  7, 22, 23, 10, 11, 26, 27, 14, 15, 30, 31,          // + 0x180
            2, 19, 18,  3,  6, 23, 22,  7, 10, 27, 26, 11, 14, 31, 30, 15,          // + 0x1c0
            // butterfly 4
            0,  1,  2,  3, 16, 17, 18, 19,  8,  9, 10, 11, 24, 25, 26, 27,          // + 0x200
            4,  5,  6,  7, 20, 21, 22, 23, 12, 13, 14, 15, 28, 29, 30, 31,          // + 0x240
            // permute 16x
            0,  8,  4, 12,  2, 10,  6, 14,  1,  9,  5, 13,  3, 11,  7, 15,          // + 0x280
        };

    } /* namespace avx512 */
} /* namespace lsp */


#endif /* PRIVATE_DSP_ARCH_X86_AVX512_FFT_CONST_H_ */
