#ifndef METRONOMECLICK_H
#define METRONOMECLICK_H

#include "util/types.h"

// This is a new recording from a real metronome
// it was converted from *.wav to plain text using Audacity

const unsigned int kClickSize44100 = 1024;
const CSAMPLE kClick44100[kClickSize44100] = {
        0.03459,
        0.09436,
        0.13646,
        0.13397,
        0.12769,
        0.16707,
        0.23479,
        0.27845,
        0.26258,
        0.15676,
        -0.04469,
        -0.25386,
        -0.34708,
        -0.32814,
        -0.32287,
        -0.38761,
        -0.44187,
        -0.41100,
        -0.30597,
        -0.15478,
        0.01382,
        0.12843,
        0.14796,
        0.13350,
        0.14399,
        0.12870,
        0.00836,
        -0.20222,
        -0.40190,
        -0.49408,
        -0.45249,
        -0.32491,
        -0.17703,
        -0.04102,
        0.07596,
        0.16295,
        0.22100,
        0.27411,
        0.31737,
        0.30172,
        0.22581,
        0.17353,
        0.20625,
        0.29894,
        0.39225,
        0.43471,
        0.39620,
        0.30707,
        0.24406,
        0.25017,
        0.28685,
        0.26838,
        0.16888,
        0.07771,
        0.07703,
        0.12917,
        0.16924,
        0.18038,
        0.12173,
        -0.03985,
        -0.22585,
        -0.33717,
        -0.38322,
        -0.42069,
        -0.47394,
        -0.54568,
        -0.60043,
        -0.56950,
        -0.43692,
        -0.25673,
        -0.07543,
        0.09491,
        0.23567,
        0.31195,
        0.30476,
        0.22808,
        0.11839,
        0.02167,
        -0.02317,
        -0.02049,
        -0.02039,
        -0.05451,
        -0.09535,
        -0.09242,
        -0.02332,
        0.07294,
        0.10909,
        0.03442,
        -0.10286,
        -0.20934,
        -0.22986,
        -0.16333,
        -0.05486,
        0.02456,
        0.04289,
        0.04285,
        0.08445,
        0.17320,
        0.25566,
        0.26299,
        0.17014,
        0.03790,
        -0.03072,
        -0.00689,
        0.03881,
        0.04679,
        0.02877,
        0.00884,
        0.00138,
        0.03024,
        0.07291,
        0.05081,
        -0.04617,
        -0.12579,
        -0.12098,
        -0.04814,
        0.04824,
        0.12493,
        0.15746,
        0.17621,
        0.22541,
        0.28672,
        0.30292,
        0.24742,
        0.13678,
        0.01260,
        -0.08157,
        -0.13262,
        -0.16340,
        -0.19945,
        -0.23970,
        -0.25591,
        -0.21998,
        -0.14390,
        -0.07781,
        -0.05757,
        -0.06808,
        -0.06935,
        -0.04456,
        -0.01490,
        -0.01461,
        -0.05266,
        -0.09777,
        -0.10582,
        -0.07299,
        -0.04444,
        -0.05213,
        -0.07615,
        -0.08385,
        -0.06168,
        -0.00244,
        0.07425,
        0.11139,
        0.09062,
        0.06733,
        0.08443,
        0.12020,
        0.14020,
        0.12856,
        0.07336,
        -0.01188,
        -0.07367,
        -0.07511,
        -0.03639,
        0.00539,
        0.04250,
        0.08281,
        0.12148,
        0.14662,
        0.14958,
        0.12349,
        0.06494,
        -0.02257,
        -0.12207,
        -0.19914,
        -0.23050,
        -0.23629,
        -0.24047,
        -0.22049,
        -0.15182,
        -0.05974,
        0.01923,
        0.07074,
        0.08392,
        0.05757,
        0.01974,
        0.00129,
        0.00862,
        0.02926,
        0.04478,
        0.04602,
        0.04341,
        0.05014,
        0.05643,
        0.03546,
        -0.01834,
        -0.07537,
        -0.11110,
        -0.12691,
        -0.12411,
        -0.10754,
        -0.09923,
        -0.10206,
        -0.08627,
        -0.03778,
        0.02648,
        0.07680,
        0.07931,
        0.03101,
        -0.01723,
        -0.01654,
        0.03056,
        0.09147,
        0.14028,
        0.18082,
        0.23092,
        0.28166,
        0.31268,
        0.32659,
        0.32160,
        0.28067,
        0.21356,
        0.14683,
        0.07928,
        -0.00116,
        -0.08048,
        -0.13060,
        -0.14039,
        -0.12032,
        -0.08408,
        -0.04745,
        -0.03051,
        -0.02827,
        -0.01512,
        0.00446,
        0.00886,
        0.00775,
        0.02161,
        0.05230,
        0.09373,
        0.12782,
        0.13474,
        0.12327,
        0.10086,
        0.04818,
        -0.03682,
        -0.12249,
        -0.17666,
        -0.18403,
        -0.15787,
        -0.12867,
        -0.11173,
        -0.10847,
        -0.10970,
        -0.09328,
        -0.07013,
        -0.08650,
        -0.13937,
        -0.17932,
        -0.19186,
        -0.19026,
        -0.17832,
        -0.15854,
        -0.12098,
        -0.05565,
        0.00610,
        0.02774,
        0.01399,
        -0.01458,
        -0.03553,
        -0.03309,
        -0.02864,
        -0.03883,
        -0.03313,
        0.00129,
        0.03547,
        0.05713,
        0.06533,
        0.04814,
        0.01266,
        -0.02066,
        -0.04113,
        -0.04551,
        -0.05089,
        -0.07535,
        -0.08810,
        -0.04419,
        0.04547,
        0.12324,
        0.13714,
        0.10579,
        0.11708,
        0.18173,
        0.19511,
        0.12903,
        0.05601,
        -0.02344,
        -0.11597,
        -0.11637,
        0.00381,
        0.09555,
        0.07643,
        0.04022,
        0.06328,
        0.10965,
        0.12557,
        0.08761,
        -0.00397,
        -0.09654,
        -0.10482,
        -0.03619,
        -0.02738,
        -0.15558,
        -0.30618,
        -0.32512,
        -0.17980,
        0.05893,
        0.24755,
        0.26022,
        0.15746,
        0.10698,
        0.12767,
        0.11703,
        0.04428,
        -0.05892,
        -0.14889,
        -0.14221,
        -0.01032,
        0.12248,
        0.12812,
        0.04112,
        -0.01848,
        0.01182,
        0.10921,
        0.19406,
        0.19163,
        0.12287,
        0.08187,
        0.10396,
        0.13949,
        0.13201,
        0.05523,
        -0.05590,
        -0.10584,
        -0.06066,
        0.00319,
        0.02458,
        0.00266,
        -0.04579,
        -0.06606,
        -0.01926,
        0.03021,
        0.02058,
        -0.01833,
        -0.06103,
        -0.10540,
        -0.11843,
        -0.09712,
        -0.08664,
        -0.10371,
        -0.13938,
        -0.17927,
        -0.18908,
        -0.15833,
        -0.11590,
        -0.07976,
        -0.05598,
        -0.03229,
        0.02044,
        0.06564,
        0.03584,
        -0.02610,
        -0.04853,
        -0.06666,
        -0.09862,
        -0.07855,
        -0.00945,
        0.03533,
        0.05170,
        0.06937,
        0.06798,
        0.03647,
        0.00590,
        -0.02032,
        -0.07579,
        -0.15381,
        -0.19499,
        -0.16406,
        -0.08496,
        -0.00320,
        0.04234,
        0.04797,
        0.06657,
        0.13493,
        0.20529,
        0.22004,
        0.18459,
        0.12525,
        0.06540,
        0.03991,
        0.05305,
        0.06738,
        0.06670,
        0.06504,
        0.06147,
        0.04185,
        0.00507,
        -0.03448,
        -0.05125,
        -0.02913,
        0.01559,
        0.05433,
        0.07532,
        0.07889,
        0.07308,
        0.06800,
        0.05050,
        0.00521,
        -0.03885,
        -0.04959,
        -0.05210,
        -0.07879,
        -0.11559,
        -0.14183,
        -0.14651,
        -0.10790,
        -0.03378,
        0.02235,
        0.03398,
        0.02714,
        0.02948,
        0.04395,
        0.05421,
        0.03861,
        0.00299,
        -0.01504,
        0.00895,
        0.05926,
        0.09261,
        0.07086,
        0.00626,
        -0.04195,
        -0.03927,
        -0.00847,
        0.01482,
        0.01056,
        -0.02572,
        -0.06891,
        -0.07971,
        -0.05297,
        -0.01872,
        -0.00207,
        -0.00398,
        -0.00381,
        0.01610,
        0.03990,
        0.04023,
        0.01932,
        -0.00338,
        -0.00751,
        0.02743,
        0.08275,
        0.09694,
        0.05281,
        0.00310,
        -0.01163,
        0.00362,
        0.02366,
        0.01377,
        -0.03865,
        -0.09842,
        -0.12568,
        -0.11386,
        -0.07865,
        -0.04651,
        -0.03427,
        -0.03039,
        -0.02670,
        -0.03711,
        -0.06215,
        -0.08460,
        -0.09131,
        -0.06823,
        -0.01608,
        0.03005,
        0.04887,
        0.06172,
        0.07927,
        0.08341,
        0.07165,
        0.05462,
        0.03051,
        0.00477,
        -0.00508,
        -0.00179,
        -0.00285,
        -0.01019,
        -0.01545,
        -0.01302,
        0.00070,
        0.01781,
        0.02326,
        0.02301,
        0.03102,
        0.04078,
        0.04430,
        0.04788,
        0.05010,
        0.04386,
        0.03747,
        0.03837,
        0.04012,
        0.03893,
        0.03982,
        0.04251,
        0.03661,
        0.01758,
        -0.00095,
        -0.00688,
        -0.00886,
        -0.01248,
        -0.00724,
        0.01037,
        0.03237,
        0.05020,
        0.05024,
        0.02496,
        -0.01019,
        -0.03626,
        -0.05082,
        -0.06031,
        -0.07213,
        -0.08779,
        -0.09670,
        -0.08881,
        -0.06862,
        -0.05296,
        -0.05507,
        -0.06497,
        -0.06256,
        -0.04937,
        -0.03752,
        -0.02667,
        -0.01798,
        -0.01659,
        -0.01715,
        -0.01636,
        -0.01894,
        -0.02081,
        -0.01681,
        -0.01081,
        -0.00266,
        0.00976,
        0.01961,
        0.02005,
        0.00787,
        -0.01560,
        -0.03515,
        -0.03517,
        -0.01931,
        0.00098,
        0.02146,
        0.03971,
        0.05064,
        0.05017,
        0.04095,
        0.02953,
        0.01613,
        0.00188,
        -0.00294,
        0.00327,
        0.00960,
        0.01332,
        0.01695,
        0.01727,
        0.01597,
        0.01702,
        0.01760,
        0.02107,
        0.03329,
        0.04531,
        0.04560,
        0.03429,
        0.01720,
        0.00530,
        0.00873,
        0.02175,
        0.02995,
        0.02552,
        0.00884,
        -0.01128,
        -0.02336,
        -0.02722,
        -0.03135,
        -0.03952,
        -0.04668,
        -0.04382,
        -0.03009,
        -0.01701,
        -0.01214,
        -0.01040,
        -0.00535,
        0.00276,
        0.00917,
        0.00917,
        0.00376,
        -0.00109,
        -0.00011,
        0.00812,
        0.01667,
        0.01447,
        0.00214,
        -0.00807,
        -0.00921,
        -0.00465,
        -0.00107,
        -0.00255,
        -0.00626,
        -0.00682,
        -0.00359,
        0.00187,
        0.00778,
        0.01000,
        0.00710,
        0.00484,
        0.00858,
        0.01621,
        0.02208,
        0.02281,
        0.01799,
        0.00918,
        0.00085,
        -0.00195,
        0.00253,
        0.01246,
        0.02305,
        0.02821,
        0.02704,
        0.02144,
        0.00832,
        -0.01313,
        -0.03553,
        -0.05392,
        -0.06622,
        -0.06704,
        -0.05745,
        -0.04523,
        -0.03152,
        -0.01732,
        -0.00927,
        -0.00420,
        0.00578,
        0.01470,
        0.01608,
        0.01481,
        0.01288,
        0.00814,
        0.00392,
        0.00106,
        -0.00516,
        -0.01293,
        -0.01547,
        -0.01176,
        -0.00531,
        -0.00050,
        -0.00313,
        -0.01409,
        -0.02467,
        -0.02669,
        -0.02200,
        -0.01610,
        -0.01018,
        -0.00480,
        -0.00149,
        0.00044,
        0.00330,
        0.00943,
        0.01908,
        0.02922,
        0.03911,
        0.04968,
        0.05445,
        0.04785,
        0.03744,
        0.03068,
        0.02705,
        0.02862,
        0.03255,
        0.02670,
        0.01343,
        0.00736,
        0.00706,
        0.00310,
        -0.00076,
        -0.00043,
        -0.00254,
        -0.00989,
        -0.01529,
        -0.01277,
        -0.00406,
        0.00496,
        0.00916,
        0.00840,
        0.00675,
        0.00703,
        0.00834,
        0.00888,
        0.00870,
        0.00814,
        0.00586,
        0.00117,
        -0.00234,
        0.00107,
        0.00937,
        0.01080,
        0.00099,
        -0.00992,
        -0.01441,
        -0.01484,
        -0.01387,
        -0.01309,
        -0.01397,
        -0.01470,
        -0.01306,
        -0.01017,
        -0.00953,
        -0.01384,
        -0.01947,
        -0.01853,
        -0.01074,
        -0.00252,
        0.00325,
        0.00444,
        -0.00075,
        -0.00597,
        -0.00383,
        0.00245,
        0.00528,
        0.00279,
        0.00056,
        0.00434,
        0.00943,
        0.00780,
        0.00253,
        -0.00069,
        -0.00444,
        -0.01025,
        -0.01549,
        -0.02011,
        -0.02360,
        -0.02317,
        -0.01863,
        -0.01191,
        -0.00593,
        -0.00375,
        -0.00403,
        -0.00332,
        0.00001,
        0.00805,
        0.01843,
        0.02264,
        0.01888,
        0.01236,
        0.00453,
        -0.00255,
        -0.00455,
        -0.00347,
        -0.00305,
        -0.00222,
        -0.00116,
        -0.00113,
        -0.00131,
        -0.00330,
        -0.00871,
        -0.01252,
        -0.01099,
        -0.00728,
        -0.00405,
        -0.00148,
        0.00049,
        0.00387,
        0.01024,
        0.01637,
        0.01840,
        0.01844,
        0.02045,
        0.02204,
        0.01867,
        0.01215,
        0.00699,
        0.00492,
        0.00609,
        0.00842,
        0.00762,
        0.00176,
        -0.00793,
        -0.01681,
        -0.01759,
        -0.01103,
        -0.00653,
        -0.00699,
        -0.00783,
        -0.00746,
        -0.00483,
        0.00046,
        0.00343,
        0.00255,
        0.00311,
        0.00490,
        0.00426,
        0.00363,
        0.00488,
        0.00516,
        0.00389,
        0.00196,
        -0.00142,
        -0.00481,
        -0.00569,
        -0.00510,
        -0.00612,
        -0.00983,
        -0.01362,
        -0.01390,
        -0.01148,
        -0.00983,
        -0.00829,
        -0.00531,
        -0.00385,
        -0.00472,
        -0.00327,
        0.00131,
        0.00386,
        0.00262,
        -0.00075,
        -0.00649,
        -0.01300,
        -0.01545,
        -0.01281,
        -0.00767,
        -0.00151,
        0.00345,
        0.00511,
        0.00552,
        0.00618,
        0.00517,
        0.00257,
        0.00035,
        -0.00062,
        0.00081,
        0.00449,
        0.00662,
        0.00483,
        0.00087,
        -0.00231,
        -0.00188,
        0.00079,
        0.00003,
        -0.00413,
        -0.00568,
        -0.00325,
        0.00005,
        0.00261,
        0.00430,
        0.00598,
        0.00836,
        0.01013,
        0.01027,
        0.00911,
        0.00544,
        0.00005,
        -0.00318,
        -0.00422,
        -0.00557,
        -0.00576,
        -0.00344,
        -0.00097,
        0.00079,
        0.00296,
        0.00520,
        0.00723,
        0.00874,
        0.00781,
        0.00473,
        0.00280,
        0.00251,
        0.00132,
        -0.00091,
        -0.00291,
        -0.00509,
        -0.00772,
        -0.00921,
        -0.00887,
        -0.00758,
        -0.00571,
        -0.00279,
        0.00175,
        0.00699,
        0.01008,
        0.00993,
        0.00821,
        0.00559,
        0.00272,
        0.00164,
        0.00126,
        -0.00125,
        -0.00393,
        -0.00441,
        -0.00497,
        -0.00616,
        -0.00534,
        -0.00271,
        -0.00037,
        0.00080,
        0.00026,
        -0.00097,
        -0.00053,
        0.00148,
        0.00373,
        0.00606,
        0.00767,
        0.00730,
        0.00572,
        0.00385,
        0.00195,
        0.00085,
        0.00011,
        -0.00186,
        -0.00475,
        -0.00703,
        -0.00856,
        -0.00916,
        -0.00749,
        -0.00364,
        0.00023,
        0.00235,
        0.00242,
        0.00104,
        -0.00017,
        0.00057,
        0.00247,
        0.00335,
        0.00314,
        0.00248,
        0.00140,
        0.00089,
        0.00166,
        0.00254,
        0.00289,
        0.00284,
        0.00186,
        0.00027,
        -0.00105,
        -0.00214,
        -0.00285,
        -0.00232,
        -0.00094,
        0.00041,
        0.00154,
        0.00174,
        0.00068,
        -0.00036,
        -0.00042,
        0.00031,
        0.00123,
        0.00185,
        0.00262,
        0.00406,
        0.00526,
        0.00556,
        0.00519,
        0.00365,
        0.00112,
        -0.00027,
        0.00008,
        0.00019,
        -0.00101,
        -0.00223,
        -0.00197,
        -0.00014,
        0.00189,
        0.00295,
        0.00288,
        0.00164,
        -0.00026,
        -0.00152,
        -0.00197,
        -0.00283,
        -0.00435,
        -0.00562,
        -0.00587,
        -0.00503,
        -0.00393,
        -0.00329,
        -0.00291,
        -0.00225,
        -0.00120,
        -0.00006,
        0.00031,
        -0.00065,
        -0.00196,
        -0.00234,
        -0.00181,
        -0.00092,
        0.00011,
        0.00103,
        0.00125,
        0.00042,
        -0.00110,
        -0.00237,
        -0.00304,
        -0.00350,
        -0.00403,
        -0.00439,
        -0.00419,
        -0.00322,
        -0.00175,
        -0.00042,
        0.00026,
        0.00057,
        0.00099,
        0.00100,
        0.00041,
        0.00039,
        0.00139
};

const unsigned int kClickSize48000 = 1116;
const CSAMPLE kClick48000[kClickSize48000] = {
        0.01534,
        0.05623,
        0.10618,
        0.13596,
        0.13323,
        0.12915,
        0.16533,
        0.22630,
        0.26943,
        0.26715,
        0.19582,
        0.04604,
        -0.14266,
        -0.28995,
        -0.34129,
        -0.32696,
        -0.33215,
        -0.39098,
        -0.44083,
        -0.41410,
        -0.32505,
        -0.19452,
        -0.04420,
        0.07968,
        0.13807,
        0.14200,
        0.13697,
        0.14017,
        0.10844,
        -0.00998,
        -0.20339,
        -0.38685,
        -0.47964,
        -0.46238,
        -0.36563,
        -0.23624,
        -0.10653,
        0.01011,
        0.10692,
        0.17889,
        0.23127,
        0.27896,
        0.31689,
        0.30251,
        0.23580,
        0.18466,
        0.19663,
        0.26415,
        0.34964,
        0.41187,
        0.42004,
        0.36949,
        0.29331,
        0.24490,
        0.25222,
        0.28592,
        0.27035,
        0.18757,
        0.10225,
        0.07727,
        0.10667,
        0.14869,
        0.17376,
        0.16134,
        0.08241,
        -0.07001,
        -0.23485,
        -0.33713,
        -0.37946,
        -0.41459,
        -0.46094,
        -0.52234,
        -0.57817,
        -0.58459,
        -0.51238,
        -0.37392,
        -0.20807,
        -0.04356,
        0.10981,
        0.23755,
        0.30763,
        0.30575,
        0.24488,
        0.15134,
        0.05858,
        -0.00241,
        -0.02195,
        -0.02045,
        -0.03040,
        -0.06317,
        -0.09497,
        -0.08899,
        -0.02551,
        0.06207,
        0.10207,
        0.05498,
        -0.05390,
        -0.16271,
        -0.21921,
        -0.20327,
        -0.12880,
        -0.03603,
        0.02742,
        0.04289,
        0.04285,
        0.08079,
        0.15819,
        0.23501,
        0.26056,
        0.20848,
        0.10325,
        0.00876,
        -0.02254,
        0.00509,
        0.04025,
        0.04500,
        0.02840,
        0.01009,
        0.00246,
        0.02374,
        0.05983,
        0.05938,
        -0.00067,
        -0.08197,
        -0.12402,
        -0.10007,
        -0.02830,
        0.05780,
        0.12634,
        0.15623,
        0.17398,
        0.21555,
        0.26945,
        0.29704,
        0.27207,
        0.19491,
        0.08793,
        -0.01679,
        -0.09336,
        -0.13723,
        -0.16586,
        -0.19899,
        -0.23591,
        -0.25307,
        -0.22920,
        -0.16961,
        -0.10551,
        -0.06770,
        -0.06197,
        -0.06851,
        -0.06301,
        -0.03938,
        -0.01487,
        -0.01507,
        -0.05003,
        -0.09099,
        -0.10396,
        -0.08326,
        -0.05569,
        -0.04847,
        -0.06278,
        -0.07894,
        -0.07762,
        -0.04985,
        0.00664,
        0.07563,
        0.10975,
        0.09322,
        0.07214,
        0.07951,
        0.10700,
        0.13119,
        0.13475,
        0.10719,
        0.04729,
        -0.02576,
        -0.07388,
        -0.07271,
        -0.03713,
        0.00120,
        0.03576,
        0.07221,
        0.10817,
        0.13593,
        0.14808,
        0.13883,
        0.10412,
        0.04310,
        -0.03932,
        -0.12878,
        -0.19932,
        -0.22814,
        -0.23538,
        -0.23948,
        -0.22687,
        -0.17931,
        -0.10409,
        -0.02522,
        0.03756,
        0.07436,
        0.07882,
        0.05333,
        0.01917,
        0.00222,
        0.00766,
        0.02487,
        0.04022,
        0.04555,
        0.04460,
        0.04652,
        0.05254,
        0.05015,
        0.02371,
        -0.02616,
        -0.07737,
        -0.11019,
        -0.12522,
        -0.12464,
        -0.11200,
        -0.10214,
        -0.10084,
        -0.09437,
        -0.06659,
        -0.01692,
        0.03873,
        0.07721,
        0.07540,
        0.03103,
        -0.01329,
        -0.01665,
        0.01906,
        0.07165,
        0.12043,
        0.16104,
        0.20241,
        0.24866,
        0.28998,
        0.31528,
        0.32606,
        0.32059,
        0.28299,
        0.22281,
        0.16145,
        0.09957,
        0.02954,
        -0.04376,
        -0.10333,
        -0.13427,
        -0.13450,
        -0.11263,
        -0.07929,
        -0.04661,
        -0.03105,
        -0.02852,
        -0.01767,
        -0.00093,
        0.00729,
        0.00824,
        0.01441,
        0.03387,
        0.06549,
        0.10181,
        0.12890,
        0.13388,
        0.12335,
        0.10283,
        0.05709,
        -0.01554,
        -0.09408,
        -0.15429,
        -0.18039,
        -0.17292,
        -0.14784,
        -0.12423,
        -0.11114,
        -0.10859,
        -0.10940,
        -0.09431,
        -0.07347,
        -0.08281,
        -0.12316,
        -0.16382,
        -0.18598,
        -0.19114,
        -0.18586,
        -0.17264,
        -0.15081,
        -0.11284,
        -0.05297,
        0.00376,
        0.02516,
        0.01675,
        -0.00653,
        -0.02793,
        -0.03417,
        -0.03098,
        -0.03265,
        -0.03705,
        -0.02518,
        0.00640,
        0.03695,
        0.05685,
        0.06456,
        0.05115,
        0.02176,
        -0.00940,
        -0.03255,
        -0.04332,
        -0.04776,
        -0.05914,
        -0.07861,
        -0.08043,
        -0.03582,
        0.04641,
        0.11786,
        0.13505,
        0.11305,
        0.11355,
        0.15625,
        0.18875,
        0.16581,
        0.10259,
        0.03370,
        -0.04191,
        -0.11602,
        -0.11191,
        -0.00149,
        0.08405,
        0.08038,
        0.05064,
        0.05477,
        0.08877,
        0.11711,
        0.11088,
        0.05960,
        -0.02476,
        -0.09773,
        -0.10056,
        -0.03750,
        -0.02826,
        -0.13229,
        -0.26659,
        -0.31860,
        -0.24162,
        -0.06202,
        0.13666,
        0.25174,
        0.23457,
        0.14896,
        0.10878,
        0.12761,
        0.11783,
        0.05568,
        -0.03437,
        -0.12018,
        -0.14488,
        -0.07384,
        0.04773,
        0.12449,
        0.10423,
        0.02960,
        -0.01508,
        0.01482,
        0.10430,
        0.18289,
        0.19215,
        0.14309,
        0.09726,
        0.09387,
        0.12038,
        0.13664,
        0.10901,
        0.03096,
        -0.06275,
        -0.10332,
        -0.06181,
        -0.00362,
        0.02056,
        0.00856,
        -0.02881,
        -0.05731,
        -0.04326,
        0.00082,
        0.02708,
        0.01111,
        -0.02525,
        -0.06462,
        -0.10538,
        -0.11737,
        -0.10059,
        -0.08920,
        -0.09816,
        -0.12488,
        -0.15981,
        -0.18350,
        -0.17833,
        -0.14694,
        -0.10914,
        -0.07724,
        -0.05540,
        -0.03363,
        0.01317,
        0.05574,
        0.04479,
        -0.00246,
        -0.03815,
        -0.05679,
        -0.07863,
        -0.09273,
        -0.06389,
        -0.00359,
        0.03614,
        0.05118,
        0.06737,
        0.06825,
        0.04515,
        0.01680,
        -0.00884,
        -0.04699,
        -0.10697,
        -0.16692,
        -0.18766,
        -0.15173,
        -0.07886,
        -0.00374,
        0.03834,
        0.04702,
        0.06191,
        0.11226,
        0.17624,
        0.21275,
        0.20499,
        0.16421,
        0.10956,
        0.06079,
        0.04122,
        0.05331,
        0.06648,
        0.06680,
        0.06541,
        0.06256,
        0.04946,
        0.02232,
        -0.01271,
        -0.04066,
        -0.04490,
        -0.01992,
        0.02042,
        0.05524,
        0.07452,
        0.07846,
        0.07424,
        0.06943,
        0.05685,
        0.02533,
        -0.01570,
        -0.04307,
        -0.05037,
        -0.05826,
        -0.08430,
        -0.11738,
        -0.14149,
        -0.14607,
        -0.11467,
        -0.05280,
        0.00338,
        0.02911,
        0.03056,
        0.02812,
        0.03436,
        0.04658,
        0.05149,
        0.03528,
        0.00277,
        -0.01379,
        0.00534,
        0.04761,
        0.08218,
        0.07943,
        0.03697,
        -0.01511,
        -0.04098,
        -0.03062,
        -0.00382,
        0.01432,
        0.00921,
        -0.02412,
        -0.06350,
        -0.07748,
        -0.06067,
        -0.03136,
        -0.00957,
        -0.00296,
        -0.00391,
        0.00228,
        0.02145,
        0.03995,
        0.03893,
        0.01972,
        -0.00110,
        -0.00676,
        0.01825,
        0.06371,
        0.09090,
        0.07517,
        0.03232,
        -0.00177,
        -0.00782,
        0.00699,
        0.02280,
        0.01346,
        -0.03470,
        -0.08906,
        -0.11919,
        -0.11763,
        -0.09275,
        -0.06199,
        -0.04116,
        -0.03289,
        -0.02938,
        -0.02871,
        -0.03992,
        -0.06284,
        -0.08347,
        -0.09043,
        -0.07314,
        -0.03142,
        0.01273,
        0.04028,
        0.05481,
        0.06840,
        0.08051,
        0.08084,
        0.06932,
        0.05327,
        0.03112,
        0.00751,
        -0.00323,
        -0.00268,
        -0.00248,
        -0.00702,
        -0.01275,
        -0.01446,
        -0.00857,
        0.00486,
        0.01869,
        0.02324,
        0.02301,
        0.03037,
        0.03919,
        0.04344,
        0.04672,
        0.04920,
        0.04690,
        0.04111,
        0.03778,
        0.03884,
        0.03990,
        0.03902,
        0.03989,
        0.04236,
        0.03742,
        0.02175,
        0.00462,
        -0.00462,
        -0.00794,
        -0.01051,
        -0.01052,
        -0.00207,
        0.01504,
        0.03470,
        0.05020,
        0.05024,
        0.02781,
        -0.00337,
        -0.02908,
        -0.04563,
        -0.05615,
        -0.06599,
        -0.07839,
        -0.09063,
        -0.09483,
        -0.08566,
        -0.06745,
        -0.05306,
        -0.05488,
        -0.06330,
        -0.06316,
        -0.05374,
        -0.04241,
        -0.03203,
        -0.02298,
        -0.01750,
        -0.01674,
        -0.01701,
        -0.01662,
        -0.01897,
        -0.02069,
        -0.01739,
        -0.01216,
        -0.00516,
        0.00494,
        0.01499,
        0.01981,
        0.01556,
        0.00113,
        -0.01962,
        -0.03515,
        -0.03448,
        -0.01991,
        -0.00144,
        0.01736,
        0.03457,
        0.04667,
        0.05038,
        0.04579,
        0.03646,
        0.02535,
        0.01284,
        0.00116,
        -0.00252,
        0.00319,
        0.00900,
        0.01267,
        0.01602,
        0.01716,
        0.01651,
        0.01649,
        0.01726,
        0.01877,
        0.02420,
        0.03539,
        0.04534,
        0.04546,
        0.03507,
        0.01977,
        0.00806,
        0.00766,
        0.01662,
        0.02605,
        0.02799,
        0.01948,
        0.00319,
        -0.01369,
        -0.02382,
        -0.02737,
        -0.03117,
        -0.03850,
        -0.04520,
        -0.04464,
        -0.03516,
        -0.02290,
        -0.01473,
        -0.01147,
        -0.00886,
        -0.00353,
        0.00368,
        0.00917,
        0.00917,
        0.00430,
        -0.00021,
        -0.00037,
        0.00529,
        0.01303,
        0.01558,
        0.00939,
        -0.00124,
        -0.00835,
        -0.00844,
        -0.00434,
        -0.00108,
        -0.00244,
        -0.00568,
        -0.00669,
        -0.00462,
        -0.00032,
        0.00493,
        0.00875,
        0.00897,
        0.00648,
        0.00556,
        0.00944,
        0.01639,
        0.02178,
        0.02271,
        0.01902,
        0.01177,
        0.00398,
        -0.00067,
        0.00012,
        0.00631,
        0.01563,
        0.02418,
        0.02805,
        0.02673,
        0.02158,
        0.00972,
        -0.00910,
        -0.02950,
        -0.04748,
        -0.06091,
        -0.06662,
        -0.06315,
        -0.05348,
        -0.04189,
        -0.02922,
        -0.01667,
        -0.00927,
        -0.00461,
        0.00415,
        0.01252,
        0.01563,
        0.01533,
        0.01382,
        0.01084,
        0.00666,
        0.00315,
        -0.00010,
        -0.00598,
        -0.01299,
        -0.01533,
        -0.01227,
        -0.00672,
        -0.00194,
        -0.00213,
        -0.00902,
        -0.01891,
        -0.02543,
        -0.02531,
        -0.02075,
        -0.01533,
        -0.00991,
        -0.00497,
        -0.00186,
        0.00007,
        0.00251,
        0.00724,
        0.01485,
        0.02396,
        0.03317,
        0.04248,
        0.05081,
        0.05342,
        0.04707,
        0.03751,
        0.03127,
        0.02766,
        0.02823,
        0.03125,
        0.02912,
        0.01999,
        0.01085,
        0.00726,
        0.00602,
        0.00240,
        -0.00073,
        -0.00047,
        -0.00241,
        -0.00883,
        -0.01407,
        -0.01354,
        -0.00744,
        0.00073,
        0.00685,
        0.00888,
        0.00793,
        0.00681,
        0.00719,
        0.00836,
        0.00886,
        0.00872,
        0.00825,
        0.00650,
        0.00287,
        -0.00078,
        -0.00072,
        0.00433,
        0.00982,
        0.00854,
        -0.00064,
        -0.01023,
        -0.01435,
        -0.01480,
        -0.01404,
        -0.01329,
        -0.01367,
        -0.01439,
        -0.01388,
        -0.01185,
        -0.00995,
        -0.01063,
        -0.01482,
        -0.01938,
        -0.01844,
        -0.01128,
        -0.00376,
        0.00191,
        0.00407,
        0.00130,
        -0.00349,
        -0.00502,
        -0.00156,
        0.00324,
        0.00478,
        0.00253,
        0.00070,
        0.00417,
        0.00879,
        0.00814,
        0.00405,
        0.00050,
        -0.00275,
        -0.00716,
        -0.01228,
        -0.01690,
        -0.02089,
        -0.02354,
        -0.02289,
        -0.01872,
        -0.01258,
        -0.00702,
        -0.00432,
        -0.00393,
        -0.00362,
        -0.00168,
        0.00332,
        0.01148,
        0.01948,
        0.02201,
        0.01831,
        0.01231,
        0.00512,
        -0.00144,
        -0.00407,
        -0.00381,
        -0.00322,
        -0.00262,
        -0.00176,
        -0.00115,
        -0.00118,
        -0.00169,
        -0.00391,
        -0.00883,
        -0.01233,
        -0.01119,
        -0.00807,
        -0.00500,
        -0.00244,
        -0.00041,
        0.00205,
        0.00630,
        0.01208,
        0.01681,
        0.01841,
        0.01855,
        0.02040,
        0.02187,
        0.01930,
        0.01390,
        0.00880,
        0.00581,
        0.00549,
        0.00704,
        0.00816,
        0.00619,
        0.00019,
        -0.00865,
        -0.01681,
        -0.01753,
        -0.01210,
        -0.00763,
        -0.00684,
        -0.00749,
        -0.00764,
        -0.00633,
        -0.00298,
        0.00126,
        0.00327,
        0.00261,
        0.00315,
        0.00480,
        0.00435,
        0.00377,
        0.00450,
        0.00505,
        0.00448,
        0.00301,
        0.00069,
        -0.00241,
        -0.00500,
        -0.00561,
        -0.00515,
        -0.00609,
        -0.00941,
        -0.01288,
        -0.01382,
        -0.01234,
        -0.01055,
        -0.00909,
        -0.00710,
        -0.00485,
        -0.00406,
        -0.00449,
        -0.00293,
        0.00128,
        0.00364,
        0.00283,
        0.00009,
        -0.00459,
        -0.01031,
        -0.01424,
        -0.01433,
        -0.01105,
        -0.00606,
        -0.00061,
        0.00362,
        0.00512,
        0.00549,
        0.00608,
        0.00540,
        0.00337,
        0.00121,
        -0.00016,
        0.00002,
        0.00217,
        0.00510,
        0.00625,
        0.00434,
        0.00073,
        -0.00219,
        -0.00193,
        0.00025,
        0.00024,
        -0.00262,
        -0.00499,
        -0.00453,
        -0.00195,
        0.00085,
        0.00300,
        0.00455,
        0.00614,
        0.00833,
        0.00996,
        0.01025,
        0.00941,
        0.00668,
        0.00231,
        -0.00156,
        -0.00362,
        -0.00468,
        -0.00562,
        -0.00535,
        -0.00321,
        -0.00095,
        0.00067,
        0.00263,
        0.00468,
        0.00659,
        0.00814,
        0.00825,
        0.00644,
        0.00403,
        0.00272,
        0.00227,
        0.00106,
        -0.00098,
        -0.00282,
        -0.00482,
        -0.00718,
        -0.00878,
        -0.00900,
        -0.00816,
        -0.00670,
        -0.00458,
        -0.00140,
        0.00293,
        0.00743,
        0.01007,
        0.00993,
        0.00838,
        0.00607,
        0.00347,
        0.00201,
        0.00142,
        0.00002,
        -0.00235,
        -0.00409,
        -0.00455,
        -0.00517,
        -0.00609,
        -0.00532,
        -0.00291,
        -0.00074,
        0.00052,
        0.00043,
        -0.00048,
        -0.00074,
        0.00035,
        0.00228,
        0.00437,
        0.00637,
        0.00763,
        0.00725,
        0.00580,
        0.00410,
        0.00235,
        0.00117,
        0.00039,
        -0.00096,
        -0.00320,
        -0.00562,
        -0.00749,
        -0.00869,
        -0.00893,
        -0.00727,
        -0.00374,
        -0.00018,
        0.00195,
        0.00240,
        0.00152,
        0.00035,
        0.00019,
        0.00134,
        0.00276,
        0.00330,
        0.00303,
        0.00239,
        0.00140,
        0.00093,
        0.00153,
        0.00233,
        0.00278,
        0.00286,
        0.00234,
        0.00117,
        -0.00019,
        -0.00134,
        -0.00227,
        -0.00279,
        -0.00229,
        -0.00102,
        0.00022,
        0.00129,
        0.00168,
        0.00108,
        0.00012,
        -0.00039,
        -0.00015,
        0.00058,
        0.00136,
        0.00195,
        0.00269,
        0.00401,
        0.00512,
        0.00550,
        0.00529,
        0.00420,
        0.00223,
        0.00045,
        -0.00013,
        0.00012,
        -0.00009,
        -0.00120,
        -0.00221,
        -0.00197,
        -0.00030,
        0.00155,
        0.00268,
        0.00290,
        0.00215,
        0.00068,
        -0.00080,
        -0.00167,
        -0.00220,
        -0.00310,
        -0.00448,
        -0.00562,
        -0.00585,
        -0.00515,
        -0.00418,
        -0.00349,
        -0.00306,
        -0.00256,
        -0.00178,
        -0.00078,
        0.00005,
        0.00011,
        -0.00081,
        -0.00198,
        -0.00233,
        -0.00187,
        -0.00110,
        -0.00018,
        0.00070,
        0.00115,
        0.00086,
        -0.00018,
        -0.00150,
        -0.00252,
        -0.00311,
        -0.00354,
        -0.00402,
        -0.00436,
        -0.00423,
        -0.00347,
        -0.00225,
        -0.00098,
        -0.00008,
        0.00039,
        0.00071,
        0.00099,
        0.00090,
        0.00041,
        0.00040,
        0.00132,
        0.00021
};


const unsigned int kClickSize96000 = 2231;
const CSAMPLE kClick96000[kClickSize96000] = {
        0.01534,
        0.03123,
        0.05623,
        0.08369,
        0.10618,
        0.12552,
        0.13596,
        0.13482,
        0.13323,
        0.13034,
        0.12915,
        0.14724,
        0.16533,
        0.19519,
        0.22630,
        0.24937,
        0.26943,
        0.27444,
        0.26715,
        0.24443,
        0.19582,
        0.13858,
        0.04604,
        -0.04657,
        -0.14266,
        -0.23875,
        -0.28995,
        -0.33277,
        -0.34129,
        -0.33259,
        -0.32696,
        -0.32454,
        -0.33215,
        -0.36189,
        -0.39098,
        -0.41591,
        -0.44083,
        -0.42828,
        -0.41410,
        -0.37329,
        -0.32505,
        -0.26398,
        -0.19452,
        -0.12165,
        -0.04420,
        0.02703,
        0.07968,
        0.12909,
        0.13807,
        0.14704,
        0.14200,
        0.13536,
        0.13697,
        0.14179,
        0.14017,
        0.13315,
        0.10844,
        0.05316,
        -0.00998,
        -0.10672,
        -0.20339,
        -0.29512,
        -0.38685,
        -0.43730,
        -0.47964,
        -0.48149,
        -0.46238,
        -0.42423,
        -0.36563,
        -0.30417,
        -0.23624,
        -0.16901,
        -0.10653,
        -0.04405,
        0.01011,
        0.06385,
        0.10692,
        0.14688,
        0.17889,
        0.20556,
        0.23127,
        0.25567,
        0.27896,
        0.29883,
        0.31689,
        0.30970,
        0.30251,
        0.27067,
        0.23580,
        0.20868,
        0.18466,
        0.18160,
        0.19663,
        0.22157,
        0.26415,
        0.30678,
        0.34964,
        0.39237,
        0.41187,
        0.43138,
        0.42004,
        0.40235,
        0.36949,
        0.32855,
        0.29331,
        0.26436,
        0.24490,
        0.24770,
        0.25222,
        0.26907,
        0.28592,
        0.27883,
        0.27035,
        0.23328,
        0.18757,
        0.14413,
        0.10225,
        0.07758,
        0.07727,
        0.08271,
        0.10667,
        0.13028,
        0.14869,
        0.16710,
        0.17376,
        0.17888,
        0.16134,
        0.13440,
        0.08241,
        0.00818,
        -0.07001,
        -0.15545,
        -0.23485,
        -0.28599,
        -0.33713,
        -0.35831,
        -0.37946,
        -0.39737,
        -0.41459,
        -0.43648,
        -0.46094,
        -0.48938,
        -0.52234,
        -0.55302,
        -0.57817,
        -0.59880,
        -0.58459,
        -0.57038,
        -0.51238,
        -0.45147,
        -0.37392,
        -0.29115,
        -0.20807,
        -0.12479,
        -0.04356,
        0.03469,
        0.10981,
        0.17447,
        0.23755,
        0.27259,
        0.30763,
        0.30905,
        0.30575,
        0.28011,
        0.24488,
        0.20173,
        0.15134,
        0.10301,
        0.05858,
        0.01818,
        -0.00241,
        -0.02301,
        -0.02195,
        -0.02072,
        -0.02045,
        -0.02041,
        -0.03040,
        -0.04607,
        -0.06317,
        -0.08193,
        -0.09497,
        -0.09362,
        -0.08899,
        -0.05725,
        -0.02551,
        0.01785,
        0.06207,
        0.08547,
        0.10207,
        0.08929,
        0.05498,
        0.00916,
        -0.05390,
        -0.11380,
        -0.16271,
        -0.20978,
        -0.21921,
        -0.22863,
        -0.20327,
        -0.17271,
        -0.12880,
        -0.07897,
        -0.03603,
        0.00046,
        0.02742,
        0.03584,
        0.04289,
        0.04287,
        0.04285,
        0.06168,
        0.08079,
        0.11742,
        0.15819,
        0.19713,
        0.23501,
        0.25719,
        0.26056,
        0.25113,
        0.20848,
        0.16399,
        0.10325,
        0.04250,
        0.00876,
        -0.02276,
        -0.02254,
        -0.01159,
        0.00509,
        0.02608,
        0.04025,
        0.04392,
        0.04500,
        0.03672,
        0.02840,
        0.01925,
        0.01009,
        0.00588,
        0.00246,
        0.01048,
        0.02374,
        0.04022,
        0.05983,
        0.06953,
        0.05938,
        0.04388,
        -0.00067,
        -0.04522,
        -0.08197,
        -0.11854,
        -0.12402,
        -0.12181,
        -0.10007,
        -0.06661,
        -0.02830,
        0.01598,
        0.05780,
        0.09303,
        0.12634,
        0.14128,
        0.15623,
        0.16536,
        0.17398,
        0.19295,
        0.21555,
        0.24129,
        0.26945,
        0.28960,
        0.29704,
        0.29756,
        0.27207,
        0.24574,
        0.19491,
        0.14408,
        0.08793,
        0.03089,
        -0.01679,
        -0.06005,
        -0.09336,
        -0.11681,
        -0.13723,
        -0.15136,
        -0.16586,
        -0.18243,
        -0.19899,
        -0.21742,
        -0.23591,
        -0.24562,
        -0.25307,
        -0.24571,
        -0.22920,
        -0.20456,
        -0.16961,
        -0.13587,
        -0.10551,
        -0.07700,
        -0.06770,
        -0.05840,
        -0.06197,
        -0.06680,
        -0.06851,
        -0.06909,
        -0.06301,
        -0.05162,
        -0.03938,
        -0.02576,
        -0.01487,
        -0.01474,
        -0.01507,
        -0.03255,
        -0.05003,
        -0.07026,
        -0.09099,
        -0.10026,
        -0.10396,
        -0.09834,
        -0.08326,
        -0.06881,
        -0.05569,
        -0.04494,
        -0.04847,
        -0.05201,
        -0.06278,
        -0.07381,
        -0.07894,
        -0.08248,
        -0.07762,
        -0.06744,
        -0.04985,
        -0.02264,
        0.00664,
        0.04187,
        0.07563,
        0.09269,
        0.10975,
        0.10277,
        0.09322,
        0.08284,
        0.07214,
        0.07165,
        0.07951,
        0.09056,
        0.10700,
        0.12200,
        0.13119,
        0.14010,
        0.13475,
        0.12940,
        0.10719,
        0.08183,
        0.04729,
        0.00813,
        -0.02576,
        -0.05414,
        -0.07388,
        -0.07454,
        -0.07271,
        -0.05492,
        -0.03713,
        -0.01800,
        0.00120,
        0.01871,
        0.03576,
        0.05370,
        0.07221,
        0.09041,
        0.10817,
        0.12438,
        0.13593,
        0.14672,
        0.14808,
        0.14944,
        0.13883,
        0.12684,
        0.10412,
        0.07722,
        0.04310,
        0.00290,
        -0.03932,
        -0.08503,
        -0.12878,
        -0.16419,
        -0.19932,
        -0.21373,
        -0.22814,
        -0.23272,
        -0.23538,
        -0.23756,
        -0.23948,
        -0.23604,
        -0.22687,
        -0.21086,
        -0.17931,
        -0.14639,
        -0.10409,
        -0.06179,
        -0.02522,
        0.01106,
        0.03756,
        0.06122,
        0.07436,
        0.08041,
        0.07882,
        0.06672,
        0.05333,
        0.03595,
        0.01917,
        0.01070,
        0.00222,
        0.00429,
        0.00766,
        0.01538,
        0.02487,
        0.03309,
        0.04022,
        0.04498,
        0.04555,
        0.04580,
        0.04460,
        0.04343,
        0.04652,
        0.04961,
        0.05254,
        0.05543,
        0.05015,
        0.04051,
        0.02371,
        -0.00100,
        -0.02616,
        -0.05236,
        -0.07737,
        -0.09378,
        -0.11019,
        -0.11796,
        -0.12522,
        -0.12592,
        -0.12464,
        -0.11961,
        -0.11200,
        -0.10596,
        -0.10214,
        -0.09954,
        -0.10084,
        -0.10162,
        -0.09437,
        -0.08711,
        -0.06659,
        -0.04431,
        -0.01692,
        0.01260,
        0.03873,
        0.06184,
        0.07721,
        0.07836,
        0.07540,
        0.05322,
        0.03103,
        0.00887,
        -0.01329,
        -0.01697,
        -0.01665,
        -0.00258,
        0.01906,
        0.04367,
        0.07165,
        0.09801,
        0.12043,
        0.14242,
        0.16104,
        0.17966,
        0.20241,
        0.22542,
        0.24866,
        0.27197,
        0.28998,
        0.30423,
        0.31528,
        0.32167,
        0.32606,
        0.32377,
        0.32059,
        0.30179,
        0.28299,
        0.25364,
        0.22281,
        0.19211,
        0.16145,
        0.13060,
        0.09957,
        0.06649,
        0.02954,
        -0.00733,
        -0.04376,
        -0.08020,
        -0.10333,
        -0.12635,
        -0.13427,
        -0.13876,
        -0.13450,
        -0.12528,
        -0.11263,
        -0.09599,
        -0.07929,
        -0.06246,
        -0.04661,
        -0.03883,
        -0.03105,
        -0.02955,
        -0.02852,
        -0.02371,
        -0.01767,
        -0.00993,
        -0.00093,
        0.00527,
        0.00729,
        0.00875,
        0.00824,
        0.00805,
        0.01441,
        0.02078,
        0.03387,
        0.04797,
        0.06549,
        0.08452,
        0.10181,
        0.11747,
        0.12890,
        0.13208,
        0.13388,
        0.12862,
        0.12335,
        0.11312,
        0.10283,
        0.08129,
        0.05709,
        0.02351,
        -0.01554,
        -0.05472,
        -0.09408,
        -0.12941,
        -0.15429,
        -0.17700,
        -0.18039,
        -0.18377,
        -0.17292,
        -0.16090,
        -0.14784,
        -0.13443,
        -0.12423,
        -0.11645,
        -0.11114,
        -0.10964,
        -0.10859,
        -0.10916,
        -0.10940,
        -0.10186,
        -0.09431,
        -0.08410,
        -0.07347,
        -0.07529,
        -0.08281,
        -0.09887,
        -0.12316,
        -0.14547,
        -0.16382,
        -0.18022,
        -0.18598,
        -0.19174,
        -0.19114,
        -0.19041,
        -0.18586,
        -0.18038,
        -0.17264,
        -0.16355,
        -0.15081,
        -0.13355,
        -0.11284,
        -0.08283,
        -0.05297,
        -0.02461,
        0.00376,
        0.01522,
        0.02516,
        0.02306,
        0.01675,
        0.00659,
        -0.00653,
        -0.01830,
        -0.02793,
        -0.03529,
        -0.03417,
        -0.03302,
        -0.03098,
        -0.02893,
        -0.03265,
        -0.03733,
        -0.03705,
        -0.03443,
        -0.02518,
        -0.00937,
        0.00640,
        0.02210,
        0.03695,
        0.04690,
        0.05685,
        0.06079,
        0.06456,
        0.05905,
        0.05115,
        0.03806,
        0.02176,
        0.00591,
        -0.00940,
        -0.02315,
        -0.03255,
        -0.04131,
        -0.04332,
        -0.04533,
        -0.04776,
        -0.05023,
        -0.05914,
        -0.07037,
        -0.07861,
        -0.08447,
        -0.08043,
        -0.06026,
        -0.03582,
        0.00537,
        0.04641,
        0.08214,
        0.11786,
        0.12866,
        0.13505,
        0.12745,
        0.11305,
        0.10836,
        0.11355,
        0.12655,
        0.15625,
        0.18260,
        0.18875,
        0.19490,
        0.16581,
        0.13546,
        0.10259,
        0.06904,
        0.03370,
        -0.00280,
        -0.04191,
        -0.08442,
        -0.11602,
        -0.11620,
        -0.11191,
        -0.05670,
        -0.00149,
        0.04191,
        0.08405,
        0.08916,
        0.08038,
        0.06728,
        0.05064,
        0.04417,
        0.05477,
        0.06746,
        0.08877,
        0.10979,
        0.11711,
        0.12442,
        0.11088,
        0.09344,
        0.05960,
        0.01753,
        -0.02476,
        -0.06729,
        -0.09773,
        -0.10153,
        -0.10056,
        -0.06903,
        -0.03750,
        -0.03231,
        -0.02826,
        -0.07340,
        -0.13229,
        -0.19741,
        -0.26659,
        -0.30990,
        -0.31860,
        -0.30837,
        -0.24162,
        -0.17168,
        -0.06202,
        0.04764,
        0.13666,
        0.22331,
        0.25174,
        0.25756,
        0.23457,
        0.18736,
        0.14896,
        0.12577,
        0.10878,
        0.11829,
        0.12761,
        0.12272,
        0.11783,
        0.08909,
        0.05568,
        0.01304,
        -0.03437,
        -0.07885,
        -0.12018,
        -0.14795,
        -0.14488,
        -0.13443,
        -0.07384,
        -0.01325,
        0.04773,
        0.10873,
        0.12449,
        0.12708,
        0.10423,
        0.06426,
        0.02960,
        0.00222,
        -0.01508,
        -0.00116,
        0.01482,
        0.05956,
        0.10430,
        0.14391,
        0.18289,
        0.19326,
        0.19215,
        0.17468,
        0.14309,
        0.11609,
        0.09726,
        0.08373,
        0.09387,
        0.10406,
        0.12038,
        0.13670,
        0.13664,
        0.13321,
        0.10901,
        0.07374,
        0.03096,
        -0.02009,
        -0.06275,
        -0.08569,
        -0.10332,
        -0.08256,
        -0.06181,
        -0.03295,
        -0.00362,
        0.01073,
        0.02056,
        0.01863,
        0.00856,
        -0.00656,
        -0.02881,
        -0.04800,
        -0.05731,
        -0.06476,
        -0.04326,
        -0.02177,
        0.00082,
        0.02354,
        0.02708,
        0.02266,
        0.01111,
        -0.00676,
        -0.02525,
        -0.04487,
        -0.06462,
        -0.08500,
        -0.10538,
        -0.11138,
        -0.11737,
        -0.11038,
        -0.10059,
        -0.09401,
        -0.08920,
        -0.09031,
        -0.09816,
        -0.10849,
        -0.12488,
        -0.14148,
        -0.15981,
        -0.17813,
        -0.18350,
        -0.18800,
        -0.17833,
        -0.16420,
        -0.14694,
        -0.12745,
        -0.10914,
        -0.09254,
        -0.07724,
        -0.06632,
        -0.05540,
        -0.04451,
        -0.03363,
        -0.01106,
        0.01317,
        0.03497,
        0.05574,
        0.05848,
        0.04479,
        0.02599,
        -0.00246,
        -0.02784,
        -0.03815,
        -0.04845,
        -0.05679,
        -0.06512,
        -0.07863,
        -0.09331,
        -0.09273,
        -0.08351,
        -0.06389,
        -0.03215,
        -0.00359,
        0.01698,
        0.03614,
        0.04366,
        0.05118,
        0.05926,
        0.06737,
        0.06889,
        0.06825,
        0.05962,
        0.04515,
        0.03085,
        0.01680,
        0.00321,
        -0.00884,
        -0.02151,
        -0.04699,
        -0.07248,
        -0.10697,
        -0.14281,
        -0.16692,
        -0.18584,
        -0.18766,
        -0.17345,
        -0.15173,
        -0.11539,
        -0.07886,
        -0.04130,
        -0.00374,
        0.01742,
        0.03834,
        0.04443,
        0.04702,
        0.05337,
        0.06191,
        0.08086,
        0.11226,
        0.14392,
        0.17624,
        0.20598,
        0.21275,
        0.21953,
        0.20499,
        0.18870,
        0.16421,
        0.13696,
        0.10956,
        0.08207,
        0.06079,
        0.04908,
        0.04122,
        0.04725,
        0.05331,
        0.05990,
        0.06648,
        0.06711,
        0.06680,
        0.06618,
        0.06541,
        0.06420,
        0.06256,
        0.05847,
        0.04946,
        0.03922,
        0.02232,
        0.00543,
        -0.01271,
        -0.03088,
        -0.04066,
        -0.04836,
        -0.04490,
        -0.03474,
        -0.01992,
        0.00062,
        0.02042,
        0.03821,
        0.05524,
        0.06488,
        0.07452,
        0.07682,
        0.07846,
        0.07691,
        0.07424,
        0.07176,
        0.06943,
        0.06489,
        0.05685,
        0.04613,
        0.02533,
        0.00454,
        -0.01570,
        -0.03594,
        -0.04307,
        -0.04801,
        -0.05037,
        -0.05153,
        -0.05826,
        -0.07052,
        -0.08430,
        -0.10120,
        -0.11738,
        -0.12944,
        -0.14149,
        -0.14392,
        -0.14607,
        -0.13241,
        -0.11467,
        -0.08685,
        -0.05280,
        -0.02240,
        0.00338,
        0.02376,
        0.02911,
        0.03370,
        0.03056,
        0.02742,
        0.02812,
        0.02919,
        0.03436,
        0.04101,
        0.04658,
        0.05129,
        0.05149,
        0.04432,
        0.03528,
        0.01892,
        0.00277,
        -0.00551,
        -0.01379,
        -0.00568,
        0.00534,
        0.02449,
        0.04761,
        0.06685,
        0.08218,
        0.08942,
        0.07943,
        0.06665,
        0.03697,
        0.00729,
        -0.01511,
        -0.03726,
        -0.04098,
        -0.03975,
        -0.03062,
        -0.01647,
        -0.00382,
        0.00688,
        0.01432,
        0.01236,
        0.00921,
        -0.00745,
        -0.02412,
        -0.04365,
        -0.06350,
        -0.07252,
        -0.07748,
        -0.07295,
        -0.06067,
        -0.04710,
        -0.03136,
        -0.01722,
        -0.00957,
        -0.00209,
        -0.00296,
        -0.00384,
        -0.00391,
        -0.00384,
        0.00228,
        0.01143,
        0.02145,
        0.03238,
        0.03995,
        0.04010,
        0.03893,
        0.02933,
        0.01972,
        0.00933,
        -0.00110,
        -0.00486,
        -0.00676,
        0.00219,
        0.01825,
        0.03830,
        0.06371,
        0.08439,
        0.09090,
        0.09544,
        0.07517,
        0.05489,
        0.03232,
        0.00949,
        -0.00177,
        -0.00854,
        -0.00782,
        -0.00082,
        0.00699,
        0.01620,
        0.02280,
        0.01826,
        0.01346,
        -0.01062,
        -0.03470,
        -0.06160,
        -0.08906,
        -0.10667,
        -0.11919,
        -0.12306,
        -0.11763,
        -0.10892,
        -0.09275,
        -0.07676,
        -0.06199,
        -0.04723,
        -0.04116,
        -0.03554,
        -0.03289,
        -0.03111,
        -0.02938,
        -0.02768,
        -0.02871,
        -0.03349,
        -0.03992,
        -0.05142,
        -0.06284,
        -0.07316,
        -0.08347,
        -0.08734,
        -0.09043,
        -0.08375,
        -0.07314,
        -0.05538,
        -0.03142,
        -0.00846,
        0.01273,
        0.03163,
        0.04028,
        0.04891,
        0.05481,
        0.06071,
        0.06840,
        0.07647,
        0.08051,
        0.08241,
        0.08084,
        0.07544,
        0.06932,
        0.06149,
        0.05327,
        0.04220,
        0.03112,
        0.01934,
        0.00751,
        0.00130,
        -0.00323,
        -0.00419,
        -0.00268,
        -0.00199,
        -0.00248,
        -0.00365,
        -0.00702,
        -0.01034,
        -0.01275,
        -0.01517,
        -0.01446,
        -0.01335,
        -0.00857,
        -0.00226,
        0.00486,
        0.01272,
        0.01869,
        0.02120,
        0.02324,
        0.02312,
        0.02301,
        0.02669,
        0.03037,
        0.03471,
        0.03919,
        0.04182,
        0.04344,
        0.04507,
        0.04672,
        0.04818,
        0.04920,
        0.04977,
        0.04690,
        0.04404,
        0.04111,
        0.03817,
        0.03778,
        0.03820,
        0.03884,
        0.03964,
        0.03990,
        0.03935,
        0.03902,
        0.03943,
        0.03989,
        0.04112,
        0.04236,
        0.04013,
        0.03742,
        0.03049,
        0.02175,
        0.01313,
        0.00462,
        -0.00189,
        -0.00462,
        -0.00703,
        -0.00794,
        -0.00885,
        -0.01051,
        -0.01217,
        -0.01052,
        -0.00811,
        -0.00207,
        0.00602,
        0.01504,
        0.02514,
        0.03470,
        0.04289,
        0.05020,
        0.05022,
        0.05024,
        0.03943,
        0.02781,
        0.01278,
        -0.00337,
        -0.01711,
        -0.02908,
        -0.03894,
        -0.04563,
        -0.05179,
        -0.05615,
        -0.06056,
        -0.06599,
        -0.07142,
        -0.07839,
        -0.08558,
        -0.09063,
        -0.09472,
        -0.09483,
        -0.09120,
        -0.08566,
        -0.07639,
        -0.06745,
        -0.06026,
        -0.05306,
        -0.05392,
        -0.05488,
        -0.05875,
        -0.06330,
        -0.06427,
        -0.06316,
        -0.05980,
        -0.05374,
        -0.04786,
        -0.04241,
        -0.03702,
        -0.03203,
        -0.02705,
        -0.02298,
        -0.01899,
        -0.01750,
        -0.01686,
        -0.01674,
        -0.01699,
        -0.01701,
        -0.01664,
        -0.01662,
        -0.01780,
        -0.01897,
        -0.01983,
        -0.02069,
        -0.01922,
        -0.01739,
        -0.01492,
        -0.01216,
        -0.00890,
        -0.00516,
        -0.00076,
        0.00494,
        0.01046,
        0.01499,
        0.01951,
        0.01981,
        0.02001,
        0.01556,
        0.00997,
        0.00113,
        -0.00965,
        -0.01962,
        -0.02861,
        -0.03515,
        -0.03516,
        -0.03448,
        -0.02720,
        -0.01991,
        -0.01076,
        -0.00144,
        0.00795,
        0.01736,
        0.02619,
        0.03457,
        0.04165,
        0.04667,
        0.05059,
        0.05038,
        0.05003,
        0.04579,
        0.04156,
        0.03646,
        0.03121,
        0.02535,
        0.01919,
        0.01284,
        0.00629,
        0.00116,
        -0.00106,
        -0.00252,
        0.00034,
        0.00319,
        0.00610,
        0.00900,
        0.01096,
        0.01267,
        0.01435,
        0.01602,
        0.01701,
        0.01716,
        0.01711,
        0.01651,
        0.01601,
        0.01649,
        0.01698,
        0.01726,
        0.01753,
        0.01877,
        0.02036,
        0.02420,
        0.02981,
        0.03539,
        0.04091,
        0.04534,
        0.04547,
        0.04546,
        0.04027,
        0.03507,
        0.02762,
        0.01977,
        0.01352,
        0.00806,
        0.00608,
        0.00766,
        0.01064,
        0.01662,
        0.02229,
        0.02605,
        0.02982,
        0.02799,
        0.02595,
        0.01948,
        0.01182,
        0.00319,
        -0.00605,
        -0.01369,
        -0.01924,
        -0.02382,
        -0.02559,
        -0.02737,
        -0.02927,
        -0.03117,
        -0.03474,
        -0.03850,
        -0.04191,
        -0.04520,
        -0.04596,
        -0.04464,
        -0.04147,
        -0.03516,
        -0.02891,
        -0.02290,
        -0.01697,
        -0.01473,
        -0.01249,
        -0.01147,
        -0.01067,
        -0.00886,
        -0.00654,
        -0.00353,
        0.00020,
        0.00368,
        0.00662,
        0.00917,
        0.00917,
        0.00917,
        0.00679,
        0.00430,
        0.00202,
        -0.00021,
        -0.00082,
        -0.00037,
        0.00151,
        0.00529,
        0.00911,
        0.01303,
        0.01660,
        0.01558,
        0.01457,
        0.00939,
        0.00372,
        -0.00124,
        -0.00593,
        -0.00835,
        -0.00888,
        -0.00844,
        -0.00635,
        -0.00434,
        -0.00269,
        -0.00108,
        -0.00176,
        -0.00244,
        -0.00397,
        -0.00568,
        -0.00643,
        -0.00669,
        -0.00610,
        -0.00462,
        -0.00282,
        -0.00032,
        0.00222,
        0.00493,
        0.00765,
        0.00875,
        0.00977,
        0.00897,
        0.00764,
        0.00648,
        0.00544,
        0.00556,
        0.00728,
        0.00944,
        0.01294,
        0.01639,
        0.01909,
        0.02178,
        0.02238,
        0.02271,
        0.02123,
        0.01902,
        0.01582,
        0.01177,
        0.00780,
        0.00398,
        0.00061,
        -0.00067,
        -0.00194,
        0.00012,
        0.00218,
        0.00631,
        0.01087,
        0.01563,
        0.02050,
        0.02418,
        0.02655,
        0.02805,
        0.02751,
        0.02673,
        0.02415,
        0.02158,
        0.01575,
        0.00972,
        0.00075,
        -0.00910,
        -0.01921,
        -0.02950,
        -0.03903,
        -0.04748,
        -0.05526,
        -0.06091,
        -0.06624,
        -0.06662,
        -0.06700,
        -0.06315,
        -0.05874,
        -0.05348,
        -0.04787,
        -0.04189,
        -0.03560,
        -0.02922,
        -0.02270,
        -0.01667,
        -0.01297,
        -0.00927,
        -0.00694,
        -0.00461,
        -0.00043,
        0.00415,
        0.00842,
        0.01252,
        0.01500,
        0.01563,
        0.01591,
        0.01533,
        0.01471,
        0.01382,
        0.01294,
        0.01084,
        0.00866,
        0.00666,
        0.00473,
        0.00315,
        0.00184,
        -0.00010,
        -0.00296,
        -0.00598,
        -0.00955,
        -0.01299,
        -0.01416,
        -0.01533,
        -0.01398,
        -0.01227,
        -0.00969,
        -0.00672,
        -0.00415,
        -0.00194,
        -0.00092,
        -0.00213,
        -0.00398,
        -0.00902,
        -0.01405,
        -0.01891,
        -0.02377,
        -0.02543,
        -0.02635,
        -0.02531,
        -0.02316,
        -0.02075,
        -0.01804,
        -0.01533,
        -0.01261,
        -0.00991,
        -0.00744,
        -0.00497,
        -0.00338,
        -0.00186,
        -0.00082,
        0.00007,
        0.00120,
        0.00251,
        0.00443,
        0.00724,
        0.01042,
        0.01485,
        0.01930,
        0.02396,
        0.02861,
        0.03317,
        0.03772,
        0.04248,
        0.04733,
        0.05081,
        0.05300,
        0.05342,
        0.05039,
        0.04707,
        0.04229,
        0.03751,
        0.03438,
        0.03127,
        0.02933,
        0.02766,
        0.02751,
        0.02823,
        0.02944,
        0.03125,
        0.03180,
        0.02912,
        0.02608,
        0.01999,
        0.01389,
        0.01085,
        0.00806,
        0.00726,
        0.00712,
        0.00602,
        0.00420,
        0.00240,
        0.00063,
        -0.00073,
        -0.00058,
        -0.00047,
        -0.00144,
        -0.00241,
        -0.00545,
        -0.00883,
        -0.01159,
        -0.01407,
        -0.01470,
        -0.01354,
        -0.01144,
        -0.00744,
        -0.00342,
        0.00073,
        0.00487,
        0.00685,
        0.00878,
        0.00888,
        0.00853,
        0.00793,
        0.00717,
        0.00681,
        0.00694,
        0.00719,
        0.00780,
        0.00836,
        0.00861,
        0.00886,
        0.00880,
        0.00872,
        0.00851,
        0.00825,
        0.00755,
        0.00650,
        0.00503,
        0.00287,
        0.00083,
        -0.00078,
        -0.00229,
        -0.00072,
        0.00084,
        0.00433,
        0.00815,
        0.00982,
        0.01047,
        0.00854,
        0.00403,
        -0.00064,
        -0.00565,
        -0.01023,
        -0.01229,
        -0.01435,
        -0.01460,
        -0.01480,
        -0.01449,
        -0.01404,
        -0.01365,
        -0.01329,
        -0.01327,
        -0.01367,
        -0.01406,
        -0.01439,
        -0.01463,
        -0.01388,
        -0.01313,
        -0.01185,
        -0.01052,
        -0.00995,
        -0.00966,
        -0.01063,
        -0.01261,
        -0.01482,
        -0.01741,
        -0.01938,
        -0.01895,
        -0.01844,
        -0.01486,
        -0.01128,
        -0.00753,
        -0.00376,
        -0.00074,
        0.00191,
        0.00352,
        0.00407,
        0.00368,
        0.00130,
        -0.00109,
        -0.00349,
        -0.00589,
        -0.00502,
        -0.00404,
        -0.00156,
        0.00133,
        0.00324,
        0.00454,
        0.00478,
        0.00364,
        0.00253,
        0.00150,
        0.00070,
        0.00244,
        0.00417,
        0.00645,
        0.00879,
        0.00889,
        0.00814,
        0.00647,
        0.00405,
        0.00198,
        0.00050,
        -0.00103,
        -0.00275,
        -0.00449,
        -0.00716,
        -0.00983,
        -0.01228,
        -0.01469,
        -0.01690,
        -0.01903,
        -0.02089,
        -0.02250,
        -0.02354,
        -0.02334,
        -0.02289,
        -0.02080,
        -0.01872,
        -0.01567,
        -0.01258,
        -0.00976,
        -0.00702,
        -0.00532,
        -0.00432,
        -0.00381,
        -0.00393,
        -0.00395,
        -0.00362,
        -0.00321,
        -0.00168,
        -0.00015,
        0.00332,
        0.00702,
        0.01148,
        0.01625,
        0.01948,
        0.02141,
        0.02201,
        0.02028,
        0.01831,
        0.01532,
        0.01231,
        0.00872,
        0.00512,
        0.00181,
        -0.00144,
        -0.00316,
        -0.00407,
        -0.00431,
        -0.00381,
        -0.00341,
        -0.00322,
        -0.00300,
        -0.00262,
        -0.00224,
        -0.00176,
        -0.00127,
        -0.00115,
        -0.00114,
        -0.00118,
        -0.00126,
        -0.00169,
        -0.00261,
        -0.00391,
        -0.00639,
        -0.00883,
        -0.01058,
        -0.01233,
        -0.01189,
        -0.01119,
        -0.00977,
        -0.00807,
        -0.00648,
        -0.00500,
        -0.00363,
        -0.00244,
        -0.00131,
        -0.00041,
        0.00050,
        0.00205,
        0.00360,
        0.00630,
        0.00922,
        0.01208,
        0.01489,
        0.01681,
        0.01775,
        0.01841,
        0.01842,
        0.01855,
        0.01948,
        0.02040,
        0.02114,
        0.02187,
        0.02085,
        0.01930,
        0.01690,
        0.01390,
        0.01117,
        0.00880,
        0.00676,
        0.00581,
        0.00495,
        0.00549,
        0.00603,
        0.00704,
        0.00811,
        0.00816,
        0.00779,
        0.00619,
        0.00350,
        0.00019,
        -0.00426,
        -0.00865,
        -0.01273,
        -0.01681,
        -0.01717,
        -0.01753,
        -0.01511,
        -0.01210,
        -0.00970,
        -0.00763,
        -0.00663,
        -0.00684,
        -0.00710,
        -0.00749,
        -0.00781,
        -0.00764,
        -0.00747,
        -0.00633,
        -0.00512,
        -0.00298,
        -0.00055,
        0.00126,
        0.00262,
        0.00327,
        0.00286,
        0.00261,
        0.00287,
        0.00315,
        0.00398,
        0.00480,
        0.00464,
        0.00435,
        0.00406,
        0.00377,
        0.00393,
        0.00450,
        0.00492,
        0.00505,
        0.00506,
        0.00448,
        0.00389,
        0.00301,
        0.00212,
        0.00069,
        -0.00086,
        -0.00241,
        -0.00397,
        -0.00500,
        -0.00540,
        -0.00561,
        -0.00534,
        -0.00515,
        -0.00562,
        -0.00609,
        -0.00771,
        -0.00941,
        -0.01114,
        -0.01288,
        -0.01369,
        -0.01382,
        -0.01345,
        -0.01234,
        -0.01131,
        -0.01055,
        -0.00980,
        -0.00909,
        -0.00838,
        -0.00710,
        -0.00573,
        -0.00485,
        -0.00417,
        -0.00406,
        -0.00446,
        -0.00449,
        -0.00383,
        -0.00293,
        -0.00082,
        0.00128,
        0.00246,
        0.00364,
        0.00340,
        0.00283,
        0.00164,
        0.00009,
        -0.00195,
        -0.00459,
        -0.00732,
        -0.01031,
        -0.01311,
        -0.01424,
        -0.01536,
        -0.01433,
        -0.01312,
        -0.01105,
        -0.00868,
        -0.00606,
        -0.00323,
        -0.00061,
        0.00167,
        0.00362,
        0.00438,
        0.00512,
        0.00531,
        0.00549,
        0.00578,
        0.00608,
        0.00586,
        0.00540,
        0.00456,
        0.00337,
        0.00223,
        0.00121,
        0.00028,
        -0.00016,
        -0.00061,
        0.00002,
        0.00068,
        0.00217,
        0.00386,
        0.00510,
        0.00608,
        0.00625,
        0.00543,
        0.00434,
        0.00252,
        0.00073,
        -0.00073,
        -0.00219,
        -0.00213,
        -0.00193,
        -0.00097,
        0.00025,
        0.00059,
        0.00024,
        -0.00071,
        -0.00262,
        -0.00428,
        -0.00499,
        -0.00564,
        -0.00453,
        -0.00341,
        -0.00195,
        -0.00044,
        0.00085,
        0.00203,
        0.00300,
        0.00378,
        0.00455,
        0.00532,
        0.00614,
        0.00724,
        0.00833,
        0.00915,
        0.00996,
        0.01018,
        0.01025,
        0.00994,
        0.00941,
        0.00837,
        0.00668,
        0.00479,
        0.00231,
        -0.00008,
        -0.00156,
        -0.00305,
        -0.00362,
        -0.00409,
        -0.00468,
        -0.00530,
        -0.00562,
        -0.00571,
        -0.00535,
        -0.00429,
        -0.00321,
        -0.00207,
        -0.00095,
        -0.00014,
        0.00067,
        0.00164,
        0.00263,
        0.00365,
        0.00468,
        0.00566,
        0.00659,
        0.00745,
        0.00814,
        0.00868,
        0.00825,
        0.00782,
        0.00644,
        0.00503,
        0.00403,
        0.00314,
        0.00272,
        0.00259,
        0.00227,
        0.00173,
        0.00106,
        0.00003,
        -0.00098,
        -0.00190,
        -0.00282,
        -0.00382,
        -0.00482,
        -0.00597,
        -0.00718,
        -0.00810,
        -0.00878,
        -0.00915,
        -0.00900,
        -0.00875,
        -0.00816,
        -0.00756,
        -0.00670,
        -0.00585,
        -0.00458,
        -0.00324,
        -0.00140,
        0.00068,
        0.00293,
        0.00533,
        0.00743,
        0.00885,
        0.01007,
        0.01000,
        0.00993,
        0.00917,
        0.00838,
        0.00727,
        0.00607,
        0.00479,
        0.00347,
        0.00251,
        0.00201,
        0.00160,
        0.00142,
        0.00117,
        0.00002,
        -0.00113,
        -0.00235,
        -0.00359,
        -0.00409,
        -0.00431,
        -0.00455,
        -0.00481,
        -0.00517,
        -0.00572,
        -0.00609,
        -0.00571,
        -0.00532,
        -0.00412,
        -0.00291,
        -0.00181,
        -0.00074,
        -0.00002,
        0.00052,
        0.00068,
        0.00043,
        0.00009,
        -0.00048,
        -0.00094,
        -0.00074,
        -0.00054,
        0.00035,
        0.00127,
        0.00228,
        0.00331,
        0.00437,
        0.00544,
        0.00637,
        0.00711,
        0.00763,
        0.00746,
        0.00725,
        0.00653,
        0.00580,
        0.00496,
        0.00410,
        0.00323,
        0.00235,
        0.00168,
        0.00117,
        0.00073,
        0.00039,
        -0.00006,
        -0.00096,
        -0.00187,
        -0.00320,
        -0.00452,
        -0.00562,
        -0.00667,
        -0.00749,
        -0.00819,
        -0.00869,
        -0.00897,
        -0.00893,
        -0.00816,
        -0.00727,
        -0.00551,
        -0.00374,
        -0.00196,
        -0.00018,
        0.00098,
        0.00195,
        0.00237,
        0.00240,
        0.00216,
        0.00152,
        0.00091,
        0.00035,
        -0.00015,
        0.00019,
        0.00053,
        0.00134,
        0.00221,
        0.00276,
        0.00316,
        0.00330,
        0.00320,
        0.00303,
        0.00273,
        0.00239,
        0.00190,
        0.00140,
        0.00117,
        0.00093,
        0.00118,
        0.00153,
        0.00192,
        0.00233,
        0.00262,
        0.00278,
        0.00288,
        0.00286,
        0.00279,
        0.00234,
        0.00189,
        0.00117,
        0.00044,
        -0.00019,
        -0.00080,
        -0.00134,
        -0.00184,
        -0.00227,
        -0.00260,
        -0.00279,
        -0.00255,
        -0.00229,
        -0.00165,
        -0.00102,
        -0.00040,
        0.00022,
        0.00077,
        0.00129,
        0.00159,
        0.00168,
        0.00157,
        0.00108,
        0.00060,
        0.00012,
        -0.00036,
        -0.00039,
        -0.00041,
        -0.00015,
        0.00019,
        0.00058,
        0.00100,
        0.00136,
        0.00165,
        0.00195,
        0.00230,
        0.00269,
        0.00335,
        0.00401,
        0.00457,
        0.00512,
        0.00536,
        0.00550,
        0.00546,
        0.00529,
        0.00491,
        0.00420,
        0.00339,
        0.00223,
        0.00109,
        0.00045,
        -0.00019,
        -0.00013,
        0.00003,
        0.00012,
        0.00017,
        -0.00009,
        -0.00065,
        -0.00120,
        -0.00176,
        -0.00221,
        -0.00209,
        -0.00197,
        -0.00114,
        -0.00030,
        0.00061,
        0.00155,
        0.00220,
        0.00268,
        0.00294,
        0.00290,
        0.00272,
        0.00215,
        0.00155,
        0.00068,
        -0.00019,
        -0.00080,
        -0.00137,
        -0.00167,
        -0.00188,
        -0.00220,
        -0.00259,
        -0.00310,
        -0.00380,
        -0.00448,
        -0.00506,
        -0.00562,
        -0.00574,
        -0.00585,
        -0.00554,
        -0.00515,
        -0.00468,
        -0.00418,
        -0.00378,
        -0.00349,
        -0.00323,
        -0.00306,
        -0.00286,
        -0.00256,
        -0.00226,
        -0.00178,
        -0.00130,
        -0.00078,
        -0.00026,
        0.00005,
        0.00022,
        0.00011,
        -0.00033,
        -0.00081,
        -0.00142,
        -0.00198,
        -0.00215,
        -0.00233,
        -0.00212,
        -0.00187,
        -0.00151,
        -0.00110,
        -0.00065,
        -0.00018,
        0.00027,
        0.00070,
        0.00105,
        0.00115,
        0.00124,
        0.00086,
        0.00047,
        -0.00018,
        -0.00088,
        -0.00150,
        -0.00208,
        -0.00252,
        -0.00283,
        -0.00311,
        -0.00332,
        -0.00354,
        -0.00378,
        -0.00402,
        -0.00419,
        -0.00436,
        -0.00432,
        -0.00423,
        -0.00391,
        -0.00347,
        -0.00292,
        -0.00225,
        -0.00159,
        -0.00098,
        -0.00039,
        -0.00008,
        0.00023,
        0.00039,
        0.00053,
        0.00071,
        0.00090,
        0.00099,
        0.00100,
        0.00090,
        0.00063,
        0.00041,
        0.00040,
        0.00040,
        0.00086,
        0.00132,
        0.00085,
        0.00021
};


#endif /* METRONOMECLICK_H */
