// Copyright (c) 2013-2020, SIB - Swiss Institute of Bioinformatics and
//                          Biozentrum - University of Basel
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// 
//   http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.


#include <promod3/loop/amino_acid_atoms.hh>
#include <promod3/core/runtime_profiling.hh>
#include <promod3/core/message.hh>

namespace promod3 { namespace loop {

AminoAcidLookup::AminoAcidLookup() {
  core::ScopedTimerPtr prof = core::StaticRuntimeProfiler::StartScoped(
                                "AminoAcidLookup::AminoAcidLookup", 2);
  using namespace ost::conop;
  // AA-LUT
  olc_[ALA] = 'A';
  first_aaa_[ALA] = ALA_N;
  num_atoms_[ALA] = ALA_NUM_ATOMS;
  olc_[ARG] = 'R';
  first_aaa_[ARG] = ARG_N;
  num_atoms_[ARG] = ARG_NUM_ATOMS;
  olc_[ASN] = 'N';
  first_aaa_[ASN] = ASN_N;
  num_atoms_[ASN] = ASN_NUM_ATOMS;
  olc_[ASP] = 'D';
  first_aaa_[ASP] = ASP_N;
  num_atoms_[ASP] = ASP_NUM_ATOMS;
  olc_[GLN] = 'Q';
  first_aaa_[GLN] = GLN_N;
  num_atoms_[GLN] = GLN_NUM_ATOMS;
  olc_[GLU] = 'E';
  first_aaa_[GLU] = GLU_N;
  num_atoms_[GLU] = GLU_NUM_ATOMS;
  olc_[LYS] = 'K';
  first_aaa_[LYS] = LYS_N;
  num_atoms_[LYS] = LYS_NUM_ATOMS;
  olc_[SER] = 'S';
  first_aaa_[SER] = SER_N;
  num_atoms_[SER] = SER_NUM_ATOMS;
  olc_[CYS] = 'C';
  first_aaa_[CYS] = CYS_N;
  num_atoms_[CYS] = CYS_NUM_ATOMS;
  olc_[MET] = 'M';
  first_aaa_[MET] = MET_N;
  num_atoms_[MET] = MET_NUM_ATOMS;
  olc_[TRP] = 'W';
  first_aaa_[TRP] = TRP_N;
  num_atoms_[TRP] = TRP_NUM_ATOMS;
  olc_[TYR] = 'Y';
  first_aaa_[TYR] = TYR_N;
  num_atoms_[TYR] = TYR_NUM_ATOMS;
  olc_[THR] = 'T';
  first_aaa_[THR] = THR_N;
  num_atoms_[THR] = THR_NUM_ATOMS;
  olc_[VAL] = 'V';
  first_aaa_[VAL] = VAL_N;
  num_atoms_[VAL] = VAL_NUM_ATOMS;
  olc_[ILE] = 'I';
  first_aaa_[ILE] = ILE_N;
  num_atoms_[ILE] = ILE_NUM_ATOMS;
  olc_[LEU] = 'L';
  first_aaa_[LEU] = LEU_N;
  num_atoms_[LEU] = LEU_NUM_ATOMS;
  olc_[GLY] = 'G';
  first_aaa_[GLY] = GLY_N;
  num_atoms_[GLY] = GLY_NUM_ATOMS;
  olc_[PRO] = 'P';
  first_aaa_[PRO] = PRO_N;
  num_atoms_[PRO] = PRO_NUM_ATOMS;
  olc_[HIS] = 'H';
  first_aaa_[HIS] = HIS_N;
  num_atoms_[HIS] = HIS_NUM_ATOMS;
  olc_[PHE] = 'F';
  first_aaa_[PHE] = PHE_N;
  num_atoms_[PHE] = PHE_NUM_ATOMS;
  olc_[XXX] = 'X';
  first_aaa_[XXX] = XXX_NUM_ATOMS;
  num_atoms_[XXX] = 0;

  // AAA-LUT
  atom_name_[ALA_N] = "N";
  atom_name_[ALA_CA] = "CA";
  atom_name_[ALA_C] = "C";
  atom_name_[ALA_O] = "O";
  atom_name_[ALA_CB] = "CB";
  atom_name_[ARG_N] = "N";
  atom_name_[ARG_CA] = "CA";
  atom_name_[ARG_C] = "C";
  atom_name_[ARG_O] = "O";
  atom_name_[ARG_CB] = "CB";
  atom_name_[ARG_CG] = "CG";
  atom_name_[ARG_CD] = "CD";
  atom_name_[ARG_NE] = "NE";
  atom_name_[ARG_CZ] = "CZ";
  atom_name_[ARG_NH1] = "NH1";
  atom_name_[ARG_NH2] = "NH2";
  atom_name_[ASN_N] = "N";
  atom_name_[ASN_CA] = "CA";
  atom_name_[ASN_C] = "C";
  atom_name_[ASN_O] = "O";
  atom_name_[ASN_CB] = "CB";
  atom_name_[ASN_CG] = "CG";
  atom_name_[ASN_OD1] = "OD1";
  atom_name_[ASN_ND2] = "ND2";
  atom_name_[ASP_N] = "N";
  atom_name_[ASP_CA] = "CA";
  atom_name_[ASP_C] = "C";
  atom_name_[ASP_O] = "O";
  atom_name_[ASP_CB] = "CB";
  atom_name_[ASP_CG] = "CG";
  atom_name_[ASP_OD1] = "OD1";
  atom_name_[ASP_OD2] = "OD2";
  atom_name_[GLN_N] = "N";
  atom_name_[GLN_CA] = "CA";
  atom_name_[GLN_C] = "C";
  atom_name_[GLN_O] = "O";
  atom_name_[GLN_CB] = "CB";
  atom_name_[GLN_CG] = "CG";
  atom_name_[GLN_CD] = "CD";
  atom_name_[GLN_OE1] = "OE1";
  atom_name_[GLN_NE2] = "NE2";
  atom_name_[GLU_N] = "N";
  atom_name_[GLU_CA] = "CA";
  atom_name_[GLU_C] = "C";
  atom_name_[GLU_O] = "O";
  atom_name_[GLU_CB] = "CB";
  atom_name_[GLU_CG] = "CG";
  atom_name_[GLU_CD] = "CD";
  atom_name_[GLU_OE1] = "OE1";
  atom_name_[GLU_OE2] = "OE2";
  atom_name_[LYS_N] = "N";
  atom_name_[LYS_CA] = "CA";
  atom_name_[LYS_C] = "C";
  atom_name_[LYS_O] = "O";
  atom_name_[LYS_CB] = "CB";
  atom_name_[LYS_CG] = "CG";
  atom_name_[LYS_CD] = "CD";
  atom_name_[LYS_CE] = "CE";
  atom_name_[LYS_NZ] = "NZ";
  atom_name_[SER_N] = "N";
  atom_name_[SER_CA] = "CA";
  atom_name_[SER_C] = "C";
  atom_name_[SER_O] = "O";
  atom_name_[SER_CB] = "CB";
  atom_name_[SER_OG] = "OG";
  atom_name_[CYS_N] = "N";
  atom_name_[CYS_CA] = "CA";
  atom_name_[CYS_C] = "C";
  atom_name_[CYS_O] = "O";
  atom_name_[CYS_CB] = "CB";
  atom_name_[CYS_SG] = "SG";
  atom_name_[MET_N] = "N";
  atom_name_[MET_CA] = "CA";
  atom_name_[MET_C] = "C";
  atom_name_[MET_O] = "O";
  atom_name_[MET_CB] = "CB";
  atom_name_[MET_CG] = "CG";
  atom_name_[MET_SD] = "SD";
  atom_name_[MET_CE] = "CE";
  atom_name_[TRP_N] = "N";
  atom_name_[TRP_CA] = "CA";
  atom_name_[TRP_C] = "C";
  atom_name_[TRP_O] = "O";
  atom_name_[TRP_CB] = "CB";
  atom_name_[TRP_CG] = "CG";
  atom_name_[TRP_CD1] = "CD1";
  atom_name_[TRP_CD2] = "CD2";
  atom_name_[TRP_NE1] = "NE1";
  atom_name_[TRP_CE2] = "CE2";
  atom_name_[TRP_CE3] = "CE3";
  atom_name_[TRP_CZ2] = "CZ2";
  atom_name_[TRP_CZ3] = "CZ3";
  atom_name_[TRP_CH2] = "CH2";
  atom_name_[TYR_N] = "N";
  atom_name_[TYR_CA] = "CA";
  atom_name_[TYR_C] = "C";
  atom_name_[TYR_O] = "O";
  atom_name_[TYR_CB] = "CB";
  atom_name_[TYR_CG] = "CG";
  atom_name_[TYR_CD1] = "CD1";
  atom_name_[TYR_CD2] = "CD2";
  atom_name_[TYR_CE1] = "CE1";
  atom_name_[TYR_CE2] = "CE2";
  atom_name_[TYR_CZ] = "CZ";
  atom_name_[TYR_OH] = "OH";
  atom_name_[THR_N] = "N";
  atom_name_[THR_CA] = "CA";
  atom_name_[THR_C] = "C";
  atom_name_[THR_O] = "O";
  atom_name_[THR_CB] = "CB";
  atom_name_[THR_OG1] = "OG1";
  atom_name_[THR_CG2] = "CG2";
  atom_name_[VAL_N] = "N";
  atom_name_[VAL_CA] = "CA";
  atom_name_[VAL_C] = "C";
  atom_name_[VAL_O] = "O";
  atom_name_[VAL_CB] = "CB";
  atom_name_[VAL_CG1] = "CG1";
  atom_name_[VAL_CG2] = "CG2";
  atom_name_[ILE_N] = "N";
  atom_name_[ILE_CA] = "CA";
  atom_name_[ILE_C] = "C";
  atom_name_[ILE_O] = "O";
  atom_name_[ILE_CB] = "CB";
  atom_name_[ILE_CG1] = "CG1";
  atom_name_[ILE_CG2] = "CG2";
  atom_name_[ILE_CD1] = "CD1";
  atom_name_[LEU_N] = "N";
  atom_name_[LEU_CA] = "CA";
  atom_name_[LEU_C] = "C";
  atom_name_[LEU_O] = "O";
  atom_name_[LEU_CB] = "CB";
  atom_name_[LEU_CG] = "CG";
  atom_name_[LEU_CD1] = "CD1";
  atom_name_[LEU_CD2] = "CD2";
  atom_name_[GLY_N] = "N";
  atom_name_[GLY_CA] = "CA";
  atom_name_[GLY_C] = "C";
  atom_name_[GLY_O] = "O";
  atom_name_[PRO_N] = "N";
  atom_name_[PRO_CA] = "CA";
  atom_name_[PRO_C] = "C";
  atom_name_[PRO_O] = "O";
  atom_name_[PRO_CB] = "CB";
  atom_name_[PRO_CG] = "CG";
  atom_name_[PRO_CD] = "CD";
  atom_name_[HIS_N] = "N";
  atom_name_[HIS_CA] = "CA";
  atom_name_[HIS_C] = "C";
  atom_name_[HIS_O] = "O";
  atom_name_[HIS_CB] = "CB";
  atom_name_[HIS_CG] = "CG";
  atom_name_[HIS_ND1] = "ND1";
  atom_name_[HIS_CD2] = "CD2";
  atom_name_[HIS_CE1] = "CE1";
  atom_name_[HIS_NE2] = "NE2";
  atom_name_[PHE_N] = "N";
  atom_name_[PHE_CA] = "CA";
  atom_name_[PHE_C] = "C";
  atom_name_[PHE_O] = "O";
  atom_name_[PHE_CB] = "CB";
  atom_name_[PHE_CG] = "CG";
  atom_name_[PHE_CD1] = "CD1";
  atom_name_[PHE_CD2] = "CD2";
  atom_name_[PHE_CE1] = "CE1";
  atom_name_[PHE_CE2] = "CE2";
  atom_name_[PHE_CZ] = "CZ";
  atom_name_[XXX_NUM_ATOMS] = "UNK";
  ff_name_ile_cd1_ = "CD";

  // heavy-atom bonding
  bonds_[ALA].push_back(BondInfo(BB_N_INDEX, BB_CA_INDEX, 1));
  bonds_[ALA].push_back(BondInfo(BB_CA_INDEX, BB_C_INDEX, 1));
  bonds_[ALA].push_back(BondInfo(BB_CA_INDEX, ALA_CB_INDEX, 1));
  bonds_[ALA].push_back(BondInfo(BB_C_INDEX, BB_O_INDEX, 2));
  bonds_[ARG].push_back(BondInfo(BB_N_INDEX, BB_CA_INDEX, 1));
  bonds_[ARG].push_back(BondInfo(BB_CA_INDEX, BB_C_INDEX, 1));
  bonds_[ARG].push_back(BondInfo(BB_CA_INDEX, ARG_CB_INDEX, 1));
  bonds_[ARG].push_back(BondInfo(BB_C_INDEX, BB_O_INDEX, 2));
  bonds_[ARG].push_back(BondInfo(ARG_CB_INDEX, ARG_CG_INDEX, 1));
  bonds_[ARG].push_back(BondInfo(ARG_CG_INDEX, ARG_CD_INDEX, 1));
  bonds_[ARG].push_back(BondInfo(ARG_CD_INDEX, ARG_NE_INDEX, 1));
  bonds_[ARG].push_back(BondInfo(ARG_NE_INDEX, ARG_CZ_INDEX, 1));
  bonds_[ARG].push_back(BondInfo(ARG_CZ_INDEX, ARG_NH1_INDEX, 1));
  bonds_[ARG].push_back(BondInfo(ARG_CZ_INDEX, ARG_NH2_INDEX, 2));
  bonds_[ASN].push_back(BondInfo(BB_N_INDEX, BB_CA_INDEX, 1));
  bonds_[ASN].push_back(BondInfo(BB_CA_INDEX, BB_C_INDEX, 1));
  bonds_[ASN].push_back(BondInfo(BB_CA_INDEX, ASN_CB_INDEX, 1));
  bonds_[ASN].push_back(BondInfo(BB_C_INDEX, BB_O_INDEX, 2));
  bonds_[ASN].push_back(BondInfo(ASN_CB_INDEX, ASN_CG_INDEX, 1));
  bonds_[ASN].push_back(BondInfo(ASN_CG_INDEX, ASN_OD1_INDEX, 2));
  bonds_[ASN].push_back(BondInfo(ASN_CG_INDEX, ASN_ND2_INDEX, 1));
  bonds_[ASP].push_back(BondInfo(BB_N_INDEX, BB_CA_INDEX, 1));
  bonds_[ASP].push_back(BondInfo(BB_CA_INDEX, BB_C_INDEX, 1));
  bonds_[ASP].push_back(BondInfo(BB_CA_INDEX, ASP_CB_INDEX, 1));
  bonds_[ASP].push_back(BondInfo(BB_C_INDEX, BB_O_INDEX, 2));
  bonds_[ASP].push_back(BondInfo(ASP_CB_INDEX, ASP_CG_INDEX, 1));
  bonds_[ASP].push_back(BondInfo(ASP_CG_INDEX, ASP_OD1_INDEX, 2));
  bonds_[ASP].push_back(BondInfo(ASP_CG_INDEX, ASP_OD2_INDEX, 1));
  bonds_[GLN].push_back(BondInfo(BB_N_INDEX, BB_CA_INDEX, 1));
  bonds_[GLN].push_back(BondInfo(BB_CA_INDEX, BB_C_INDEX, 1));
  bonds_[GLN].push_back(BondInfo(BB_CA_INDEX, GLN_CB_INDEX, 1));
  bonds_[GLN].push_back(BondInfo(BB_C_INDEX, BB_O_INDEX, 2));
  bonds_[GLN].push_back(BondInfo(GLN_CB_INDEX, GLN_CG_INDEX, 1));
  bonds_[GLN].push_back(BondInfo(GLN_CG_INDEX, GLN_CD_INDEX, 1));
  bonds_[GLN].push_back(BondInfo(GLN_CD_INDEX, GLN_OE1_INDEX, 2));
  bonds_[GLN].push_back(BondInfo(GLN_CD_INDEX, GLN_NE2_INDEX, 1));
  bonds_[GLU].push_back(BondInfo(BB_N_INDEX, BB_CA_INDEX, 1));
  bonds_[GLU].push_back(BondInfo(BB_CA_INDEX, BB_C_INDEX, 1));
  bonds_[GLU].push_back(BondInfo(BB_CA_INDEX, GLU_CB_INDEX, 1));
  bonds_[GLU].push_back(BondInfo(BB_C_INDEX, BB_O_INDEX, 2));
  bonds_[GLU].push_back(BondInfo(GLU_CB_INDEX, GLU_CG_INDEX, 1));
  bonds_[GLU].push_back(BondInfo(GLU_CG_INDEX, GLU_CD_INDEX, 1));
  bonds_[GLU].push_back(BondInfo(GLU_CD_INDEX, GLU_OE1_INDEX, 2));
  bonds_[GLU].push_back(BondInfo(GLU_CD_INDEX, GLU_OE2_INDEX, 1));
  bonds_[LYS].push_back(BondInfo(BB_N_INDEX, BB_CA_INDEX, 1));
  bonds_[LYS].push_back(BondInfo(BB_CA_INDEX, BB_C_INDEX, 1));
  bonds_[LYS].push_back(BondInfo(BB_CA_INDEX, LYS_CB_INDEX, 1));
  bonds_[LYS].push_back(BondInfo(BB_C_INDEX, BB_O_INDEX, 2));
  bonds_[LYS].push_back(BondInfo(LYS_CB_INDEX, LYS_CG_INDEX, 1));
  bonds_[LYS].push_back(BondInfo(LYS_CG_INDEX, LYS_CD_INDEX, 1));
  bonds_[LYS].push_back(BondInfo(LYS_CD_INDEX, LYS_CE_INDEX, 1));
  bonds_[LYS].push_back(BondInfo(LYS_CE_INDEX, LYS_NZ_INDEX, 1));
  bonds_[SER].push_back(BondInfo(BB_N_INDEX, BB_CA_INDEX, 1));
  bonds_[SER].push_back(BondInfo(BB_CA_INDEX, BB_C_INDEX, 1));
  bonds_[SER].push_back(BondInfo(BB_CA_INDEX, SER_CB_INDEX, 1));
  bonds_[SER].push_back(BondInfo(BB_C_INDEX, BB_O_INDEX, 2));
  bonds_[SER].push_back(BondInfo(SER_CB_INDEX, SER_OG_INDEX, 1));
  bonds_[CYS].push_back(BondInfo(BB_N_INDEX, BB_CA_INDEX, 1));
  bonds_[CYS].push_back(BondInfo(BB_CA_INDEX, BB_C_INDEX, 1));
  bonds_[CYS].push_back(BondInfo(BB_CA_INDEX, CYS_CB_INDEX, 1));
  bonds_[CYS].push_back(BondInfo(BB_C_INDEX, BB_O_INDEX, 2));
  bonds_[CYS].push_back(BondInfo(CYS_CB_INDEX, CYS_SG_INDEX, 1));
  bonds_[MET].push_back(BondInfo(BB_N_INDEX, BB_CA_INDEX, 1));
  bonds_[MET].push_back(BondInfo(BB_CA_INDEX, BB_C_INDEX, 1));
  bonds_[MET].push_back(BondInfo(BB_CA_INDEX, MET_CB_INDEX, 1));
  bonds_[MET].push_back(BondInfo(BB_C_INDEX, BB_O_INDEX, 2));
  bonds_[MET].push_back(BondInfo(MET_CB_INDEX, MET_CG_INDEX, 1));
  bonds_[MET].push_back(BondInfo(MET_CG_INDEX, MET_SD_INDEX, 1));
  bonds_[MET].push_back(BondInfo(MET_SD_INDEX, MET_CE_INDEX, 1));
  bonds_[TRP].push_back(BondInfo(BB_N_INDEX, BB_CA_INDEX, 1));
  bonds_[TRP].push_back(BondInfo(BB_CA_INDEX, BB_C_INDEX, 1));
  bonds_[TRP].push_back(BondInfo(BB_CA_INDEX, TRP_CB_INDEX, 1));
  bonds_[TRP].push_back(BondInfo(BB_C_INDEX, BB_O_INDEX, 2));
  bonds_[TRP].push_back(BondInfo(TRP_CB_INDEX, TRP_CG_INDEX, 1));
  bonds_[TRP].push_back(BondInfo(TRP_CG_INDEX, TRP_CD1_INDEX, 2));
  bonds_[TRP].push_back(BondInfo(TRP_CG_INDEX, TRP_CD2_INDEX, 1));
  bonds_[TRP].push_back(BondInfo(TRP_CD1_INDEX, TRP_NE1_INDEX, 1));
  bonds_[TRP].push_back(BondInfo(TRP_CD2_INDEX, TRP_CE2_INDEX, 2));
  bonds_[TRP].push_back(BondInfo(TRP_CD2_INDEX, TRP_CE3_INDEX, 1));
  bonds_[TRP].push_back(BondInfo(TRP_NE1_INDEX, TRP_CE2_INDEX, 1));
  bonds_[TRP].push_back(BondInfo(TRP_CE2_INDEX, TRP_CZ2_INDEX, 1));
  bonds_[TRP].push_back(BondInfo(TRP_CE3_INDEX, TRP_CZ3_INDEX, 2));
  bonds_[TRP].push_back(BondInfo(TRP_CZ2_INDEX, TRP_CH2_INDEX, 2));
  bonds_[TRP].push_back(BondInfo(TRP_CZ3_INDEX, TRP_CH2_INDEX, 1));
  bonds_[TYR].push_back(BondInfo(BB_N_INDEX, BB_CA_INDEX, 1));
  bonds_[TYR].push_back(BondInfo(BB_CA_INDEX, BB_C_INDEX, 1));
  bonds_[TYR].push_back(BondInfo(BB_CA_INDEX, TYR_CB_INDEX, 1));
  bonds_[TYR].push_back(BondInfo(BB_C_INDEX, BB_O_INDEX, 2));
  bonds_[TYR].push_back(BondInfo(TYR_CB_INDEX, TYR_CG_INDEX, 1));
  bonds_[TYR].push_back(BondInfo(TYR_CG_INDEX, TYR_CD1_INDEX, 2));
  bonds_[TYR].push_back(BondInfo(TYR_CG_INDEX, TYR_CD2_INDEX, 1));
  bonds_[TYR].push_back(BondInfo(TYR_CD1_INDEX, TYR_CE1_INDEX, 1));
  bonds_[TYR].push_back(BondInfo(TYR_CD2_INDEX, TYR_CE2_INDEX, 2));
  bonds_[TYR].push_back(BondInfo(TYR_CE1_INDEX, TYR_CZ_INDEX, 2));
  bonds_[TYR].push_back(BondInfo(TYR_CE2_INDEX, TYR_CZ_INDEX, 1));
  bonds_[TYR].push_back(BondInfo(TYR_CZ_INDEX, TYR_OH_INDEX, 1));
  bonds_[THR].push_back(BondInfo(BB_N_INDEX, BB_CA_INDEX, 1));
  bonds_[THR].push_back(BondInfo(BB_CA_INDEX, BB_C_INDEX, 1));
  bonds_[THR].push_back(BondInfo(BB_CA_INDEX, THR_CB_INDEX, 1));
  bonds_[THR].push_back(BondInfo(BB_C_INDEX, BB_O_INDEX, 2));
  bonds_[THR].push_back(BondInfo(THR_CB_INDEX, THR_OG1_INDEX, 1));
  bonds_[THR].push_back(BondInfo(THR_CB_INDEX, THR_CG2_INDEX, 1));
  bonds_[VAL].push_back(BondInfo(BB_N_INDEX, BB_CA_INDEX, 1));
  bonds_[VAL].push_back(BondInfo(BB_CA_INDEX, BB_C_INDEX, 1));
  bonds_[VAL].push_back(BondInfo(BB_CA_INDEX, VAL_CB_INDEX, 1));
  bonds_[VAL].push_back(BondInfo(BB_C_INDEX, BB_O_INDEX, 2));
  bonds_[VAL].push_back(BondInfo(VAL_CB_INDEX, VAL_CG1_INDEX, 1));
  bonds_[VAL].push_back(BondInfo(VAL_CB_INDEX, VAL_CG2_INDEX, 1));
  bonds_[ILE].push_back(BondInfo(BB_N_INDEX, BB_CA_INDEX, 1));
  bonds_[ILE].push_back(BondInfo(BB_CA_INDEX, BB_C_INDEX, 1));
  bonds_[ILE].push_back(BondInfo(BB_CA_INDEX, ILE_CB_INDEX, 1));
  bonds_[ILE].push_back(BondInfo(BB_C_INDEX, BB_O_INDEX, 2));
  bonds_[ILE].push_back(BondInfo(ILE_CB_INDEX, ILE_CG1_INDEX, 1));
  bonds_[ILE].push_back(BondInfo(ILE_CB_INDEX, ILE_CG2_INDEX, 1));
  bonds_[ILE].push_back(BondInfo(ILE_CG1_INDEX, ILE_CD1_INDEX, 1));
  bonds_[LEU].push_back(BondInfo(BB_N_INDEX, BB_CA_INDEX, 1));
  bonds_[LEU].push_back(BondInfo(BB_CA_INDEX, BB_C_INDEX, 1));
  bonds_[LEU].push_back(BondInfo(BB_CA_INDEX, LEU_CB_INDEX, 1));
  bonds_[LEU].push_back(BondInfo(BB_C_INDEX, BB_O_INDEX, 2));
  bonds_[LEU].push_back(BondInfo(LEU_CB_INDEX, LEU_CG_INDEX, 1));
  bonds_[LEU].push_back(BondInfo(LEU_CG_INDEX, LEU_CD1_INDEX, 1));
  bonds_[LEU].push_back(BondInfo(LEU_CG_INDEX, LEU_CD2_INDEX, 1));
  bonds_[GLY].push_back(BondInfo(BB_N_INDEX, BB_CA_INDEX, 1));
  bonds_[GLY].push_back(BondInfo(BB_CA_INDEX, BB_C_INDEX, 1));
  bonds_[GLY].push_back(BondInfo(BB_C_INDEX, BB_O_INDEX, 2));
  bonds_[PRO].push_back(BondInfo(BB_N_INDEX, BB_CA_INDEX, 1));
  bonds_[PRO].push_back(BondInfo(BB_N_INDEX, PRO_CD_INDEX, 1));
  bonds_[PRO].push_back(BondInfo(BB_CA_INDEX, BB_C_INDEX, 1));
  bonds_[PRO].push_back(BondInfo(BB_CA_INDEX, PRO_CB_INDEX, 1));
  bonds_[PRO].push_back(BondInfo(BB_C_INDEX, BB_O_INDEX, 2));
  bonds_[PRO].push_back(BondInfo(PRO_CB_INDEX, PRO_CG_INDEX, 1));
  bonds_[PRO].push_back(BondInfo(PRO_CG_INDEX, PRO_CD_INDEX, 1));
  bonds_[HIS].push_back(BondInfo(BB_N_INDEX, BB_CA_INDEX, 1));
  bonds_[HIS].push_back(BondInfo(BB_CA_INDEX, BB_C_INDEX, 1));
  bonds_[HIS].push_back(BondInfo(BB_CA_INDEX, HIS_CB_INDEX, 1));
  bonds_[HIS].push_back(BondInfo(BB_C_INDEX, BB_O_INDEX, 2));
  bonds_[HIS].push_back(BondInfo(HIS_CB_INDEX, HIS_CG_INDEX, 1));
  bonds_[HIS].push_back(BondInfo(HIS_CG_INDEX, HIS_ND1_INDEX, 1));
  bonds_[HIS].push_back(BondInfo(HIS_CG_INDEX, HIS_CD2_INDEX, 2));
  bonds_[HIS].push_back(BondInfo(HIS_ND1_INDEX, HIS_CE1_INDEX, 2));
  bonds_[HIS].push_back(BondInfo(HIS_CD2_INDEX, HIS_NE2_INDEX, 1));
  bonds_[HIS].push_back(BondInfo(HIS_CE1_INDEX, HIS_NE2_INDEX, 1));
  bonds_[PHE].push_back(BondInfo(BB_N_INDEX, BB_CA_INDEX, 1));
  bonds_[PHE].push_back(BondInfo(BB_CA_INDEX, BB_C_INDEX, 1));
  bonds_[PHE].push_back(BondInfo(BB_CA_INDEX, PHE_CB_INDEX, 1));
  bonds_[PHE].push_back(BondInfo(BB_C_INDEX, BB_O_INDEX, 2));
  bonds_[PHE].push_back(BondInfo(PHE_CB_INDEX, PHE_CG_INDEX, 1));
  bonds_[PHE].push_back(BondInfo(PHE_CG_INDEX, PHE_CD1_INDEX, 2));
  bonds_[PHE].push_back(BondInfo(PHE_CG_INDEX, PHE_CD2_INDEX, 1));
  bonds_[PHE].push_back(BondInfo(PHE_CD1_INDEX, PHE_CE1_INDEX, 1));
  bonds_[PHE].push_back(BondInfo(PHE_CD2_INDEX, PHE_CE2_INDEX, 2));
  bonds_[PHE].push_back(BondInfo(PHE_CE1_INDEX, PHE_CZ_INDEX, 2));
  bonds_[PHE].push_back(BondInfo(PHE_CE2_INDEX, PHE_CZ_INDEX, 1));

  ////////////////////////////////////////////////////////////////////////

  // HYDROGEN AA-LUT
  first_aah_[ALA] = ALA_H;
  num_hydrogens_[ALA] = ALA_NUM_HYDROGENS;
  first_aah_[ARG] = ARG_H;
  num_hydrogens_[ARG] = ARG_NUM_HYDROGENS;
  first_aah_[ASN] = ASN_H;
  num_hydrogens_[ASN] = ASN_NUM_HYDROGENS;
  first_aah_[ASP] = ASP_H;
  num_hydrogens_[ASP] = ASP_NUM_HYDROGENS;
  first_aah_[GLN] = GLN_H;
  num_hydrogens_[GLN] = GLN_NUM_HYDROGENS;
  first_aah_[GLU] = GLU_H;
  num_hydrogens_[GLU] = GLU_NUM_HYDROGENS;
  first_aah_[LYS] = LYS_H;
  num_hydrogens_[LYS] = LYS_NUM_HYDROGENS;
  first_aah_[SER] = SER_H;
  num_hydrogens_[SER] = SER_NUM_HYDROGENS;
  first_aah_[CYS] = CYS_H;
  num_hydrogens_[CYS] = CYS_NUM_HYDROGENS;
  first_aah_[MET] = MET_H;
  num_hydrogens_[MET] = MET_NUM_HYDROGENS;
  first_aah_[TRP] = TRP_H;
  num_hydrogens_[TRP] = TRP_NUM_HYDROGENS;
  first_aah_[TYR] = TYR_H;
  num_hydrogens_[TYR] = TYR_NUM_HYDROGENS;
  first_aah_[THR] = THR_H;
  num_hydrogens_[THR] = THR_NUM_HYDROGENS;
  first_aah_[VAL] = VAL_H;
  num_hydrogens_[VAL] = VAL_NUM_HYDROGENS;
  first_aah_[ILE] = ILE_H;
  num_hydrogens_[ILE] = ILE_NUM_HYDROGENS;
  first_aah_[LEU] = LEU_H;
  num_hydrogens_[LEU] = LEU_NUM_HYDROGENS;
  first_aah_[GLY] = GLY_H;
  num_hydrogens_[GLY] = GLY_NUM_HYDROGENS;
  first_aah_[PRO] = PRO_H1;
  num_hydrogens_[PRO] = PRO_NUM_HYDROGENS;
  first_aah_[HIS] = HIS_H;
  num_hydrogens_[HIS] = HIS_NUM_HYDROGENS;
  first_aah_[PHE] = PHE_H;
  num_hydrogens_[PHE] = PHE_NUM_HYDROGENS;
  first_aah_[XXX] = XXX_NUM_HYDROGENS;
  num_hydrogens_[XXX] = 0;

  // HYDROGEN AAA-LUT
  hydrogen_name_[ALA_H] = "H";
  anchor_atom_idx_[ALA_H] = BB_N_INDEX;
  hydrogen_name_[ALA_H1] = "H";
  anchor_atom_idx_[ALA_H1] = BB_N_INDEX;
  hydrogen_name_[ALA_H2] = "H2";
  anchor_atom_idx_[ALA_H2] = BB_N_INDEX;
  hydrogen_name_[ALA_H3] = "H3";
  anchor_atom_idx_[ALA_H3] = BB_N_INDEX;
  hydrogen_name_[ALA_HA] = "HA";
  anchor_atom_idx_[ALA_HA] = BB_CA_INDEX;
  hydrogen_name_[ALA_HB1] = "HB1";
  anchor_atom_idx_[ALA_HB1] = BB_CB_INDEX;
  hydrogen_name_[ALA_HB2] = "HB2";
  anchor_atom_idx_[ALA_HB2] = BB_CB_INDEX;
  hydrogen_name_[ALA_HB3] = "HB3";
  anchor_atom_idx_[ALA_HB3] = BB_CB_INDEX;
  hydrogen_name_[ARG_H] = "H";
  anchor_atom_idx_[ARG_H] = BB_N_INDEX;
  hydrogen_name_[ARG_H1] = "H";
  anchor_atom_idx_[ARG_H1] = BB_N_INDEX;
  hydrogen_name_[ARG_H2] = "H2";
  anchor_atom_idx_[ARG_H2] = BB_N_INDEX;
  hydrogen_name_[ARG_H3] = "H3";
  anchor_atom_idx_[ARG_H3] = BB_N_INDEX;
  hydrogen_name_[ARG_HA] = "HA";
  anchor_atom_idx_[ARG_HA] = BB_CA_INDEX;
  hydrogen_name_[ARG_HB2] = "HB2";
  anchor_atom_idx_[ARG_HB2] = BB_CB_INDEX;
  hydrogen_name_[ARG_HB3] = "HB3";
  anchor_atom_idx_[ARG_HB3] = BB_CB_INDEX;
  hydrogen_name_[ARG_HG2] = "HG2";
  anchor_atom_idx_[ARG_HG2] = ARG_CG_INDEX;
  hydrogen_name_[ARG_HG3] = "HG3";
  anchor_atom_idx_[ARG_HG3] = ARG_CG_INDEX;
  hydrogen_name_[ARG_HD2] = "HD2";
  anchor_atom_idx_[ARG_HD2] = ARG_CD_INDEX;
  hydrogen_name_[ARG_HD3] = "HD3";
  anchor_atom_idx_[ARG_HD3] = ARG_CD_INDEX;
  hydrogen_name_[ARG_HE] = "HE";
  anchor_atom_idx_[ARG_HE] = ARG_NE_INDEX;
  hydrogen_name_[ARG_HH11] = "HH11";
  anchor_atom_idx_[ARG_HH11] = ARG_NH1_INDEX;
  hydrogen_name_[ARG_HH12] = "HH12";
  anchor_atom_idx_[ARG_HH12] = ARG_NH1_INDEX;
  hydrogen_name_[ARG_HH21] = "HH21";
  anchor_atom_idx_[ARG_HH21] = ARG_NH2_INDEX;
  hydrogen_name_[ARG_HH22] = "HH22";
  anchor_atom_idx_[ARG_HH22] = ARG_NH2_INDEX;
  hydrogen_name_[ASN_H] = "H";
  anchor_atom_idx_[ASN_H] = BB_N_INDEX;
  hydrogen_name_[ASN_H1] = "H";
  anchor_atom_idx_[ASN_H1] = BB_N_INDEX;
  hydrogen_name_[ASN_H2] = "H2";
  anchor_atom_idx_[ASN_H2] = BB_N_INDEX;
  hydrogen_name_[ASN_H3] = "H3";
  anchor_atom_idx_[ASN_H3] = BB_N_INDEX;
  hydrogen_name_[ASN_HA] = "HA";
  anchor_atom_idx_[ASN_HA] = BB_CA_INDEX;
  hydrogen_name_[ASN_HB2] = "HB2";
  anchor_atom_idx_[ASN_HB2] = BB_CB_INDEX;
  hydrogen_name_[ASN_HB3] = "HB3";
  anchor_atom_idx_[ASN_HB3] = BB_CB_INDEX;
  hydrogen_name_[ASN_HD21] = "HD21";
  anchor_atom_idx_[ASN_HD21] = ASN_ND2_INDEX;
  hydrogen_name_[ASN_HD22] = "HD22";
  anchor_atom_idx_[ASN_HD22] = ASN_ND2_INDEX;
  hydrogen_name_[ASP_H] = "H";
  anchor_atom_idx_[ASP_H] = BB_N_INDEX;
  hydrogen_name_[ASP_H1] = "H";
  anchor_atom_idx_[ASP_H1] = BB_N_INDEX;
  hydrogen_name_[ASP_H2] = "H2";
  anchor_atom_idx_[ASP_H2] = BB_N_INDEX;
  hydrogen_name_[ASP_H3] = "H3";
  anchor_atom_idx_[ASP_H3] = BB_N_INDEX;
  hydrogen_name_[ASP_HA] = "HA";
  anchor_atom_idx_[ASP_HA] = BB_CA_INDEX;
  hydrogen_name_[ASP_HB2] = "HB2";
  anchor_atom_idx_[ASP_HB2] = BB_CB_INDEX;
  hydrogen_name_[ASP_HB3] = "HB3";
  anchor_atom_idx_[ASP_HB3] = BB_CB_INDEX;
  hydrogen_name_[GLN_H] = "H";
  anchor_atom_idx_[GLN_H] = BB_N_INDEX;
  hydrogen_name_[GLN_H1] = "H";
  anchor_atom_idx_[GLN_H1] = BB_N_INDEX;
  hydrogen_name_[GLN_H2] = "H2";
  anchor_atom_idx_[GLN_H2] = BB_N_INDEX;
  hydrogen_name_[GLN_H3] = "H3";
  anchor_atom_idx_[GLN_H3] = BB_N_INDEX;
  hydrogen_name_[GLN_HA] = "HA";
  anchor_atom_idx_[GLN_HA] = BB_CA_INDEX;
  hydrogen_name_[GLN_HB2] = "HB2";
  anchor_atom_idx_[GLN_HB2] = BB_CB_INDEX;
  hydrogen_name_[GLN_HB3] = "HB3";
  anchor_atom_idx_[GLN_HB3] = BB_CB_INDEX;
  hydrogen_name_[GLN_HG2] = "HG2";
  anchor_atom_idx_[GLN_HG2] = GLN_CG_INDEX;
  hydrogen_name_[GLN_HG3] = "HG3";
  anchor_atom_idx_[GLN_HG3] = GLN_CG_INDEX;
  hydrogen_name_[GLN_HE21] = "HE21";
  anchor_atom_idx_[GLN_HE21] = GLN_NE2_INDEX;
  hydrogen_name_[GLN_HE22] = "HE22";
  anchor_atom_idx_[GLN_HE22] = GLN_NE2_INDEX;
  hydrogen_name_[GLU_H] = "H";
  anchor_atom_idx_[GLU_H] = BB_N_INDEX;
  hydrogen_name_[GLU_H1] = "H";
  anchor_atom_idx_[GLU_H1] = BB_N_INDEX;
  hydrogen_name_[GLU_H2] = "H2";
  anchor_atom_idx_[GLU_H2] = BB_N_INDEX;
  hydrogen_name_[GLU_H3] = "H3";
  anchor_atom_idx_[GLU_H3] = BB_N_INDEX;
  hydrogen_name_[GLU_HA] = "HA";
  anchor_atom_idx_[GLU_HA] = BB_CA_INDEX;
  hydrogen_name_[GLU_HB2] = "HB2";
  anchor_atom_idx_[GLU_HB2] = BB_CB_INDEX;
  hydrogen_name_[GLU_HB3] = "HB3";
  anchor_atom_idx_[GLU_HB3] = BB_CB_INDEX;
  hydrogen_name_[GLU_HG2] = "HG2";
  anchor_atom_idx_[GLU_HG2] = GLU_CG_INDEX;
  hydrogen_name_[GLU_HG3] = "HG3";
  anchor_atom_idx_[GLU_HG3] = GLU_CG_INDEX;
  hydrogen_name_[LYS_H] = "H";
  anchor_atom_idx_[LYS_H] = BB_N_INDEX;
  hydrogen_name_[LYS_H1] = "H";
  anchor_atom_idx_[LYS_H1] = BB_N_INDEX;
  hydrogen_name_[LYS_H2] = "H2";
  anchor_atom_idx_[LYS_H2] = BB_N_INDEX;
  hydrogen_name_[LYS_H3] = "H3";
  anchor_atom_idx_[LYS_H3] = BB_N_INDEX;
  hydrogen_name_[LYS_HA] = "HA";
  anchor_atom_idx_[LYS_HA] = BB_CA_INDEX;
  hydrogen_name_[LYS_HB2] = "HB2";
  anchor_atom_idx_[LYS_HB2] = BB_CB_INDEX;
  hydrogen_name_[LYS_HB3] = "HB3";
  anchor_atom_idx_[LYS_HB3] = BB_CB_INDEX;
  hydrogen_name_[LYS_HG2] = "HG2";
  anchor_atom_idx_[LYS_HG2] = LYS_CG_INDEX;
  hydrogen_name_[LYS_HG3] = "HG3";
  anchor_atom_idx_[LYS_HG3] = LYS_CG_INDEX;
  hydrogen_name_[LYS_HD2] = "HD2";
  anchor_atom_idx_[LYS_HD2] = LYS_CD_INDEX;
  hydrogen_name_[LYS_HD3] = "HD3";
  anchor_atom_idx_[LYS_HD3] = LYS_CD_INDEX;
  hydrogen_name_[LYS_HE2] = "HE2";
  anchor_atom_idx_[LYS_HE2] = LYS_CE_INDEX;
  hydrogen_name_[LYS_HE3] = "HE3";
  anchor_atom_idx_[LYS_HE3] = LYS_CE_INDEX;
  hydrogen_name_[LYS_HZ1] = "HZ1";
  anchor_atom_idx_[LYS_HZ1] = LYS_NZ_INDEX;
  hydrogen_name_[LYS_HZ2] = "HZ2";
  anchor_atom_idx_[LYS_HZ2] = LYS_NZ_INDEX;
  hydrogen_name_[LYS_HZ3] = "HZ3";
  anchor_atom_idx_[LYS_HZ3] = LYS_NZ_INDEX;
  hydrogen_name_[SER_H] = "H";
  anchor_atom_idx_[SER_H] = BB_N_INDEX;
  hydrogen_name_[SER_H1] = "H";
  anchor_atom_idx_[SER_H1] = BB_N_INDEX;
  hydrogen_name_[SER_H2] = "H2";
  anchor_atom_idx_[SER_H2] = BB_N_INDEX;
  hydrogen_name_[SER_H3] = "H3";
  anchor_atom_idx_[SER_H3] = BB_N_INDEX;
  hydrogen_name_[SER_HA] = "HA";
  anchor_atom_idx_[SER_HA] = BB_CA_INDEX;
  hydrogen_name_[SER_HB2] = "HB2";
  anchor_atom_idx_[SER_HB2] = BB_CB_INDEX;
  hydrogen_name_[SER_HB3] = "HB3";
  anchor_atom_idx_[SER_HB3] = BB_CB_INDEX;
  hydrogen_name_[SER_HG] = "HG";
  anchor_atom_idx_[SER_HG] = SER_OG_INDEX;
  hydrogen_name_[CYS_H] = "H";
  anchor_atom_idx_[CYS_H] = BB_N_INDEX;
  hydrogen_name_[CYS_H1] = "H";
  anchor_atom_idx_[CYS_H1] = BB_N_INDEX;
  hydrogen_name_[CYS_H2] = "H2";
  anchor_atom_idx_[CYS_H2] = BB_N_INDEX;
  hydrogen_name_[CYS_H3] = "H3";
  anchor_atom_idx_[CYS_H3] = BB_N_INDEX;
  hydrogen_name_[CYS_HA] = "HA";
  anchor_atom_idx_[CYS_HA] = BB_CA_INDEX;
  hydrogen_name_[CYS_HB2] = "HB2";
  anchor_atom_idx_[CYS_HB2] = BB_CB_INDEX;
  hydrogen_name_[CYS_HB3] = "HB3";
  anchor_atom_idx_[CYS_HB3] = BB_CB_INDEX;
  hydrogen_name_[CYS_HG] = "HG";
  anchor_atom_idx_[CYS_HG] = CYS_SG_INDEX;
  hydrogen_name_[MET_H] = "H";
  anchor_atom_idx_[MET_H] = BB_N_INDEX;
  hydrogen_name_[MET_H1] = "H";
  anchor_atom_idx_[MET_H1] = BB_N_INDEX;
  hydrogen_name_[MET_H2] = "H2";
  anchor_atom_idx_[MET_H2] = BB_N_INDEX;
  hydrogen_name_[MET_H3] = "H3";
  anchor_atom_idx_[MET_H3] = BB_N_INDEX;
  hydrogen_name_[MET_HA] = "HA";
  anchor_atom_idx_[MET_HA] = BB_CA_INDEX;
  hydrogen_name_[MET_HB2] = "HB2";
  anchor_atom_idx_[MET_HB2] = BB_CB_INDEX;
  hydrogen_name_[MET_HB3] = "HB3";
  anchor_atom_idx_[MET_HB3] = BB_CB_INDEX;
  hydrogen_name_[MET_HG2] = "HG2";
  anchor_atom_idx_[MET_HG2] = MET_CG_INDEX;
  hydrogen_name_[MET_HG3] = "HG3";
  anchor_atom_idx_[MET_HG3] = MET_CG_INDEX;
  hydrogen_name_[MET_HE1] = "HE1";
  anchor_atom_idx_[MET_HE1] = MET_CE_INDEX;
  hydrogen_name_[MET_HE2] = "HE2";
  anchor_atom_idx_[MET_HE2] = MET_CE_INDEX;
  hydrogen_name_[MET_HE3] = "HE3";
  anchor_atom_idx_[MET_HE3] = MET_CE_INDEX;
  hydrogen_name_[TRP_H] = "H";
  anchor_atom_idx_[TRP_H] = BB_N_INDEX;
  hydrogen_name_[TRP_H1] = "H";
  anchor_atom_idx_[TRP_H1] = BB_N_INDEX;
  hydrogen_name_[TRP_H2] = "H2";
  anchor_atom_idx_[TRP_H2] = BB_N_INDEX;
  hydrogen_name_[TRP_H3] = "H3";
  anchor_atom_idx_[TRP_H3] = BB_N_INDEX;
  hydrogen_name_[TRP_HA] = "HA";
  anchor_atom_idx_[TRP_HA] = BB_CA_INDEX;
  hydrogen_name_[TRP_HB2] = "HB2";
  anchor_atom_idx_[TRP_HB2] = BB_CB_INDEX;
  hydrogen_name_[TRP_HB3] = "HB3";
  anchor_atom_idx_[TRP_HB3] = BB_CB_INDEX;
  hydrogen_name_[TRP_HD1] = "HD1";
  anchor_atom_idx_[TRP_HD1] = TRP_CD1_INDEX;
  hydrogen_name_[TRP_HE1] = "HE1";
  anchor_atom_idx_[TRP_HE1] = TRP_NE1_INDEX;
  hydrogen_name_[TRP_HE3] = "HE3";
  anchor_atom_idx_[TRP_HE3] = TRP_CE3_INDEX;
  hydrogen_name_[TRP_HZ2] = "HZ2";
  anchor_atom_idx_[TRP_HZ2] = TRP_CZ2_INDEX;
  hydrogen_name_[TRP_HZ3] = "HZ3";
  anchor_atom_idx_[TRP_HZ3] = TRP_CZ3_INDEX;
  hydrogen_name_[TRP_HH2] = "HH2";
  anchor_atom_idx_[TRP_HH2] = TRP_CH2_INDEX;
  hydrogen_name_[TYR_H] = "H";
  anchor_atom_idx_[TYR_H] = BB_N_INDEX;
  hydrogen_name_[TYR_H1] = "H";
  anchor_atom_idx_[TYR_H1] = BB_N_INDEX;
  hydrogen_name_[TYR_H2] = "H2";
  anchor_atom_idx_[TYR_H2] = BB_N_INDEX;
  hydrogen_name_[TYR_H3] = "H3";
  anchor_atom_idx_[TYR_H3] = BB_N_INDEX;
  hydrogen_name_[TYR_HA] = "HA";
  anchor_atom_idx_[TYR_HA] = BB_CA_INDEX;
  hydrogen_name_[TYR_HB2] = "HB2";
  anchor_atom_idx_[TYR_HB2] = BB_CB_INDEX;
  hydrogen_name_[TYR_HB3] = "HB3";
  anchor_atom_idx_[TYR_HB3] = BB_CB_INDEX;
  hydrogen_name_[TYR_HD1] = "HD1";
  anchor_atom_idx_[TYR_HD1] = TYR_CD1_INDEX;
  hydrogen_name_[TYR_HD2] = "HD2";
  anchor_atom_idx_[TYR_HD2] = TYR_CD2_INDEX;
  hydrogen_name_[TYR_HE1] = "HE1";
  anchor_atom_idx_[TYR_HE1] = TYR_CE1_INDEX;
  hydrogen_name_[TYR_HE2] = "HE2";
  anchor_atom_idx_[TYR_HE2] = TYR_CE2_INDEX;
  hydrogen_name_[TYR_HH] = "HH";
  anchor_atom_idx_[TYR_HH] = TYR_OH_INDEX;
  hydrogen_name_[THR_H] = "H";
  anchor_atom_idx_[THR_H] = BB_N_INDEX;
  hydrogen_name_[THR_H1] = "H";
  anchor_atom_idx_[THR_H1] = BB_N_INDEX;
  hydrogen_name_[THR_H2] = "H2";
  anchor_atom_idx_[THR_H2] = BB_N_INDEX;
  hydrogen_name_[THR_H3] = "H3";
  anchor_atom_idx_[THR_H3] = BB_N_INDEX;
  hydrogen_name_[THR_HA] = "HA";
  anchor_atom_idx_[THR_HA] = BB_CA_INDEX;
  hydrogen_name_[THR_HB] = "HB";
  anchor_atom_idx_[THR_HB] = BB_CB_INDEX;
  hydrogen_name_[THR_HG1] = "HG1";
  anchor_atom_idx_[THR_HG1] = THR_OG1_INDEX;
  hydrogen_name_[THR_HG21] = "HG21";
  anchor_atom_idx_[THR_HG21] = THR_CG2_INDEX;
  hydrogen_name_[THR_HG22] = "HG22";
  anchor_atom_idx_[THR_HG22] = THR_CG2_INDEX;
  hydrogen_name_[THR_HG23] = "HG23";
  anchor_atom_idx_[THR_HG23] = THR_CG2_INDEX;
  hydrogen_name_[VAL_H] = "H";
  anchor_atom_idx_[VAL_H] = BB_N_INDEX;
  hydrogen_name_[VAL_H1] = "H";
  anchor_atom_idx_[VAL_H1] = BB_N_INDEX;
  hydrogen_name_[VAL_H2] = "H2";
  anchor_atom_idx_[VAL_H2] = BB_N_INDEX;
  hydrogen_name_[VAL_H3] = "H3";
  anchor_atom_idx_[VAL_H3] = BB_N_INDEX;
  hydrogen_name_[VAL_HA] = "HA";
  anchor_atom_idx_[VAL_HA] = BB_CA_INDEX;
  hydrogen_name_[VAL_HB] = "HB";
  anchor_atom_idx_[VAL_HB] = BB_CB_INDEX;
  hydrogen_name_[VAL_HG11] = "HG11";
  anchor_atom_idx_[VAL_HG11] = VAL_CG1_INDEX;
  hydrogen_name_[VAL_HG12] = "HG12";
  anchor_atom_idx_[VAL_HG12] = VAL_CG1_INDEX;
  hydrogen_name_[VAL_HG13] = "HG13";
  anchor_atom_idx_[VAL_HG13] = VAL_CG1_INDEX;
  hydrogen_name_[VAL_HG21] = "HG21";
  anchor_atom_idx_[VAL_HG21] = VAL_CG2_INDEX;
  hydrogen_name_[VAL_HG22] = "HG22";
  anchor_atom_idx_[VAL_HG22] = VAL_CG2_INDEX;
  hydrogen_name_[VAL_HG23] = "HG23";
  anchor_atom_idx_[VAL_HG23] = VAL_CG2_INDEX;
  hydrogen_name_[ILE_H] = "H";
  anchor_atom_idx_[ILE_H] = BB_N_INDEX;
  hydrogen_name_[ILE_H1] = "H";
  anchor_atom_idx_[ILE_H1] = BB_N_INDEX;
  hydrogen_name_[ILE_H2] = "H2";
  anchor_atom_idx_[ILE_H2] = BB_N_INDEX;
  hydrogen_name_[ILE_H3] = "H3";
  anchor_atom_idx_[ILE_H3] = BB_N_INDEX;
  hydrogen_name_[ILE_HA] = "HA";
  anchor_atom_idx_[ILE_HA] = BB_CA_INDEX;
  hydrogen_name_[ILE_HB] = "HB";
  anchor_atom_idx_[ILE_HB] = BB_CB_INDEX;
  hydrogen_name_[ILE_HG12] = "HG12";
  anchor_atom_idx_[ILE_HG12] = ILE_CG1_INDEX;
  hydrogen_name_[ILE_HG13] = "HG13";
  anchor_atom_idx_[ILE_HG13] = ILE_CG1_INDEX;
  hydrogen_name_[ILE_HG21] = "HG21";
  anchor_atom_idx_[ILE_HG21] = ILE_CG2_INDEX;
  hydrogen_name_[ILE_HG22] = "HG22";
  anchor_atom_idx_[ILE_HG22] = ILE_CG2_INDEX;
  hydrogen_name_[ILE_HG23] = "HG23";
  anchor_atom_idx_[ILE_HG23] = ILE_CG2_INDEX;
  hydrogen_name_[ILE_HD11] = "HD11";
  anchor_atom_idx_[ILE_HD11] = ILE_CD1_INDEX;
  hydrogen_name_[ILE_HD12] = "HD12";
  anchor_atom_idx_[ILE_HD12] = ILE_CD1_INDEX;
  hydrogen_name_[ILE_HD13] = "HD13";
  anchor_atom_idx_[ILE_HD13] = ILE_CD1_INDEX;
  hydrogen_name_[LEU_H] = "H";
  anchor_atom_idx_[LEU_H] = BB_N_INDEX;
  hydrogen_name_[LEU_H1] = "H";
  anchor_atom_idx_[LEU_H1] = BB_N_INDEX;
  hydrogen_name_[LEU_H2] = "H2";
  anchor_atom_idx_[LEU_H2] = BB_N_INDEX;
  hydrogen_name_[LEU_H3] = "H3";
  anchor_atom_idx_[LEU_H3] = BB_N_INDEX;
  hydrogen_name_[LEU_HA] = "HA";
  anchor_atom_idx_[LEU_HA] = BB_CA_INDEX;
  hydrogen_name_[LEU_HB2] = "HB2";
  anchor_atom_idx_[LEU_HB2] = BB_CB_INDEX;
  hydrogen_name_[LEU_HB3] = "HB3";
  anchor_atom_idx_[LEU_HB3] = BB_CB_INDEX;
  hydrogen_name_[LEU_HG] = "HG";
  anchor_atom_idx_[LEU_HG] = LEU_CG_INDEX;
  hydrogen_name_[LEU_HD11] = "HD11";
  anchor_atom_idx_[LEU_HD11] = LEU_CD1_INDEX;
  hydrogen_name_[LEU_HD12] = "HD12";
  anchor_atom_idx_[LEU_HD12] = LEU_CD1_INDEX;
  hydrogen_name_[LEU_HD13] = "HD13";
  anchor_atom_idx_[LEU_HD13] = LEU_CD1_INDEX;
  hydrogen_name_[LEU_HD21] = "HD21";
  anchor_atom_idx_[LEU_HD21] = LEU_CD2_INDEX;
  hydrogen_name_[LEU_HD22] = "HD22";
  anchor_atom_idx_[LEU_HD22] = LEU_CD2_INDEX;
  hydrogen_name_[LEU_HD23] = "HD23";
  anchor_atom_idx_[LEU_HD23] = LEU_CD2_INDEX;
  hydrogen_name_[GLY_H] = "H";
  anchor_atom_idx_[GLY_H] = BB_N_INDEX;
  hydrogen_name_[GLY_H1] = "H";
  anchor_atom_idx_[GLY_H1] = BB_N_INDEX;
  hydrogen_name_[GLY_H2] = "H2";
  anchor_atom_idx_[GLY_H2] = BB_N_INDEX;
  hydrogen_name_[GLY_H3] = "H3";
  anchor_atom_idx_[GLY_H3] = BB_N_INDEX;
  hydrogen_name_[GLY_HA2] = "HA2";
  anchor_atom_idx_[GLY_HA2] = BB_CA_INDEX;
  hydrogen_name_[GLY_HA3] = "HA3";
  anchor_atom_idx_[GLY_HA3] = BB_CA_INDEX;
  hydrogen_name_[PRO_H1] = "H";
  anchor_atom_idx_[PRO_H1] = BB_N_INDEX;
  hydrogen_name_[PRO_H2] = "H2";
  anchor_atom_idx_[PRO_H2] = BB_N_INDEX;
  hydrogen_name_[PRO_HA] = "HA";
  anchor_atom_idx_[PRO_HA] = BB_CA_INDEX;
  hydrogen_name_[PRO_HB2] = "HB2";
  anchor_atom_idx_[PRO_HB2] = BB_CB_INDEX;
  hydrogen_name_[PRO_HB3] = "HB3";
  anchor_atom_idx_[PRO_HB3] = BB_CB_INDEX;
  hydrogen_name_[PRO_HG2] = "HG2";
  anchor_atom_idx_[PRO_HG2] = PRO_CG_INDEX;
  hydrogen_name_[PRO_HG3] = "HG3";
  anchor_atom_idx_[PRO_HG3] = PRO_CG_INDEX;
  hydrogen_name_[PRO_HD2] = "HD2";
  anchor_atom_idx_[PRO_HD2] = PRO_CD_INDEX;
  hydrogen_name_[PRO_HD3] = "HD3";
  anchor_atom_idx_[PRO_HD3] = PRO_CD_INDEX;
  hydrogen_name_[HIS_H] = "H";
  anchor_atom_idx_[HIS_H] = BB_N_INDEX;
  hydrogen_name_[HIS_H1] = "H";
  anchor_atom_idx_[HIS_H1] = BB_N_INDEX;
  hydrogen_name_[HIS_H2] = "H2";
  anchor_atom_idx_[HIS_H2] = BB_N_INDEX;
  hydrogen_name_[HIS_H3] = "H3";
  anchor_atom_idx_[HIS_H3] = BB_N_INDEX;
  hydrogen_name_[HIS_HA] = "HA";
  anchor_atom_idx_[HIS_HA] = BB_CA_INDEX;
  hydrogen_name_[HIS_HB2] = "HB2";
  anchor_atom_idx_[HIS_HB2] = BB_CB_INDEX;
  hydrogen_name_[HIS_HB3] = "HB3";
  anchor_atom_idx_[HIS_HB3] = BB_CB_INDEX;
  hydrogen_name_[HIS_HD1] = "HD1";
  anchor_atom_idx_[HIS_HD1] = HIS_ND1_INDEX;
  hydrogen_name_[HIS_HD2] = "HD2";
  anchor_atom_idx_[HIS_HD2] = HIS_CD2_INDEX;
  hydrogen_name_[HIS_HE1] = "HE1";
  anchor_atom_idx_[HIS_HE1] = HIS_CE1_INDEX;
  hydrogen_name_[HIS_HE2] = "HE2";
  anchor_atom_idx_[HIS_HE2] = HIS_NE2_INDEX;
  hydrogen_name_[PHE_H] = "H";
  anchor_atom_idx_[PHE_H] = BB_N_INDEX;
  hydrogen_name_[PHE_H1] = "H";
  anchor_atom_idx_[PHE_H1] = BB_N_INDEX;
  hydrogen_name_[PHE_H2] = "H2";
  anchor_atom_idx_[PHE_H2] = BB_N_INDEX;
  hydrogen_name_[PHE_H3] = "H3";
  anchor_atom_idx_[PHE_H3] = BB_N_INDEX;
  hydrogen_name_[PHE_HA] = "HA";
  anchor_atom_idx_[PHE_HA] = BB_CA_INDEX;
  hydrogen_name_[PHE_HB2] = "HB2";
  anchor_atom_idx_[PHE_HB2] = BB_CB_INDEX;
  hydrogen_name_[PHE_HB3] = "HB3";
  anchor_atom_idx_[PHE_HB3] = BB_CB_INDEX;
  hydrogen_name_[PHE_HD1] = "HD1";
  anchor_atom_idx_[PHE_HD1] = PHE_CD1_INDEX;
  hydrogen_name_[PHE_HD2] = "HD2";
  anchor_atom_idx_[PHE_HD2] = PHE_CD2_INDEX;
  hydrogen_name_[PHE_HE1] = "HE1";
  anchor_atom_idx_[PHE_HE1] = PHE_CE1_INDEX;
  hydrogen_name_[PHE_HE2] = "HE2";
  anchor_atom_idx_[PHE_HE2] = PHE_CE2_INDEX;
  hydrogen_name_[PHE_HZ] = "HZ";
  anchor_atom_idx_[PHE_HZ] = PHE_CZ_INDEX;
  hydrogen_name_[XXX_NUM_HYDROGENS] = "UNK";
  anchor_atom_idx_[XXX_NUM_HYDROGENS] = XXX_NUM_ATOMS;

  // fix amber naming
  std::copy(hydrogen_name_, hydrogen_name_ + XXX_NUM_HYDROGENS + 1,
            hydrogen_name_amber_);
  hydrogen_name_amber_[ALA_H1] = "H1";
  hydrogen_name_amber_[ARG_H1] = "H1";
  hydrogen_name_amber_[ARG_HB2] = "HB1";
  hydrogen_name_amber_[ARG_HB3] = "HB2";
  hydrogen_name_amber_[ARG_HG2] = "HG1";
  hydrogen_name_amber_[ARG_HG3] = "HG2";
  hydrogen_name_amber_[ARG_HD2] = "HD1";
  hydrogen_name_amber_[ARG_HD3] = "HD2";
  hydrogen_name_amber_[ASN_H1] = "H1";
  hydrogen_name_amber_[ASN_HB2] = "HB1";
  hydrogen_name_amber_[ASN_HB3] = "HB2";
  hydrogen_name_amber_[ASP_H1] = "H1";
  hydrogen_name_amber_[ASP_HB2] = "HB1";
  hydrogen_name_amber_[ASP_HB3] = "HB2";
  hydrogen_name_amber_[GLN_H1] = "H1";
  hydrogen_name_amber_[GLN_HB2] = "HB1";
  hydrogen_name_amber_[GLN_HB3] = "HB2";
  hydrogen_name_amber_[GLN_HG2] = "HG1";
  hydrogen_name_amber_[GLN_HG3] = "HG2";
  hydrogen_name_amber_[GLU_H1] = "H1";
  hydrogen_name_amber_[GLU_HB2] = "HB1";
  hydrogen_name_amber_[GLU_HB3] = "HB2";
  hydrogen_name_amber_[GLU_HG2] = "HG1";
  hydrogen_name_amber_[GLU_HG3] = "HG2";
  hydrogen_name_amber_[LYS_H1] = "H1";
  hydrogen_name_amber_[LYS_HB2] = "HB1";
  hydrogen_name_amber_[LYS_HB3] = "HB2";
  hydrogen_name_amber_[LYS_HG2] = "HG1";
  hydrogen_name_amber_[LYS_HG3] = "HG2";
  hydrogen_name_amber_[LYS_HD2] = "HD1";
  hydrogen_name_amber_[LYS_HD3] = "HD2";
  hydrogen_name_amber_[LYS_HE2] = "HE1";
  hydrogen_name_amber_[LYS_HE3] = "HE2";
  hydrogen_name_amber_[SER_H1] = "H1";
  hydrogen_name_amber_[SER_HB2] = "HB1";
  hydrogen_name_amber_[SER_HB3] = "HB2";
  hydrogen_name_amber_[CYS_H1] = "H1";
  hydrogen_name_amber_[CYS_HB2] = "HB1";
  hydrogen_name_amber_[CYS_HB3] = "HB2";
  hydrogen_name_amber_[MET_H1] = "H1";
  hydrogen_name_amber_[MET_HB2] = "HB1";
  hydrogen_name_amber_[MET_HB3] = "HB2";
  hydrogen_name_amber_[MET_HG2] = "HG1";
  hydrogen_name_amber_[MET_HG3] = "HG2";
  hydrogen_name_amber_[TRP_H1] = "H1";
  hydrogen_name_amber_[TRP_HB2] = "HB1";
  hydrogen_name_amber_[TRP_HB3] = "HB2";
  hydrogen_name_amber_[TYR_H1] = "H1";
  hydrogen_name_amber_[TYR_HB2] = "HB1";
  hydrogen_name_amber_[TYR_HB3] = "HB2";
  hydrogen_name_amber_[THR_H1] = "H1";
  hydrogen_name_amber_[VAL_H1] = "H1";
  hydrogen_name_amber_[ILE_H1] = "H1";
  hydrogen_name_amber_[ILE_HG12] = "HG11";
  hydrogen_name_amber_[ILE_HG13] = "HG12";
  hydrogen_name_amber_[ILE_HD11] = "HD1";
  hydrogen_name_amber_[ILE_HD12] = "HD2";
  hydrogen_name_amber_[ILE_HD13] = "HD3";
  hydrogen_name_amber_[LEU_H1] = "H1";
  hydrogen_name_amber_[LEU_HB2] = "HB1";
  hydrogen_name_amber_[LEU_HB3] = "HB2";
  hydrogen_name_amber_[GLY_H1] = "H1";
  hydrogen_name_amber_[GLY_HA2] = "HA1";
  hydrogen_name_amber_[GLY_HA3] = "HA2";
  hydrogen_name_amber_[PRO_H1] = "H1";
  hydrogen_name_amber_[PRO_HB2] = "HB1";
  hydrogen_name_amber_[PRO_HB3] = "HB2";
  hydrogen_name_amber_[PRO_HG2] = "HG1";
  hydrogen_name_amber_[PRO_HG3] = "HG2";
  hydrogen_name_amber_[PRO_HD2] = "HD1";
  hydrogen_name_amber_[PRO_HD3] = "HD2";
  hydrogen_name_amber_[HIS_H1] = "H1";
  hydrogen_name_amber_[HIS_HB2] = "HB1";
  hydrogen_name_amber_[HIS_HB3] = "HB2";
  hydrogen_name_amber_[PHE_H1] = "H1";
  hydrogen_name_amber_[PHE_HB2] = "HB1";
  hydrogen_name_amber_[PHE_HB3] = "HB2";

  // fix charmm naming
  std::copy(hydrogen_name_amber_, hydrogen_name_amber_ + XXX_NUM_HYDROGENS + 1,
            hydrogen_name_charmm_);
  hydrogen_name_charmm_[ALA_H] = "HN";
  hydrogen_name_charmm_[ARG_H] = "HN";
  hydrogen_name_charmm_[ASN_H] = "HN";
  hydrogen_name_charmm_[ASP_H] = "HN";
  hydrogen_name_charmm_[GLN_H] = "HN";
  hydrogen_name_charmm_[GLU_H] = "HN";
  hydrogen_name_charmm_[LYS_H] = "HN";
  hydrogen_name_charmm_[SER_H] = "HN";
  hydrogen_name_charmm_[SER_HG] = "HG1";
  hydrogen_name_charmm_[CYS_H] = "HN";
  hydrogen_name_charmm_[CYS_HG] = "HG1";
  hydrogen_name_charmm_[MET_H] = "HN";
  hydrogen_name_charmm_[TRP_H] = "HN";
  hydrogen_name_charmm_[TYR_H] = "HN";
  hydrogen_name_charmm_[THR_H] = "HN";
  hydrogen_name_charmm_[VAL_H] = "HN";
  hydrogen_name_charmm_[ILE_H] = "HN";
  hydrogen_name_charmm_[LEU_H] = "HN";
  hydrogen_name_charmm_[GLY_H] = "HN";
  hydrogen_name_charmm_[HIS_H] = "HN";
  hydrogen_name_charmm_[PHE_H] = "HN";

  // cook up aa
  for (uint aa_idx = 0; aa_idx < XXX; ++aa_idx) {
    for (uint atom_idx = 0; atom_idx < num_atoms_[aa_idx]; ++atom_idx) {
      const uint aaa_idx = first_aaa_[aa_idx] + atom_idx;
      aa_[aaa_idx] = AminoAcid(aa_idx);
    }
    for (uint h_idx = 0; h_idx < num_hydrogens_[aa_idx]; ++h_idx) {
      const uint aah_idx = first_aah_[aa_idx] + h_idx;
      hydrogen_aa_[aah_idx] = AminoAcid(aa_idx);
    }
  }
  aa_[XXX_NUM_ATOMS] = XXX;
  hydrogen_aa_[XXX_NUM_HYDROGENS] = XXX;

  // cook up element strings (for all the heavy atoms it's simply first letter)
  for (uint idx = 0; idx < XXX_NUM_ATOMS; ++idx) {
    element_[idx] = atom_name_[idx].substr(0, 1);
  }
  element_[XXX_NUM_ATOMS] = "?";

  // get max nums
  max_num_atoms_ = 0;
  max_num_hydrogens_ = 0;
  for (uint aa_idx = 0; aa_idx < XXX; ++aa_idx) {
    max_num_atoms_ = std::max(max_num_atoms_, num_atoms_[aa_idx]);
    max_num_hydrogens_ = std::max(max_num_hydrogens_, num_hydrogens_[aa_idx]);
  }

  // cook up hx_indices
  for (uint aa_idx = 0; aa_idx <= XXX; ++aa_idx) {
    if (aa_idx == uint(XXX)) {
      hn_index_[aa_idx] = -1;
      h1_index_[aa_idx] = -1;
      h2_index_[aa_idx] = -1;
      h3_index_[aa_idx] = -1;
    } else if (aa_idx == uint(PRO)) {
      // by construction: H1/H2 as first 2 indices
      hn_index_[aa_idx] = -1;
      h1_index_[aa_idx] = 0;
      h2_index_[aa_idx] = 1;
      h3_index_[aa_idx] = -1;
    } else {
      // by construction: HN/H1/H2/H3 as first 4 indices
      hn_index_[aa_idx] = 0;
      h1_index_[aa_idx] = 1;
      h2_index_[aa_idx] = 2;
      h3_index_[aa_idx] = 3;
    }
  }
}

uint AminoAcidLookup::GetIndex(ost::conop::AminoAcid aa,
                               const String& aname) const {
  // reuse GetIndexNoExc
  int idx = GetIndexNoExc(aa, aname);
  if (idx < 0) {
    std::stringstream ss;
    ss << "There is no atom " << aname << " in amino acid "
       << ost::conop::AminoAcidToResidueName(aa);
    throw promod3::Error(ss.str());
  } else {
    return uint(idx);
  }
}

int AminoAcidLookup::GetIndexNoExc(ost::conop::AminoAcid aa,
                                   const String& aname) const {
  // use atom_name look up table
  uint first_aaa = GetFirstAAA(aa);
  uint num_atoms = GetNumAtoms(aa);
  for (uint idx = 0; idx < num_atoms; ++idx) {
    if (aname == atom_name_[first_aaa + idx]) return int(idx);
  }
  // if we got this far, it's bad
  return -1;
}

uint AminoAcidLookup::GetHydrogenIndex(ost::conop::AminoAcid aa,
                                       const String& aname) const {
  // reuse GetHydrogenIndexNoExc
  int idx = GetHydrogenIndexNoExc(aa, aname);
  if (idx < 0) {
    std::stringstream ss;
    ss << "There is no hydrogen atom " << aname << " in amino acid "
       << ost::conop::AminoAcidToResidueName(aa);
    throw promod3::Error(ss.str());
  } else {
    return uint(idx);
  }
}

int AminoAcidLookup::GetHydrogenIndexNoExc(ost::conop::AminoAcid aa,
                                           const String& aname) const {
  // use atom_name look up table
  uint first_aah = GetFirstAAH(aa);
  uint num_atoms = GetNumHydrogens(aa);
  for (uint idx = 0; idx < num_atoms; ++idx) {
    if (aname == hydrogen_name_[first_aah + idx]) return int(idx);
  }
  // if we got this far, it's bad
  return -1;
}

}} //ns
