# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Resource(_serialization.Model):
    """The resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar tags: Azure resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Azure resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar tags: Azure resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, location: Optional[str] = None, **kwargs):
        """
        :keyword tags: Azure resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        """
        super().__init__(tags=tags, **kwargs)
        self.location = location


class ElasticSan(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """Response for ElasticSan request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar tags: Azure resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar system_data: Resource metadata required by ARM RPC.
    :vartype system_data: ~azure.mgmt.elasticsan.models.SystemData
    :ivar sku: resource sku. Required.
    :vartype sku: ~azure.mgmt.elasticsan.models.Sku
    :ivar availability_zones: Logical zone for Elastic San resource; example: ["1"].
    :vartype availability_zones: list[str]
    :ivar provisioning_state: State of the operation on the resource. Known values are: "Invalid",
     "Succeeded", "Failed", "Canceled", "Pending", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.elasticsan.models.ProvisioningStates
    :ivar base_size_ti_b: Base size of the Elastic San appliance in TiB. Required.
    :vartype base_size_ti_b: int
    :ivar extended_capacity_size_ti_b: Extended size of the Elastic San appliance in TiB. Required.
    :vartype extended_capacity_size_ti_b: int
    :ivar total_volume_size_gi_b: Total size of the provisioned Volumes in GiB.
    :vartype total_volume_size_gi_b: int
    :ivar volume_group_count: Total number of volume groups in this Elastic San appliance.
    :vartype volume_group_count: int
    :ivar total_iops: Total Provisioned IOPS of the Elastic San appliance.
    :vartype total_iops: int
    :ivar total_m_bps: Total Provisioned MBps Elastic San appliance.
    :vartype total_m_bps: int
    :ivar total_size_ti_b: Total size of the Elastic San appliance in TB.
    :vartype total_size_ti_b: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "sku": {"required": True},
        "provisioning_state": {"readonly": True},
        "base_size_ti_b": {"required": True},
        "extended_capacity_size_ti_b": {"required": True},
        "total_volume_size_gi_b": {"readonly": True},
        "volume_group_count": {"readonly": True},
        "total_iops": {"readonly": True},
        "total_m_bps": {"readonly": True},
        "total_size_ti_b": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "sku": {"key": "properties.sku", "type": "Sku"},
        "availability_zones": {"key": "properties.availabilityZones", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "base_size_ti_b": {"key": "properties.baseSizeTiB", "type": "int"},
        "extended_capacity_size_ti_b": {"key": "properties.extendedCapacitySizeTiB", "type": "int"},
        "total_volume_size_gi_b": {"key": "properties.totalVolumeSizeGiB", "type": "int"},
        "volume_group_count": {"key": "properties.volumeGroupCount", "type": "int"},
        "total_iops": {"key": "properties.totalIops", "type": "int"},
        "total_m_bps": {"key": "properties.totalMBps", "type": "int"},
        "total_size_ti_b": {"key": "properties.totalSizeTiB", "type": "int"},
    }

    def __init__(
        self,
        *,
        sku: "_models.Sku",
        base_size_ti_b: int,
        extended_capacity_size_ti_b: int,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        availability_zones: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword tags: Azure resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        :keyword sku: resource sku. Required.
        :paramtype sku: ~azure.mgmt.elasticsan.models.Sku
        :keyword availability_zones: Logical zone for Elastic San resource; example: ["1"].
        :paramtype availability_zones: list[str]
        :keyword base_size_ti_b: Base size of the Elastic San appliance in TiB. Required.
        :paramtype base_size_ti_b: int
        :keyword extended_capacity_size_ti_b: Extended size of the Elastic San appliance in TiB.
         Required.
        :paramtype extended_capacity_size_ti_b: int
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.system_data = None
        self.sku = sku
        self.availability_zones = availability_zones
        self.provisioning_state = None
        self.base_size_ti_b = base_size_ti_b
        self.extended_capacity_size_ti_b = extended_capacity_size_ti_b
        self.total_volume_size_gi_b = None
        self.volume_group_count = None
        self.total_iops = None
        self.total_m_bps = None
        self.total_size_ti_b = None


class ElasticSanList(_serialization.Model):
    """List of Elastic Sans.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: An array of Elastic San objects. Required.
    :vartype value: list[~azure.mgmt.elasticsan.models.ElasticSan]
    :ivar next_link: URI to fetch the next section of the paginated response.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ElasticSan]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ElasticSan"], **kwargs):
        """
        :keyword value: An array of Elastic San objects. Required.
        :paramtype value: list[~azure.mgmt.elasticsan.models.ElasticSan]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ElasticSanOperationDisplay(_serialization.Model):
    """Metadata about an operation.

    All required parameters must be populated in order to send to Azure.

    :ivar provider: Localized friendly form of the resource provider name. Required.
    :vartype provider: str
    :ivar resource: Localized friendly form of the resource type related to this action/operation.
     Required.
    :vartype resource: str
    :ivar operation: Localized friendly name for the operation, as it should be shown to the user.
     Required.
    :vartype operation: str
    :ivar description: Localized friendly description for the operation, as it should be shown to
     the user. Required.
    :vartype description: str
    """

    _validation = {
        "provider": {"required": True},
        "resource": {"required": True},
        "operation": {"required": True},
        "description": {"required": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, provider: str, resource: str, operation: str, description: str, **kwargs):
        """
        :keyword provider: Localized friendly form of the resource provider name. Required.
        :paramtype provider: str
        :keyword resource: Localized friendly form of the resource type related to this
         action/operation. Required.
        :paramtype resource: str
        :keyword operation: Localized friendly name for the operation, as it should be shown to the
         user. Required.
        :paramtype operation: str
        :keyword description: Localized friendly description for the operation, as it should be shown
         to the user. Required.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class ElasticSanOperationListResult(_serialization.Model):
    """List of operations supported by the RP.

    All required parameters must be populated in order to send to Azure.

    :ivar value: An array of operations supported by the ElasticSan RP. Required.
    :vartype value: list[~azure.mgmt.elasticsan.models.ElasticSanRPOperation]
    :ivar next_link: URI to fetch the next section of the paginated response.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ElasticSanRPOperation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ElasticSanRPOperation"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: An array of operations supported by the ElasticSan RP. Required.
        :paramtype value: list[~azure.mgmt.elasticsan.models.ElasticSanRPOperation]
        :keyword next_link: URI to fetch the next section of the paginated response.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ElasticSanRPOperation(_serialization.Model):
    """Description of a ElasticSan RP Operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the operation being performed on this particular object. Required.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation applies to data-plane.
    :vartype is_data_action: bool
    :ivar display: Additional metadata about RP operation.
    :vartype display: ~azure.mgmt.elasticsan.models.ElasticSanOperationDisplay
    """

    _validation = {
        "name": {"required": True},
        "is_data_action": {"readonly": True},
        "display": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "ElasticSanOperationDisplay"},
    }

    def __init__(self, *, name: str, **kwargs):
        """
        :keyword name: The name of the operation being performed on this particular object. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_data_action = None
        self.display = None


class ElasticSanUpdate(_serialization.Model):
    """Response for ElasticSan update request.

    :ivar tags: Update tags.
    :vartype tags: dict[str, str]
    :ivar base_size_ti_b: Base size of the Elastic San appliance in TiB.
    :vartype base_size_ti_b: int
    :ivar extended_capacity_size_ti_b: Extended size of the Elastic San appliance in TiB.
    :vartype extended_capacity_size_ti_b: int
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "base_size_ti_b": {"key": "properties.baseSizeTiB", "type": "int"},
        "extended_capacity_size_ti_b": {"key": "properties.extendedCapacitySizeTiB", "type": "int"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        base_size_ti_b: Optional[int] = None,
        extended_capacity_size_ti_b: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword tags: Update tags.
        :paramtype tags: dict[str, str]
        :keyword base_size_ti_b: Base size of the Elastic San appliance in TiB.
        :paramtype base_size_ti_b: int
        :keyword extended_capacity_size_ti_b: Extended size of the Elastic San appliance in TiB.
        :paramtype extended_capacity_size_ti_b: int
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.base_size_ti_b = base_size_ti_b
        self.extended_capacity_size_ti_b = extended_capacity_size_ti_b


class Error(_serialization.Model):
    """The resource management error response.

    :ivar error: RP error response.
    :vartype error: ~azure.mgmt.elasticsan.models.ErrorResponse
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorResponse"},
    }

    def __init__(self, *, error: Optional["_models.ErrorResponse"] = None, **kwargs):
        """
        :keyword error: RP error response.
        :paramtype error: ~azure.mgmt.elasticsan.models.ErrorResponse
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorResponse(_serialization.Model):
    """The resource management error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.elasticsan.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.elasticsan.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorResponse]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class IscsiTargetInfo(_serialization.Model):
    """Iscsi target information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar target_iqn: iSCSI Target IQN (iSCSI Qualified Name); example:
     "iqn.2005-03.org.iscsi:server".
    :vartype target_iqn: str
    :ivar target_portal_hostname: iSCSI Target Portal Host Name.
    :vartype target_portal_hostname: str
    :ivar target_portal_port: iSCSI Target Portal Port.
    :vartype target_portal_port: int
    :ivar provisioning_state: State of the operation on the resource. Known values are: "Invalid",
     "Succeeded", "Failed", "Canceled", "Pending", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.elasticsan.models.ProvisioningStates
    :ivar status: Operational status of the iSCSI Target. Known values are: "Invalid", "Unknown",
     "Healthy", "Unhealthy", "Updating", "Running", "Stopped", and "Stopped (deallocated)".
    :vartype status: str or ~azure.mgmt.elasticsan.models.OperationalStatus
    """

    _validation = {
        "target_iqn": {"readonly": True},
        "target_portal_hostname": {"readonly": True},
        "target_portal_port": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "target_iqn": {"key": "targetIqn", "type": "str"},
        "target_portal_hostname": {"key": "targetPortalHostname", "type": "str"},
        "target_portal_port": {"key": "targetPortalPort", "type": "int"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, *, status: Optional[Union[str, "_models.OperationalStatus"]] = None, **kwargs):
        """
        :keyword status: Operational status of the iSCSI Target. Known values are: "Invalid",
         "Unknown", "Healthy", "Unhealthy", "Updating", "Running", "Stopped", and "Stopped
         (deallocated)".
        :paramtype status: str or ~azure.mgmt.elasticsan.models.OperationalStatus
        """
        super().__init__(**kwargs)
        self.target_iqn = None
        self.target_portal_hostname = None
        self.target_portal_port = None
        self.provisioning_state = None
        self.status = status


class NetworkRuleSet(_serialization.Model):
    """A set of rules governing the network accessibility.

    :ivar virtual_network_rules: The list of virtual network rules.
    :vartype virtual_network_rules: list[~azure.mgmt.elasticsan.models.VirtualNetworkRule]
    """

    _attribute_map = {
        "virtual_network_rules": {"key": "virtualNetworkRules", "type": "[VirtualNetworkRule]"},
    }

    def __init__(self, *, virtual_network_rules: Optional[List["_models.VirtualNetworkRule"]] = None, **kwargs):
        """
        :keyword virtual_network_rules: The list of virtual network rules.
        :paramtype virtual_network_rules: list[~azure.mgmt.elasticsan.models.VirtualNetworkRule]
        """
        super().__init__(**kwargs)
        self.virtual_network_rules = virtual_network_rules


class Sku(_serialization.Model):
    """The SKU name. Required for account creation; optional for update.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The sku name. Required. Known values are: "Premium_LRS" and "Premium_ZRS".
    :vartype name: str or ~azure.mgmt.elasticsan.models.SkuName
    :ivar tier: The sku tier. "Premium"
    :vartype tier: str or ~azure.mgmt.elasticsan.models.SkuTier
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(
        self, *, name: Union[str, "_models.SkuName"], tier: Optional[Union[str, "_models.SkuTier"]] = None, **kwargs
    ):
        """
        :keyword name: The sku name. Required. Known values are: "Premium_LRS" and "Premium_ZRS".
        :paramtype name: str or ~azure.mgmt.elasticsan.models.SkuName
        :keyword tier: The sku tier. "Premium"
        :paramtype tier: str or ~azure.mgmt.elasticsan.models.SkuTier
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier


class SKUCapability(_serialization.Model):
    """The capability information in the specified SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of capability.
    :vartype name: str
    :ivar value: A string value to indicate states of given capability.
    :vartype value: str
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.value = None


class SkuInformation(_serialization.Model):
    """ElasticSAN SKU and its properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Sku Name. Required. Known values are: "Premium_LRS" and "Premium_ZRS".
    :vartype name: str or ~azure.mgmt.elasticsan.models.SkuName
    :ivar tier: Sku Tier. "Premium"
    :vartype tier: str or ~azure.mgmt.elasticsan.models.SkuTier
    :ivar resource_type: The type of the resource.
    :vartype resource_type: str
    :ivar locations: The set of locations that the SKU is available. This will be supported and
     registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.).
    :vartype locations: list[str]
    :ivar location_info: Availability of the SKU for the location/zone.
    :vartype location_info: list[~azure.mgmt.elasticsan.models.SkuLocationInfo]
    :ivar capabilities: The capability information in the specified SKU.
    :vartype capabilities: list[~azure.mgmt.elasticsan.models.SKUCapability]
    """

    _validation = {
        "name": {"required": True},
        "resource_type": {"readonly": True},
        "locations": {"readonly": True},
        "location_info": {"readonly": True},
        "capabilities": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "locations": {"key": "locations", "type": "[str]"},
        "location_info": {"key": "locationInfo", "type": "[SkuLocationInfo]"},
        "capabilities": {"key": "capabilities", "type": "[SKUCapability]"},
    }

    def __init__(
        self, *, name: Union[str, "_models.SkuName"], tier: Optional[Union[str, "_models.SkuTier"]] = None, **kwargs
    ):
        """
        :keyword name: Sku Name. Required. Known values are: "Premium_LRS" and "Premium_ZRS".
        :paramtype name: str or ~azure.mgmt.elasticsan.models.SkuName
        :keyword tier: Sku Tier. "Premium"
        :paramtype tier: str or ~azure.mgmt.elasticsan.models.SkuTier
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.resource_type = None
        self.locations = None
        self.location_info = None
        self.capabilities = None


class SkuInformationList(_serialization.Model):
    """List of SKU Information objects.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of ResourceType Sku.
    :vartype value: list[~azure.mgmt.elasticsan.models.SkuInformation]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SkuInformation]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None


class SkuLocationInfo(_serialization.Model):
    """The location info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: The location.
    :vartype location: str
    :ivar zones: The zones.
    :vartype zones: list[str]
    """

    _validation = {
        "location": {"readonly": True},
        "zones": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.location = None
        self.zones = None


class SourceCreationData(_serialization.Model):
    """Data source used when creating the volume.

    :ivar create_source: This enumerates the possible sources of a volume creation. Default value
     is "None".
    :vartype create_source: str
    :ivar source_uri: If createOption is Copy, this is the ARM id of the source snapshot or disk.
     If createOption is Restore, this is the ARM-like id of the source disk restore point.
    :vartype source_uri: str
    """

    _attribute_map = {
        "create_source": {"key": "createSource", "type": "str"},
        "source_uri": {"key": "sourceUri", "type": "str"},
    }

    def __init__(self, *, create_source: Optional[str] = None, source_uri: Optional[str] = None, **kwargs):
        """
        :keyword create_source: This enumerates the possible sources of a volume creation. Default
         value is "None".
        :paramtype create_source: str
        :keyword source_uri: If createOption is Copy, this is the ARM id of the source snapshot or
         disk. If createOption is Restore, this is the ARM-like id of the source disk restore point.
        :paramtype source_uri: str
        """
        super().__init__(**kwargs)
        self.create_source = create_source
        self.source_uri = source_uri


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.elasticsan.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.elasticsan.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.elasticsan.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.elasticsan.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class VirtualNetworkRule(_serialization.Model):
    """Virtual Network rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar virtual_network_resource_id: Resource ID of a subnet, for example:
     /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
     Required.
    :vartype virtual_network_resource_id: str
    :ivar action: The action of virtual network rule. Default value is "Allow".
    :vartype action: str
    :ivar state: Gets the state of virtual network rule. Known values are: "provisioning",
     "deprovisioning", "succeeded", "failed", and "networkSourceDeleted".
    :vartype state: str or ~azure.mgmt.elasticsan.models.State
    """

    _validation = {
        "virtual_network_resource_id": {"required": True},
        "state": {"readonly": True},
    }

    _attribute_map = {
        "virtual_network_resource_id": {"key": "id", "type": "str"},
        "action": {"key": "action", "type": "str"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(self, *, virtual_network_resource_id: str, action: str = "Allow", **kwargs):
        """
        :keyword virtual_network_resource_id: Resource ID of a subnet, for example:
         /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
         Required.
        :paramtype virtual_network_resource_id: str
        :keyword action: The action of virtual network rule. Default value is "Allow".
        :paramtype action: str
        """
        super().__init__(**kwargs)
        self.virtual_network_resource_id = virtual_network_resource_id
        self.action = action
        self.state = None


class Volume(Resource):
    """Response for Volume request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar tags: Azure resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: Resource metadata required by ARM RPC.
    :vartype system_data: ~azure.mgmt.elasticsan.models.SystemData
    :ivar volume_id: Unique Id of the volume in GUID format.
    :vartype volume_id: str
    :ivar creation_data: State of the operation on the resource.
    :vartype creation_data: ~azure.mgmt.elasticsan.models.SourceCreationData
    :ivar size_gi_b: Volume size.
    :vartype size_gi_b: int
    :ivar storage_target: Storage target information.
    :vartype storage_target: ~azure.mgmt.elasticsan.models.IscsiTargetInfo
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "volume_id": {"readonly": True},
        "storage_target": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "volume_id": {"key": "properties.volumeId", "type": "str"},
        "creation_data": {"key": "properties.creationData", "type": "SourceCreationData"},
        "size_gi_b": {"key": "properties.sizeGiB", "type": "int"},
        "storage_target": {"key": "properties.storageTarget", "type": "IscsiTargetInfo"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        creation_data: Optional["_models.SourceCreationData"] = None,
        size_gi_b: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword tags: Azure resource tags.
        :paramtype tags: dict[str, str]
        :keyword creation_data: State of the operation on the resource.
        :paramtype creation_data: ~azure.mgmt.elasticsan.models.SourceCreationData
        :keyword size_gi_b: Volume size.
        :paramtype size_gi_b: int
        """
        super().__init__(tags=tags, **kwargs)
        self.system_data = None
        self.volume_id = None
        self.creation_data = creation_data
        self.size_gi_b = size_gi_b
        self.storage_target = None


class VolumeGroup(Resource):
    """Response for Volume Group request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar tags: Azure resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: Resource metadata required by ARM RPC.
    :vartype system_data: ~azure.mgmt.elasticsan.models.SystemData
    :ivar provisioning_state: State of the operation on the resource. Known values are: "Invalid",
     "Succeeded", "Failed", "Canceled", "Pending", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.elasticsan.models.ProvisioningStates
    :ivar protocol_type: Type of storage target. Known values are: "Iscsi" and "None".
    :vartype protocol_type: str or ~azure.mgmt.elasticsan.models.StorageTargetType
    :ivar encryption: Type of encryption. "EncryptionAtRestWithPlatformKey"
    :vartype encryption: str or ~azure.mgmt.elasticsan.models.EncryptionType
    :ivar network_acls: A collection of rules governing the accessibility from specific network
     locations.
    :vartype network_acls: ~azure.mgmt.elasticsan.models.NetworkRuleSet
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "protocol_type": {"key": "properties.protocolType", "type": "str"},
        "encryption": {"key": "properties.encryption", "type": "str"},
        "network_acls": {"key": "properties.networkAcls", "type": "NetworkRuleSet"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        protocol_type: Optional[Union[str, "_models.StorageTargetType"]] = None,
        encryption: Optional[Union[str, "_models.EncryptionType"]] = None,
        network_acls: Optional["_models.NetworkRuleSet"] = None,
        **kwargs
    ):
        """
        :keyword tags: Azure resource tags.
        :paramtype tags: dict[str, str]
        :keyword protocol_type: Type of storage target. Known values are: "Iscsi" and "None".
        :paramtype protocol_type: str or ~azure.mgmt.elasticsan.models.StorageTargetType
        :keyword encryption: Type of encryption. "EncryptionAtRestWithPlatformKey"
        :paramtype encryption: str or ~azure.mgmt.elasticsan.models.EncryptionType
        :keyword network_acls: A collection of rules governing the accessibility from specific network
         locations.
        :paramtype network_acls: ~azure.mgmt.elasticsan.models.NetworkRuleSet
        """
        super().__init__(tags=tags, **kwargs)
        self.system_data = None
        self.provisioning_state = None
        self.protocol_type = protocol_type
        self.encryption = encryption
        self.network_acls = network_acls


class VolumeGroupList(_serialization.Model):
    """List of Volume Groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: An array of Volume Groups objects. Required.
    :vartype value: list[~azure.mgmt.elasticsan.models.VolumeGroup]
    :ivar next_link: URI to fetch the next section of the paginated response.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VolumeGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.VolumeGroup"], **kwargs):
        """
        :keyword value: An array of Volume Groups objects. Required.
        :paramtype value: list[~azure.mgmt.elasticsan.models.VolumeGroup]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class VolumeGroupUpdate(_serialization.Model):
    """Volume Group request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar protocol_type: Type of storage target. Known values are: "Iscsi" and "None".
    :vartype protocol_type: str or ~azure.mgmt.elasticsan.models.StorageTargetType
    :ivar encryption: Type of encryption. "EncryptionAtRestWithPlatformKey"
    :vartype encryption: str or ~azure.mgmt.elasticsan.models.EncryptionType
    :ivar network_acls: A collection of rules governing the accessibility from specific network
     locations.
    :vartype network_acls: ~azure.mgmt.elasticsan.models.NetworkRuleSet
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "protocol_type": {"key": "properties.protocolType", "type": "str"},
        "encryption": {"key": "properties.encryption", "type": "str"},
        "network_acls": {"key": "properties.networkAcls", "type": "NetworkRuleSet"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        protocol_type: Optional[Union[str, "_models.StorageTargetType"]] = None,
        encryption: Optional[Union[str, "_models.EncryptionType"]] = None,
        network_acls: Optional["_models.NetworkRuleSet"] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword protocol_type: Type of storage target. Known values are: "Iscsi" and "None".
        :paramtype protocol_type: str or ~azure.mgmt.elasticsan.models.StorageTargetType
        :keyword encryption: Type of encryption. "EncryptionAtRestWithPlatformKey"
        :paramtype encryption: str or ~azure.mgmt.elasticsan.models.EncryptionType
        :keyword network_acls: A collection of rules governing the accessibility from specific network
         locations.
        :paramtype network_acls: ~azure.mgmt.elasticsan.models.NetworkRuleSet
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.protocol_type = protocol_type
        self.encryption = encryption
        self.network_acls = network_acls


class VolumeList(_serialization.Model):
    """List of Volumes.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: An array of Volume objects. Required.
    :vartype value: list[~azure.mgmt.elasticsan.models.Volume]
    :ivar next_link: URI to fetch the next section of the paginated response.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Volume]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Volume"], **kwargs):
        """
        :keyword value: An array of Volume objects. Required.
        :paramtype value: list[~azure.mgmt.elasticsan.models.Volume]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class VolumeUpdate(_serialization.Model):
    """Response for Volume request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar size_gi_b: Volume size.
    :vartype size_gi_b: int
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "size_gi_b": {"key": "properties.sizeGiB", "type": "int"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, size_gi_b: Optional[int] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword size_gi_b: Volume size.
        :paramtype size_gi_b: int
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.size_gi_b = size_gi_b
