# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.compute import ComputeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeManagementGalleryApplicationVersionsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gallery_application_versions_list_by_gallery_application(self, resource_group):
        response = self.client.gallery_application_versions.list_by_gallery_application(
            resource_group_name=resource_group.name,
            gallery_name="str",
            gallery_application_name="str",
            api_version="2025-03-03",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gallery_application_versions_get(self, resource_group):
        response = self.client.gallery_application_versions.get(
            resource_group_name=resource_group.name,
            gallery_name="str",
            gallery_application_name="str",
            gallery_application_version_name="str",
            api_version="2025-03-03",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gallery_application_versions_begin_create_or_update(self, resource_group):
        response = self.client.gallery_application_versions.begin_create_or_update(
            resource_group_name=resource_group.name,
            gallery_name="str",
            gallery_application_name="str",
            gallery_application_version_name="str",
            gallery_application_version={
                "location": "str",
                "id": "str",
                "name": "str",
                "provisioningState": "str",
                "publishingProfile": {
                    "source": {"mediaLink": "str", "defaultConfigurationLink": "str"},
                    "advancedSettings": {"str": "str"},
                    "customActions": [
                        {
                            "name": "str",
                            "script": "str",
                            "description": "str",
                            "parameters": [
                                {
                                    "name": "str",
                                    "defaultValue": "str",
                                    "description": "str",
                                    "required": bool,
                                    "type": "str",
                                }
                            ],
                        }
                    ],
                    "enableHealthCheck": bool,
                    "endOfLifeDate": "2020-02-20 00:00:00",
                    "excludeFromLatest": bool,
                    "manageActions": {"install": "str", "remove": "str", "update": "str"},
                    "publishedDate": "2020-02-20 00:00:00",
                    "replicaCount": 0,
                    "replicationMode": "str",
                    "settings": {"configFileName": "str", "packageFileName": "str", "scriptBehaviorAfterReboot": "str"},
                    "storageAccountStrategy": "str",
                    "storageAccountType": "str",
                    "targetExtendedLocations": [
                        {
                            "encryption": {
                                "dataDiskImages": [{"lun": 0, "diskEncryptionSetId": "str"}],
                                "osDiskImage": {
                                    "diskEncryptionSetId": "str",
                                    "securityProfile": {
                                        "confidentialVMEncryptionType": "str",
                                        "secureVMDiskEncryptionSetId": "str",
                                    },
                                },
                            },
                            "extendedLocation": {"name": "str", "type": "str"},
                            "extendedLocationReplicaCount": 0,
                            "name": "str",
                            "storageAccountType": "str",
                        }
                    ],
                    "targetRegions": [
                        {
                            "name": "str",
                            "additionalReplicaSets": [{"regionalReplicaCount": 0, "storageAccountType": "str"}],
                            "encryption": {
                                "dataDiskImages": [{"lun": 0, "diskEncryptionSetId": "str"}],
                                "osDiskImage": {
                                    "diskEncryptionSetId": "str",
                                    "securityProfile": {
                                        "confidentialVMEncryptionType": "str",
                                        "secureVMDiskEncryptionSetId": "str",
                                    },
                                },
                            },
                            "excludeFromLatest": bool,
                            "regionalReplicaCount": 0,
                            "storageAccountType": "str",
                        }
                    ],
                },
                "replicationStatus": {
                    "aggregatedState": "str",
                    "summary": [{"details": "str", "progress": 0, "region": "str", "state": "str"}],
                },
                "safetyProfile": {"allowDeletionOfReplicatedLocations": bool},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2025-03-03",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gallery_application_versions_begin_update(self, resource_group):
        response = self.client.gallery_application_versions.begin_update(
            resource_group_name=resource_group.name,
            gallery_name="str",
            gallery_application_name="str",
            gallery_application_version_name="str",
            gallery_application_version={
                "id": "str",
                "name": "str",
                "provisioningState": "str",
                "publishingProfile": {
                    "source": {"mediaLink": "str", "defaultConfigurationLink": "str"},
                    "advancedSettings": {"str": "str"},
                    "customActions": [
                        {
                            "name": "str",
                            "script": "str",
                            "description": "str",
                            "parameters": [
                                {
                                    "name": "str",
                                    "defaultValue": "str",
                                    "description": "str",
                                    "required": bool,
                                    "type": "str",
                                }
                            ],
                        }
                    ],
                    "enableHealthCheck": bool,
                    "endOfLifeDate": "2020-02-20 00:00:00",
                    "excludeFromLatest": bool,
                    "manageActions": {"install": "str", "remove": "str", "update": "str"},
                    "publishedDate": "2020-02-20 00:00:00",
                    "replicaCount": 0,
                    "replicationMode": "str",
                    "settings": {"configFileName": "str", "packageFileName": "str", "scriptBehaviorAfterReboot": "str"},
                    "storageAccountStrategy": "str",
                    "storageAccountType": "str",
                    "targetExtendedLocations": [
                        {
                            "encryption": {
                                "dataDiskImages": [{"lun": 0, "diskEncryptionSetId": "str"}],
                                "osDiskImage": {
                                    "diskEncryptionSetId": "str",
                                    "securityProfile": {
                                        "confidentialVMEncryptionType": "str",
                                        "secureVMDiskEncryptionSetId": "str",
                                    },
                                },
                            },
                            "extendedLocation": {"name": "str", "type": "str"},
                            "extendedLocationReplicaCount": 0,
                            "name": "str",
                            "storageAccountType": "str",
                        }
                    ],
                    "targetRegions": [
                        {
                            "name": "str",
                            "additionalReplicaSets": [{"regionalReplicaCount": 0, "storageAccountType": "str"}],
                            "encryption": {
                                "dataDiskImages": [{"lun": 0, "diskEncryptionSetId": "str"}],
                                "osDiskImage": {
                                    "diskEncryptionSetId": "str",
                                    "securityProfile": {
                                        "confidentialVMEncryptionType": "str",
                                        "secureVMDiskEncryptionSetId": "str",
                                    },
                                },
                            },
                            "excludeFromLatest": bool,
                            "regionalReplicaCount": 0,
                            "storageAccountType": "str",
                        }
                    ],
                },
                "replicationStatus": {
                    "aggregatedState": "str",
                    "summary": [{"details": "str", "progress": 0, "region": "str", "state": "str"}],
                },
                "safetyProfile": {"allowDeletionOfReplicatedLocations": bool},
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2025-03-03",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gallery_application_versions_begin_delete(self, resource_group):
        response = self.client.gallery_application_versions.begin_delete(
            resource_group_name=resource_group.name,
            gallery_name="str",
            gallery_application_name="str",
            gallery_application_version_name="str",
            api_version="2025-03-03",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
