import qbs.FileInfo
import qbs.Host

Project {
    property bool shouldInstallLibrary: true
    property bool lazy: false

    Application {
        condition: {
            var result = qbs.targetPlatform === Host.platform() && qbs.architecture === Host.architecture();
            if (!result)
                console.info("target platform/arch differ from host platform/arch");
            return result;
        }
        Depends { name: "cpp" }
        Depends {
            name: "functions";
            cpp.symbolLinkMode: product.symbolLinkMode
            cpp.link: !(product.qbs.targetOS.includes("linux") && product.symbolLinkMode === "weak")
        }

        property string symbolLinkMode: project.lazy ? "lazy" : "weak"

        name: "driver"
        files: ["main.cpp"]
        consoleApplication: true
        installDir: "bin"
        property string installLib: "SHOULD_INSTALL_LIB=" + project.shouldInstallLibrary
        cpp.defines: {
            if (symbolLinkMode === "weak") {
                return qbs.targetOS.includes("darwin")
                        ? ["WEAK_IMPORT=__attribute__((weak_import))", installLib]
                        : ["WEAK_IMPORT=__attribute__((weak))", installLib];
            }
            return ["WEAK_IMPORT=", installLib];
        }
        cpp.cxxLanguageVersion: "c++11"
        cpp.minimumMacosVersion: "10.7"
        cpp.rpaths: [cpp.rpathOrigin + "/../lib"]
    }

    DynamicLibrary {
        Depends { name: "cpp" }
        Depends { name: "indirect"; cpp.symbolLinkMode: "reexport" }

        Properties {
            condition: qbs.targetOS.includes("darwin")
            bundle.isBundle: false
        }
        name: "functions"
        files: ["lib.cpp"]
        install: project.shouldInstallLibrary
        installDir: "lib"
        cpp.cxxLanguageVersion: "c++11"
        cpp.minimumMacosVersion: "10.7"
        cpp.rpaths: [cpp.rpathOrigin]

        Properties {
            condition: qbs.targetOS.includes("darwin")
            cpp.sonamePrefix: "@rpath"
        }

        Export {
            // let the autotest pass on Linux where reexport is not supported
            Depends { name: "indirect"; condition: !qbs.targetOS.includes("darwin") }

            // on Linux, there is no LC_WEAK_LOAD_DYLIB equivalent (the library is simply omitted
            // from the list of load commands entirely), so use LD_PRELOAD to emulate
            qbs.commonRunEnvironment: {
                var env = original || {};
                if (project.shouldInstallLibrary) {
                    env["LD_PRELOAD"] = FileInfo.joinPaths(qbs.installRoot,
                                                           "lib", "libfunctions.so");
                }
                return env;
            }
        }
    }

    DynamicLibrary {
        Depends { name: "cpp" }

        Properties {
            condition: qbs.targetOS.includes("darwin")
            bundle.isBundle: false
        }
        name: "indirect"
        installDir: "lib"
        files: ["indirect.cpp"]
        cpp.cxxLanguageVersion: "c++11"
        cpp.minimumMacosVersion: "10.7"

        Properties {
            condition: qbs.targetOS.includes("darwin")
            // reexport is incompatible with rpath,
            // "ERROR: ld: file not found: @rpath/libindirect.dylib for architecture x86_64"
            cpp.sonamePrefix: qbs.installRoot + "/lib"
        }
    }
}
