% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSparseMatrix.R
\name{readSparseMatrix}
\alias{readSparseMatrix}
\title{Read a sparse matrix from disk}
\usage{
readSparseMatrix(path, metadata, ...)
}
\arguments{
\item{path}{String containing a path to a directory, itself created by the \code{\link{saveObject}} method for a spars matrix.}

\item{metadata}{Named list of metadata for this object, see \code{\link{readObject}} for more details.}

\item{...}{Further arguments, ignored.}
}
\value{
A sparse \linkS4class{ReloadedMatrix} object.
}
\description{
Read a sparse matrix from its on-disk representation.
This is usually not directly called by users, but is instead called by dispatch in \code{\link{readObject}}.
}
\examples{
mat <- Matrix::rsparsematrix(100, 200, density=0.2)
rownames(mat) <- paste0("GENE_", seq_len(nrow(mat)))
dir <- tempfile()
saveObject(mat, dir)
readObject(dir)

}
\seealso{
\code{"\link{saveObject,sparseMatrix-method}"}, to create the directory and its contents.
}
\author{
Aaron Lun
}
