% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDots.R
\name{plotDots}
\alias{plotDots}
\title{Create a dot plot of expression values}
\usage{
plotDots(
  object,
  features,
  group = NULL,
  block = NULL,
  exprs_values = "logcounts",
  detection_limit = 0,
  low_color = "white",
  high_color = "red",
  max_ave = NULL,
  max_detected = NULL,
  other_fields = list(),
  by_exprs_values = exprs_values,
  swap_rownames = NULL
)
}
\arguments{
\item{object}{A \linkS4class{SingleCellExperiment} object.}

\item{features}{A character vector of feature names to show as rows of the dot plot.}

\item{group}{Specification of a column metadata field to show as columns.
Alternatively, an \link{AsIs} vector, see \code{?\link{retrieveCellInfo}} for details.}

\item{block}{Specification of a column metadata field containing the blocking factors, e.g., batch of origin for each cell. 
Alternatively, an \link{AsIs} vector, see \code{?\link{retrieveCellInfo}} for details.}

\item{exprs_values}{A string or integer scalar specifying which assay in \code{assays(object)} to obtain expression values from.}

\item{detection_limit}{Numeric scalar providing the value above which observations are deemed to be expressed.
This is also used as the}

\item{low_color}{String specifying the color to use for low expression.
This is also used as the background color, see Details.}

\item{high_color}{String specifying the color to use for high expression.}

\item{max_ave}{Numeric value specifying the cap on the average expression.}

\item{max_detected}{Numeric value specifying the cap on the proportion of detected expression values.}

\item{other_fields}{Additional feature-based fields to include in the data.frame, see \code{?"\link{scater-plot-args}"} for details.
Note that any \link{AsIs} vectors or data.frames must be of length equal to \code{nrow(object)}, not \code{features}.}

\item{by_exprs_values}{A string or integer scalar specifying which assay to obtain expression values from,
to use when extracting values according to each entry of \code{other_fields}.}

\item{swap_rownames}{Column name of \code{rowData(object)} to be used to 
identify features instead of \code{rownames(object)} when labelling plot 
elements.}
}
\value{
A \link{ggplot} object containing a dot plot.
}
\description{
Create a dot plot of expression values for a grouping of cells,
where the size and color of each dot represents the proportion of detected expression values and the average expression,
respectively, for each feature in each group of cells.
}
\details{
This implements a \pkg{Seurat}-style \dQuote{dot plot} that creates a dot for each feature (row) in each group of cells (column).
The proportion of detected expression values and the average expression for each feature in each group of cells is visualized efficiently using the size and colour, respectively, of each dot.
If \code{block} is specified, batch-corrected averages for each group are computed with \code{\link{batchCorrectedAverages}}.

We impose two restrictions - the low end of the color scale must correspond to the detection limit,
and the color at this end of the scale must be the same as the background color.
These ensure that the visual cues from low average expression or low detected proportions are consistent,
as both will result in a stronger \code{low_color}.
(In the latter case, the reduced size of the dot means that the background color dominates.)

If these restrictions are violated, visualization can be misleading due to the difficulty of simultaneously interpreting both size and color.
For example, if we colored by z-score on a conventional blue-white-red color axis, a gene that is downregulated in a group of cells would show up as a small blue dot.
If the background color was also white, this might be mistaken for a gene that is not downregulated at all.
On the other hand, any other background color would effectively require consideration of two color axes as expression decreases.

We can also cap the color and size scales at \code{max_ave} and \code{max_detected}, respectively.
This aims to preserve resolution for low-abundance genes by preventing domination of the scales by high-abundance features.
}
\examples{
sce <- mockSCE()
sce <- logNormCounts(sce)

plotDots(sce, features=rownames(sce)[1:10], group="Cell_Cycle")

plotDots(sce, features=rownames(sce)[1:10], group="Treatment", block="Cell_Cycle")

}
\seealso{
\code{\link{plotExpression}} and \code{\link{plotHeatmap}}, 
for alternatives to visualizing group-level expression values.
}
\author{
Aaron Lun
}
