% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ra-ref.R
\name{as.ra_ref}
\alias{as.ra_ref}
\alias{as.ra_ref.cell_addr}
\alias{as.ra_ref.character}
\alias{as.ra_ref_v}
\alias{as.ra_ref_v.cell_addr}
\alias{as.ra_ref_v.character}
\title{Convert to a ra_ref object}
\usage{
as.ra_ref(x, ...)

as.ra_ref_v(x, ...)

\method{as.ra_ref}{character}(x, fo = NULL, strict = TRUE, ...)

\method{as.ra_ref_v}{character}(x, fo = NULL, strict = TRUE, ...)

\method{as.ra_ref}{cell_addr}(x, ...)

\method{as.ra_ref_v}{cell_addr}(x, ...)
}
\arguments{
\item{x}{one or more cell references, as a character vector or
\code{\link{cell_addr}} object}

\item{...}{further arguments passed to or from other methods}

\item{fo}{either \code{"R1C1"} (the default) or \code{"A1"} specifying the
cell reference format; in many contexts, it can be inferred and is optional}

\item{strict}{logical, affects reading and writing of A1 formatted cell
references. When \code{strict = TRUE}, references must be declared absolute
through the use of dollar signs, e.g., \code{$A$1},  for parsing. When
making a string, \code{strict = TRUE} requests dollar signs for absolute
reference. When \code{strict = FALSE}, pure relative reference strings will
be interpreted as absolute, i.e. \code{A1} and \code{$A$1} are treated the
same. When making a string, \code{strict = FALSE} will cause dollars signs
to be omitted in the reference string.}
}
\value{
a \code{\link{ra_ref}} object, in the case of \code{as.ra_ref}, or a
  list of them, in the case of \code{as.ra_ref_v}
}
\description{
Convert various representations of a cell reference into an object of class
\code{\link{ra_ref}}.
\itemize{
\item \code{as.ra_ref} is NOT vectorized and therefore requires the input to
represent exactly one cell, i.e. be of length 1.
\item \code{as.ra_ref_v} accepts input of length >= 1 and returns a list of
\code{\link{ra_ref}} objects.
}
}
\examples{
## as.ra_ref.character()
as.ra_ref("$F$2")
as.ra_ref("R[-4]C3")
as.ra_ref("B4")
as.ra_ref("B4", strict = FALSE)
as.ra_ref("B$4")

## this is actually ambiguous! is format A1 or R1C1 format?
as.ra_ref("RC2")
## format could be specified in this case
as.ra_ref("RC2", fo = "R1C1")
as.ra_ref("RC2", fo = "A1", strict = FALSE)

## as.ra_ref_v.character()
cs <- c("$A$1", "Sheet1!$F$14", "Sheet2!B$4", "D9")
\dontrun{
## won't work because as.ra_ref requires length one input
as.ra_ref(cs)
}
## use as.ra_ref_v instead
as.ra_ref_v(cs, strict = FALSE)
## as.ra_ref.cell_addr
ca <- cell_addr(2, 5)
as.ra_ref(ca)
## as.ra_ref_v.cell_addr()

ca <- cell_addr(1:3, 1)
\dontrun{
## won't work because as.ra_ref methods not natively vectorized
as.ra_ref(ca)
}
## use as.ra_ref_v instead
as.ra_ref_v(ca)
}

