% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ansi-palette.R
\docType{data}
\name{truecolor}
\alias{truecolor}
\alias{ansi_palettes}
\alias{ansi_palette_show}
\title{ANSI colors palettes}
\format{
\code{truecolor} is an integer scalar.

\code{ansi_palettes} is a data frame with one row for each palette,
and one column for each base ANSI color. \code{attr(ansi_palettes, "info")}
contains a list with information about each palette.
}
\usage{
truecolor

ansi_palettes

ansi_palette_show(palette = NULL, colors = num_ansi_colors(), rows = 4)
}
\arguments{
\item{palette}{The palette to show, in the same format as for the
\code{cli.palette} option, so it can be the name of a built-in palette,
of a list of 16 colors.}

\item{colors}{Number of ANSI colors to use the show the palette. If the
platform does not have sufficient support, the output might have
a lower color resolution. Without color support it will have no color
at all.}

\item{rows}{The number of colored rows to print.}
}
\value{
\code{ansi_palette_show} returns a character vector, the rows that
are printed to the screen, invisibly.
}
\description{
If your platform supports at least 256 colors, then you can configure
the colors that cli uses for the eight base and the eight bright colors.
(I.e. the colors of \code{\link[=col_black]{col_black()}}, \code{\link[=col_red]{col_red()}}, and \code{\link[=col_br_black]{col_br_black()}},
\code{\link[=col_br_red]{col_br_red()}}, etc.
}
\details{
\code{truecolor} is an integer constant for the number of 24 bit ANSI colors.

To customize the default palette, set the \code{cli.palette} option to the
name of a built-in palette (see \code{ansi_palettes()}), or the list of
16 colors. Colors can be specified with RGB colors strings:
\verb{#rrggbb} or R color names (see the output of \code{\link[grDevices:colors]{grDevices::colors()}}).

For example, you can put this in your R profile:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{options(cli.palette = "vscode")
}\if{html}{\out{</div>}}

It is currently not possible to configure the background colors
separately, these will be always the same as the foreground colors.

If your platform only has 256 colors, then the colors specified in the
palette have to be interpolated. On true color platforms they RGB
values are used as-is.

\code{ansi_palettes} is a data frame of the built-in palettes, each row
is one palette.

\code{ansi_palette_show()} shows the colors of an ANSI palette on the screen.
}
\examples{
ansi_palettes
ansi_palette_show("dichro", colors = truecolor)
}
\keyword{datasets}
