% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse_re_data.R
\name{collapse_by_group}
\alias{collapse_by_group}
\title{Collapse raw data by random effect groups}
\usage{
collapse_by_group(grid, model, collapse.by = NULL, residuals = FALSE)
}
\arguments{
\item{grid}{A data frame representing the data grid, or an object of class
\code{ggeffects}, as returned by \code{ggpredict()} and others.}

\item{model}{The model for which to compute partial residuals. The data grid
\code{grid} should match to predictors in the model.}

\item{collapse.by}{Name of the (random effects) grouping factor. Data is
collapsed by the levels of this factor.}

\item{residuals}{Logical, if \code{TRUE}, collapsed partial residuals instead
of raw data by the levels of the grouping factor.}
}
\value{
A data frame with raw data points, averaged over the levels of
the given grouping factor from the random effects. The group level of
the random effect is saved in the column \code{"random"}.
}
\description{
This function extracts the raw data points (i.e. the data
that was used to fit the model) and "averages" (i.e. "collapses") the
response variable over the levels of the grouping factor given in
\code{collapse.by}. Only works with mixed models.
}
\examples{
library(ggeffects)
if (require("lme4", quietly = TRUE)) {
  data(efc)
  efc$e15relat <- as.factor(efc$e15relat)
  efc$c161sex <- as.factor(efc$c161sex)
  levels(efc$c161sex) <- c("male", "female")
  model <- lmer(neg_c_7 ~ c161sex + (1 | e15relat), data = efc)
  me <- ggpredict(model, terms = "c161sex")
  head(attributes(me)$rawdata)
  collapse_by_group(me, model, "e15relat")
}
}
