% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_accuracy.R
\name{performance_accuracy}
\alias{performance_accuracy}
\title{Accuracy of predictions from model fit}
\usage{
performance_accuracy(
  model,
  method = c("cv", "boot"),
  k = 5,
  n = 1000,
  verbose = TRUE
)
}
\arguments{
\item{model}{A linear or logistic regression model. A mixed-effects model is
also accepted.}

\item{method}{Character string, indicating whether cross-validation
(\code{method = "cv"}) or bootstrapping (\code{method = "boot"}) is used to
compute the accuracy values.}

\item{k}{The number of folds for the k-fold cross-validation.}

\item{n}{Number of bootstrap-samples.}

\item{verbose}{Toggle warnings.}
}
\value{
A list with three values: The \code{Accuracy} of the model
predictions, i.e. the proportion of accurately predicted values from the
model, its standard error, \code{SE}, and the \code{Method} used to compute
the accuracy.
}
\description{
This function calculates the predictive accuracy of linear
or logistic regression models.
}
\details{
For linear models, the accuracy is the correlation coefficient
between the actual and the predicted value of the outcome. For
logistic regression models, the accuracy corresponds to the
AUC-value, calculated with the \code{bayestestR::auc()}-function.
\cr \cr
The accuracy is the mean value of multiple correlation resp.
AUC-values, which are either computed with cross-validation
or non-parametric bootstrapping (see argument \code{method}).
The standard error is the standard deviation of the computed
correlation resp. AUC-values.
}
\examples{
model <- lm(mpg ~ wt + cyl, data = mtcars)
performance_accuracy(model)

model <- glm(vs ~ wt + mpg, data = mtcars, family = "binomial")
performance_accuracy(model)
}
