//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/filters/http/lua/v3/lua.proto

package luav3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on Lua with the rules defined in the proto
// definition for this message. If any rules are violated, the first error
// encountered is returned, or nil if there are no violations.
func (m *Lua) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Lua with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in LuaMultiError, or nil if none found.
func (m *Lua) ValidateAll() error {
	return m.validate(true)
}

func (m *Lua) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for InlineCode

	{
		sorted_keys := make([]string, len(m.GetSourceCodes()))
		i := 0
		for key := range m.GetSourceCodes() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetSourceCodes()[key]
			_ = val

			// no validation rules for SourceCodes[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, LuaValidationError{
							field:  fmt.Sprintf("SourceCodes[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, LuaValidationError{
							field:  fmt.Sprintf("SourceCodes[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return LuaValidationError{
						field:  fmt.Sprintf("SourceCodes[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	if all {
		switch v := interface{}(m.GetDefaultSourceCode()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, LuaValidationError{
					field:  "DefaultSourceCode",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, LuaValidationError{
					field:  "DefaultSourceCode",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDefaultSourceCode()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return LuaValidationError{
				field:  "DefaultSourceCode",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for StatPrefix

	if all {
		switch v := interface{}(m.GetClearRouteCache()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, LuaValidationError{
					field:  "ClearRouteCache",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, LuaValidationError{
					field:  "ClearRouteCache",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetClearRouteCache()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return LuaValidationError{
				field:  "ClearRouteCache",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return LuaMultiError(errors)
	}

	return nil
}

// LuaMultiError is an error wrapping multiple validation errors returned by
// Lua.ValidateAll() if the designated constraints aren't met.
type LuaMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m LuaMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m LuaMultiError) AllErrors() []error { return m }

// LuaValidationError is the validation error returned by Lua.Validate if the
// designated constraints aren't met.
type LuaValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LuaValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LuaValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LuaValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LuaValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LuaValidationError) ErrorName() string { return "LuaValidationError" }

// Error satisfies the builtin error interface
func (e LuaValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLua.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LuaValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LuaValidationError{}

// Validate checks the field values on LuaPerRoute with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *LuaPerRoute) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on LuaPerRoute with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in LuaPerRouteMultiError, or
// nil if none found.
func (m *LuaPerRoute) ValidateAll() error {
	return m.validate(true)
}

func (m *LuaPerRoute) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetFilterContext()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, LuaPerRouteValidationError{
					field:  "FilterContext",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, LuaPerRouteValidationError{
					field:  "FilterContext",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetFilterContext()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return LuaPerRouteValidationError{
				field:  "FilterContext",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	switch v := m.Override.(type) {
	case *LuaPerRoute_Disabled:
		if v == nil {
			err := LuaPerRouteValidationError{
				field:  "Override",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if m.GetDisabled() != true {
			err := LuaPerRouteValidationError{
				field:  "Disabled",
				reason: "value must equal true",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *LuaPerRoute_Name:
		if v == nil {
			err := LuaPerRouteValidationError{
				field:  "Override",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if utf8.RuneCountInString(m.GetName()) < 1 {
			err := LuaPerRouteValidationError{
				field:  "Name",
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *LuaPerRoute_SourceCode:
		if v == nil {
			err := LuaPerRouteValidationError{
				field:  "Override",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetSourceCode()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, LuaPerRouteValidationError{
						field:  "SourceCode",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, LuaPerRouteValidationError{
						field:  "SourceCode",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetSourceCode()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return LuaPerRouteValidationError{
					field:  "SourceCode",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return LuaPerRouteMultiError(errors)
	}

	return nil
}

// LuaPerRouteMultiError is an error wrapping multiple validation errors
// returned by LuaPerRoute.ValidateAll() if the designated constraints aren't met.
type LuaPerRouteMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m LuaPerRouteMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m LuaPerRouteMultiError) AllErrors() []error { return m }

// LuaPerRouteValidationError is the validation error returned by
// LuaPerRoute.Validate if the designated constraints aren't met.
type LuaPerRouteValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LuaPerRouteValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LuaPerRouteValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LuaPerRouteValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LuaPerRouteValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LuaPerRouteValidationError) ErrorName() string { return "LuaPerRouteValidationError" }

// Error satisfies the builtin error interface
func (e LuaPerRouteValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLuaPerRoute.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LuaPerRouteValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LuaPerRouteValidationError{}
