/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef CFG_GPIO_H
#define CFG_GPIO_H

#include <gpio.h>

#ifndef PAD_CFG_GPIO_BIDIRECT
#define PAD_CFG_GPIO_BIDIRECT(pad, val, pull, rst, trig, own)		\
	_PAD_CFG_STRUCT(pad,						\
		PAD_FUNC(GPIO) | PAD_RESET(rst) | PAD_TRIG(trig) |	\
		PAD_BUF(NO_DISABLE) | val,				\
		PAD_PULL(pull) | PAD_CFG_OWN_GPIO(own))
#endif

/* Pad configuration was generated automatically using intelp2m utility */
static const struct pad_config gpio_table[] = {

	/* ------- GPIO Community 0 ------- */

	/* ------- GPIO Group GPPC_A ------- */
	PAD_CFG_NF(GPPC_A0, NONE, RSMRST, NF1),	/* ESPI_ALERT0_N */
	PAD_CFG_NF(GPPC_A1, NONE, RSMRST, NF1),	/* ESPI_ALERT1_N */
	PAD_CFG_NF(GPPC_A2, NONE, RSMRST, NF1),	/* ESPI_IO_0 */
	PAD_CFG_NF(GPPC_A3, NONE, RSMRST, NF1),	/* ESPI_IO_1 */
	PAD_CFG_NF(GPPC_A4, NONE, RSMRST, NF1),	/* ESPI_IO_2 */
	PAD_CFG_NF(GPPC_A5, NONE, RSMRST, NF1),	/* ESPI_IO_3 */
	PAD_CFG_NF(GPPC_A6, NONE, RSMRST, NF1),	/* ESPI_CS0_N */
	PAD_CFG_NF(GPPC_A7, NONE, RSMRST, NF1),	/* ESPI_CS1_N */
	PAD_CFG_NF(GPPC_A8, NONE, RSMRST, NF1),	/* ESPI_RESET_N */
	PAD_CFG_NF(GPPC_A9, NONE, RSMRST, NF1),	/* ESPI_CLK */
	PAD_CFG_GPI_TRIG_OWN(GPPC_A10, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_A11, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_A12, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPO(GPPC_A13, 0, RSMRST),	/* GPIO */
	PAD_NC(GPPC_A14, NONE),	/* GPIO */
	PAD_NC(GPPC_A15, NONE),	/* GPIO */
	PAD_CFG_GPIO_BIDIRECT(GPPC_A16, 0, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_A17, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_A18, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_A19, NONE, RSMRST, OFF, ACPI),	/* GPIO */

	/* ------- GPIO Group GPPC_B ------- */
	PAD_CFG_GPI_TRIG_OWN(GPPC_B0, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_B1, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_B2, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_B3, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_B4, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_NF(GPPC_B5, NONE, RSMRST, NF1),	/* USB2_OC0_N */
	PAD_CFG_NF(GPPC_B6, NONE, RSMRST, NF1),	/* USB2_OC1_N */
	PAD_CFG_NF(GPPC_B7, NONE, RSMRST, NF1),	/* USB2_OC2_N */
	PAD_CFG_GPI_TRIG_OWN(GPPC_B8, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_B9, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_B10, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPO(GPPC_B11, 1, PLTRST),	/* GPIO */
	PAD_CFG_NF(GPPC_B12, NONE, DEEP, NF4),	/* 1P8_PTI_DATA5 */
	PAD_CFG_NF(GPPC_B13, NONE, DEEP, NF4),	/* 1P8_PTI_DATA6 */
	PAD_CFG_NF(GPPC_B14, NONE, DEEP, NF4),	/* 1P8_PTI_DATA7 */
	PAD_CFG_NF(GPPC_B15, NONE, DEEP, NF4),	/* 1P8_PTI_DATA8 */
	PAD_CFG_GPI_TRIG_OWN(GPPC_B16, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_B17, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_B18, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_B19, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_B20, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_B21, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPO(GPPC_B22, 0, RSMRST),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_B23, NONE, RSMRST, OFF, ACPI),	/* GPIO */

	/* ------- GPIO Group GPPC_S ------- */
	PAD_CFG_GPI_TRIG_OWN(GPPC_S0, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_NF(GPPC_S1, NONE, DEEP, NF1),	/* SPRK */
	PAD_CFG_GPI_TRIG_OWN(GPPC_S2, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_S3, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_S4, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_S5, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_S6, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_NF(GPPC_S7, NONE, RSMRST, NF1),	/* SUSACK_N */
	PAD_CFG_NF(GPPC_S8, NONE, RSMRST, NF1),	/* NMI_N */
	PAD_CFG_GPI_SMI(GPPC_S9, NONE, DEEP, LEVEL, INVERT),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_S10, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_S11, NONE, RSMRST, OFF, ACPI),	/* GPIO */

	/* ------- GPIO Community 1 ------- */

	/* ------- GPIO Group GPPC_C ------- */
	/* GPPC_C0 - RESERVED */
	/* GPPC_C1 - RESERVED */
	PAD_CFG_NF(GPPC_C2, NONE, DEEP, NF1),	/* ME_SML0ALERT_N */
	PAD_CFG_GPI_TRIG_OWN(GPPC_C3, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_C4, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPO(GPPC_C5, 1, PLTRST),	/* GPIO */
	/* GPPC_C6 - RESERVED */
	/* GPPC_C7 - RESERVED */
	/* GPPC_C8 - RESERVED */
	PAD_NC(GPPC_C9, NONE),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_C10, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	/* GPPC_C11 - RESERVED */
	/* GPPC_C12 - RESERVED */
	/* GPPC_C13 - RESERVED */
	/* GPPC_C14 - RESERVED */
	PAD_NC(GPPC_C15, NONE),	/* GPIO */
	PAD_NC(GPPC_C16, NONE),	/* GPIO */
	PAD_CFG_GPO(GPPC_C17, 0, RSMRST),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_C18, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_C19, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_C20, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_SCI(GPPC_C21, NONE, DEEP, LEVEL, INVERT),	/* GPIO */

	/* ------- GPIO Group GPP_D ------- */
	/* GPP_D0 - RESERVED */
	/* GPP_D1 - RESERVED */
	PAD_CFG_GPI_TRIG_OWN(GPP_D2, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D3, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D4, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D5, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D6, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D7, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_NF(GPP_D8, NONE, RSMRST, NF1),	/* CRASHLOG_TRIG_N */
	PAD_CFG_GPI_TRIG_OWN(GPP_D9, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D10, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_NF(GPP_D11, NONE, RSMRST, NF1),	/* PLTRST_N */
	PAD_CFG_NF(GPP_D12, NONE, RSMRST, NF1),	/* PCHHOT_N */
	/* GPP_D13 - RESERVED */
	PAD_CFG_NF(GPP_D14, NONE, RSMRST, NF1),	/* ADR_TRIGGER */
	PAD_CFG_GPI_TRIG_OWN(GPP_D15, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_NF(GPP_D16, NONE, RSMRST, NF1),	/* ADR_ACK */
	/* GPP_D17 - RESERVED */
	PAD_CFG_GPI_TRIG_OWN(GPP_D18, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D19, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D20, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_NF(GPP_D21, NONE, RSMRST, NF1),	/* GLB_RST_WARN_N */
	PAD_CFG_GPI_TRIG_OWN(GPP_D22, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D23, NONE, RSMRST, OFF, ACPI),	/* GPIO */

	/* ------- GPIO Community 3 ------- */

	/* ------- GPIO Group GPP_E ------- */
	PAD_CFG_GPI_NMI(GPP_E0, NONE, PLTRST, LEVEL, INVERT),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_E1, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_NF(GPP_E2, NONE, RSMRST, NF1),	/* SATA1_XPCIE_2 */
	PAD_CFG_NF(GPP_E3, NONE, RSMRST, NF1),	/* SATA1_XPCIE_3 */
	PAD_CFG_NF(GPP_E4, NONE, RSMRST, NF1),	/* SATA0_XPCIE_2 */
	PAD_CFG_NF(GPP_E5, NONE, RSMRST, NF1),	/* SATA0_XPCIE_1 */
	PAD_CFG_NF(GPP_E6, NONE, RSMRST, NF1),	/* SATA0_USB3_XPCIE_0 */
	PAD_CFG_NF(GPP_E7, NONE, RSMRST, NF1),	/* SATA0_USB3_XPCIE_1 */
	PAD_CFG_NF(GPP_E8, NONE, PLTRST, NF2),	/* SATA0_LED_N */
	PAD_CFG_GPI_TRIG_OWN(GPP_E9, NONE, PLTRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_E10, NONE, PLTRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_E11, NONE, PLTRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_E12, NONE, PLTRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_E13, NONE, PLTRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_E14, NONE, PLTRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_E15, NONE, PLTRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_E16, NONE, PLTRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_E17, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_E18, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_E19, NONE, RSMRST, OFF, ACPI),	/* GPIO */

	/* ------- GPIO Group JTAG ------- */

	/* ------- GPIO Community 4 ------- */

	/* ------- GPIO Group GPPC_H ------- */
	PAD_CFG_GPI_TRIG_OWN(GPPC_H0, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	/* GPPC_H1 - RESERVED */
	PAD_CFG_GPI_TRIG_OWN(GPPC_H2, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_H3, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_H4, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_H5, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_H6, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_H7, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_H8, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_H9, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_H10, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_H11, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_H12, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_H13, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_H14, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPO(GPPC_H15, 0, PLTRST),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_H16, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_H17, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPO(GPPC_H18, 0, PLTRST),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPPC_H19, NONE, RSMRST, OFF, ACPI),	/* GPIO */

	/* ------- GPIO Group GPP_J ------- */
	PAD_CFG_NF(GPP_J0, NONE, DEEP, NF1),	/* CPUPWRGD */
	/* GPP_J1 - RESERVED */
	PAD_CFG_NF(GPP_J2, NONE, DEEP, NF1),	/* PLTRST_CPU_N */
	PAD_CFG_NF(GPP_J3, NONE, DEEP, NF1),	/* TRIGGER0_N */
	PAD_CFG_NF(GPP_J4, NONE, DEEP, NF1),	/* TRIGGER1_N */
	/* GPP_J5 - RESERVED */
	PAD_CFG_GPI_TRIG_OWN(GPP_J6, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_J7, NONE, DEEP, OFF, ACPI),	/* GPIO */
	/* GPP_J8 - RESERVED */
	PAD_CFG_GPI_TRIG_OWN(GPP_J9, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_J10, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_J11, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_J12, UP_20K, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_J13, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_J14, UP_20K, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_J15, UP_20K, DEEP, OFF, ACPI),	/* GPIO */

	/* ------- GPIO Community 5 ------- */

	/* ------- GPIO Group GPP_I ------- */
	PAD_CFG_GPI_TRIG_OWN(GPP_I0, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I1, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I2, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I3, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I4, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I5, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I6, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I7, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I8, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I9, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I10, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I11, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I12, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I13, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I14, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I15, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I16, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I17, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I18, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I19, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I20, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I21, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I22, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I23, NONE, RSMRST, OFF, ACPI),	/* GPIO */

	/* ------- GPIO Group GPP_L ------- */
	/* GPP_L0 - RESERVED */
	/* GPP_L1 - RESERVED */
	PAD_CFG_GPI_TRIG_OWN(GPP_L2, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_L3, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	/* GPP_L4 - RESERVED */
	PAD_CFG_GPI_TRIG_OWN(GPP_L5, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_L6, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_L7, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_L8, NONE, RSMRST, OFF, ACPI),	/* GPIO */

	/* ------- GPIO Group GPP_M ------- */
	PAD_CFG_GPI_TRIG_OWN(GPP_M0, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_M1, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_M2, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_M3, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_M4, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_M5, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_M6, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_M7, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_M8, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_M9, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_M10, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_M11, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_M12, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_M13, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_M14, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_M15, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_M16, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_M17, NONE, RSMRST, OFF, ACPI),	/* GPIO */

	/* ------- GPIO Group GPP_N ------- */
	PAD_CFG_GPI_TRIG_OWN(GPP_N0, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_N1, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_N2, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_N3, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_N4, NONE, RSMRST, OFF, ACPI),	/* GPIO */
};

#endif /* CFG_GPIO_H */
