/**
 * JA4 tests.
 *
 * @author n1474335 [n1474335@gmail.com]
 * @copyright Crown Copyright 2024
 * @license Apache-2.0
 */
import TestRegister from "../../lib/TestRegister.mjs";

TestRegister.addTests([
    {
        name: "JA4 Fingerprint: TLS 1.3",
        input: "1603010200010001fc0303b2c03e7ba990ef540c316a665d4d925f8e9079ac4b15687e587dc99016e75a6c20d0b0099243c9296a0c84153ea4ada7d87ad017f4211c2ea1350b0b3cc5514d5f00205a5a130113021303c02bc02fc02cc030cca9cca8c013c014009c009d002f003501000193fafa000000000024002200001f636f6e74656e742d6175746f66696c6c2e676f6f676c65617069732e636f6d0033002b00293a3a000100001d0020fb2cd8ef3d605b96ab03119ec4f30a6e2088cb1af86c41a81feace8706068c50000d001200100403080404010503080505010806060100230000000b00020100ff01000100000a000a00083a3a001d00170018001b000302000244690005000302683200120000002d000201010010000e000c02683208687474702f312e31000500050100000000002b0007060a0a03040303001700001a1a000100001500b800000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
        expectedOutput: "t13d1516h2_8daaf6152771_e5627efa2ab1",
        recipeConfig: [
            {
                "op": "JA4 Fingerprint",
                "args": ["Hex", "JA4"]
            }
        ],
    },
    {
        name: "JA4 Fingerprint: TLS 1.3 Original Rendering",
        input: "1603010200010001fc0303b2c03e7ba990ef540c316a665d4d925f8e9079ac4b15687e587dc99016e75a6c20d0b0099243c9296a0c84153ea4ada7d87ad017f4211c2ea1350b0b3cc5514d5f00205a5a130113021303c02bc02fc02cc030cca9cca8c013c014009c009d002f003501000193fafa000000000024002200001f636f6e74656e742d6175746f66696c6c2e676f6f676c65617069732e636f6d0033002b00293a3a000100001d0020fb2cd8ef3d605b96ab03119ec4f30a6e2088cb1af86c41a81feace8706068c50000d001200100403080404010503080505010806060100230000000b00020100ff01000100000a000a00083a3a001d00170018001b000302000244690005000302683200120000002d000201010010000e000c02683208687474702f312e31000500050100000000002b0007060a0a03040303001700001a1a000100001500b800000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
        expectedOutput: "t13d1516h2_acb858a92679_5276cb03a33b",
        recipeConfig: [
            {
                "op": "JA4 Fingerprint",
                "args": ["Hex", "JA4 Original Rendering"]
            }
        ],
    },
    {
        name: "JA4 Fingerprint: TLS 1.2",
        input: "1603010200010001fc0303ecb2691addb2bf6c599c7aaae23de5f42561cc04eb41029acc6fc050a16ac1d22046f8617b580ac9358e2aa44e306d52466bcc989c87c8ca64309f5faf50ba7b4d0022130113031302c02bc02fcca9cca8c02cc030c00ac009c013c014009c009d002f00350100019100000021001f00001c636f6e74696c652e73657276696365732e6d6f7a696c6c612e636f6d00170000ff01000100000a000e000c001d00170018001901000101000b00020100002300000010000e000c02683208687474702f312e310005000501000000000022000a000804030503060302030033006b0069001d00208909858fbeb6ed2f1248ba5b9e2978bead0e840110192c61daed0096798b184400170041044d183d91f5eed35791fa982464e3b0214aaa5f5d1b78616d9b9fbebc22d11f535b2f94c686143136aa795e6e5a875d6c08064ad5b76d44caad766e2483012748002b00050403040303000d0018001604030503060308040805080604010501060102030201002d00020101001c000240010015007a0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
        expectedOutput: "t13d1715h2_5b57614c22b0_3d5424432f57",
        recipeConfig: [
            {
                "op": "JA4 Fingerprint",
                "args": ["Hex", "JA4"]
            }
        ],
    },
    {
        name: "JA4 Fingerprint: TLS 1.2 Original Rendering",
        input: "1603010200010001fc0303ecb2691addb2bf6c599c7aaae23de5f42561cc04eb41029acc6fc050a16ac1d22046f8617b580ac9358e2aa44e306d52466bcc989c87c8ca64309f5faf50ba7b4d0022130113031302c02bc02fcca9cca8c02cc030c00ac009c013c014009c009d002f00350100019100000021001f00001c636f6e74696c652e73657276696365732e6d6f7a696c6c612e636f6d00170000ff01000100000a000e000c001d00170018001901000101000b00020100002300000010000e000c02683208687474702f312e310005000501000000000022000a000804030503060302030033006b0069001d00208909858fbeb6ed2f1248ba5b9e2978bead0e840110192c61daed0096798b184400170041044d183d91f5eed35791fa982464e3b0214aaa5f5d1b78616d9b9fbebc22d11f535b2f94c686143136aa795e6e5a875d6c08064ad5b76d44caad766e2483012748002b00050403040303000d0018001604030503060308040805080604010501060102030201002d00020101001c000240010015007a0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
        expectedOutput: "t13d1715h2_5b234860e130_014157ec0da2",
        recipeConfig: [
            {
                "op": "JA4 Fingerprint",
                "args": ["Hex", "JA4 Original Rendering"]
            }
        ],
    },
    {
        name: "JA4Server Fingerprint: TLS 1.2 h2 ALPN",
        input: "16030300640200006003035f0236c07f47bfb12dc2da706ecb3fe7f9eeac9968cc2ddf444f574e4752440120b89ff1ab695278c69b8a73f76242ef755e0b13dc6d459aaaa784fec9c2dfce34cca900001800000000ff01000100000b00020100001000050003026832",
        expectedOutput: "t1204h2_cca9_1428ce7b4018",
        recipeConfig: [
            {
                "op": "JA4Server Fingerprint",
                "args": ["Hex", "JA4S"]
            }
        ]
    },
    {
        name: "JA4Server Fingerprint: TLS 1.2 h2 ALPN Raw",
        input: "16030300640200006003035f0236c07f47bfb12dc2da706ecb3fe7f9eeac9968cc2ddf444f574e4752440120b89ff1ab695278c69b8a73f76242ef755e0b13dc6d459aaaa784fec9c2dfce34cca900001800000000ff01000100000b00020100001000050003026832",
        expectedOutput: "t1204h2_cca9_0000,ff01,000b,0010",
        recipeConfig: [
            {
                "op": "JA4Server Fingerprint",
                "args": ["Hex", "JA4S Raw"]
            }
        ]
    },
    {
        name: "JA4Server Fingerprint: TLS 1.3",
        input: "160303007a020000760303236d214556452c55a0754487e64b1a8b0262c50ba23004c9d504166a6de3439920d0b0099243c9296a0c84153ea4ada7d87ad017f4211c2ea1350b0b3cc5514d5f130100002e00330024001d002099e3cc43a2c9941ae75af1b2c7a629bee3ee7031973cad85c82f2f23677fb244002b00020304",
        expectedOutput: "t130200_1301_234ea6891581",
        recipeConfig: [
            {
                "op": "JA4Server Fingerprint",
                "args": ["Hex", "JA4S"]
            }
        ]
    },
    {
        name: "JA4Server Fingerprint: TLS 1.3 Raw",
        input: "160303007a020000760303236d214556452c55a0754487e64b1a8b0262c50ba23004c9d504166a6de3439920d0b0099243c9296a0c84153ea4ada7d87ad017f4211c2ea1350b0b3cc5514d5f130100002e00330024001d002099e3cc43a2c9941ae75af1b2c7a629bee3ee7031973cad85c82f2f23677fb244002b00020304",
        expectedOutput: "t130200_1301_0033,002b",
        recipeConfig: [
            {
                "op": "JA4Server Fingerprint",
                "args": ["Hex", "JA4S Raw"]
            }
        ]
    },
    {
        name: "JA4Server Fingerprint: TLS 1.3 non-ascii ALPN",
        input: "160303007a020000760303897c232e3ee313314f2b662307ff4f7e2cf1caeec1b27711bca77f469519168520bc58b92f865e6b9aa4a6371cadcb0afe1da1c0f705209a11d52357f56d5dd962130100002e00330024001d002076b8b7ed0f96b63a773d85ab6f3a87a151c130529785b41a4defb53184055957002b00020304",
        expectedOutput: "t130200_1301_234ea6891581",
        recipeConfig: [
            {
                "op": "JA4Server Fingerprint",
                "args": ["Hex", "JA4S"]
            }
        ]
    },
    {
        name: "JA4Server Fingerprint: TLS 1.3 non-ascii ALPN Raw",
        input: "160303007a020000760303897c232e3ee313314f2b662307ff4f7e2cf1caeec1b27711bca77f469519168520bc58b92f865e6b9aa4a6371cadcb0afe1da1c0f705209a11d52357f56d5dd962130100002e00330024001d002076b8b7ed0f96b63a773d85ab6f3a87a151c130529785b41a4defb53184055957002b00020304",
        expectedOutput: "t130200_1301_0033,002b",
        recipeConfig: [
            {
                "op": "JA4Server Fingerprint",
                "args": ["Hex", "JA4S Raw"]
            }
        ]
    },
]);
