//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappservice

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// CertificateOrdersClient contains the methods for the AppServiceCertificateOrders group.
// Don't use this type directly, use NewCertificateOrdersClient() instead.
type CertificateOrdersClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewCertificateOrdersClient creates a new instance of CertificateOrdersClient with the specified values.
// subscriptionID - Your Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewCertificateOrdersClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*CertificateOrdersClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &CertificateOrdersClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Description for Create or update a certificate purchase order.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// certificateOrderName - Name of the certificate order.
// certificateDistinguishedName - Distinguished name to use for the certificate order.
// options - CertificateOrdersClientBeginCreateOrUpdateOptions contains the optional parameters for the CertificateOrdersClient.BeginCreateOrUpdate
// method.
func (client *CertificateOrdersClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, certificateOrderName string, certificateDistinguishedName CertificateOrder, options *CertificateOrdersClientBeginCreateOrUpdateOptions) (*runtime.Poller[CertificateOrdersClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, certificateOrderName, certificateDistinguishedName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[CertificateOrdersClientCreateOrUpdateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[CertificateOrdersClientCreateOrUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdate - Description for Create or update a certificate purchase order.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *CertificateOrdersClient) createOrUpdate(ctx context.Context, resourceGroupName string, certificateOrderName string, certificateDistinguishedName CertificateOrder, options *CertificateOrdersClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, certificateOrderName, certificateDistinguishedName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *CertificateOrdersClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, certificateOrderName string, certificateDistinguishedName CertificateOrder, options *CertificateOrdersClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if certificateOrderName == "" {
		return nil, errors.New("parameter certificateOrderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificateOrderName}", url.PathEscape(certificateOrderName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, certificateDistinguishedName)
}

// BeginCreateOrUpdateCertificate - Description for Creates or updates a certificate and associates with key vault secret.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// certificateOrderName - Name of the certificate order.
// name - Name of the certificate.
// keyVaultCertificate - Key vault certificate resource Id.
// options - CertificateOrdersClientBeginCreateOrUpdateCertificateOptions contains the optional parameters for the CertificateOrdersClient.BeginCreateOrUpdateCertificate
// method.
func (client *CertificateOrdersClient) BeginCreateOrUpdateCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate CertificateResource, options *CertificateOrdersClientBeginCreateOrUpdateCertificateOptions) (*runtime.Poller[CertificateOrdersClientCreateOrUpdateCertificateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdateCertificate(ctx, resourceGroupName, certificateOrderName, name, keyVaultCertificate, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[CertificateOrdersClientCreateOrUpdateCertificateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[CertificateOrdersClientCreateOrUpdateCertificateResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdateCertificate - Description for Creates or updates a certificate and associates with key vault secret.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *CertificateOrdersClient) createOrUpdateCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate CertificateResource, options *CertificateOrdersClientBeginCreateOrUpdateCertificateOptions) (*http.Response, error) {
	req, err := client.createOrUpdateCertificateCreateRequest(ctx, resourceGroupName, certificateOrderName, name, keyVaultCertificate, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateCertificateCreateRequest creates the CreateOrUpdateCertificate request.
func (client *CertificateOrdersClient) createOrUpdateCertificateCreateRequest(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate CertificateResource, options *CertificateOrdersClientBeginCreateOrUpdateCertificateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if certificateOrderName == "" {
		return nil, errors.New("parameter certificateOrderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificateOrderName}", url.PathEscape(certificateOrderName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, keyVaultCertificate)
}

// Delete - Description for Delete an existing certificate order.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// certificateOrderName - Name of the certificate order.
// options - CertificateOrdersClientDeleteOptions contains the optional parameters for the CertificateOrdersClient.Delete
// method.
func (client *CertificateOrdersClient) Delete(ctx context.Context, resourceGroupName string, certificateOrderName string, options *CertificateOrdersClientDeleteOptions) (CertificateOrdersClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, certificateOrderName, options)
	if err != nil {
		return CertificateOrdersClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return CertificateOrdersClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return CertificateOrdersClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return CertificateOrdersClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *CertificateOrdersClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, certificateOrderName string, options *CertificateOrdersClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if certificateOrderName == "" {
		return nil, errors.New("parameter certificateOrderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificateOrderName}", url.PathEscape(certificateOrderName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteCertificate - Description for Delete the certificate associated with a certificate order.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// certificateOrderName - Name of the certificate order.
// name - Name of the certificate.
// options - CertificateOrdersClientDeleteCertificateOptions contains the optional parameters for the CertificateOrdersClient.DeleteCertificate
// method.
func (client *CertificateOrdersClient) DeleteCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, options *CertificateOrdersClientDeleteCertificateOptions) (CertificateOrdersClientDeleteCertificateResponse, error) {
	req, err := client.deleteCertificateCreateRequest(ctx, resourceGroupName, certificateOrderName, name, options)
	if err != nil {
		return CertificateOrdersClientDeleteCertificateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return CertificateOrdersClientDeleteCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return CertificateOrdersClientDeleteCertificateResponse{}, runtime.NewResponseError(resp)
	}
	return CertificateOrdersClientDeleteCertificateResponse{}, nil
}

// deleteCertificateCreateRequest creates the DeleteCertificate request.
func (client *CertificateOrdersClient) deleteCertificateCreateRequest(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, options *CertificateOrdersClientDeleteCertificateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if certificateOrderName == "" {
		return nil, errors.New("parameter certificateOrderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificateOrderName}", url.PathEscape(certificateOrderName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Description for Get a certificate order.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// certificateOrderName - Name of the certificate order..
// options - CertificateOrdersClientGetOptions contains the optional parameters for the CertificateOrdersClient.Get method.
func (client *CertificateOrdersClient) Get(ctx context.Context, resourceGroupName string, certificateOrderName string, options *CertificateOrdersClientGetOptions) (CertificateOrdersClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, certificateOrderName, options)
	if err != nil {
		return CertificateOrdersClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return CertificateOrdersClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return CertificateOrdersClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *CertificateOrdersClient) getCreateRequest(ctx context.Context, resourceGroupName string, certificateOrderName string, options *CertificateOrdersClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if certificateOrderName == "" {
		return nil, errors.New("parameter certificateOrderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificateOrderName}", url.PathEscape(certificateOrderName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *CertificateOrdersClient) getHandleResponse(resp *http.Response) (CertificateOrdersClientGetResponse, error) {
	result := CertificateOrdersClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateOrder); err != nil {
		return CertificateOrdersClientGetResponse{}, err
	}
	return result, nil
}

// GetCertificate - Description for Get the certificate associated with a certificate order.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// certificateOrderName - Name of the certificate order.
// name - Name of the certificate.
// options - CertificateOrdersClientGetCertificateOptions contains the optional parameters for the CertificateOrdersClient.GetCertificate
// method.
func (client *CertificateOrdersClient) GetCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, options *CertificateOrdersClientGetCertificateOptions) (CertificateOrdersClientGetCertificateResponse, error) {
	req, err := client.getCertificateCreateRequest(ctx, resourceGroupName, certificateOrderName, name, options)
	if err != nil {
		return CertificateOrdersClientGetCertificateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return CertificateOrdersClientGetCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return CertificateOrdersClientGetCertificateResponse{}, runtime.NewResponseError(resp)
	}
	return client.getCertificateHandleResponse(resp)
}

// getCertificateCreateRequest creates the GetCertificate request.
func (client *CertificateOrdersClient) getCertificateCreateRequest(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, options *CertificateOrdersClientGetCertificateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if certificateOrderName == "" {
		return nil, errors.New("parameter certificateOrderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificateOrderName}", url.PathEscape(certificateOrderName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getCertificateHandleResponse handles the GetCertificate response.
func (client *CertificateOrdersClient) getCertificateHandleResponse(resp *http.Response) (CertificateOrdersClientGetCertificateResponse, error) {
	result := CertificateOrdersClientGetCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateResource); err != nil {
		return CertificateOrdersClientGetCertificateResponse{}, err
	}
	return result, nil
}

// NewListPager - Description for List all certificate orders in a subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// options - CertificateOrdersClientListOptions contains the optional parameters for the CertificateOrdersClient.List method.
func (client *CertificateOrdersClient) NewListPager(options *CertificateOrdersClientListOptions) *runtime.Pager[CertificateOrdersClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[CertificateOrdersClientListResponse]{
		More: func(page CertificateOrdersClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *CertificateOrdersClientListResponse) (CertificateOrdersClientListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return CertificateOrdersClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return CertificateOrdersClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return CertificateOrdersClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *CertificateOrdersClient) listCreateRequest(ctx context.Context, options *CertificateOrdersClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.CertificateRegistration/certificateOrders"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *CertificateOrdersClient) listHandleResponse(resp *http.Response) (CertificateOrdersClientListResponse, error) {
	result := CertificateOrdersClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateOrderCollection); err != nil {
		return CertificateOrdersClientListResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - Description for Get certificate orders in a resource group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// options - CertificateOrdersClientListByResourceGroupOptions contains the optional parameters for the CertificateOrdersClient.ListByResourceGroup
// method.
func (client *CertificateOrdersClient) NewListByResourceGroupPager(resourceGroupName string, options *CertificateOrdersClientListByResourceGroupOptions) *runtime.Pager[CertificateOrdersClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[CertificateOrdersClientListByResourceGroupResponse]{
		More: func(page CertificateOrdersClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *CertificateOrdersClientListByResourceGroupResponse) (CertificateOrdersClientListByResourceGroupResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return CertificateOrdersClientListByResourceGroupResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return CertificateOrdersClientListByResourceGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return CertificateOrdersClientListByResourceGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *CertificateOrdersClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *CertificateOrdersClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *CertificateOrdersClient) listByResourceGroupHandleResponse(resp *http.Response) (CertificateOrdersClientListByResourceGroupResponse, error) {
	result := CertificateOrdersClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateOrderCollection); err != nil {
		return CertificateOrdersClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListCertificatesPager - Description for List all certificates associated with a certificate order.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// certificateOrderName - Name of the certificate order.
// options - CertificateOrdersClientListCertificatesOptions contains the optional parameters for the CertificateOrdersClient.ListCertificates
// method.
func (client *CertificateOrdersClient) NewListCertificatesPager(resourceGroupName string, certificateOrderName string, options *CertificateOrdersClientListCertificatesOptions) *runtime.Pager[CertificateOrdersClientListCertificatesResponse] {
	return runtime.NewPager(runtime.PagingHandler[CertificateOrdersClientListCertificatesResponse]{
		More: func(page CertificateOrdersClientListCertificatesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *CertificateOrdersClientListCertificatesResponse) (CertificateOrdersClientListCertificatesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCertificatesCreateRequest(ctx, resourceGroupName, certificateOrderName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return CertificateOrdersClientListCertificatesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return CertificateOrdersClientListCertificatesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return CertificateOrdersClientListCertificatesResponse{}, runtime.NewResponseError(resp)
			}
			return client.listCertificatesHandleResponse(resp)
		},
	})
}

// listCertificatesCreateRequest creates the ListCertificates request.
func (client *CertificateOrdersClient) listCertificatesCreateRequest(ctx context.Context, resourceGroupName string, certificateOrderName string, options *CertificateOrdersClientListCertificatesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if certificateOrderName == "" {
		return nil, errors.New("parameter certificateOrderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificateOrderName}", url.PathEscape(certificateOrderName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listCertificatesHandleResponse handles the ListCertificates response.
func (client *CertificateOrdersClient) listCertificatesHandleResponse(resp *http.Response) (CertificateOrdersClientListCertificatesResponse, error) {
	result := CertificateOrdersClientListCertificatesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateCollection); err != nil {
		return CertificateOrdersClientListCertificatesResponse{}, err
	}
	return result, nil
}

// Reissue - Description for Reissue an existing certificate order.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// certificateOrderName - Name of the certificate order.
// reissueCertificateOrderRequest - Parameters for the reissue.
// options - CertificateOrdersClientReissueOptions contains the optional parameters for the CertificateOrdersClient.Reissue
// method.
func (client *CertificateOrdersClient) Reissue(ctx context.Context, resourceGroupName string, certificateOrderName string, reissueCertificateOrderRequest ReissueCertificateOrderRequest, options *CertificateOrdersClientReissueOptions) (CertificateOrdersClientReissueResponse, error) {
	req, err := client.reissueCreateRequest(ctx, resourceGroupName, certificateOrderName, reissueCertificateOrderRequest, options)
	if err != nil {
		return CertificateOrdersClientReissueResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return CertificateOrdersClientReissueResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return CertificateOrdersClientReissueResponse{}, runtime.NewResponseError(resp)
	}
	return CertificateOrdersClientReissueResponse{}, nil
}

// reissueCreateRequest creates the Reissue request.
func (client *CertificateOrdersClient) reissueCreateRequest(ctx context.Context, resourceGroupName string, certificateOrderName string, reissueCertificateOrderRequest ReissueCertificateOrderRequest, options *CertificateOrdersClientReissueOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/reissue"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if certificateOrderName == "" {
		return nil, errors.New("parameter certificateOrderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificateOrderName}", url.PathEscape(certificateOrderName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, reissueCertificateOrderRequest)
}

// Renew - Description for Renew an existing certificate order.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// certificateOrderName - Name of the certificate order.
// renewCertificateOrderRequest - Renew parameters
// options - CertificateOrdersClientRenewOptions contains the optional parameters for the CertificateOrdersClient.Renew method.
func (client *CertificateOrdersClient) Renew(ctx context.Context, resourceGroupName string, certificateOrderName string, renewCertificateOrderRequest RenewCertificateOrderRequest, options *CertificateOrdersClientRenewOptions) (CertificateOrdersClientRenewResponse, error) {
	req, err := client.renewCreateRequest(ctx, resourceGroupName, certificateOrderName, renewCertificateOrderRequest, options)
	if err != nil {
		return CertificateOrdersClientRenewResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return CertificateOrdersClientRenewResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return CertificateOrdersClientRenewResponse{}, runtime.NewResponseError(resp)
	}
	return CertificateOrdersClientRenewResponse{}, nil
}

// renewCreateRequest creates the Renew request.
func (client *CertificateOrdersClient) renewCreateRequest(ctx context.Context, resourceGroupName string, certificateOrderName string, renewCertificateOrderRequest RenewCertificateOrderRequest, options *CertificateOrdersClientRenewOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/renew"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if certificateOrderName == "" {
		return nil, errors.New("parameter certificateOrderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificateOrderName}", url.PathEscape(certificateOrderName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, renewCertificateOrderRequest)
}

// ResendEmail - Description for Resend certificate email.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// certificateOrderName - Name of the certificate order.
// options - CertificateOrdersClientResendEmailOptions contains the optional parameters for the CertificateOrdersClient.ResendEmail
// method.
func (client *CertificateOrdersClient) ResendEmail(ctx context.Context, resourceGroupName string, certificateOrderName string, options *CertificateOrdersClientResendEmailOptions) (CertificateOrdersClientResendEmailResponse, error) {
	req, err := client.resendEmailCreateRequest(ctx, resourceGroupName, certificateOrderName, options)
	if err != nil {
		return CertificateOrdersClientResendEmailResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return CertificateOrdersClientResendEmailResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return CertificateOrdersClientResendEmailResponse{}, runtime.NewResponseError(resp)
	}
	return CertificateOrdersClientResendEmailResponse{}, nil
}

// resendEmailCreateRequest creates the ResendEmail request.
func (client *CertificateOrdersClient) resendEmailCreateRequest(ctx context.Context, resourceGroupName string, certificateOrderName string, options *CertificateOrdersClientResendEmailOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/resendEmail"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if certificateOrderName == "" {
		return nil, errors.New("parameter certificateOrderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificateOrderName}", url.PathEscape(certificateOrderName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// ResendRequestEmails - Resend domain verification ownership email containing steps on how to verify a domain for a given
// certificate order
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// certificateOrderName - Name of the certificate order.
// nameIdentifier - Email address
// options - CertificateOrdersClientResendRequestEmailsOptions contains the optional parameters for the CertificateOrdersClient.ResendRequestEmails
// method.
func (client *CertificateOrdersClient) ResendRequestEmails(ctx context.Context, resourceGroupName string, certificateOrderName string, nameIdentifier NameIdentifier, options *CertificateOrdersClientResendRequestEmailsOptions) (CertificateOrdersClientResendRequestEmailsResponse, error) {
	req, err := client.resendRequestEmailsCreateRequest(ctx, resourceGroupName, certificateOrderName, nameIdentifier, options)
	if err != nil {
		return CertificateOrdersClientResendRequestEmailsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return CertificateOrdersClientResendRequestEmailsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return CertificateOrdersClientResendRequestEmailsResponse{}, runtime.NewResponseError(resp)
	}
	return CertificateOrdersClientResendRequestEmailsResponse{}, nil
}

// resendRequestEmailsCreateRequest creates the ResendRequestEmails request.
func (client *CertificateOrdersClient) resendRequestEmailsCreateRequest(ctx context.Context, resourceGroupName string, certificateOrderName string, nameIdentifier NameIdentifier, options *CertificateOrdersClientResendRequestEmailsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/resendRequestEmails"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if certificateOrderName == "" {
		return nil, errors.New("parameter certificateOrderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificateOrderName}", url.PathEscape(certificateOrderName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, nameIdentifier)
}

// RetrieveCertificateActions - Description for Retrieve the list of certificate actions.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the certificate order.
// options - CertificateOrdersClientRetrieveCertificateActionsOptions contains the optional parameters for the CertificateOrdersClient.RetrieveCertificateActions
// method.
func (client *CertificateOrdersClient) RetrieveCertificateActions(ctx context.Context, resourceGroupName string, name string, options *CertificateOrdersClientRetrieveCertificateActionsOptions) (CertificateOrdersClientRetrieveCertificateActionsResponse, error) {
	req, err := client.retrieveCertificateActionsCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return CertificateOrdersClientRetrieveCertificateActionsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return CertificateOrdersClientRetrieveCertificateActionsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return CertificateOrdersClientRetrieveCertificateActionsResponse{}, runtime.NewResponseError(resp)
	}
	return client.retrieveCertificateActionsHandleResponse(resp)
}

// retrieveCertificateActionsCreateRequest creates the RetrieveCertificateActions request.
func (client *CertificateOrdersClient) retrieveCertificateActionsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *CertificateOrdersClientRetrieveCertificateActionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/retrieveCertificateActions"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// retrieveCertificateActionsHandleResponse handles the RetrieveCertificateActions response.
func (client *CertificateOrdersClient) retrieveCertificateActionsHandleResponse(resp *http.Response) (CertificateOrdersClientRetrieveCertificateActionsResponse, error) {
	result := CertificateOrdersClientRetrieveCertificateActionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateOrderActionArray); err != nil {
		return CertificateOrdersClientRetrieveCertificateActionsResponse{}, err
	}
	return result, nil
}

// RetrieveCertificateEmailHistory - Description for Retrieve email history.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the certificate order.
// options - CertificateOrdersClientRetrieveCertificateEmailHistoryOptions contains the optional parameters for the CertificateOrdersClient.RetrieveCertificateEmailHistory
// method.
func (client *CertificateOrdersClient) RetrieveCertificateEmailHistory(ctx context.Context, resourceGroupName string, name string, options *CertificateOrdersClientRetrieveCertificateEmailHistoryOptions) (CertificateOrdersClientRetrieveCertificateEmailHistoryResponse, error) {
	req, err := client.retrieveCertificateEmailHistoryCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return CertificateOrdersClientRetrieveCertificateEmailHistoryResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return CertificateOrdersClientRetrieveCertificateEmailHistoryResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return CertificateOrdersClientRetrieveCertificateEmailHistoryResponse{}, runtime.NewResponseError(resp)
	}
	return client.retrieveCertificateEmailHistoryHandleResponse(resp)
}

// retrieveCertificateEmailHistoryCreateRequest creates the RetrieveCertificateEmailHistory request.
func (client *CertificateOrdersClient) retrieveCertificateEmailHistoryCreateRequest(ctx context.Context, resourceGroupName string, name string, options *CertificateOrdersClientRetrieveCertificateEmailHistoryOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/retrieveEmailHistory"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// retrieveCertificateEmailHistoryHandleResponse handles the RetrieveCertificateEmailHistory response.
func (client *CertificateOrdersClient) retrieveCertificateEmailHistoryHandleResponse(resp *http.Response) (CertificateOrdersClientRetrieveCertificateEmailHistoryResponse, error) {
	result := CertificateOrdersClientRetrieveCertificateEmailHistoryResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateEmailArray); err != nil {
		return CertificateOrdersClientRetrieveCertificateEmailHistoryResponse{}, err
	}
	return result, nil
}

// RetrieveSiteSeal - This method is used to obtain the site seal information for an issued certificate. A site seal is a
// graphic that the certificate purchaser can embed on their web site to show their visitors
// information about their SSL certificate. If a web site visitor clicks on the site seal image, a pop-up page is displayed
// that contains detailed information about the SSL certificate. The site seal
// token is used to link the site seal graphic image to the appropriate certificate details pop-up page display when a user
// clicks on the site seal. The site seal images are expected to be static images
// and hosted by the reseller, to minimize delays for customer page load times.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// certificateOrderName - Name of the certificate order.
// siteSealRequest - Site seal request.
// options - CertificateOrdersClientRetrieveSiteSealOptions contains the optional parameters for the CertificateOrdersClient.RetrieveSiteSeal
// method.
func (client *CertificateOrdersClient) RetrieveSiteSeal(ctx context.Context, resourceGroupName string, certificateOrderName string, siteSealRequest SiteSealRequest, options *CertificateOrdersClientRetrieveSiteSealOptions) (CertificateOrdersClientRetrieveSiteSealResponse, error) {
	req, err := client.retrieveSiteSealCreateRequest(ctx, resourceGroupName, certificateOrderName, siteSealRequest, options)
	if err != nil {
		return CertificateOrdersClientRetrieveSiteSealResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return CertificateOrdersClientRetrieveSiteSealResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return CertificateOrdersClientRetrieveSiteSealResponse{}, runtime.NewResponseError(resp)
	}
	return client.retrieveSiteSealHandleResponse(resp)
}

// retrieveSiteSealCreateRequest creates the RetrieveSiteSeal request.
func (client *CertificateOrdersClient) retrieveSiteSealCreateRequest(ctx context.Context, resourceGroupName string, certificateOrderName string, siteSealRequest SiteSealRequest, options *CertificateOrdersClientRetrieveSiteSealOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/retrieveSiteSeal"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if certificateOrderName == "" {
		return nil, errors.New("parameter certificateOrderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificateOrderName}", url.PathEscape(certificateOrderName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, siteSealRequest)
}

// retrieveSiteSealHandleResponse handles the RetrieveSiteSeal response.
func (client *CertificateOrdersClient) retrieveSiteSealHandleResponse(resp *http.Response) (CertificateOrdersClientRetrieveSiteSealResponse, error) {
	result := CertificateOrdersClientRetrieveSiteSealResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SiteSeal); err != nil {
		return CertificateOrdersClientRetrieveSiteSealResponse{}, err
	}
	return result, nil
}

// Update - Description for Create or update a certificate purchase order.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// certificateOrderName - Name of the certificate order.
// certificateDistinguishedName - Distinguished name to use for the certificate order.
// options - CertificateOrdersClientUpdateOptions contains the optional parameters for the CertificateOrdersClient.Update
// method.
func (client *CertificateOrdersClient) Update(ctx context.Context, resourceGroupName string, certificateOrderName string, certificateDistinguishedName CertificateOrderPatchResource, options *CertificateOrdersClientUpdateOptions) (CertificateOrdersClientUpdateResponse, error) {
	req, err := client.updateCreateRequest(ctx, resourceGroupName, certificateOrderName, certificateDistinguishedName, options)
	if err != nil {
		return CertificateOrdersClientUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return CertificateOrdersClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return CertificateOrdersClientUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateHandleResponse(resp)
}

// updateCreateRequest creates the Update request.
func (client *CertificateOrdersClient) updateCreateRequest(ctx context.Context, resourceGroupName string, certificateOrderName string, certificateDistinguishedName CertificateOrderPatchResource, options *CertificateOrdersClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if certificateOrderName == "" {
		return nil, errors.New("parameter certificateOrderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificateOrderName}", url.PathEscape(certificateOrderName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, certificateDistinguishedName)
}

// updateHandleResponse handles the Update response.
func (client *CertificateOrdersClient) updateHandleResponse(resp *http.Response) (CertificateOrdersClientUpdateResponse, error) {
	result := CertificateOrdersClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateOrder); err != nil {
		return CertificateOrdersClientUpdateResponse{}, err
	}
	return result, nil
}

// UpdateCertificate - Description for Creates or updates a certificate and associates with key vault secret.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// certificateOrderName - Name of the certificate order.
// name - Name of the certificate.
// keyVaultCertificate - Key vault certificate resource Id.
// options - CertificateOrdersClientUpdateCertificateOptions contains the optional parameters for the CertificateOrdersClient.UpdateCertificate
// method.
func (client *CertificateOrdersClient) UpdateCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate CertificatePatchResource, options *CertificateOrdersClientUpdateCertificateOptions) (CertificateOrdersClientUpdateCertificateResponse, error) {
	req, err := client.updateCertificateCreateRequest(ctx, resourceGroupName, certificateOrderName, name, keyVaultCertificate, options)
	if err != nil {
		return CertificateOrdersClientUpdateCertificateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return CertificateOrdersClientUpdateCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return CertificateOrdersClientUpdateCertificateResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateCertificateHandleResponse(resp)
}

// updateCertificateCreateRequest creates the UpdateCertificate request.
func (client *CertificateOrdersClient) updateCertificateCreateRequest(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate CertificatePatchResource, options *CertificateOrdersClientUpdateCertificateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if certificateOrderName == "" {
		return nil, errors.New("parameter certificateOrderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificateOrderName}", url.PathEscape(certificateOrderName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, keyVaultCertificate)
}

// updateCertificateHandleResponse handles the UpdateCertificate response.
func (client *CertificateOrdersClient) updateCertificateHandleResponse(resp *http.Response) (CertificateOrdersClientUpdateCertificateResponse, error) {
	result := CertificateOrdersClientUpdateCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateResource); err != nil {
		return CertificateOrdersClientUpdateCertificateResponse{}, err
	}
	return result, nil
}

// ValidatePurchaseInformation - Description for Validate information for a certificate order.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// appServiceCertificateOrder - Information for a certificate order.
// options - CertificateOrdersClientValidatePurchaseInformationOptions contains the optional parameters for the CertificateOrdersClient.ValidatePurchaseInformation
// method.
func (client *CertificateOrdersClient) ValidatePurchaseInformation(ctx context.Context, appServiceCertificateOrder CertificateOrder, options *CertificateOrdersClientValidatePurchaseInformationOptions) (CertificateOrdersClientValidatePurchaseInformationResponse, error) {
	req, err := client.validatePurchaseInformationCreateRequest(ctx, appServiceCertificateOrder, options)
	if err != nil {
		return CertificateOrdersClientValidatePurchaseInformationResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return CertificateOrdersClientValidatePurchaseInformationResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return CertificateOrdersClientValidatePurchaseInformationResponse{}, runtime.NewResponseError(resp)
	}
	return CertificateOrdersClientValidatePurchaseInformationResponse{}, nil
}

// validatePurchaseInformationCreateRequest creates the ValidatePurchaseInformation request.
func (client *CertificateOrdersClient) validatePurchaseInformationCreateRequest(ctx context.Context, appServiceCertificateOrder CertificateOrder, options *CertificateOrdersClientValidatePurchaseInformationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.CertificateRegistration/validateCertificateRegistrationInformation"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, appServiceCertificateOrder)
}

// VerifyDomainOwnership - Description for Verify domain ownership for this certificate order.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// certificateOrderName - Name of the certificate order.
// options - CertificateOrdersClientVerifyDomainOwnershipOptions contains the optional parameters for the CertificateOrdersClient.VerifyDomainOwnership
// method.
func (client *CertificateOrdersClient) VerifyDomainOwnership(ctx context.Context, resourceGroupName string, certificateOrderName string, options *CertificateOrdersClientVerifyDomainOwnershipOptions) (CertificateOrdersClientVerifyDomainOwnershipResponse, error) {
	req, err := client.verifyDomainOwnershipCreateRequest(ctx, resourceGroupName, certificateOrderName, options)
	if err != nil {
		return CertificateOrdersClientVerifyDomainOwnershipResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return CertificateOrdersClientVerifyDomainOwnershipResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return CertificateOrdersClientVerifyDomainOwnershipResponse{}, runtime.NewResponseError(resp)
	}
	return CertificateOrdersClientVerifyDomainOwnershipResponse{}, nil
}

// verifyDomainOwnershipCreateRequest creates the VerifyDomainOwnership request.
func (client *CertificateOrdersClient) verifyDomainOwnershipCreateRequest(ctx context.Context, resourceGroupName string, certificateOrderName string, options *CertificateOrdersClientVerifyDomainOwnershipOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/verifyDomainOwnership"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if certificateOrderName == "" {
		return nil, errors.New("parameter certificateOrderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificateOrderName}", url.PathEscape(certificateOrderName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}
