//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdelegatednetwork

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// DelegatedSubnetServiceClient contains the methods for the DelegatedSubnetService group.
// Don't use this type directly, use NewDelegatedSubnetServiceClient() instead.
type DelegatedSubnetServiceClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewDelegatedSubnetServiceClient creates a new instance of DelegatedSubnetServiceClient with the specified values.
// subscriptionID - The ID of the target subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewDelegatedSubnetServiceClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*DelegatedSubnetServiceClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &DelegatedSubnetServiceClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginDeleteDetails - Delete dnc DelegatedSubnet.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-03-15
// resourceGroupName - The name of the resource group. The name is case insensitive.
// resourceName - The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
// options - DelegatedSubnetServiceClientBeginDeleteDetailsOptions contains the optional parameters for the DelegatedSubnetServiceClient.BeginDeleteDetails
// method.
func (client *DelegatedSubnetServiceClient) BeginDeleteDetails(ctx context.Context, resourceGroupName string, resourceName string, options *DelegatedSubnetServiceClientBeginDeleteDetailsOptions) (*runtime.Poller[DelegatedSubnetServiceClientDeleteDetailsResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteDetails(ctx, resourceGroupName, resourceName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[DelegatedSubnetServiceClientDeleteDetailsResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[DelegatedSubnetServiceClientDeleteDetailsResponse](options.ResumeToken, client.pl, nil)
	}
}

// DeleteDetails - Delete dnc DelegatedSubnet.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-03-15
func (client *DelegatedSubnetServiceClient) deleteDetails(ctx context.Context, resourceGroupName string, resourceName string, options *DelegatedSubnetServiceClientBeginDeleteDetailsOptions) (*http.Response, error) {
	req, err := client.deleteDetailsCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteDetailsCreateRequest creates the DeleteDetails request.
func (client *DelegatedSubnetServiceClient) deleteDetailsCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *DelegatedSubnetServiceClientBeginDeleteDetailsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/delegatedSubnets/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	if options != nil && options.ForceDelete != nil {
		reqQP.Set("forceDelete", strconv.FormatBool(*options.ForceDelete))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GetDetails - Gets details about the specified dnc DelegatedSubnet Link.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-03-15
// resourceGroupName - The name of the resource group. The name is case insensitive.
// resourceName - The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
// options - DelegatedSubnetServiceClientGetDetailsOptions contains the optional parameters for the DelegatedSubnetServiceClient.GetDetails
// method.
func (client *DelegatedSubnetServiceClient) GetDetails(ctx context.Context, resourceGroupName string, resourceName string, options *DelegatedSubnetServiceClientGetDetailsOptions) (DelegatedSubnetServiceClientGetDetailsResponse, error) {
	req, err := client.getDetailsCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return DelegatedSubnetServiceClientGetDetailsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DelegatedSubnetServiceClientGetDetailsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DelegatedSubnetServiceClientGetDetailsResponse{}, runtime.NewResponseError(resp)
	}
	return client.getDetailsHandleResponse(resp)
}

// getDetailsCreateRequest creates the GetDetails request.
func (client *DelegatedSubnetServiceClient) getDetailsCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *DelegatedSubnetServiceClientGetDetailsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/delegatedSubnets/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDetailsHandleResponse handles the GetDetails response.
func (client *DelegatedSubnetServiceClient) getDetailsHandleResponse(resp *http.Response) (DelegatedSubnetServiceClientGetDetailsResponse, error) {
	result := DelegatedSubnetServiceClientGetDetailsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DelegatedSubnet); err != nil {
		return DelegatedSubnetServiceClientGetDetailsResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - Get all the DelegatedSubnets resources in a resource group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-03-15
// resourceGroupName - The name of the resource group. The name is case insensitive.
// options - DelegatedSubnetServiceClientListByResourceGroupOptions contains the optional parameters for the DelegatedSubnetServiceClient.ListByResourceGroup
// method.
func (client *DelegatedSubnetServiceClient) NewListByResourceGroupPager(resourceGroupName string, options *DelegatedSubnetServiceClientListByResourceGroupOptions) *runtime.Pager[DelegatedSubnetServiceClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[DelegatedSubnetServiceClientListByResourceGroupResponse]{
		More: func(page DelegatedSubnetServiceClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DelegatedSubnetServiceClientListByResourceGroupResponse) (DelegatedSubnetServiceClientListByResourceGroupResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return DelegatedSubnetServiceClientListByResourceGroupResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return DelegatedSubnetServiceClientListByResourceGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DelegatedSubnetServiceClientListByResourceGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *DelegatedSubnetServiceClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *DelegatedSubnetServiceClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/delegatedSubnets"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *DelegatedSubnetServiceClient) listByResourceGroupHandleResponse(resp *http.Response) (DelegatedSubnetServiceClientListByResourceGroupResponse, error) {
	result := DelegatedSubnetServiceClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DelegatedSubnets); err != nil {
		return DelegatedSubnetServiceClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - Get all the DelegatedSubnets resources in a subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-03-15
// options - DelegatedSubnetServiceClientListBySubscriptionOptions contains the optional parameters for the DelegatedSubnetServiceClient.ListBySubscription
// method.
func (client *DelegatedSubnetServiceClient) NewListBySubscriptionPager(options *DelegatedSubnetServiceClientListBySubscriptionOptions) *runtime.Pager[DelegatedSubnetServiceClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[DelegatedSubnetServiceClientListBySubscriptionResponse]{
		More: func(page DelegatedSubnetServiceClientListBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DelegatedSubnetServiceClientListBySubscriptionResponse) (DelegatedSubnetServiceClientListBySubscriptionResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listBySubscriptionCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return DelegatedSubnetServiceClientListBySubscriptionResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return DelegatedSubnetServiceClientListBySubscriptionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DelegatedSubnetServiceClientListBySubscriptionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *DelegatedSubnetServiceClient) listBySubscriptionCreateRequest(ctx context.Context, options *DelegatedSubnetServiceClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DelegatedNetwork/delegatedSubnets"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *DelegatedSubnetServiceClient) listBySubscriptionHandleResponse(resp *http.Response) (DelegatedSubnetServiceClientListBySubscriptionResponse, error) {
	result := DelegatedSubnetServiceClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DelegatedSubnets); err != nil {
		return DelegatedSubnetServiceClientListBySubscriptionResponse{}, err
	}
	return result, nil
}

// BeginPatchDetails - Patch delegated subnet resource
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-03-15
// resourceGroupName - The name of the resource group. The name is case insensitive.
// resourceName - The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
// parameters - Delegated subnet details.
// options - DelegatedSubnetServiceClientBeginPatchDetailsOptions contains the optional parameters for the DelegatedSubnetServiceClient.BeginPatchDetails
// method.
func (client *DelegatedSubnetServiceClient) BeginPatchDetails(ctx context.Context, resourceGroupName string, resourceName string, parameters ResourceUpdateParameters, options *DelegatedSubnetServiceClientBeginPatchDetailsOptions) (*runtime.Poller[DelegatedSubnetServiceClientPatchDetailsResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.patchDetails(ctx, resourceGroupName, resourceName, parameters, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[DelegatedSubnetServiceClientPatchDetailsResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[DelegatedSubnetServiceClientPatchDetailsResponse](options.ResumeToken, client.pl, nil)
	}
}

// PatchDetails - Patch delegated subnet resource
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-03-15
func (client *DelegatedSubnetServiceClient) patchDetails(ctx context.Context, resourceGroupName string, resourceName string, parameters ResourceUpdateParameters, options *DelegatedSubnetServiceClientBeginPatchDetailsOptions) (*http.Response, error) {
	req, err := client.patchDetailsCreateRequest(ctx, resourceGroupName, resourceName, parameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// patchDetailsCreateRequest creates the PatchDetails request.
func (client *DelegatedSubnetServiceClient) patchDetailsCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, parameters ResourceUpdateParameters, options *DelegatedSubnetServiceClientBeginPatchDetailsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/delegatedSubnets/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// BeginPutDetails - Put delegated subnet resource
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-03-15
// resourceGroupName - The name of the resource group. The name is case insensitive.
// resourceName - The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
// parameters - Delegated subnet details.
// options - DelegatedSubnetServiceClientBeginPutDetailsOptions contains the optional parameters for the DelegatedSubnetServiceClient.BeginPutDetails
// method.
func (client *DelegatedSubnetServiceClient) BeginPutDetails(ctx context.Context, resourceGroupName string, resourceName string, parameters DelegatedSubnet, options *DelegatedSubnetServiceClientBeginPutDetailsOptions) (*runtime.Poller[DelegatedSubnetServiceClientPutDetailsResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.putDetails(ctx, resourceGroupName, resourceName, parameters, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[DelegatedSubnetServiceClientPutDetailsResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[DelegatedSubnetServiceClientPutDetailsResponse](options.ResumeToken, client.pl, nil)
	}
}

// PutDetails - Put delegated subnet resource
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-03-15
func (client *DelegatedSubnetServiceClient) putDetails(ctx context.Context, resourceGroupName string, resourceName string, parameters DelegatedSubnet, options *DelegatedSubnetServiceClientBeginPutDetailsOptions) (*http.Response, error) {
	req, err := client.putDetailsCreateRequest(ctx, resourceGroupName, resourceName, parameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// putDetailsCreateRequest creates the PutDetails request.
func (client *DelegatedSubnetServiceClient) putDetailsCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, parameters DelegatedSubnet, options *DelegatedSubnetServiceClientBeginPutDetailsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/delegatedSubnets/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}
