// Code generated by smithy-go-codegen DO NOT EDIT.

package datasync

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datasync/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Runs a DataSync discovery job on your on-premises storage system. If you
// haven't added the storage system to DataSync Discovery yet, do this first by
// using the [AddStorageSystem]operation.
//
// [AddStorageSystem]: https://docs.aws.amazon.com/datasync/latest/userguide/API_AddStorageSystem.html
func (c *Client) StartDiscoveryJob(ctx context.Context, params *StartDiscoveryJobInput, optFns ...func(*Options)) (*StartDiscoveryJobOutput, error) {
	if params == nil {
		params = &StartDiscoveryJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartDiscoveryJob", params, optFns, c.addOperationStartDiscoveryJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartDiscoveryJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartDiscoveryJobInput struct {

	// Specifies a client token to make sure requests with this API operation are
	// idempotent. If you don't specify a client token, DataSync generates one for you
	// automatically.
	//
	// This member is required.
	ClientToken *string

	// Specifies in minutes how long you want the discovery job to run.
	//
	// For more accurate recommendations, we recommend a duration of at least 14 days.
	// Longer durations allow time to collect a sufficient number of data points and
	// provide a realistic representation of storage performance and utilization.
	//
	// This member is required.
	CollectionDurationMinutes *int32

	// Specifies the Amazon Resource Name (ARN) of the on-premises storage system that
	// you want to run the discovery job on.
	//
	// This member is required.
	StorageSystemArn *string

	// Specifies labels that help you categorize, filter, and search for your Amazon
	// Web Services resources.
	Tags []types.TagListEntry

	noSmithyDocumentSerde
}

type StartDiscoveryJobOutput struct {

	// The ARN of the discovery job that you started.
	DiscoveryJobArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartDiscoveryJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpStartDiscoveryJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpStartDiscoveryJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartDiscoveryJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addEndpointPrefix_opStartDiscoveryJobMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStartDiscoveryJobMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStartDiscoveryJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartDiscoveryJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opStartDiscoveryJobMiddleware struct {
}

func (*endpointPrefix_opStartDiscoveryJobMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opStartDiscoveryJobMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "discovery-" + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opStartDiscoveryJobMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opStartDiscoveryJobMiddleware{}, "ResolveEndpointV2", middleware.After)
}

type idempotencyToken_initializeOpStartDiscoveryJob struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStartDiscoveryJob) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStartDiscoveryJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StartDiscoveryJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StartDiscoveryJobInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStartDiscoveryJobMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStartDiscoveryJob{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStartDiscoveryJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartDiscoveryJob",
	}
}
