package eventgrid

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ChannelProvisioningState enumerates the values for channel provisioning state.
type ChannelProvisioningState string

const (
	// ChannelProvisioningStateCanceled ...
	ChannelProvisioningStateCanceled ChannelProvisioningState = "Canceled"
	// ChannelProvisioningStateCreating ...
	ChannelProvisioningStateCreating ChannelProvisioningState = "Creating"
	// ChannelProvisioningStateDeleting ...
	ChannelProvisioningStateDeleting ChannelProvisioningState = "Deleting"
	// ChannelProvisioningStateFailed ...
	ChannelProvisioningStateFailed ChannelProvisioningState = "Failed"
	// ChannelProvisioningStateSucceeded ...
	ChannelProvisioningStateSucceeded ChannelProvisioningState = "Succeeded"
	// ChannelProvisioningStateUpdating ...
	ChannelProvisioningStateUpdating ChannelProvisioningState = "Updating"
)

// PossibleChannelProvisioningStateValues returns an array of possible values for the ChannelProvisioningState const type.
func PossibleChannelProvisioningStateValues() []ChannelProvisioningState {
	return []ChannelProvisioningState{ChannelProvisioningStateCanceled, ChannelProvisioningStateCreating, ChannelProvisioningStateDeleting, ChannelProvisioningStateFailed, ChannelProvisioningStateSucceeded, ChannelProvisioningStateUpdating}
}

// ChannelType enumerates the values for channel type.
type ChannelType string

const (
	// ChannelTypePartnerDestination ...
	ChannelTypePartnerDestination ChannelType = "PartnerDestination"
	// ChannelTypePartnerTopic ...
	ChannelTypePartnerTopic ChannelType = "PartnerTopic"
)

// PossibleChannelTypeValues returns an array of possible values for the ChannelType const type.
func PossibleChannelTypeValues() []ChannelType {
	return []ChannelType{ChannelTypePartnerDestination, ChannelTypePartnerTopic}
}

// ClientAuthenticationType enumerates the values for client authentication type.
type ClientAuthenticationType string

const (
	// ClientAuthenticationTypeAzureAD ...
	ClientAuthenticationTypeAzureAD ClientAuthenticationType = "AzureAD"
	// ClientAuthenticationTypePartnerClientAuthentication ...
	ClientAuthenticationTypePartnerClientAuthentication ClientAuthenticationType = "PartnerClientAuthentication"
)

// PossibleClientAuthenticationTypeValues returns an array of possible values for the ClientAuthenticationType const type.
func PossibleClientAuthenticationTypeValues() []ClientAuthenticationType {
	return []ClientAuthenticationType{ClientAuthenticationTypeAzureAD, ClientAuthenticationTypePartnerClientAuthentication}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// DataResidencyBoundary enumerates the values for data residency boundary.
type DataResidencyBoundary string

const (
	// DataResidencyBoundaryWithinGeopair ...
	DataResidencyBoundaryWithinGeopair DataResidencyBoundary = "WithinGeopair"
	// DataResidencyBoundaryWithinRegion ...
	DataResidencyBoundaryWithinRegion DataResidencyBoundary = "WithinRegion"
)

// PossibleDataResidencyBoundaryValues returns an array of possible values for the DataResidencyBoundary const type.
func PossibleDataResidencyBoundaryValues() []DataResidencyBoundary {
	return []DataResidencyBoundary{DataResidencyBoundaryWithinGeopair, DataResidencyBoundaryWithinRegion}
}

// DomainProvisioningState enumerates the values for domain provisioning state.
type DomainProvisioningState string

const (
	// DomainProvisioningStateCanceled ...
	DomainProvisioningStateCanceled DomainProvisioningState = "Canceled"
	// DomainProvisioningStateCreating ...
	DomainProvisioningStateCreating DomainProvisioningState = "Creating"
	// DomainProvisioningStateDeleting ...
	DomainProvisioningStateDeleting DomainProvisioningState = "Deleting"
	// DomainProvisioningStateFailed ...
	DomainProvisioningStateFailed DomainProvisioningState = "Failed"
	// DomainProvisioningStateSucceeded ...
	DomainProvisioningStateSucceeded DomainProvisioningState = "Succeeded"
	// DomainProvisioningStateUpdating ...
	DomainProvisioningStateUpdating DomainProvisioningState = "Updating"
)

// PossibleDomainProvisioningStateValues returns an array of possible values for the DomainProvisioningState const type.
func PossibleDomainProvisioningStateValues() []DomainProvisioningState {
	return []DomainProvisioningState{DomainProvisioningStateCanceled, DomainProvisioningStateCreating, DomainProvisioningStateDeleting, DomainProvisioningStateFailed, DomainProvisioningStateSucceeded, DomainProvisioningStateUpdating}
}

// DomainTopicProvisioningState enumerates the values for domain topic provisioning state.
type DomainTopicProvisioningState string

const (
	// DomainTopicProvisioningStateCanceled ...
	DomainTopicProvisioningStateCanceled DomainTopicProvisioningState = "Canceled"
	// DomainTopicProvisioningStateCreating ...
	DomainTopicProvisioningStateCreating DomainTopicProvisioningState = "Creating"
	// DomainTopicProvisioningStateDeleting ...
	DomainTopicProvisioningStateDeleting DomainTopicProvisioningState = "Deleting"
	// DomainTopicProvisioningStateFailed ...
	DomainTopicProvisioningStateFailed DomainTopicProvisioningState = "Failed"
	// DomainTopicProvisioningStateSucceeded ...
	DomainTopicProvisioningStateSucceeded DomainTopicProvisioningState = "Succeeded"
	// DomainTopicProvisioningStateUpdating ...
	DomainTopicProvisioningStateUpdating DomainTopicProvisioningState = "Updating"
)

// PossibleDomainTopicProvisioningStateValues returns an array of possible values for the DomainTopicProvisioningState const type.
func PossibleDomainTopicProvisioningStateValues() []DomainTopicProvisioningState {
	return []DomainTopicProvisioningState{DomainTopicProvisioningStateCanceled, DomainTopicProvisioningStateCreating, DomainTopicProvisioningStateDeleting, DomainTopicProvisioningStateFailed, DomainTopicProvisioningStateSucceeded, DomainTopicProvisioningStateUpdating}
}

// EndpointType enumerates the values for endpoint type.
type EndpointType string

const (
	// EndpointTypePartnerDestinationInfo ...
	EndpointTypePartnerDestinationInfo EndpointType = "PartnerDestinationInfo"
	// EndpointTypeWebHook ...
	EndpointTypeWebHook EndpointType = "WebHook"
)

// PossibleEndpointTypeValues returns an array of possible values for the EndpointType const type.
func PossibleEndpointTypeValues() []EndpointType {
	return []EndpointType{EndpointTypePartnerDestinationInfo, EndpointTypeWebHook}
}

// EndpointTypeBasicDeadLetterDestination enumerates the values for endpoint type basic dead letter
// destination.
type EndpointTypeBasicDeadLetterDestination string

const (
	// EndpointTypeBasicDeadLetterDestinationEndpointTypeDeadLetterDestination ...
	EndpointTypeBasicDeadLetterDestinationEndpointTypeDeadLetterDestination EndpointTypeBasicDeadLetterDestination = "DeadLetterDestination"
	// EndpointTypeBasicDeadLetterDestinationEndpointTypeStorageBlob ...
	EndpointTypeBasicDeadLetterDestinationEndpointTypeStorageBlob EndpointTypeBasicDeadLetterDestination = "StorageBlob"
)

// PossibleEndpointTypeBasicDeadLetterDestinationValues returns an array of possible values for the EndpointTypeBasicDeadLetterDestination const type.
func PossibleEndpointTypeBasicDeadLetterDestinationValues() []EndpointTypeBasicDeadLetterDestination {
	return []EndpointTypeBasicDeadLetterDestination{EndpointTypeBasicDeadLetterDestinationEndpointTypeDeadLetterDestination, EndpointTypeBasicDeadLetterDestinationEndpointTypeStorageBlob}
}

// EndpointTypeBasicEventSubscriptionDestination enumerates the values for endpoint type basic event
// subscription destination.
type EndpointTypeBasicEventSubscriptionDestination string

const (
	// EndpointTypeBasicEventSubscriptionDestinationEndpointTypeAzureFunction ...
	EndpointTypeBasicEventSubscriptionDestinationEndpointTypeAzureFunction EndpointTypeBasicEventSubscriptionDestination = "AzureFunction"
	// EndpointTypeBasicEventSubscriptionDestinationEndpointTypeEventHub ...
	EndpointTypeBasicEventSubscriptionDestinationEndpointTypeEventHub EndpointTypeBasicEventSubscriptionDestination = "EventHub"
	// EndpointTypeBasicEventSubscriptionDestinationEndpointTypeEventSubscriptionDestination ...
	EndpointTypeBasicEventSubscriptionDestinationEndpointTypeEventSubscriptionDestination EndpointTypeBasicEventSubscriptionDestination = "EventSubscriptionDestination"
	// EndpointTypeBasicEventSubscriptionDestinationEndpointTypeHybridConnection ...
	EndpointTypeBasicEventSubscriptionDestinationEndpointTypeHybridConnection EndpointTypeBasicEventSubscriptionDestination = "HybridConnection"
	// EndpointTypeBasicEventSubscriptionDestinationEndpointTypePartnerDestination ...
	EndpointTypeBasicEventSubscriptionDestinationEndpointTypePartnerDestination EndpointTypeBasicEventSubscriptionDestination = "PartnerDestination"
	// EndpointTypeBasicEventSubscriptionDestinationEndpointTypeServiceBusQueue ...
	EndpointTypeBasicEventSubscriptionDestinationEndpointTypeServiceBusQueue EndpointTypeBasicEventSubscriptionDestination = "ServiceBusQueue"
	// EndpointTypeBasicEventSubscriptionDestinationEndpointTypeServiceBusTopic ...
	EndpointTypeBasicEventSubscriptionDestinationEndpointTypeServiceBusTopic EndpointTypeBasicEventSubscriptionDestination = "ServiceBusTopic"
	// EndpointTypeBasicEventSubscriptionDestinationEndpointTypeStorageQueue ...
	EndpointTypeBasicEventSubscriptionDestinationEndpointTypeStorageQueue EndpointTypeBasicEventSubscriptionDestination = "StorageQueue"
	// EndpointTypeBasicEventSubscriptionDestinationEndpointTypeWebHook ...
	EndpointTypeBasicEventSubscriptionDestinationEndpointTypeWebHook EndpointTypeBasicEventSubscriptionDestination = "WebHook"
)

// PossibleEndpointTypeBasicEventSubscriptionDestinationValues returns an array of possible values for the EndpointTypeBasicEventSubscriptionDestination const type.
func PossibleEndpointTypeBasicEventSubscriptionDestinationValues() []EndpointTypeBasicEventSubscriptionDestination {
	return []EndpointTypeBasicEventSubscriptionDestination{EndpointTypeBasicEventSubscriptionDestinationEndpointTypeAzureFunction, EndpointTypeBasicEventSubscriptionDestinationEndpointTypeEventHub, EndpointTypeBasicEventSubscriptionDestinationEndpointTypeEventSubscriptionDestination, EndpointTypeBasicEventSubscriptionDestinationEndpointTypeHybridConnection, EndpointTypeBasicEventSubscriptionDestinationEndpointTypePartnerDestination, EndpointTypeBasicEventSubscriptionDestinationEndpointTypeServiceBusQueue, EndpointTypeBasicEventSubscriptionDestinationEndpointTypeServiceBusTopic, EndpointTypeBasicEventSubscriptionDestinationEndpointTypeStorageQueue, EndpointTypeBasicEventSubscriptionDestinationEndpointTypeWebHook}
}

// EndpointTypeBasicPartnerUpdateDestinationInfo enumerates the values for endpoint type basic partner update
// destination info.
type EndpointTypeBasicPartnerUpdateDestinationInfo string

const (
	// EndpointTypeBasicPartnerUpdateDestinationInfoEndpointTypePartnerUpdateDestinationInfo ...
	EndpointTypeBasicPartnerUpdateDestinationInfoEndpointTypePartnerUpdateDestinationInfo EndpointTypeBasicPartnerUpdateDestinationInfo = "PartnerUpdateDestinationInfo"
	// EndpointTypeBasicPartnerUpdateDestinationInfoEndpointTypeWebHook ...
	EndpointTypeBasicPartnerUpdateDestinationInfoEndpointTypeWebHook EndpointTypeBasicPartnerUpdateDestinationInfo = "WebHook"
)

// PossibleEndpointTypeBasicPartnerUpdateDestinationInfoValues returns an array of possible values for the EndpointTypeBasicPartnerUpdateDestinationInfo const type.
func PossibleEndpointTypeBasicPartnerUpdateDestinationInfoValues() []EndpointTypeBasicPartnerUpdateDestinationInfo {
	return []EndpointTypeBasicPartnerUpdateDestinationInfo{EndpointTypeBasicPartnerUpdateDestinationInfoEndpointTypePartnerUpdateDestinationInfo, EndpointTypeBasicPartnerUpdateDestinationInfoEndpointTypeWebHook}
}

// EventChannelProvisioningState enumerates the values for event channel provisioning state.
type EventChannelProvisioningState string

const (
	// EventChannelProvisioningStateCanceled ...
	EventChannelProvisioningStateCanceled EventChannelProvisioningState = "Canceled"
	// EventChannelProvisioningStateCreating ...
	EventChannelProvisioningStateCreating EventChannelProvisioningState = "Creating"
	// EventChannelProvisioningStateDeleting ...
	EventChannelProvisioningStateDeleting EventChannelProvisioningState = "Deleting"
	// EventChannelProvisioningStateFailed ...
	EventChannelProvisioningStateFailed EventChannelProvisioningState = "Failed"
	// EventChannelProvisioningStateSucceeded ...
	EventChannelProvisioningStateSucceeded EventChannelProvisioningState = "Succeeded"
	// EventChannelProvisioningStateUpdating ...
	EventChannelProvisioningStateUpdating EventChannelProvisioningState = "Updating"
)

// PossibleEventChannelProvisioningStateValues returns an array of possible values for the EventChannelProvisioningState const type.
func PossibleEventChannelProvisioningStateValues() []EventChannelProvisioningState {
	return []EventChannelProvisioningState{EventChannelProvisioningStateCanceled, EventChannelProvisioningStateCreating, EventChannelProvisioningStateDeleting, EventChannelProvisioningStateFailed, EventChannelProvisioningStateSucceeded, EventChannelProvisioningStateUpdating}
}

// EventDefinitionKind enumerates the values for event definition kind.
type EventDefinitionKind string

const (
	// EventDefinitionKindInline ...
	EventDefinitionKindInline EventDefinitionKind = "Inline"
)

// PossibleEventDefinitionKindValues returns an array of possible values for the EventDefinitionKind const type.
func PossibleEventDefinitionKindValues() []EventDefinitionKind {
	return []EventDefinitionKind{EventDefinitionKindInline}
}

// EventDeliverySchema enumerates the values for event delivery schema.
type EventDeliverySchema string

const (
	// EventDeliverySchemaCloudEventSchemaV10 ...
	EventDeliverySchemaCloudEventSchemaV10 EventDeliverySchema = "CloudEventSchemaV1_0"
	// EventDeliverySchemaCustomInputSchema ...
	EventDeliverySchemaCustomInputSchema EventDeliverySchema = "CustomInputSchema"
	// EventDeliverySchemaEventGridSchema ...
	EventDeliverySchemaEventGridSchema EventDeliverySchema = "EventGridSchema"
)

// PossibleEventDeliverySchemaValues returns an array of possible values for the EventDeliverySchema const type.
func PossibleEventDeliverySchemaValues() []EventDeliverySchema {
	return []EventDeliverySchema{EventDeliverySchemaCloudEventSchemaV10, EventDeliverySchemaCustomInputSchema, EventDeliverySchemaEventGridSchema}
}

// EventSubscriptionIdentityType enumerates the values for event subscription identity type.
type EventSubscriptionIdentityType string

const (
	// EventSubscriptionIdentityTypeSystemAssigned ...
	EventSubscriptionIdentityTypeSystemAssigned EventSubscriptionIdentityType = "SystemAssigned"
	// EventSubscriptionIdentityTypeUserAssigned ...
	EventSubscriptionIdentityTypeUserAssigned EventSubscriptionIdentityType = "UserAssigned"
)

// PossibleEventSubscriptionIdentityTypeValues returns an array of possible values for the EventSubscriptionIdentityType const type.
func PossibleEventSubscriptionIdentityTypeValues() []EventSubscriptionIdentityType {
	return []EventSubscriptionIdentityType{EventSubscriptionIdentityTypeSystemAssigned, EventSubscriptionIdentityTypeUserAssigned}
}

// EventSubscriptionProvisioningState enumerates the values for event subscription provisioning state.
type EventSubscriptionProvisioningState string

const (
	// EventSubscriptionProvisioningStateAwaitingManualAction ...
	EventSubscriptionProvisioningStateAwaitingManualAction EventSubscriptionProvisioningState = "AwaitingManualAction"
	// EventSubscriptionProvisioningStateCanceled ...
	EventSubscriptionProvisioningStateCanceled EventSubscriptionProvisioningState = "Canceled"
	// EventSubscriptionProvisioningStateCreating ...
	EventSubscriptionProvisioningStateCreating EventSubscriptionProvisioningState = "Creating"
	// EventSubscriptionProvisioningStateDeleting ...
	EventSubscriptionProvisioningStateDeleting EventSubscriptionProvisioningState = "Deleting"
	// EventSubscriptionProvisioningStateFailed ...
	EventSubscriptionProvisioningStateFailed EventSubscriptionProvisioningState = "Failed"
	// EventSubscriptionProvisioningStateSucceeded ...
	EventSubscriptionProvisioningStateSucceeded EventSubscriptionProvisioningState = "Succeeded"
	// EventSubscriptionProvisioningStateUpdating ...
	EventSubscriptionProvisioningStateUpdating EventSubscriptionProvisioningState = "Updating"
)

// PossibleEventSubscriptionProvisioningStateValues returns an array of possible values for the EventSubscriptionProvisioningState const type.
func PossibleEventSubscriptionProvisioningStateValues() []EventSubscriptionProvisioningState {
	return []EventSubscriptionProvisioningState{EventSubscriptionProvisioningStateAwaitingManualAction, EventSubscriptionProvisioningStateCanceled, EventSubscriptionProvisioningStateCreating, EventSubscriptionProvisioningStateDeleting, EventSubscriptionProvisioningStateFailed, EventSubscriptionProvisioningStateSucceeded, EventSubscriptionProvisioningStateUpdating}
}

// IdentityType enumerates the values for identity type.
type IdentityType string

const (
	// IdentityTypeNone ...
	IdentityTypeNone IdentityType = "None"
	// IdentityTypeSystemAssigned ...
	IdentityTypeSystemAssigned IdentityType = "SystemAssigned"
	// IdentityTypeSystemAssignedUserAssigned ...
	IdentityTypeSystemAssignedUserAssigned IdentityType = "SystemAssigned, UserAssigned"
	// IdentityTypeUserAssigned ...
	IdentityTypeUserAssigned IdentityType = "UserAssigned"
)

// PossibleIdentityTypeValues returns an array of possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{IdentityTypeNone, IdentityTypeSystemAssigned, IdentityTypeSystemAssignedUserAssigned, IdentityTypeUserAssigned}
}

// InputSchema enumerates the values for input schema.
type InputSchema string

const (
	// InputSchemaCloudEventSchemaV10 ...
	InputSchemaCloudEventSchemaV10 InputSchema = "CloudEventSchemaV1_0"
	// InputSchemaCustomEventSchema ...
	InputSchemaCustomEventSchema InputSchema = "CustomEventSchema"
	// InputSchemaEventGridSchema ...
	InputSchemaEventGridSchema InputSchema = "EventGridSchema"
)

// PossibleInputSchemaValues returns an array of possible values for the InputSchema const type.
func PossibleInputSchemaValues() []InputSchema {
	return []InputSchema{InputSchemaCloudEventSchemaV10, InputSchemaCustomEventSchema, InputSchemaEventGridSchema}
}

// InputSchemaMappingType enumerates the values for input schema mapping type.
type InputSchemaMappingType string

const (
	// InputSchemaMappingTypeInputSchemaMapping ...
	InputSchemaMappingTypeInputSchemaMapping InputSchemaMappingType = "InputSchemaMapping"
	// InputSchemaMappingTypeJSON ...
	InputSchemaMappingTypeJSON InputSchemaMappingType = "Json"
)

// PossibleInputSchemaMappingTypeValues returns an array of possible values for the InputSchemaMappingType const type.
func PossibleInputSchemaMappingTypeValues() []InputSchemaMappingType {
	return []InputSchemaMappingType{InputSchemaMappingTypeInputSchemaMapping, InputSchemaMappingTypeJSON}
}

// IPActionType enumerates the values for ip action type.
type IPActionType string

const (
	// IPActionTypeAllow ...
	IPActionTypeAllow IPActionType = "Allow"
)

// PossibleIPActionTypeValues returns an array of possible values for the IPActionType const type.
func PossibleIPActionTypeValues() []IPActionType {
	return []IPActionType{IPActionTypeAllow}
}

// OperatorType enumerates the values for operator type.
type OperatorType string

const (
	// OperatorTypeAdvancedFilter ...
	OperatorTypeAdvancedFilter OperatorType = "AdvancedFilter"
	// OperatorTypeBoolEquals ...
	OperatorTypeBoolEquals OperatorType = "BoolEquals"
	// OperatorTypeIsNotNull ...
	OperatorTypeIsNotNull OperatorType = "IsNotNull"
	// OperatorTypeIsNullOrUndefined ...
	OperatorTypeIsNullOrUndefined OperatorType = "IsNullOrUndefined"
	// OperatorTypeNumberGreaterThan ...
	OperatorTypeNumberGreaterThan OperatorType = "NumberGreaterThan"
	// OperatorTypeNumberGreaterThanOrEquals ...
	OperatorTypeNumberGreaterThanOrEquals OperatorType = "NumberGreaterThanOrEquals"
	// OperatorTypeNumberIn ...
	OperatorTypeNumberIn OperatorType = "NumberIn"
	// OperatorTypeNumberInRange ...
	OperatorTypeNumberInRange OperatorType = "NumberInRange"
	// OperatorTypeNumberLessThan ...
	OperatorTypeNumberLessThan OperatorType = "NumberLessThan"
	// OperatorTypeNumberLessThanOrEquals ...
	OperatorTypeNumberLessThanOrEquals OperatorType = "NumberLessThanOrEquals"
	// OperatorTypeNumberNotIn ...
	OperatorTypeNumberNotIn OperatorType = "NumberNotIn"
	// OperatorTypeNumberNotInRange ...
	OperatorTypeNumberNotInRange OperatorType = "NumberNotInRange"
	// OperatorTypeStringBeginsWith ...
	OperatorTypeStringBeginsWith OperatorType = "StringBeginsWith"
	// OperatorTypeStringContains ...
	OperatorTypeStringContains OperatorType = "StringContains"
	// OperatorTypeStringEndsWith ...
	OperatorTypeStringEndsWith OperatorType = "StringEndsWith"
	// OperatorTypeStringIn ...
	OperatorTypeStringIn OperatorType = "StringIn"
	// OperatorTypeStringNotBeginsWith ...
	OperatorTypeStringNotBeginsWith OperatorType = "StringNotBeginsWith"
	// OperatorTypeStringNotContains ...
	OperatorTypeStringNotContains OperatorType = "StringNotContains"
	// OperatorTypeStringNotEndsWith ...
	OperatorTypeStringNotEndsWith OperatorType = "StringNotEndsWith"
	// OperatorTypeStringNotIn ...
	OperatorTypeStringNotIn OperatorType = "StringNotIn"
)

// PossibleOperatorTypeValues returns an array of possible values for the OperatorType const type.
func PossibleOperatorTypeValues() []OperatorType {
	return []OperatorType{OperatorTypeAdvancedFilter, OperatorTypeBoolEquals, OperatorTypeIsNotNull, OperatorTypeIsNullOrUndefined, OperatorTypeNumberGreaterThan, OperatorTypeNumberGreaterThanOrEquals, OperatorTypeNumberIn, OperatorTypeNumberInRange, OperatorTypeNumberLessThan, OperatorTypeNumberLessThanOrEquals, OperatorTypeNumberNotIn, OperatorTypeNumberNotInRange, OperatorTypeStringBeginsWith, OperatorTypeStringContains, OperatorTypeStringEndsWith, OperatorTypeStringIn, OperatorTypeStringNotBeginsWith, OperatorTypeStringNotContains, OperatorTypeStringNotEndsWith, OperatorTypeStringNotIn}
}

// ParentType enumerates the values for parent type.
type ParentType string

const (
	// ParentTypeDomains ...
	ParentTypeDomains ParentType = "domains"
	// ParentTypePartnerNamespaces ...
	ParentTypePartnerNamespaces ParentType = "partnerNamespaces"
	// ParentTypeTopics ...
	ParentTypeTopics ParentType = "topics"
)

// PossibleParentTypeValues returns an array of possible values for the ParentType const type.
func PossibleParentTypeValues() []ParentType {
	return []ParentType{ParentTypeDomains, ParentTypePartnerNamespaces, ParentTypeTopics}
}

// PartnerConfigurationProvisioningState enumerates the values for partner configuration provisioning state.
type PartnerConfigurationProvisioningState string

const (
	// PartnerConfigurationProvisioningStateCanceled ...
	PartnerConfigurationProvisioningStateCanceled PartnerConfigurationProvisioningState = "Canceled"
	// PartnerConfigurationProvisioningStateCreating ...
	PartnerConfigurationProvisioningStateCreating PartnerConfigurationProvisioningState = "Creating"
	// PartnerConfigurationProvisioningStateDeleting ...
	PartnerConfigurationProvisioningStateDeleting PartnerConfigurationProvisioningState = "Deleting"
	// PartnerConfigurationProvisioningStateFailed ...
	PartnerConfigurationProvisioningStateFailed PartnerConfigurationProvisioningState = "Failed"
	// PartnerConfigurationProvisioningStateSucceeded ...
	PartnerConfigurationProvisioningStateSucceeded PartnerConfigurationProvisioningState = "Succeeded"
	// PartnerConfigurationProvisioningStateUpdating ...
	PartnerConfigurationProvisioningStateUpdating PartnerConfigurationProvisioningState = "Updating"
)

// PossiblePartnerConfigurationProvisioningStateValues returns an array of possible values for the PartnerConfigurationProvisioningState const type.
func PossiblePartnerConfigurationProvisioningStateValues() []PartnerConfigurationProvisioningState {
	return []PartnerConfigurationProvisioningState{PartnerConfigurationProvisioningStateCanceled, PartnerConfigurationProvisioningStateCreating, PartnerConfigurationProvisioningStateDeleting, PartnerConfigurationProvisioningStateFailed, PartnerConfigurationProvisioningStateSucceeded, PartnerConfigurationProvisioningStateUpdating}
}

// PartnerDestinationActivationState enumerates the values for partner destination activation state.
type PartnerDestinationActivationState string

const (
	// PartnerDestinationActivationStateActivated ...
	PartnerDestinationActivationStateActivated PartnerDestinationActivationState = "Activated"
	// PartnerDestinationActivationStateNeverActivated ...
	PartnerDestinationActivationStateNeverActivated PartnerDestinationActivationState = "NeverActivated"
)

// PossiblePartnerDestinationActivationStateValues returns an array of possible values for the PartnerDestinationActivationState const type.
func PossiblePartnerDestinationActivationStateValues() []PartnerDestinationActivationState {
	return []PartnerDestinationActivationState{PartnerDestinationActivationStateActivated, PartnerDestinationActivationStateNeverActivated}
}

// PartnerDestinationProvisioningState enumerates the values for partner destination provisioning state.
type PartnerDestinationProvisioningState string

const (
	// PartnerDestinationProvisioningStateCanceled ...
	PartnerDestinationProvisioningStateCanceled PartnerDestinationProvisioningState = "Canceled"
	// PartnerDestinationProvisioningStateCreating ...
	PartnerDestinationProvisioningStateCreating PartnerDestinationProvisioningState = "Creating"
	// PartnerDestinationProvisioningStateDeleting ...
	PartnerDestinationProvisioningStateDeleting PartnerDestinationProvisioningState = "Deleting"
	// PartnerDestinationProvisioningStateFailed ...
	PartnerDestinationProvisioningStateFailed PartnerDestinationProvisioningState = "Failed"
	// PartnerDestinationProvisioningStateSucceeded ...
	PartnerDestinationProvisioningStateSucceeded PartnerDestinationProvisioningState = "Succeeded"
	// PartnerDestinationProvisioningStateUpdating ...
	PartnerDestinationProvisioningStateUpdating PartnerDestinationProvisioningState = "Updating"
)

// PossiblePartnerDestinationProvisioningStateValues returns an array of possible values for the PartnerDestinationProvisioningState const type.
func PossiblePartnerDestinationProvisioningStateValues() []PartnerDestinationProvisioningState {
	return []PartnerDestinationProvisioningState{PartnerDestinationProvisioningStateCanceled, PartnerDestinationProvisioningStateCreating, PartnerDestinationProvisioningStateDeleting, PartnerDestinationProvisioningStateFailed, PartnerDestinationProvisioningStateSucceeded, PartnerDestinationProvisioningStateUpdating}
}

// PartnerNamespaceProvisioningState enumerates the values for partner namespace provisioning state.
type PartnerNamespaceProvisioningState string

const (
	// PartnerNamespaceProvisioningStateCanceled ...
	PartnerNamespaceProvisioningStateCanceled PartnerNamespaceProvisioningState = "Canceled"
	// PartnerNamespaceProvisioningStateCreating ...
	PartnerNamespaceProvisioningStateCreating PartnerNamespaceProvisioningState = "Creating"
	// PartnerNamespaceProvisioningStateDeleting ...
	PartnerNamespaceProvisioningStateDeleting PartnerNamespaceProvisioningState = "Deleting"
	// PartnerNamespaceProvisioningStateFailed ...
	PartnerNamespaceProvisioningStateFailed PartnerNamespaceProvisioningState = "Failed"
	// PartnerNamespaceProvisioningStateSucceeded ...
	PartnerNamespaceProvisioningStateSucceeded PartnerNamespaceProvisioningState = "Succeeded"
	// PartnerNamespaceProvisioningStateUpdating ...
	PartnerNamespaceProvisioningStateUpdating PartnerNamespaceProvisioningState = "Updating"
)

// PossiblePartnerNamespaceProvisioningStateValues returns an array of possible values for the PartnerNamespaceProvisioningState const type.
func PossiblePartnerNamespaceProvisioningStateValues() []PartnerNamespaceProvisioningState {
	return []PartnerNamespaceProvisioningState{PartnerNamespaceProvisioningStateCanceled, PartnerNamespaceProvisioningStateCreating, PartnerNamespaceProvisioningStateDeleting, PartnerNamespaceProvisioningStateFailed, PartnerNamespaceProvisioningStateSucceeded, PartnerNamespaceProvisioningStateUpdating}
}

// PartnerRegistrationProvisioningState enumerates the values for partner registration provisioning state.
type PartnerRegistrationProvisioningState string

const (
	// PartnerRegistrationProvisioningStateCanceled ...
	PartnerRegistrationProvisioningStateCanceled PartnerRegistrationProvisioningState = "Canceled"
	// PartnerRegistrationProvisioningStateCreating ...
	PartnerRegistrationProvisioningStateCreating PartnerRegistrationProvisioningState = "Creating"
	// PartnerRegistrationProvisioningStateDeleting ...
	PartnerRegistrationProvisioningStateDeleting PartnerRegistrationProvisioningState = "Deleting"
	// PartnerRegistrationProvisioningStateFailed ...
	PartnerRegistrationProvisioningStateFailed PartnerRegistrationProvisioningState = "Failed"
	// PartnerRegistrationProvisioningStateSucceeded ...
	PartnerRegistrationProvisioningStateSucceeded PartnerRegistrationProvisioningState = "Succeeded"
	// PartnerRegistrationProvisioningStateUpdating ...
	PartnerRegistrationProvisioningStateUpdating PartnerRegistrationProvisioningState = "Updating"
)

// PossiblePartnerRegistrationProvisioningStateValues returns an array of possible values for the PartnerRegistrationProvisioningState const type.
func PossiblePartnerRegistrationProvisioningStateValues() []PartnerRegistrationProvisioningState {
	return []PartnerRegistrationProvisioningState{PartnerRegistrationProvisioningStateCanceled, PartnerRegistrationProvisioningStateCreating, PartnerRegistrationProvisioningStateDeleting, PartnerRegistrationProvisioningStateFailed, PartnerRegistrationProvisioningStateSucceeded, PartnerRegistrationProvisioningStateUpdating}
}

// PartnerRegistrationVisibilityState enumerates the values for partner registration visibility state.
type PartnerRegistrationVisibilityState string

const (
	// PartnerRegistrationVisibilityStateGenerallyAvailable ...
	PartnerRegistrationVisibilityStateGenerallyAvailable PartnerRegistrationVisibilityState = "GenerallyAvailable"
	// PartnerRegistrationVisibilityStateHidden ...
	PartnerRegistrationVisibilityStateHidden PartnerRegistrationVisibilityState = "Hidden"
	// PartnerRegistrationVisibilityStatePublicPreview ...
	PartnerRegistrationVisibilityStatePublicPreview PartnerRegistrationVisibilityState = "PublicPreview"
)

// PossiblePartnerRegistrationVisibilityStateValues returns an array of possible values for the PartnerRegistrationVisibilityState const type.
func PossiblePartnerRegistrationVisibilityStateValues() []PartnerRegistrationVisibilityState {
	return []PartnerRegistrationVisibilityState{PartnerRegistrationVisibilityStateGenerallyAvailable, PartnerRegistrationVisibilityStateHidden, PartnerRegistrationVisibilityStatePublicPreview}
}

// PartnerTopicActivationState enumerates the values for partner topic activation state.
type PartnerTopicActivationState string

const (
	// PartnerTopicActivationStateActivated ...
	PartnerTopicActivationStateActivated PartnerTopicActivationState = "Activated"
	// PartnerTopicActivationStateDeactivated ...
	PartnerTopicActivationStateDeactivated PartnerTopicActivationState = "Deactivated"
	// PartnerTopicActivationStateNeverActivated ...
	PartnerTopicActivationStateNeverActivated PartnerTopicActivationState = "NeverActivated"
)

// PossiblePartnerTopicActivationStateValues returns an array of possible values for the PartnerTopicActivationState const type.
func PossiblePartnerTopicActivationStateValues() []PartnerTopicActivationState {
	return []PartnerTopicActivationState{PartnerTopicActivationStateActivated, PartnerTopicActivationStateDeactivated, PartnerTopicActivationStateNeverActivated}
}

// PartnerTopicProvisioningState enumerates the values for partner topic provisioning state.
type PartnerTopicProvisioningState string

const (
	// PartnerTopicProvisioningStateCanceled ...
	PartnerTopicProvisioningStateCanceled PartnerTopicProvisioningState = "Canceled"
	// PartnerTopicProvisioningStateCreating ...
	PartnerTopicProvisioningStateCreating PartnerTopicProvisioningState = "Creating"
	// PartnerTopicProvisioningStateDeleting ...
	PartnerTopicProvisioningStateDeleting PartnerTopicProvisioningState = "Deleting"
	// PartnerTopicProvisioningStateFailed ...
	PartnerTopicProvisioningStateFailed PartnerTopicProvisioningState = "Failed"
	// PartnerTopicProvisioningStateSucceeded ...
	PartnerTopicProvisioningStateSucceeded PartnerTopicProvisioningState = "Succeeded"
	// PartnerTopicProvisioningStateUpdating ...
	PartnerTopicProvisioningStateUpdating PartnerTopicProvisioningState = "Updating"
)

// PossiblePartnerTopicProvisioningStateValues returns an array of possible values for the PartnerTopicProvisioningState const type.
func PossiblePartnerTopicProvisioningStateValues() []PartnerTopicProvisioningState {
	return []PartnerTopicProvisioningState{PartnerTopicProvisioningStateCanceled, PartnerTopicProvisioningStateCreating, PartnerTopicProvisioningStateDeleting, PartnerTopicProvisioningStateFailed, PartnerTopicProvisioningStateSucceeded, PartnerTopicProvisioningStateUpdating}
}

// PartnerTopicReadinessState enumerates the values for partner topic readiness state.
type PartnerTopicReadinessState string

const (
	// PartnerTopicReadinessStateActivatedByUser ...
	PartnerTopicReadinessStateActivatedByUser PartnerTopicReadinessState = "ActivatedByUser"
	// PartnerTopicReadinessStateDeactivatedByUser ...
	PartnerTopicReadinessStateDeactivatedByUser PartnerTopicReadinessState = "DeactivatedByUser"
	// PartnerTopicReadinessStateDeletedByUser ...
	PartnerTopicReadinessStateDeletedByUser PartnerTopicReadinessState = "DeletedByUser"
	// PartnerTopicReadinessStateNotActivatedByUserYet ...
	PartnerTopicReadinessStateNotActivatedByUserYet PartnerTopicReadinessState = "NotActivatedByUserYet"
)

// PossiblePartnerTopicReadinessStateValues returns an array of possible values for the PartnerTopicReadinessState const type.
func PossiblePartnerTopicReadinessStateValues() []PartnerTopicReadinessState {
	return []PartnerTopicReadinessState{PartnerTopicReadinessStateActivatedByUser, PartnerTopicReadinessStateDeactivatedByUser, PartnerTopicReadinessStateDeletedByUser, PartnerTopicReadinessStateNotActivatedByUserYet}
}

// PartnerTopicRoutingMode enumerates the values for partner topic routing mode.
type PartnerTopicRoutingMode string

const (
	// PartnerTopicRoutingModeChannelNameHeader ...
	PartnerTopicRoutingModeChannelNameHeader PartnerTopicRoutingMode = "ChannelNameHeader"
	// PartnerTopicRoutingModeSourceEventAttribute ...
	PartnerTopicRoutingModeSourceEventAttribute PartnerTopicRoutingMode = "SourceEventAttribute"
)

// PossiblePartnerTopicRoutingModeValues returns an array of possible values for the PartnerTopicRoutingMode const type.
func PossiblePartnerTopicRoutingModeValues() []PartnerTopicRoutingMode {
	return []PartnerTopicRoutingMode{PartnerTopicRoutingModeChannelNameHeader, PartnerTopicRoutingModeSourceEventAttribute}
}

// PersistedConnectionStatus enumerates the values for persisted connection status.
type PersistedConnectionStatus string

const (
	// PersistedConnectionStatusApproved ...
	PersistedConnectionStatusApproved PersistedConnectionStatus = "Approved"
	// PersistedConnectionStatusDisconnected ...
	PersistedConnectionStatusDisconnected PersistedConnectionStatus = "Disconnected"
	// PersistedConnectionStatusPending ...
	PersistedConnectionStatusPending PersistedConnectionStatus = "Pending"
	// PersistedConnectionStatusRejected ...
	PersistedConnectionStatusRejected PersistedConnectionStatus = "Rejected"
)

// PossiblePersistedConnectionStatusValues returns an array of possible values for the PersistedConnectionStatus const type.
func PossiblePersistedConnectionStatusValues() []PersistedConnectionStatus {
	return []PersistedConnectionStatus{PersistedConnectionStatusApproved, PersistedConnectionStatusDisconnected, PersistedConnectionStatusPending, PersistedConnectionStatusRejected}
}

// PublicNetworkAccess enumerates the values for public network access.
type PublicNetworkAccess string

const (
	// PublicNetworkAccessDisabled ...
	PublicNetworkAccessDisabled PublicNetworkAccess = "Disabled"
	// PublicNetworkAccessEnabled ...
	PublicNetworkAccessEnabled PublicNetworkAccess = "Enabled"
)

// PossiblePublicNetworkAccessValues returns an array of possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{PublicNetworkAccessDisabled, PublicNetworkAccessEnabled}
}

// ReadinessState enumerates the values for readiness state.
type ReadinessState string

const (
	// ReadinessStateActivated ...
	ReadinessStateActivated ReadinessState = "Activated"
	// ReadinessStateNeverActivated ...
	ReadinessStateNeverActivated ReadinessState = "NeverActivated"
)

// PossibleReadinessStateValues returns an array of possible values for the ReadinessState const type.
func PossibleReadinessStateValues() []ReadinessState {
	return []ReadinessState{ReadinessStateActivated, ReadinessStateNeverActivated}
}

// ResourceKind enumerates the values for resource kind.
type ResourceKind string

const (
	// ResourceKindAzure ...
	ResourceKindAzure ResourceKind = "Azure"
	// ResourceKindAzureArc ...
	ResourceKindAzureArc ResourceKind = "AzureArc"
)

// PossibleResourceKindValues returns an array of possible values for the ResourceKind const type.
func PossibleResourceKindValues() []ResourceKind {
	return []ResourceKind{ResourceKindAzure, ResourceKindAzureArc}
}

// ResourceProvisioningState enumerates the values for resource provisioning state.
type ResourceProvisioningState string

const (
	// ResourceProvisioningStateCanceled ...
	ResourceProvisioningStateCanceled ResourceProvisioningState = "Canceled"
	// ResourceProvisioningStateCreating ...
	ResourceProvisioningStateCreating ResourceProvisioningState = "Creating"
	// ResourceProvisioningStateDeleting ...
	ResourceProvisioningStateDeleting ResourceProvisioningState = "Deleting"
	// ResourceProvisioningStateFailed ...
	ResourceProvisioningStateFailed ResourceProvisioningState = "Failed"
	// ResourceProvisioningStateSucceeded ...
	ResourceProvisioningStateSucceeded ResourceProvisioningState = "Succeeded"
	// ResourceProvisioningStateUpdating ...
	ResourceProvisioningStateUpdating ResourceProvisioningState = "Updating"
)

// PossibleResourceProvisioningStateValues returns an array of possible values for the ResourceProvisioningState const type.
func PossibleResourceProvisioningStateValues() []ResourceProvisioningState {
	return []ResourceProvisioningState{ResourceProvisioningStateCanceled, ResourceProvisioningStateCreating, ResourceProvisioningStateDeleting, ResourceProvisioningStateFailed, ResourceProvisioningStateSucceeded, ResourceProvisioningStateUpdating}
}

// ResourceRegionType enumerates the values for resource region type.
type ResourceRegionType string

const (
	// ResourceRegionTypeGlobalResource ...
	ResourceRegionTypeGlobalResource ResourceRegionType = "GlobalResource"
	// ResourceRegionTypeRegionalResource ...
	ResourceRegionTypeRegionalResource ResourceRegionType = "RegionalResource"
)

// PossibleResourceRegionTypeValues returns an array of possible values for the ResourceRegionType const type.
func PossibleResourceRegionTypeValues() []ResourceRegionType {
	return []ResourceRegionType{ResourceRegionTypeGlobalResource, ResourceRegionTypeRegionalResource}
}

// Sku enumerates the values for sku.
type Sku string

const (
	// SkuBasic ...
	SkuBasic Sku = "Basic"
	// SkuPremium ...
	SkuPremium Sku = "Premium"
)

// PossibleSkuValues returns an array of possible values for the Sku const type.
func PossibleSkuValues() []Sku {
	return []Sku{SkuBasic, SkuPremium}
}

// TopicProvisioningState enumerates the values for topic provisioning state.
type TopicProvisioningState string

const (
	// TopicProvisioningStateCanceled ...
	TopicProvisioningStateCanceled TopicProvisioningState = "Canceled"
	// TopicProvisioningStateCreating ...
	TopicProvisioningStateCreating TopicProvisioningState = "Creating"
	// TopicProvisioningStateDeleting ...
	TopicProvisioningStateDeleting TopicProvisioningState = "Deleting"
	// TopicProvisioningStateFailed ...
	TopicProvisioningStateFailed TopicProvisioningState = "Failed"
	// TopicProvisioningStateSucceeded ...
	TopicProvisioningStateSucceeded TopicProvisioningState = "Succeeded"
	// TopicProvisioningStateUpdating ...
	TopicProvisioningStateUpdating TopicProvisioningState = "Updating"
)

// PossibleTopicProvisioningStateValues returns an array of possible values for the TopicProvisioningState const type.
func PossibleTopicProvisioningStateValues() []TopicProvisioningState {
	return []TopicProvisioningState{TopicProvisioningStateCanceled, TopicProvisioningStateCreating, TopicProvisioningStateDeleting, TopicProvisioningStateFailed, TopicProvisioningStateSucceeded, TopicProvisioningStateUpdating}
}

// TopicTypeProvisioningState enumerates the values for topic type provisioning state.
type TopicTypeProvisioningState string

const (
	// TopicTypeProvisioningStateCanceled ...
	TopicTypeProvisioningStateCanceled TopicTypeProvisioningState = "Canceled"
	// TopicTypeProvisioningStateCreating ...
	TopicTypeProvisioningStateCreating TopicTypeProvisioningState = "Creating"
	// TopicTypeProvisioningStateDeleting ...
	TopicTypeProvisioningStateDeleting TopicTypeProvisioningState = "Deleting"
	// TopicTypeProvisioningStateFailed ...
	TopicTypeProvisioningStateFailed TopicTypeProvisioningState = "Failed"
	// TopicTypeProvisioningStateSucceeded ...
	TopicTypeProvisioningStateSucceeded TopicTypeProvisioningState = "Succeeded"
	// TopicTypeProvisioningStateUpdating ...
	TopicTypeProvisioningStateUpdating TopicTypeProvisioningState = "Updating"
)

// PossibleTopicTypeProvisioningStateValues returns an array of possible values for the TopicTypeProvisioningState const type.
func PossibleTopicTypeProvisioningStateValues() []TopicTypeProvisioningState {
	return []TopicTypeProvisioningState{TopicTypeProvisioningStateCanceled, TopicTypeProvisioningStateCreating, TopicTypeProvisioningStateDeleting, TopicTypeProvisioningStateFailed, TopicTypeProvisioningStateSucceeded, TopicTypeProvisioningStateUpdating}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeDeliveryAttributeMapping ...
	TypeDeliveryAttributeMapping Type = "DeliveryAttributeMapping"
	// TypeDynamic ...
	TypeDynamic Type = "Dynamic"
	// TypeStatic ...
	TypeStatic Type = "Static"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeDeliveryAttributeMapping, TypeDynamic, TypeStatic}
}

// VerifiedPartnerProvisioningState enumerates the values for verified partner provisioning state.
type VerifiedPartnerProvisioningState string

const (
	// VerifiedPartnerProvisioningStateCanceled ...
	VerifiedPartnerProvisioningStateCanceled VerifiedPartnerProvisioningState = "Canceled"
	// VerifiedPartnerProvisioningStateCreating ...
	VerifiedPartnerProvisioningStateCreating VerifiedPartnerProvisioningState = "Creating"
	// VerifiedPartnerProvisioningStateDeleting ...
	VerifiedPartnerProvisioningStateDeleting VerifiedPartnerProvisioningState = "Deleting"
	// VerifiedPartnerProvisioningStateFailed ...
	VerifiedPartnerProvisioningStateFailed VerifiedPartnerProvisioningState = "Failed"
	// VerifiedPartnerProvisioningStateSucceeded ...
	VerifiedPartnerProvisioningStateSucceeded VerifiedPartnerProvisioningState = "Succeeded"
	// VerifiedPartnerProvisioningStateUpdating ...
	VerifiedPartnerProvisioningStateUpdating VerifiedPartnerProvisioningState = "Updating"
)

// PossibleVerifiedPartnerProvisioningStateValues returns an array of possible values for the VerifiedPartnerProvisioningState const type.
func PossibleVerifiedPartnerProvisioningStateValues() []VerifiedPartnerProvisioningState {
	return []VerifiedPartnerProvisioningState{VerifiedPartnerProvisioningStateCanceled, VerifiedPartnerProvisioningStateCreating, VerifiedPartnerProvisioningStateDeleting, VerifiedPartnerProvisioningStateFailed, VerifiedPartnerProvisioningStateSucceeded, VerifiedPartnerProvisioningStateUpdating}
}
