// -*- c++ -*-
// generated by glade--
//------------------------------------------------------------------------------
// $Id: GeneralPref.h,v 1.13 2008/05/19 03:39:13 vlg Exp $
//------------------------------------------------------------------------------
//                            GeneralPref.h
//------------------------------------------------------------------------------
//  Copyright (c) 2004,2006 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Sun May 30 21:09:23 EDT 2004
//
//------------------------------------------------------------------------------

#ifndef _GENERALPREF_H
#define _GENERALPREF_H

#include <gtkmm/entry.h>
#include <gtkmm/button.h>
#include <gtkmm/box.h>
#include <gtkmm/checkbutton.h>
#include <gtkmm/label.h>
#include <gtkmm/table.h>
#include <gtkmm/fontselection.h>

class PrefWindow;

/**-----------------------------------------------------------------------------
 **	Compound history size option
 **-----------------------------------------------------------------------------
 */
class HistSizeBox : public Gtk::HBox
{
public:
	HistSizeBox ();

	Gtk::Entry* get_entry () { return m_entry; }
	void set_value (int v_);
	int  get_value ();

private:
	Gtk::Label*  m_label;
	Gtk::Entry*  m_entry;
};

/**-----------------------------------------------------------------------------
 *	General Preferences tab
 **-----------------------------------------------------------------------------
 */
class GeneralPref : public Gtk::VBox
{  
public:
    GeneralPref (PrefWindow& parent_);

    void changed_cb        ();
    void load_from_config  ();
    void save_to_config    ();

protected:
    PrefWindow&       m_pref_window;

    Gtk::CheckButton* m_dup_checkbutton;
	Gtk::CheckButton* m_relpath_checkbutton;
	Gtk::CheckButton* m_keys_shortcuts_checkbutton;
	Gtk::CheckButton* m_auto_pronounce_checkbutton;
	Gtk::CheckButton* m_va_control_checkbutton;
	Gtk::CheckButton* m_si_control_checkbutton;

	HistSizeBox*      m_hist_size;
};

/**-----------------------------------------------------------------------------
 *	Some useful macros
 **-----------------------------------------------------------------------------
 */
#define SET_FRAME(f,l,w) \
	f->set_shadow_type  (Gtk::SHADOW_ETCHED_IN); \
	f->set_border_width (4); \
	f->set_label_align  (1, 1); \
	f->set_label_widget (*l); \
	f->add (*w);

#define MAKE_EMPTY_LABEL(l) \
	l = Gtk::manage(new Gtk::Label("")); \
	l->set_alignment  (0.5,0.5); \
	l->set_padding    (0,0); \
	l->set_justify    (Gtk::JUSTIFY_LEFT); \
	l->set_line_wrap  (false); \
	l->set_use_markup (false); \
	l->set_selectable (false);

#define SET_CHECKBUTTON(b) \
	b->set_flags  (Gtk::CAN_FOCUS); \
	b->set_relief (Gtk::RELIEF_NORMAL); \
	b->set_mode   (true); \
    b->set_active (false); \
	b->set_border_width (4); \
	b->set_alignment (0.1, 0);

#endif
