---
tweet: What's new in Joplin 3.2
forum_url: https://discourse.joplinapp.org/t/43101
---

# What's new in Joplin 3.2

## Import OneNote Archives

Joplin now supports importing OneNote archives, a significant step for users transitioning from OneNote. Microsoft has long made it challenging to leave OneNote, offering limited export options and complex formats that make it difficult for app developers to support it. Despite these hurdles, @pedr tackled these issues head-on, developing an import tool that simplifies the process. This addition makes Joplin a practical choice for those looking to move away from OneNote's ecosystem.

To use this feature, select **File** => **Import** => **ZIP - OneNote Notebook**

## Multi-window support

We're excited to introduce Multi-Window Support, a highly requested feature that makes managing multiple notes easier than ever. With this update, you can open notes in different windows and each window operates independently, allowing you to compare notes, reference content, and organise projects with greater flexibility.

To use this feature, right-click on a note, select **Open in...** and select **Edit in new window**

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20250114-multi-window.png)

## Customisable toolbar on mobile

The new customisable toolbar on mobile is now draggable, making it easier to access the buttons you need. You can also choose which buttons to display by tapping the Cog button, allowing for a more personalised and efficient note-editing experience!

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20250114-mobile-toolbar.png)

## Enhanced Accessibility

In order to implement the [WCAG 2.0 guidelines](https://www.w3.org/TR/WCAG20/), accessibility has seen a substantial upgrade thanks to the efforts of @personalizedrefrigerator. The desktop and mobile apps now offer better keyboard navigation, including improved functionality in dropdown menus and settings. Focus indicators have been made more visible, while ARIA labels have been added to boost compatibility with screen readers. Specific areas like note attachments, sidebars, and dialogs have also been optimised to ensure accessibility for all users.

## Refined Drawing and Markdown Editing

Joplin's drawing and editing features have been fine-tuned for a smoother experience. Freehand Drawing on mobile and desktop has been updated to version 2.14.0, addressing several usability issues and bugs. Additionally, the Freehand Drawing plugin is now part of the desktop app by default. These changes enhance the reliability and integration of the drawing tool.

## Faster and more secure encryption

For GSoC 2024, @wh201906 worked on optimising the encryption and decryption processes, boosting speed for mobile devices in particular (but desktop too). Additionally, the encryption security was improved by transitioning to a more robust 256-bit key.

As of now this feature is optional and can be enabled by going to the **Configuration Screen**, then **Synchronisation** => **Advanced options** => **Use beta encryption**.

## Expanded Plugin Support

Developers will appreciate the updates to Joplin's plugin ecosystem. A new API has been introduced to create [toast notifications](https://joplinapp.org/api/references/plugin_api/classes/joplinviewsdialogs.html#showtoast), alongside updates to CodeMirror packages. A new [`renderMarkup`](https://github.com/laurent22/joplin/blob/5ee8a9a45493683c72a36b52e1460b5acdd4f1ac/packages/lib/commands/renderMarkup.ts#L23) command has been introduced to allow you to render Markdown content to HTML using the Joplin built-in API.

# Full changelogs

This is just an overview of the main features. The full changelogs are available there:

- Desktop: https://joplinapp.org/help/about/changelog/desktop
- Android: https://joplinapp.org/help/about/changelog/android/
- iOS: https://joplinapp.org/help/about/changelog/ios/