/*******************************************************************************
*                                                                              *
*   (C) 1997-2021 by Ernst W. Mayer.                                           *
*                                                                              *
*  This program is free software; you can redistribute it and/or modify it     *
*  under the terms of the GNU General Public License as published by the       *
*  Free Software Foundation; either version 2 of the License, or (at your      *
*  option) any later version.                                                  *
*                                                                              *
*  This program is distributed in the hope that it will be useful, but WITHOUT *
*  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or       *
*  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for   *
*  more details.                                                               *
*                                                                              *
*  You should have received a copy of the GNU General Public License along     *
*  with this program; see the file GPL.txt.  If not, you may view one at       *
*  http://www.fsf.org/licenses/licenses.html, or obtain one by writing to the  *
*  Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA     *
*  02111-1307, USA.                                                            *
*                                                                              *
*******************************************************************************/

#include "radix1024.h"

// Skip the usual include-this-header-file-if-it-was-not-included-before #ifndef wapper,
// since this file is not for defines/typedefs and such but rather to store a lengthy sonst-array-declaration
// and thus needs to be inline-able in multiple places in a source filing making use of it.

const double DFT1024_TWIDDLES[64][30] = {
	{ 1,0, 1,0, 1,0, 1,0, 1,0, 1,0, 1,0, 1,0, 1,0, 1,0, 1,0, 1,0, 1,0, 1,0, 1,0 },
	{ 0,1, ISRT2,ISRT2, -ISRT2,ISRT2, c16,s16, -s16,c16, s16,c16, -c16,s16, c32_1,s32_1, -s32_1,c32_1, s32_3,c32_3, -c32_3,s32_3, c32_3,s32_3, -s32_3,c32_3, s32_1,c32_1, -c32_1,s32_1 } ,
	{ ISRT2,ISRT2, c16,s16, s16,c16, c32_1,s32_1, s32_3,c32_3, c32_3,s32_3, s32_1,c32_1, c64_1,s64_1, s64_7,c64_7, c64_5,s64_5, s64_3,c64_3, c64_3,s64_3, s64_5,c64_5, c64_7,s64_7, s64_1,c64_1 } ,
	{ -ISRT2,ISRT2, s16,c16, -c16,-s16, c32_3,s32_3, -c32_1,s32_1, -s32_1,c32_1, -s32_3,-c32_3, c64_3,s64_3, -c64_5,s64_5, s64_1,c64_1, -c64_7,-s64_7, s64_7,c64_7, -c64_1,-s64_1, -s64_5,c64_5, -s64_3,-c64_3 } ,
	{ c16,s16, c32_1,s32_1, c32_3,s32_3, c64_1,s64_1, c64_5,s64_5, c64_3,s64_3, c64_7,s64_7, c128_1,s128_1, c128_9,s128_9, c128_5,s128_5, c128_d,s128_d, c128_3,s128_3, c128_b,s128_b, c128_7,s128_7, c128_f,s128_f } ,
	{ -s16,c16, s32_3,c32_3, -c32_1,s32_1, c64_5,s64_5, -c64_7,s64_7, s64_1,c64_1, -c64_3,-s64_3, c128_5,s128_5, -s128_d,c128_d, s128_7,c128_7, -c128_1,-s128_1, c128_f,s128_f, -c128_9,s128_9, -s128_3,c128_3, -c128_b,-s128_b } ,
	{ s16,c16, c32_3,s32_3, -s32_1,c32_1, c64_3,s64_3, s64_1,c64_1, s64_7,c64_7, -s64_5,c64_5, c128_3,s128_3, s128_5,c128_5, c128_f,s128_f, -s128_7,c128_7, c128_9,s128_9, -s128_1,c128_1, s128_b,c128_b, -s128_d,c128_d } ,
	{ -c16,s16, s32_1,c32_1, -s32_3,-c32_3, c64_7,s64_7, -c64_3,-s64_3, -s64_5,c64_5, s64_1,-c64_1, c128_7,s128_7, -c128_1,s128_1, -s128_3,c128_3, -s128_5,-c128_5, s128_b,c128_b, -c128_d,-s128_d, -c128_f,s128_f, s128_9,-c128_9 } ,
	{ c32_1,s32_1, c64_1,s64_1, c64_3,s64_3, c128_1,s128_1, c128_5,s128_5, c128_3,s128_3, c128_7,s128_7, c256_01,s256_01, c256_09,s256_09, c256_05,s256_05, c256_0d,s256_0d, c256_03,s256_03, c256_0b,s256_0b, c256_07,s256_07, c256_0f,s256_0f } ,
	{ -s32_1,c32_1, s64_7,c64_7, -c64_5,s64_5, c128_9,s128_9, -s128_d,c128_d, s128_5,c128_5, -c128_1,s128_1, c256_09,s256_09, -s256_11,c256_11, s256_13,c256_13, -c256_0b,s256_0b, c256_1b,s256_1b, -c256_1d,s256_1d, s256_01,c256_01, -c256_07,-s256_07 } ,
	{ s32_3,c32_3, c64_5,s64_5, s64_1,c64_1, c128_5,s128_5, s128_7,c128_7, c128_f,s128_f, -s128_3,c128_3, c256_05,s256_05, s256_13,c256_13, c256_19,s256_19, -s256_01,c256_01, c256_0f,s256_0f, s256_09,c256_09, s256_1d,c256_1d, -s256_0b,c256_0b } ,
	{ -c32_3,s32_3, s64_3,c64_3, -c64_7,-s64_7, c128_d,s128_d, -c128_1,-s128_1, -s128_7,c128_7, -s128_5,-c128_5, c256_0d,s256_0d, -c256_0b,s256_0b, -s256_01,c256_01, -s256_17,-c256_17, s256_19,c256_19, -c256_0f,-s256_0f, -s256_1b,c256_1b, s256_03,-c256_03 } ,
	{ c32_3,s32_3, c64_3,s64_3, s64_7,c64_7, c128_3,s128_3, c128_f,s128_f, c128_9,s128_9, s128_b,c128_b, c256_03,s256_03, c256_1b,s256_1b, c256_0f,s256_0f, s256_19,c256_19, c256_09,s256_09, s256_1f,c256_1f, c256_15,s256_15, s256_13,c256_13 } ,
	{ -s32_3,c32_3, s64_5,c64_5, -c64_1,-s64_1, c128_b,s128_b, -c128_9,s128_9, -s128_1,c128_1, -c128_d,-s128_d, c256_0b,s256_0b, -c256_1d,s256_1d, s256_09,c256_09, -c256_0f,-s256_0f, s256_1f,c256_1f, -c256_07,s256_07, -s256_0d,c256_0d, -s256_1b,-c256_1b } ,
	{ s32_1,c32_1, c64_7,s64_7, -s64_5,c64_5, c128_7,s128_7, -s128_3,c128_3, s128_b,c128_b, -c128_f,s128_f, c256_07,s256_07, s256_01,c256_01, s256_1d,c256_1d, -s256_1b,c256_1b, c256_15,s256_15, -s256_0d,c256_0d, s256_0f,c256_0f, -c256_17,s256_17 } ,
	{ -c32_1,s32_1, s64_1,c64_1, -s64_3,-c64_3, c128_f,s128_f, -c128_b,-s128_b, -s128_d,c128_d, s128_9,-c128_9, c256_0f,s256_0f, -c256_07,-s256_07, -s256_0b,c256_0b, s256_03,-c256_03, s256_13,c256_13, -s256_1b,-c256_1b, -c256_17,s256_17, c256_1f,-s256_1f } ,
	{ c64_1,s64_1, c128_1,s128_1, c128_3,s128_3, c256_01,s256_01, c256_05,s256_05, c256_03,s256_03, c256_07,s256_07, c512_01,s512_01, c512_09,s512_09, c512_05,s512_05, c512_0d,s512_0d, c512_03,s512_03, c512_0b,s512_0b, c512_07,s512_07, c512_0f,s512_0f } ,
	{ -s64_1,c64_1, s128_f,c128_f, -c128_d,s128_d, c256_11,s256_11, -s256_15,c256_15, s256_0d,c256_0d, -c256_09,s256_09, c512_11,s512_11, -s512_19,c512_19, s512_2b,c512_2b, -c512_23,s512_23, c512_33,s512_33, -s512_3b,c512_3b, s512_09,c512_09, -c512_01,s512_01 } ,
	{ s64_7,c64_7, c128_9,s128_9, s128_5,c128_5, c256_09,s256_09, s256_13,c256_13, c256_1b,s256_1b, s256_01,c256_01, c512_09,s512_09, s512_2f,c512_2f, c512_2d,s512_2d, s512_0b,c512_0b, c512_1b,s512_1b, s512_1d,c512_1d, c512_3f,s512_3f, -s512_07,c512_07 } ,
	{ -c64_7,s64_7, s128_7,c128_7, -c128_b,-s128_b, c256_19,s256_19, -c256_03,s256_03, -s256_0b,c256_0b, -s256_11,-c256_11, c512_19,s512_19, -c512_1f,s512_1f, s512_03,c512_03, -s512_3b,-c512_3b, s512_35,c512_35, -c512_13,-s512_13, -s512_2f,c512_2f, -s512_09,-c512_09 } ,
	{ c64_5,s64_5, c128_5,s128_5, c128_f,s128_f, c256_05,s256_05, c256_19,s256_19, c256_0f,s256_0f, s256_1d,c256_1d, c512_05,s512_05, c512_2d,s512_2d, c512_19,s512_19, s512_3f,c512_3f, c512_0f,s512_0f, c512_37,s512_37, c512_23,s512_23, s512_35,c512_35 } ,
	{ -s64_5,c64_5, s128_b,c128_b, -c128_1,s128_1, c256_15,s256_15, -c256_17,s256_17, s256_01,c256_01, -c256_13,-s256_13, c512_15,s512_15, -s512_3d,c512_3d, s512_17,c512_17, -c512_11,-s512_11, c512_3f,s512_3f, -c512_19,s512_19, -s512_13,c512_13, -c512_3b,-s512_3b } ,
	{ s64_3,c64_3, c128_d,s128_d, -s128_7,c128_7, c256_0d,s256_0d, -s256_01,c256_01, s256_19,c256_19, -s256_1b,c256_1b, c512_0d,s512_0d, s512_0b,c512_0b, s512_3f,c512_3f, -s512_29,c512_29, c512_27,s512_27, -s512_0f,c512_0f, s512_25,c512_25, -c512_3d,s512_3d } ,
	{ -c64_3,s64_3, s128_3,c128_3, -s128_9,-c128_9, c256_1d,s256_1d, -c256_11,-s256_11, -s256_17,c256_17, s256_0b,-c256_0b, c512_1d,s512_1d, -c512_05,-s512_05, -s512_11,c512_11, -s512_07,-c512_07, s512_29,c512_29, -c512_3f,-s512_3f, -c512_35,s512_35, s512_33,-c512_33 } ,
	{ c64_3,s64_3, c128_3,s128_3, c128_9,s128_9, c256_03,s256_03, c256_0f,s256_0f, c256_09,s256_09, c256_15,s256_15, c512_03,s512_03, c512_1b,s512_1b, c512_0f,s512_0f, c512_27,s512_27, c512_09,s512_09, c512_21,s512_21, c512_15,s512_15, c512_2d,s512_2d } ,
	{ -s64_3,c64_3, s128_d,c128_d, -c128_7,s128_7, c256_13,s256_13, -s256_1f,c256_1f, s256_07,c256_07, -c256_05,-s256_05, c512_13,s512_13, -s512_2b,c512_2b, s512_21,c512_21, -c512_09,s512_09, c512_39,s512_39, -c512_2f,s512_2f, -s512_05,c512_05, -c512_1d,-s512_1d } ,
	{ s64_5,c64_5, c128_b,s128_b, -s128_1,c128_1, c256_0b,s256_0b, s256_09,c256_09, s256_1f,c256_1f, -s256_0d,c256_0d, c512_0b,s512_0b, s512_1d,c512_1d, c512_37,s512_37, -s512_0f,c512_0f, c512_21,s512_21, s512_07,c512_07, s512_33,c512_33, -s512_25,c512_25 } ,
	{ -c64_5,s64_5, s128_5,c128_5, -s128_f,-c128_f, c256_1b,s256_1b, -c256_07,-s256_07, -s256_11,c256_11, -s256_03,-c256_03, c512_1b,s512_1b, -c512_0d,s512_0d, -s512_07,c512_07, -s512_21,-c512_21, s512_2f,c512_2f, -c512_29,-s512_29, -s512_3d,c512_3d, s512_15,-c512_15 } ,
	{ c64_7,s64_7, c128_7,s128_7, s128_b,c128_b, c256_07,s256_07, s256_1d,c256_1d, c256_15,s256_15, s256_0f,c256_0f, c512_07,s512_07, c512_3f,s512_3f, c512_23,s512_23, s512_25,c512_25, c512_15,s512_15, s512_33,c512_33, c512_31,s512_31, s512_17,c512_17 } ,
	{ -s64_7,c64_7, s128_9,c128_9, -c128_5,-s128_5, c256_17,s256_17, -c256_0d,s256_0d, -s256_05,c256_05, -s256_1f,-c256_1f, c512_17,s512_17, -c512_31,s512_31, s512_0d,c512_0d, -c512_2b,-s512_2b, s512_3b,c512_3b, -c512_03,s512_03, -s512_21,c512_21, -s512_27,-c512_27 } ,
	{ s64_1,c64_1, c128_f,s128_f, -s128_d,c128_d, c256_0f,s256_0f, -s256_0b,c256_0b, s256_13,c256_13, -c256_17,s256_17, c512_0f,s512_0f, -s512_07,c512_07, s512_35,c512_35, -c512_3d,s512_3d, c512_2d,s512_2d, -s512_25,c512_25, s512_17,c512_17, -c512_1f,s512_1f } ,
	{ -c64_1,s64_1, s128_1,c128_1, -s128_3,-c128_3, c256_1f,s256_1f, -c256_1b,-s256_1b, -s256_1d,c256_1d, s256_19,-c256_19, c512_1f,s512_1f, -c512_17,-s512_17, -s512_1b,c512_1b, s512_13,-c512_13, s512_23,c512_23, -s512_2b,-c512_2b, -c512_27,s512_27, c512_2f,-s512_2f } ,
	{ c128_1,s128_1, c256_01,s256_01, c256_03,s256_03, c512_01,s512_01, c512_05,s512_05, c512_03,s512_03, c512_07,s512_07, c1024_01,s1024_01, c1024_09,s1024_09, c1024_05,s1024_05, c1024_0d,s1024_0d, c1024_03,s1024_03, c1024_0b,s1024_0b, c1024_07,s1024_07, c1024_0f,s1024_0f } ,
	{ -s128_1,c128_1, s256_1f,c256_1f, -c256_1d,s256_1d, c512_21,s512_21, -s512_25,c512_25, s512_1d,c512_1d, -c512_19,s512_19, c1024_21,s1024_21, -s1024_29,c1024_29, s1024_5b,c1024_5b, -c1024_53,s1024_53, c1024_63,s1024_63, -s1024_6b,c1024_6b, s1024_19,c1024_19, -c1024_11,s1024_11 } ,
	{ s128_f,c128_f, c256_11,s256_11, s256_0d,c256_0d, c512_11,s512_11, s512_2b,c512_2b, c512_33,s512_33, s512_09,c512_09, c1024_11,s1024_11, s1024_67,c1024_67, c1024_55,s1024_55, s1024_23,c1024_23, c1024_33,s1024_33, s1024_45,c1024_45, c1024_77,s1024_77, s1024_01,c1024_01 } ,
	{ -c128_f,s128_f, s256_0f,c256_0f, -c256_13,-s256_13, c512_31,s512_31, -c512_0b,s512_0b, -s512_13,c512_13, -s512_29,-c512_29, c1024_31,s1024_31, -c1024_47,s1024_47, s1024_0b,c1024_0b, -c1024_7d,-s1024_7d, s1024_6d,c1024_6d, -c1024_1b,-s1024_1b, -s1024_57,c1024_57, -s1024_21,-c1024_21 } ,
	{ c128_9,s128_9, c256_09,s256_09, c256_1b,s256_1b, c512_09,s512_09, c512_2d,s512_2d, c512_1b,s512_1b, c512_3f,s512_3f, c1024_09,s1024_09, c1024_51,s1024_51, c1024_2d,s1024_2d, c1024_75,s1024_75, c1024_1b,s1024_1b, c1024_63,s1024_63, c1024_3f,s1024_3f, s1024_79,c1024_79 } ,
	{ -s128_9,c128_9, s256_17,c256_17, -c256_05,s256_05, c512_29,s512_29, -c512_33,s512_33, s512_05,c512_05, -c512_1f,-s512_1f, c1024_29,s1024_29, -s1024_71,c1024_71, s1024_33,c1024_33, -c1024_15,-s1024_15, c1024_7b,s1024_7b, -c1024_3d,s1024_3d, -s1024_1f,c1024_1f, -c1024_67,-s1024_67 } ,
	{ s128_7,c128_7, c256_19,s256_19, -s256_0b,c256_0b, c512_19,s512_19, s512_03,c512_03, s512_35,c512_35, -s512_2f,c512_2f, c1024_19,s1024_19, s1024_1f,c1024_1f, c1024_7d,s1024_7d, -s1024_45,c1024_45, c1024_4b,s1024_4b, -s1024_13,c1024_13, s1024_51,c1024_51, -s1024_77,c1024_77 } ,
	{ -c128_7,s128_7, s256_07,c256_07, -s256_15,-c256_15, c512_39,s512_39, -c512_1d,-s512_1d, -s512_2b,c512_2b, s512_0f,-c512_0f, c1024_39,s1024_39, -c1024_01,-s1024_01, -s1024_1d,c1024_1d, -s1024_1b,-c1024_1b, s1024_55,c1024_55, -c1024_73,-s1024_73, -c1024_71,s1024_71, s1024_57,-c1024_57 } ,
	{ c128_5,s128_5, c256_05,s256_05, c256_0f,s256_0f, c512_05,s512_05, c512_19,s512_19, c512_0f,s512_0f, c512_23,s512_23, c1024_05,s1024_05, c1024_2d,s1024_2d, c1024_19,s1024_19, c1024_41,s1024_41, c1024_0f,s1024_0f, c1024_37,s1024_37, c1024_23,s1024_23, c1024_4b,s1024_4b } ,
	{ -s128_5,c128_5, s256_1b,c256_1b, -c256_11,s256_11, c512_25,s512_25, -s512_39,c512_39, s512_11,c512_11, -c512_03,-s512_03, c1024_25,s1024_25, -s1024_4d,c1024_4d, s1024_47,c1024_47, -c1024_1f,s1024_1f, c1024_6f,s1024_6f, -c1024_69,s1024_69, -s1024_03,c1024_03, -c1024_2b,-s1024_2b } ,
	{ s128_b,c128_b, c256_15,s256_15, s256_01,c256_01, c512_15,s512_15, s512_17,c512_17, c512_3f,s512_3f, -s512_13,c512_13, c1024_15,s1024_15, s1024_43,c1024_43, c1024_69,s1024_69, -s1024_11,c1024_11, c1024_3f,s1024_3f, s1024_19,c1024_19, s1024_6d,c1024_6d, -s1024_3b,c1024_3b } ,
	{ -c128_b,s128_b, s256_0b,c256_0b, -c256_1f,-s256_1f, c512_35,s512_35, -c512_09,-s512_09, -s512_1f,c512_1f, -s512_0d,-c512_0d, c1024_35,s1024_35, -c1024_23,s1024_23, -s1024_09,c1024_09, -s1024_4f,-c1024_4f, s1024_61,c1024_61, -c1024_47,-s1024_47, -s1024_73,c1024_73, s1024_1b,-c1024_1b } ,
	{ c128_d,s128_d, c256_0d,s256_0d, s256_19,c256_19, c512_0d,s512_0d, s512_3f,c512_3f, c512_27,s512_27, s512_25,c512_25, c1024_0d,s1024_0d, c1024_75,s1024_75, c1024_41,s1024_41, s1024_57,c1024_57, c1024_27,s1024_27, s1024_71,c1024_71, c1024_5b,s1024_5b, s1024_3d,c1024_3d } ,
	{ -s128_d,c128_d, s256_13,c256_13, -c256_07,-s256_07, c512_2d,s512_2d, -c512_1f,s512_1f, -s512_07,c512_07, -c512_3b,-s512_3b, c1024_2d,s1024_2d, -c1024_6b,s1024_6b, s1024_1f,c1024_1f, -c1024_49,-s1024_49, s1024_79,c1024_79, -c1024_11,s1024_11, -s1024_3b,c1024_3b, -s1024_5d,-c1024_5d } ,
	{ s128_3,c128_3, c256_1d,s256_1d, -s256_17,c256_17, c512_1d,s512_1d, -s512_11,c512_11, s512_29,c512_29, -c512_35,s512_35, c1024_1d,s1024_1d, -s1024_05,c1024_05, s1024_6f,c1024_6f, -s1024_79,c1024_79, c1024_57,s1024_57, -s1024_3f,c1024_3f, s1024_35,c1024_35, -c1024_4d,s1024_4d } ,
	{ -c128_3,s128_3, s256_03,c256_03, -s256_09,-c256_09, c512_3d,s512_3d, -c512_31,-s512_31, -s512_37,c512_37, s512_2b,-c512_2b, c1024_3d,s1024_3d, -c1024_25,-s1024_25, -s1024_31,c1024_31, s1024_19,-c1024_19, s1024_49,c1024_49, -s1024_61,-c1024_61, -c1024_55,s1024_55, c1024_6d,-s1024_6d } ,
	{ c128_3,s128_3, c256_03,s256_03, c256_09,s256_09, c512_03,s512_03, c512_0f,s512_0f, c512_09,s512_09, c512_15,s512_15, c1024_03,s1024_03, c1024_1b,s1024_1b, c1024_0f,s1024_0f, c1024_27,s1024_27, c1024_09,s1024_09, c1024_21,s1024_21, c1024_15,s1024_15, c1024_2d,s1024_2d } ,
	{ -s128_3,c128_3, s256_1d,c256_1d, -c256_17,s256_17, c512_23,s512_23, -s512_2f,c512_2f, s512_17,c512_17, -c512_0b,s512_0b, c1024_23,s1024_23, -s1024_3b,c1024_3b, s1024_51,c1024_51, -c1024_39,s1024_39, c1024_69,s1024_69, -c1024_7f,s1024_7f, s1024_0b,c1024_0b, -c1024_0d,-s1024_0d } ,
	{ s128_d,c128_d, c256_13,s256_13, s256_07,c256_07, c512_13,s512_13, s512_21,c512_21, c512_39,s512_39, -s512_05,c512_05, c1024_13,s1024_13, s1024_55,c1024_55, c1024_5f,s1024_5f, s1024_09,c1024_09, c1024_39,s1024_39, s1024_2f,c1024_2f, s1024_7b,c1024_7b, -s1024_1d,c1024_1d } ,
	{ -c128_d,s128_d, s256_0d,c256_0d, -c256_19,-s256_19, c512_33,s512_33, -c512_01,s512_01, -s512_19,c512_19, -s512_1b,-c512_1b, c1024_33,s1024_33, -c1024_35,s1024_35, s1024_01,c1024_01, -s1024_69,-c1024_69, s1024_67,c1024_67, -c1024_31,-s1024_31, -s1024_65,c1024_65, -s1024_03,-c1024_03 } ,
	{ c128_b,s128_b, c256_0b,s256_0b, s256_1f,c256_1f, c512_0b,s512_0b, c512_37,s512_37, c512_21,s512_21, s512_33,c512_33, c1024_0b,s1024_0b, c1024_63,s1024_63, c1024_37,s1024_37, s1024_71,c1024_71, c1024_21,s1024_21, c1024_79,s1024_79, c1024_4d,s1024_4d, s1024_5b,c1024_5b } ,
	{ -s128_b,c128_b, s256_15,c256_15, -c256_01,-s256_01, c512_2b,s512_2b, -c512_29,s512_29, -s512_01,c512_01, -c512_2d,-s512_2d, c1024_2b,s1024_2b, -c1024_7d,s1024_7d, s1024_29,c1024_29, -c1024_2f,-s1024_2f, s1024_7f,c1024_7f, -c1024_27,s1024_27, -s1024_2d,c1024_2d, -s1024_7b,-c1024_7b } ,
	{ s128_5,c128_5, c256_1b,s256_1b, -s256_11,c256_11, c512_1b,s512_1b, -s512_07,c512_07, s512_2f,c512_2f, -s512_3d,c512_3d, c1024_1b,s1024_1b, s1024_0d,c1024_0d, s1024_79,c1024_79, -s1024_5f,c1024_5f, c1024_51,s1024_51, -s1024_29,c1024_29, s1024_43,c1024_43, -c1024_6b,s1024_6b } ,
	{ -c128_5,s128_5, s256_05,c256_05, -s256_0f,-c256_0f, c512_3b,s512_3b, -c512_27,-s512_27, -s512_31,c512_31, s512_1d,-c512_1d, c1024_3b,s1024_3b, -c1024_13,-s1024_13, -s1024_27,c1024_27, -s1024_01,-c1024_01, s1024_4f,c1024_4f, -s1024_77,-c1024_77, -c1024_63,s1024_63, s1024_75,-c1024_75 } ,
	{ c128_7,s128_7, c256_07,s256_07, c256_15,s256_15, c512_07,s512_07, c512_23,s512_23, c512_15,s512_15, c512_31,s512_31, c1024_07,s1024_07, c1024_3f,s1024_3f, c1024_23,s1024_23, c1024_5b,s1024_5b, c1024_15,s1024_15, c1024_4d,s1024_4d, c1024_31,s1024_31, c1024_69,s1024_69 } ,
	{ -s128_7,c128_7, s256_19,c256_19, -c256_0b,s256_0b, c512_27,s512_27, -c512_3d,s512_3d, s512_0b,c512_0b, -c512_11,-s512_11, c1024_27,s1024_27, -s1024_5f,c1024_5f, s1024_3d,c1024_3d, -c1024_05,s1024_05, c1024_75,s1024_75, -c1024_53,s1024_53, -s1024_11,c1024_11, -c1024_49,-s1024_49 } ,
	{ s128_9,c128_9, c256_17,s256_17, -s256_05,c256_05, c512_17,s512_17, s512_0d,c512_0d, s512_3b,c512_3b, -s512_21,c512_21, c1024_17,s1024_17, s1024_31,c1024_31, c1024_73,s1024_73, -s1024_2b,c1024_2b, c1024_45,s1024_45, s1024_03,c1024_03, s1024_5f,c1024_5f, -s1024_59,c1024_59 } ,
	{ -c128_9,s128_9, s256_09,c256_09, -s256_1b,-c256_1b, c512_37,s512_37, -c512_13,-s512_13, -s512_25,c512_25, s512_01,-c512_01, c1024_37,s1024_37, -c1024_11,s1024_11, -s1024_13,c1024_13, -s1024_35,-c1024_35, s1024_5b,c1024_5b, -c1024_5d,-s1024_5d, -c1024_7f,s1024_7f, s1024_39,-c1024_39 } ,
	{ c128_f,s128_f, c256_0f,s256_0f, s256_13,c256_13, c512_0f,s512_0f, s512_35,c512_35, c512_2d,s512_2d, s512_17,c512_17, c1024_0f,s1024_0f, s1024_79,c1024_79, c1024_4b,s1024_4b, s1024_3d,c1024_3d, c1024_2d,s1024_2d, s1024_5b,c1024_5b, c1024_69,s1024_69, s1024_1f,c1024_1f } ,
	{ -s128_f,c128_f, s256_11,c256_11, -c256_0d,-s256_0d, c512_2f,s512_2f, -c512_15,s512_15, -s512_0d,c512_0d, -s512_37,-c512_37, c1024_2f,s1024_2f, -c1024_59,s1024_59, s1024_15,c1024_15, -c1024_63,-s1024_63, s1024_73,c1024_73, -c1024_05,-s1024_05, -s1024_49,c1024_49, -s1024_3f,-c1024_3f } ,
	{ s128_1,c128_1, c256_1f,s256_1f, -s256_1d,c256_1d, c512_1f,s512_1f, -s512_1b,c512_1b, s512_23,c512_23, -c512_27,s512_27, c1024_1f,s1024_1f, -s1024_17,c1024_17, s1024_65,c1024_65, -c1024_6d,s1024_6d, c1024_5d,s1024_5d, -s1024_55,c1024_55, s1024_27,c1024_27, -c1024_2f,s1024_2f } ,
	{ -c128_1,s128_1, s256_01,c256_01, -s256_03,-c256_03, c512_3f,s512_3f, -c512_3b,-s512_3b, -s512_3d,c512_3d, s512_39,-c512_39, c1024_3f,s1024_3f, -c1024_37,-s1024_37, -s1024_3b,c1024_3b, s1024_33,-c1024_33, s1024_43,c1024_43, -s1024_4b,-c1024_4b, -c1024_47,s1024_47, c1024_4f,-s1024_4f }
};

