/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.driver.exceptions.DiscoveryException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.shell.ConnectionConfig;
import org.neo4j.shell.Connector;
import org.neo4j.shell.DatabaseManager;
import org.neo4j.shell.StatementExecuter;
import org.neo4j.shell.TransactionHandler;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.commands.CommandExecutable;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.exception.ThrowingAction;
import org.neo4j.shell.parameter.ParameterService;
import org.neo4j.shell.prettyprint.LinePrinter;
import org.neo4j.shell.prettyprint.PrettyPrinter;
import org.neo4j.shell.state.BoltResult;
import org.neo4j.shell.state.BoltStateHandler;

public class CypherShell
implements StatementExecuter,
Connector,
TransactionHandler,
DatabaseManager {
    private static final Pattern cmdNamePattern = Pattern.compile("^\\s*(?<name>[^\\s]+)\\b(?<args>.*)\\s*$");
    private static final Pattern emptyStatementPattern = Pattern.compile("^\\s*;$");
    private final ParameterService parameters;
    private final LinePrinter linePrinter;
    private final BoltStateHandler boltStateHandler;
    private final PrettyPrinter prettyPrinter;
    private CommandHelper commandHelper;
    private String lastNeo4jErrorCode;

    public CypherShell(LinePrinter linePrinter, BoltStateHandler boltStateHandler, PrettyPrinter prettyPrinter, ParameterService parameters) {
        this.linePrinter = linePrinter;
        this.boltStateHandler = boltStateHandler;
        this.prettyPrinter = prettyPrinter;
        this.parameters = parameters;
        this.addRuntimeHookToResetShell();
    }

    protected static String stripTrailingSemicolons(String text) {
        int end;
        for (end = text.length(); end > 0 && text.substring(0, end).endsWith(";"); --end) {
        }
        return text.substring(0, end);
    }

    @Override
    public void execute(String cmdString) throws ExitException, CommandException {
        if (CypherShell.isEmptyStatement(cmdString)) {
            return;
        }
        Optional<CommandExecutable> cmd = this.getCommandExecutable(cmdString);
        if (cmd.isPresent()) {
            CypherShell.executeCmd(cmd.get());
            return;
        }
        if (!this.isConnected()) {
            throw new CommandException("Not connected to Neo4j");
        }
        this.executeCypher(cmdString);
    }

    private static boolean isEmptyStatement(String statement) {
        return emptyStatementPattern.matcher(statement).matches();
    }

    @Override
    public String lastNeo4jErrorCode() {
        return this.lastNeo4jErrorCode;
    }

    private void executeCypher(String cypher) throws CommandException {
        try {
            Optional<BoltResult> result = this.boltStateHandler.runCypher(cypher, this.parameters.parameterValues());
            result.ifPresent(boltResult -> {
                this.prettyPrinter.format((BoltResult)boltResult, this.linePrinter);
                this.boltStateHandler.updateActualDbName(boltResult.getSummary());
            });
            this.lastNeo4jErrorCode = null;
        }
        catch (Neo4jException e) {
            this.lastNeo4jErrorCode = CypherShell.getErrorCode(e);
            throw this.boltStateHandler.handleException(e);
        }
    }

    @Override
    public boolean isConnected() {
        return this.boltStateHandler.isConnected();
    }

    protected Optional<CommandExecutable> getCommandExecutable(String line) {
        Matcher m = cmdNamePattern.matcher(line);
        if (this.commandHelper == null || !m.matches()) {
            return Optional.empty();
        }
        String name = m.group("name");
        String args = m.group("args");
        Command cmd = this.commandHelper.getCommand(name);
        if (cmd == null) {
            return Optional.empty();
        }
        return Optional.of(() -> cmd.execute(CypherShell.stripTrailingSemicolons(args)));
    }

    protected static void executeCmd(CommandExecutable cmdExe) throws ExitException, CommandException {
        cmdExe.execute();
    }

    @Override
    public ConnectionConfig connect(ConnectionConfig connectionConfig, ThrowingAction<CommandException> command) throws CommandException {
        return this.boltStateHandler.connect(connectionConfig, command);
    }

    @Override
    public String getServerVersion() {
        return this.boltStateHandler.getServerVersion();
    }

    @Override
    public String getProtocolVersion() {
        return this.boltStateHandler.getProtocolVersion();
    }

    @Override
    public void beginTransaction() throws CommandException {
        this.boltStateHandler.beginTransaction();
    }

    @Override
    public void commitTransaction() throws CommandException {
        try {
            this.boltStateHandler.commitTransaction();
            this.lastNeo4jErrorCode = null;
        }
        catch (Neo4jException e) {
            this.lastNeo4jErrorCode = CypherShell.getErrorCode(e);
            throw e;
        }
    }

    @Override
    public void rollbackTransaction() throws CommandException {
        this.boltStateHandler.rollbackTransaction();
    }

    @Override
    public boolean isTransactionOpen() {
        return this.boltStateHandler.isTransactionOpen();
    }

    public void setCommandHelper(CommandHelper commandHelper) {
        this.commandHelper = commandHelper;
    }

    @Override
    public void reset() {
        this.boltStateHandler.reset();
    }

    protected void addRuntimeHookToResetShell() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::reset));
    }

    @Override
    public void setActiveDatabase(String databaseName) throws CommandException {
        try {
            this.boltStateHandler.setActiveDatabase(databaseName);
            this.lastNeo4jErrorCode = null;
        }
        catch (Neo4jException e) {
            this.lastNeo4jErrorCode = CypherShell.getErrorCode(e);
            throw e;
        }
    }

    @Override
    public String getActiveDatabaseAsSetByUser() {
        return this.boltStateHandler.getActiveDatabaseAsSetByUser();
    }

    @Override
    public String getActualDatabaseAsReportedByServer() {
        return this.boltStateHandler.getActualDatabaseAsReportedByServer();
    }

    public ParameterService getParameters() {
        return this.parameters;
    }

    public void changePassword(ConnectionConfig connectionConfig, String newPassword) {
        this.boltStateHandler.changePassword(connectionConfig, newPassword);
    }

    @Override
    public void disconnect() {
        this.boltStateHandler.disconnect();
    }

    private static String getErrorCode(Neo4jException e) {
        Throwable[] suppressed;
        Neo4jException statusException = e;
        for (Throwable s : suppressed = e.getSuppressed()) {
            if (!(s instanceof Neo4jException)) continue;
            statusException = (Neo4jException)s;
            break;
        }
        if (statusException instanceof ServiceUnavailableException || statusException instanceof DiscoveryException) {
            return "Neo.TransientError.General.DatabaseUnavailable";
        }
        return statusException.code();
    }
}

