/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.function.Consumer;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.RelationshipVisitor;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public abstract class RelationshipValue
extends VirtualRelationshipValue
implements RelationshipVisitor {
    private final long id;
    private final long startNodeId;
    private final long endNodeId;
    private int type = -1;
    private static final long DIRECT_RELATIONSHIP_VALUE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(DirectRelationshipValue.class);

    protected RelationshipValue(long id, long startNodeId, long endNodeId) {
        this.id = id;
        this.startNodeId = startNodeId;
        this.endNodeId = endNodeId;
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        if (writer.entityMode() == AnyValueWriter.EntityMode.REFERENCE) {
            writer.writeRelationshipReference(this.id);
        } else {
            writer.writeRelationship(this.id, this.startNode().id(), this.endNode().id(), this.type(), this.properties(), this.isDeleted());
        }
    }

    public String toString() {
        return String.format("-[%d]-", this.id);
    }

    public long startNodeId() {
        return this.startNodeId;
    }

    @Override
    public long startNodeId(Consumer<RelationshipVisitor> consumer) {
        return this.startNodeId;
    }

    public long endNodeId() {
        return this.endNodeId;
    }

    @Override
    public long endNodeId(Consumer<RelationshipVisitor> consumer) {
        return this.endNodeId;
    }

    public abstract VirtualNodeValue startNode();

    public abstract VirtualNodeValue endNode();

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public int relationshipTypeId(Consumer<RelationshipVisitor> consumer) {
        if (this.type == -1) {
            consumer.accept(this);
        }
        return this.type;
    }

    public abstract TextValue type();

    public abstract MapValue properties();

    public VirtualNodeValue otherNode(VirtualNodeValue node) {
        return node.equals(this.startNode()) ? this.endNode() : this.startNode();
    }

    public long otherNodeId(long node) {
        return node == this.startNodeId() ? this.endNodeId() : this.startNodeId();
    }

    @Override
    public String getTypeName() {
        return "Relationship";
    }

    @Override
    public void visit(long startNode, long endNode, int type) {
        this.type = type;
    }

    static class DirectRelationshipValue
    extends RelationshipValue {
        private final VirtualNodeValue startNode;
        private final VirtualNodeValue endNode;
        private final TextValue type;
        private final MapValue properties;
        private final boolean isDeleted;

        DirectRelationshipValue(long id, VirtualNodeValue startNode, VirtualNodeValue endNode, TextValue type, MapValue properties) {
            super(id, startNode.id(), endNode.id());
            assert (properties != null);
            this.startNode = startNode;
            this.endNode = endNode;
            this.type = type;
            this.properties = properties;
            this.isDeleted = false;
        }

        DirectRelationshipValue(long id, VirtualNodeValue startNode, VirtualNodeValue endNode, TextValue type, MapValue properties, boolean isDeleted) {
            super(id, startNode.id(), endNode.id());
            assert (properties != null);
            this.startNode = startNode;
            this.endNode = endNode;
            this.type = type;
            this.properties = properties;
            this.isDeleted = isDeleted;
        }

        @Override
        public VirtualNodeValue startNode() {
            return this.startNode;
        }

        @Override
        public VirtualNodeValue endNode() {
            return this.endNode;
        }

        @Override
        public TextValue type() {
            return this.type;
        }

        @Override
        public MapValue properties() {
            return this.properties;
        }

        @Override
        public long estimatedHeapUsage() {
            return DIRECT_RELATIONSHIP_VALUE_SHALLOW_SIZE + this.startNode.estimatedHeapUsage() + this.endNode.estimatedHeapUsage() + this.type.estimatedHeapUsage() + this.properties.estimatedHeapUsage();
        }

        @Override
        public boolean isDeleted() {
            return this.isDeleted;
        }
    }
}

