/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.IntStream;
import org.neo4j.fabric.executor.FabricException;
import org.neo4j.fabric.executor.FabricSecondaryException;
import org.neo4j.kernel.api.exceptions.HasQuery;
import org.neo4j.kernel.api.exceptions.Status;

public class Exceptions {
    public static RuntimeException transform(Status defaultStatus, Throwable t) {
        return Exceptions.transform(defaultStatus, t, null);
    }

    public static RuntimeException transform(Status defaultStatus, Throwable t, Long queryId) {
        Throwable unwrapped = reactor.core.Exceptions.unwrap((Throwable)t);
        unwrapped = Exceptions.transformComposite(unwrapped);
        String message = unwrapped.getMessage();
        if (unwrapped instanceof Status.HasStatus) {
            if (unwrapped instanceof RuntimeException) {
                if (queryId == null) {
                    return (RuntimeException)unwrapped;
                }
                if (unwrapped instanceof HasQuery) {
                    ((HasQuery)unwrapped).setQuery(queryId);
                    return (RuntimeException)unwrapped;
                }
            }
            return new FabricException(((Status.HasStatus)unwrapped).status(), message, unwrapped, queryId);
        }
        return new FabricException(defaultStatus, message, unwrapped, queryId);
    }

    private static Throwable transformComposite(Throwable potentialComposite) {
        List unwrappedExceptions = reactor.core.Exceptions.unwrapMultiple((Throwable)potentialComposite);
        ArrayList primaryExceptions = new ArrayList();
        ArrayList secondaryExceptions = new ArrayList();
        unwrappedExceptions.forEach(exception -> {
            if (exception instanceof FabricSecondaryException) {
                secondaryExceptions.add((FabricSecondaryException)exception);
            } else {
                primaryExceptions.add(exception);
            }
        });
        if (!primaryExceptions.isEmpty()) {
            Throwable result = (Throwable)primaryExceptions.get(0);
            IntStream.range(1, primaryExceptions.size()).forEach(i -> result.addSuppressed((Throwable)primaryExceptions.get(i)));
            return result;
        }
        HashSet<FabricException> uniqueExceptions = new HashSet<FabricException>();
        FabricException result = ((FabricSecondaryException)secondaryExceptions.get(0)).getPrimaryException();
        uniqueExceptions.add(result);
        IntStream.range(1, secondaryExceptions.size()).mapToObj(secondaryExceptions::get).map(FabricSecondaryException::getPrimaryException).filter(exception -> !uniqueExceptions.contains(exception)).forEach(exception -> {
            result.addSuppressed((Throwable)exception);
            uniqueExceptions.add((FabricException)exception);
        });
        return result;
    }
}

