/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.internal.id.indexed.IdRange;
import org.neo4j.internal.id.indexed.IdRangeKey;
import org.neo4j.internal.id.indexed.IndexedIdGenerator;

final class IdRangeMerger
implements ValueMerger<IdRangeKey, IdRange> {
    public static final IdRangeMerger DEFAULT = new IdRangeMerger(false, IndexedIdGenerator.NO_MONITOR);
    public static final IdRangeMerger RECOVERY = new IdRangeMerger(true, IndexedIdGenerator.NO_MONITOR);
    private final boolean recoveryMode;
    private final IndexedIdGenerator.Monitor monitor;

    IdRangeMerger(boolean recoveryMode, IndexedIdGenerator.Monitor monitor) {
        this.recoveryMode = recoveryMode;
        this.monitor = monitor;
    }

    public ValueMerger.MergeResult merge(IdRangeKey existingKey, IdRangeKey newKey, IdRange existingValue, IdRange newValue) {
        boolean changed;
        if (!this.recoveryMode && existingValue.getGeneration() != newValue.getGeneration()) {
            existingValue.normalize();
            existingValue.setGeneration(newValue.getGeneration());
            this.monitor.normalized(existingKey.getIdRangeIdx());
        }
        if (!(changed = existingValue.mergeFrom(existingKey, newValue, this.recoveryMode))) {
            return ValueMerger.MergeResult.UNCHANGED;
        }
        return existingValue.isEmpty() ? ValueMerger.MergeResult.REMOVED : ValueMerger.MergeResult.MERGED;
    }
}

